/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.data.provider.RowKey;
import com.sun.data.provider.SortCriteria;
import com.sun.webui.jsf.component.Table;
import com.sun.webui.jsf.component.TableColumn;
import com.sun.webui.jsf.component.TableRowGroup;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.JsonUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UINamingContainer;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.render.Renderer;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.util.Iterator;

public final class TableRenderer
extends Renderer {
    private static final String JAVASCRIPT_OBJECT_CLASS = "Table";
    private static final String[] STRING_ATTRIBUTES = new String[]{"align", "bgColor", "dir", "frame", "lang", "onClick", "onDblClick", "onKeyDown", "onKeyPress", "onKeyUp", "onMouseDown", "onMouseMove", "onMouseOut", "onMouseOver", "onMouseUp", "rules", "summary"};

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            TableRenderer.log("encodeBegin", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            TableRenderer.log("encodeBegin", "Component not rendered, nothing to display");
            return;
        }
        Table table = (Table)component;
        ResponseWriter writer = context.getResponseWriter();
        this.renderEnclosingTagStart(context, table, writer);
        this.renderTitle(context, table, writer);
        this.renderActionsTop(context, table, writer);
        this.renderEmbeddedPanels(context, table, writer);
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            TableRenderer.log("encodeChildren", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            TableRenderer.log("encodeChildren", "Component not rendered, nothing to display");
            return;
        }
        Table table = (Table)component;
        ResponseWriter writer = context.getResponseWriter();
        Iterator kids = table.getTableRowGroupChildren();
        while (kids.hasNext()) {
            TableRowGroup group = (TableRowGroup)((Object)kids.next());
            RenderingUtilities.renderComponent((UIComponent)group, context);
        }
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (context == null || component == null) {
            TableRenderer.log("encodeEnd", "Cannot render, FacesContext or UIComponent is null");
            throw new NullPointerException();
        }
        if (!component.isRendered()) {
            TableRenderer.log("encodeEnd", "Component not rendered, nothing to display");
            return;
        }
        Table table = (Table)component;
        ResponseWriter writer = context.getResponseWriter();
        this.renderActionsBottom(context, table, writer);
        this.renderTableFooter(context, table, writer);
        this.renderEnclosingTagEnd(writer);
        this.renderJavascript(context, table, writer);
    }

    public boolean getRendersChildren() {
        return true;
    }

    protected void renderActionsBottom(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        if (component == null) {
            TableRenderer.log("renderActionsBottom", "Cannot render actions bar, Table is null");
            return;
        }
        UIComponent actions = component.getTableActionsBottom();
        if (actions == null || !actions.isRendered()) {
            TableRenderer.log("renderActionsBottom", "Actions bar not rendered, nothing to display");
            return;
        }
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)component);
        writer.writeAttribute("id", (Object)this.getId((UIComponent)component, "_tableActionsBottomBar"), null);
        RenderingUtilities.renderComponent(actions, context);
        writer.endElement("tr");
    }

    protected void renderActionsTop(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        if (component == null) {
            TableRenderer.log("renderActionsTop", "Cannot render actions bar, Table is null");
            return;
        }
        UIComponent actions = component.getTableActionsTop();
        if (actions == null || !actions.isRendered()) {
            TableRenderer.log("renderActionsTop", "Actions bar not rendered, nothing to display");
            return;
        }
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)component);
        writer.writeAttribute("id", (Object)this.getId((UIComponent)component, "_tableActionsTopBar"), null);
        RenderingUtilities.renderComponent(actions, context);
        writer.endElement("tr");
    }

    protected void renderEmbeddedPanels(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        if (component == null) {
            TableRenderer.log("renderEmbeddedPanels", "Cannot render embedded panels, Table is null");
            return;
        }
        UIComponent panels = component.getEmbeddedPanels();
        if (panels == null || !panels.isRendered()) {
            TableRenderer.log("renderEmbeddedPanels", "Embedded panels not rendered, nothing to display");
            return;
        }
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)component);
        writer.writeAttribute("id", (Object)this.getId((UIComponent)component, "_embeddedPanelsBar"), null);
        RenderingUtilities.renderComponent(panels, context);
        writer.endElement("tr");
    }

    protected void renderTableFooter(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        if (component == null) {
            TableRenderer.log("renderTableFooter", "Cannot render table foter, Table is null");
            return;
        }
        UIComponent footer = component.getTableFooter();
        if (footer == null || !footer.isRendered()) {
            TableRenderer.log("renderTableFooter", "Table footer not rendered, nothing to display");
            return;
        }
        Theme theme = this.getTheme();
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)component);
        writer.writeAttribute("id", (Object)this.getId((UIComponent)component, "_tableFooterBar"), null);
        RenderingUtilities.renderComponent(footer, context);
        writer.endElement("tr");
    }

    protected void renderTitle(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        if (component == null) {
            TableRenderer.log("renderTitle", "Cannot render title, Table is null");
            return;
        }
        UIComponent facet = component.getFacet("title");
        if (facet != null) {
            this.renderTitleStart(context, component, writer);
            RenderingUtilities.renderComponent(facet, context);
            this.renderTitleEnd(context, writer);
            return;
        }
        if (component.getTitle() == null) {
            TableRenderer.log("renderTitle", "Title is null, nothing to display");
            return;
        }
        Theme theme = this.getTheme();
        String filter = component.getFilterText() != null ? theme.getMessage("table.title.filterApplied", new String[]{component.getFilterText()}) : "";
        TableRowGroup group = component.getTableRowGroupChild();
        boolean paginated = group != null ? group.isPaginated() : false;
        int totalRows = component.getRowCount();
        boolean emptyTable = totalRows == 0;
        boolean singlePage = totalRows < component.getRows();
        String title = component.getTitle();
        if (component.isAugmentTitle()) {
            if (!emptyTable && !singlePage && paginated) {
                int maxRows = component.getRows();
                int maxFirst = component.getFirst();
                String first = Integer.toString(maxFirst + 1);
                String last = Integer.toString(Math.min(maxFirst + maxRows, totalRows));
                title = component.getItemsText() != null ? theme.getMessage("table.title.paginatedItems", new String[]{component.getTitle(), first, last, Integer.toString(totalRows), component.getItemsText(), filter}) : theme.getMessage("table.title.paginated", new String[]{component.getTitle(), first, last, Integer.toString(totalRows), filter});
            } else {
                title = component.getItemsText() != null ? theme.getMessage("table.title.scrollItems", new String[]{component.getTitle(), Integer.toString(totalRows), component.getItemsText(), filter}) : theme.getMessage("table.title.scroll", new String[]{component.getTitle(), Integer.toString(totalRows), filter});
            }
        } else {
            TableRenderer.log("renderTitle", "Title not augmented, itemsText & filterText not displayed");
        }
        this.renderTitleStart(context, component, writer);
        if (component.isHiddenSelectedRows()) {
            writer.startElement("span", (UIComponent)component);
            writer.writeAttribute("class", (Object)theme.getStyleClass("TABLE_TITLE_TEXT_SPAN"), null);
            writer.writeText((Object)title, null);
            writer.endElement("span");
            writer.startElement("span", (UIComponent)component);
            writer.writeAttribute("class", (Object)theme.getStyleClass("TABLE_TITLE_MESSAGE_SPAN"), null);
            writer.writeText((Object)theme.getMessage("table.hiddenSelections", new String[]{Integer.toString(component.getHiddenSelectedRowsCount())}), null);
            writer.endElement("span");
        } else {
            writer.writeText((Object)title, null);
        }
        this.renderTitleEnd(context, writer);
    }

    private void renderTitleStart(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        writer.writeText((Object)"\n", null);
        writer.startElement("caption", (UIComponent)component);
        writer.writeAttribute("id", (Object)this.getId((UIComponent)component, "_titleBar"), null);
        writer.writeAttribute("class", (Object)this.getTheme().getStyleClass("TABLE_TITLE_TEXT"), null);
        if (component.getExtraTitleHtml() != null) {
            RenderingUtilities.renderExtraHtmlAttributes(writer, component.getExtraTitleHtml());
        }
    }

    private void renderTitleEnd(FacesContext context, ResponseWriter writer) throws IOException {
        writer.endElement("caption");
    }

    protected void renderEnclosingTagStart(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        int first;
        if (component == null) {
            TableRenderer.log("renderEnclosingTagStart", "Cannot render enclosing tag, Table is null");
            return;
        }
        Theme theme = this.getTheme();
        writer.writeText((Object)"\n", null);
        writer.startElement("div", (UIComponent)component);
        writer.writeAttribute("id", (Object)component.getClientId(context), null);
        String style = component.getStyle();
        if (style != null) {
            writer.writeAttribute("style", (Object)style, null);
        }
        RenderingUtilities.renderStyleClass(context, writer, (UIComponent)component, null);
        writer.writeText((Object)"\n", null);
        writer.startElement("div", (UIComponent)component);
        Object width = component.getWidth();
        if (width != null) {
            if (!((String)width).contains("%")) {
                width = (String)width + "px";
            }
            writer.writeAttribute("style", (Object)("width:" + (String)width), null);
        } else {
            writer.writeAttribute("style", (Object)"width:100%", null);
        }
        writer.writeText((Object)"\n", null);
        writer.startElement("table", (UIComponent)component);
        writer.writeAttribute("id", (Object)this.getId((UIComponent)component, "_table"), null);
        Object styleClass = theme.getStyleClass("TABLE");
        if (component.isLite()) {
            styleClass = (String)styleClass + " " + theme.getStyleClass("TABLE_LITE");
        }
        writer.writeAttribute("class", styleClass, null);
        writer.writeAttribute("width", (Object)"100%", null);
        if (style != null && (first = style.indexOf("height:")) > -1) {
            int last = style.indexOf(";", first);
            if (last > -1) {
                writer.writeAttribute("style", (Object)style.substring(first, last + 1), null);
            } else {
                writer.writeAttribute("style", (Object)style.substring(first), null);
            }
        }
        this.renderTableAttributes(context, component, writer);
    }

    protected void renderTableAttributes(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        int border = component.getBorder();
        if (border > -1) {
            writer.writeAttribute("border", (Object)Integer.toString(border), null);
        } else {
            writer.writeAttribute("border", (Object)"0", null);
        }
        String value = component.getCellPadding();
        if (value != null) {
            writer.writeAttribute("cellpadding", (Object)value, null);
        } else {
            writer.writeAttribute("cellpadding", (Object)"0", null);
        }
        value = component.getCellSpacing();
        if (value != null) {
            writer.writeAttribute("cellspacing", (Object)value, null);
        } else {
            writer.writeAttribute("cellspacing", (Object)"0", null);
        }
        value = component.getToolTip();
        if (value != null) {
            writer.writeAttribute("title", (Object)value, "toolTip");
        }
        RenderingUtilities.writeStringAttributes((UIComponent)component, writer, STRING_ATTRIBUTES);
    }

    protected void renderEnclosingTagEnd(ResponseWriter writer) throws IOException {
        writer.endElement("table");
        writer.endElement("div");
        writer.endElement("div");
    }

    private String getId(UIComponent component, String id) {
        FacesContext context = FacesContext.getCurrentInstance();
        String clientId = component.getClientId(context);
        return clientId + UINamingContainer.getSeparatorChar((FacesContext)context) + id;
    }

    private String getSelectId(FacesContext context, TableColumn component) {
        TableRowGroup group;
        Object selectId = null;
        if (component == null) {
            TableRenderer.log("getSelectId", "Cannot obtain select Id, TableColumn is null");
            return selectId;
        }
        Iterator<TableColumn> kids = component.getTableColumnChildren();
        if (kids.hasNext()) {
            TableColumn col;
            while (kids.hasNext() && (!(col = kids.next()).isRendered() || (selectId = this.getSelectId(context, col)) == null)) {
            }
        } else if (component.getSelectId() != null && (group = component.getTableRowGroupAncestor()) != null) {
            String colId = component.getClientId(context);
            String groupId = group.getClientId(context) + UINamingContainer.getSeparatorChar((FacesContext)context);
            try {
                selectId = colId.substring(groupId.length(), colId.length()) + UINamingContainer.getSeparatorChar((FacesContext)context) + component.getSelectId();
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }
        return selectId;
    }

    private String getSelectSortMenuOptionValue(Table component) {
        TableRowGroup group = component.getTableRowGroupChild();
        if (group != null) {
            Iterator<TableColumn> kids = group.getTableColumnChildren();
            while (kids.hasNext()) {
                String value;
                TableColumn col = kids.next();
                if (!col.isRendered() || col.getSelectId() == null || (value = this.getSelectSortMenuOptionValue(col)) == null) continue;
                return value;
            }
        } else {
            TableRenderer.log("getSelectSortMenuOptionValue", "Cannot obtain select sort menu option value, TableRowGroup is null");
        }
        return null;
    }

    private String getSelectSortMenuOptionValue(TableColumn component) {
        SortCriteria criteria;
        Iterator<TableColumn> kids = component.getTableColumnChildren();
        if (kids.hasNext()) {
            while (kids.hasNext()) {
                String value;
                TableColumn col = kids.next();
                if (!col.isRendered() || col.getSelectId() == null || (value = this.getSelectSortMenuOptionValue(col)) == null) continue;
                return value;
            }
        }
        if ((criteria = component.getSortCriteria()) != null) {
            return criteria.getCriteriaKey();
        }
        return null;
    }

    private JsonArray getSortToolTipJavascript(Table component, boolean descending) {
        String tooltip = descending ? "table.sort.augment.undeterminedDescending" : "table.sort.augment.undeterminedAscending";
        JsonArrayBuilder jsonBuilder = JsonUtilities.JSON_BUILDER_FACTORY.createArrayBuilder().add(this.getTheme().getMessage(tooltip));
        TableRowGroup group = component.getTableRowGroupChild();
        if (group != null) {
            Iterator<TableColumn> kids = group.getTableColumnChildren();
            while (kids.hasNext()) {
                TableColumn col = kids.next();
                if (!col.isRendered()) continue;
                jsonBuilder.add(col.getSortToolTipAugment(descending));
            }
        } else {
            TableRenderer.log("getSortToolTipJavascript", "Cannot obtain Javascript array of sort tool tips, TableRowGroup is null");
        }
        return jsonBuilder.build();
    }

    private String getTableColumnFooterStyleClass(TableColumn component, int level) {
        String styleClass = component.isSpacerColumn() ? "TABLE_COL_FOOTER_SPACER" : (level == 1 ? "TABLE_COL_FOOTER_SORT" : "TABLE_COL_FOOTER");
        return this.getTheme().getStyleClass(styleClass);
    }

    private Theme getTheme() {
        return ThemeUtilities.getTheme(FacesContext.getCurrentInstance());
    }

    private static void log(String method, String msg) {
        Class<TableRenderer> clazz = TableRenderer.class;
        if (LogUtil.fineEnabled(clazz)) {
            LogUtil.fine(clazz, clazz.getName() + "." + method + ": " + msg);
        }
    }

    private void renderJavascript(FacesContext context, Table component, ResponseWriter writer) throws IOException {
        if (component == null) {
            TableRenderer.log("renderJavascript", "Cannot render Javascript, Table is null");
            return;
        }
        JsonObjectBuilder initProps = JsonUtilities.JSON_BUILDER_FACTORY.createObjectBuilder().add("id", component.getClientId(context));
        this.appendPanelProperties(context, component, initProps);
        this.appendFilterProperties(context, component, initProps);
        this.appendSortPanelProperties(context, component, initProps);
        this.appendGroupProperties(context, component, initProps);
        this.appendGroupPanelProperties(context, component, initProps);
        JavaScriptUtilities.renderInitScriptTag(writer, "table", initProps.build());
    }

    private void appendPanelProperties(FacesContext context, Table component, JsonObjectBuilder jsonBuilder) throws IOException {
        if (component == null) {
            TableRenderer.log("appendPanelProperties", "Cannot obtain properties, Table is null");
            return;
        }
        UIComponent panels = component.getFacet("_embeddedPanels");
        if (panels == null) {
            TableRenderer.log("appendPanelProperties", "Cannot obtain panel properties, embedded panels facet is null");
            return;
        }
        Theme theme = this.getTheme();
        String prefix = panels.getClientId(context) + UINamingContainer.getSeparatorChar((FacesContext)context);
        JsonArray ary1 = JsonUtilities.JSON_BUILDER_FACTORY.createArrayBuilder().add(prefix + "_sortPanel").add(prefix + "_preferencesPanel").add(prefix + "_filterPanel").build();
        jsonBuilder.add("panelIds", (JsonValue)ary1);
        UIComponent actions = component.getFacet("_tableActionsTop");
        if (actions == null) {
            TableRenderer.log("appendPanelProperties", "Cannot obtain properties, facet is null");
            return;
        }
        JsonArrayBuilder ary2 = JsonUtilities.JSON_BUILDER_FACTORY.createArrayBuilder();
        if (component.getSortPanelFocusId() != null) {
            ary2.add(component.getSortPanelFocusId());
        } else {
            ary2.add(prefix + "_primarySortColumnMenu");
        }
        if (component.getPreferencesPanelFocusId() != null) {
            ary2.add(component.getPreferencesPanelFocusId());
        } else {
            ary2.add(JsonObject.NULL);
        }
        if (component.getFilterPanelFocusId() != null) {
            ary2.add(component.getFilterPanelFocusId());
        } else {
            ary2.add(JsonObject.NULL);
        }
        jsonBuilder.add("panelFocusIds", ary2);
        prefix = actions.getClientId(context) + UINamingContainer.getSeparatorChar((FacesContext)context);
        JsonArrayBuilder ary3 = JsonUtilities.JSON_BUILDER_FACTORY.createArrayBuilder();
        ary3.add(prefix + "_sortPanelToggleButton").add(prefix + "_preferencesPanelToggleButton");
        if (component.getFilterId() != null) {
            ary3.add(component.getFilterId());
        } else {
            ary3.add(JsonObject.NULL);
        }
        jsonBuilder.add("panelToggleIds", ary3);
        JsonArray ary4 = JsonUtilities.JSON_BUILDER_FACTORY.createArrayBuilder().add(theme.getImagePath("TABLE_SORT_PANEL_FLIP")).add(theme.getImagePath("TABLE_PREFERENCES_PANEL_FLIP")).add(JsonObject.NULL).build();
        jsonBuilder.add("panelToggleIconsOpen", (JsonValue)ary4);
        JsonArray ary5 = JsonUtilities.JSON_BUILDER_FACTORY.createArrayBuilder().add(theme.getImagePath("TABLE_SORT_PANEL")).add(theme.getImagePath("TABLE_PREFERENCES_PANEL")).add(JsonObject.NULL).build();
        jsonBuilder.add("panelToggleIconsClose", (JsonValue)ary5);
    }

    private void appendFilterProperties(FacesContext context, Table component, JsonObjectBuilder jsonBuilder) throws IOException {
        if (component == null) {
            TableRenderer.log("apppendFilterProperties", "Cannot obtain properties, Table is null");
            return;
        }
        Theme theme = this.getTheme();
        jsonBuilder.add("basicFilterStyleClass", theme.getStyleClass("MENU_JUMP")).add("customFilterStyleClass", theme.getStyleClass("TABLE_CUSTOM_FILTER_MENU")).add("customFilterOptionValue", "_customFilter").add("customFilterAppliedOptionValue", "_customFilterApplied");
    }

    private void appendGroupProperties(FacesContext context, Table component, JsonObjectBuilder jsonBuilder) throws IOException {
        if (component == null) {
            TableRenderer.log("appendGroupProperties", "Cannot obtain properties, Table is null");
            return;
        }
        Theme theme = this.getTheme();
        jsonBuilder.add("selectRowStyleClass", theme.getStyleClass("TABLE_SELECT_ROW"));
        JsonArrayBuilder ary1 = JsonUtilities.JSON_BUILDER_FACTORY.createArrayBuilder();
        Iterator kids = component.getTableRowGroupChildren();
        while (kids.hasNext()) {
            TableColumn col;
            TableRowGroup group = (TableRowGroup)((Object)kids.next());
            String selectId = null;
            Iterator<TableColumn> grandkids = group.getTableColumnChildren();
            while (grandkids.hasNext() && (!(col = grandkids.next()).isRendered() || (selectId = this.getSelectId(context, col)) == null)) {
            }
            if (selectId != null) {
                ary1.add(selectId);
                continue;
            }
            ary1.add(JsonObject.NULL);
        }
        jsonBuilder.add("selectIds", ary1);
        JsonArrayBuilder ary2 = JsonUtilities.JSON_BUILDER_FACTORY.createArrayBuilder();
        kids = component.getTableRowGroupChildren();
        while (kids.hasNext()) {
            TableRowGroup group = (TableRowGroup)((Object)kids.next());
            ary2.add(group.getClientId(context));
        }
        jsonBuilder.add("groupIds", ary2);
        JsonArrayBuilder ary3 = JsonUtilities.JSON_BUILDER_FACTORY.createArrayBuilder();
        kids = component.getTableRowGroupChildren();
        while (kids.hasNext()) {
            TableRowGroup group = (TableRowGroup)((Object)kids.next());
            RowKey[] rowKeys = group.getRenderedRowKeys();
            JsonArrayBuilder tmp = JsonUtilities.JSON_BUILDER_FACTORY.createArrayBuilder();
            if (rowKeys != null) {
                for (RowKey rowKey : rowKeys) {
                    tmp.add(rowKey.getRowId());
                }
            } else {
                tmp.add(JsonObject.NULL);
            }
            ary3.add(tmp);
        }
        jsonBuilder.add("rowIds", ary3);
        JsonArrayBuilder ary4 = JsonUtilities.JSON_BUILDER_FACTORY.createArrayBuilder();
        kids = component.getTableRowGroupChildren();
        while (kids.hasNext()) {
            TableRowGroup group = (TableRowGroup)((Object)kids.next());
            if (component.isHiddenSelectedRows()) {
                ary4.add(group.getHiddenSelectedRowsCount());
                continue;
            }
            ary4.add(0);
        }
        jsonBuilder.add("hiddenSelectedRowCounts", ary4).add("hiddenSelectionsMsg", theme.getMessage("table.confirm.hiddenSelections")).add("totalSelectionsMsg", theme.getMessage("table.confirm.totalSelections")).add("deleteSelectionsMsg", theme.getMessage("table.confirm.deleteSelections"));
    }

    private void appendGroupPanelProperties(FacesContext context, Table component, JsonObjectBuilder jsonBuilder) throws IOException {
        if (component == null) {
            TableRenderer.log("appendGroupPanelProperties", "Cannot obtain properties, Table is null");
            return;
        }
        String prefix = "_groupHeader" + UINamingContainer.getSeparatorChar((FacesContext)context);
        Theme theme = this.getTheme();
        jsonBuilder.add("columnFooterId", "_columnFooterBar").add("columnHeaderId", "_columnHeaderBar").add("tableColumnFooterId", "_tableColumnFooterBar").add("groupFooterId", "_groupFooterBar").add("groupPanelToggleButtonId", prefix + "_groupPanelToggleButton").add("groupPanelToggleButtonToolTipOpen", theme.getMessage("table.group.collapse")).add("groupPanelToggleButtonToolTipClose", theme.getMessage("table.group.expand")).add("groupPanelToggleIconOpen", theme.getImagePath("TABLE_GROUP_PANEL_FLIP")).add("groupPanelToggleIconClose", theme.getImagePath("TABLE_GROUP_PANEL")).add("warningIconId", prefix + "_warningIcon").add("warningIconOpen", theme.getImagePath("DOT")).add("warningIconClose", theme.getImagePath("ALERT_WARNING_SMALL")).add("warningIconToolTipOpen", JsonObject.NULL).add("warningIconToolTipClose", theme.getMessage("table.group.warning")).add("collapsedHiddenFieldId", prefix + "_collapsedHiddenField").add("selectMultipleToggleButtonId", prefix + "_selectMultipleToggleButton").add("selectMultipleToggleButtonToolTip", theme.getMessage("table.group.selectMultiple")).add("selectMultipleToggleButtonToolTipSelected", theme.getMessage("table.group.deselectMultiple"));
    }

    private void appendSortPanelProperties(FacesContext context, Table component, JsonObjectBuilder jsonBuilder) throws IOException {
        if (component == null) {
            TableRenderer.log("appendSortPanelProperties", "Cannot obtain properties, Table is null");
            return;
        }
        UIComponent panels = component.getFacet("_embeddedPanels");
        if (panels == null) {
            TableRenderer.log("appendSortPanelProperties", "Cannot obtain properties, Embedded panels facet is null");
            return;
        }
        Theme theme = this.getTheme();
        String prefix = panels.getClientId(context) + UINamingContainer.getSeparatorChar((FacesContext)context);
        JsonArray ary1 = JsonUtilities.JSON_BUILDER_FACTORY.createArrayBuilder().add(prefix + "_primarySortColumnMenu").add(prefix + "_secondarySortColumnMenu").add(prefix + "_tertiarySortColumnMenu").build();
        jsonBuilder.add("sortColumnMenuIds", (JsonValue)ary1);
        JsonArray ary2 = JsonUtilities.JSON_BUILDER_FACTORY.createArrayBuilder().add(prefix + "_primarySortOrderMenu").add(prefix + "_secondarySortOrderMenu").add(prefix + "_tertiarySortOrderMenu").build();
        jsonBuilder.add("sortOrderMenuIds", (JsonValue)ary2);
        JsonArray ary3 = JsonUtilities.JSON_BUILDER_FACTORY.createArrayBuilder().add(theme.getMessage("table.panel.primarySortOrder")).add(theme.getMessage("table.panel.secondarySortOrder")).add(theme.getMessage("table.panel.tertiarySortOrder")).build();
        jsonBuilder.add("sortOrderToolTips", (JsonValue)ary3);
        String value = this.getSelectSortMenuOptionValue(component);
        TableRowGroup group = component.getTableRowGroupChild();
        jsonBuilder.add("sortOrderToolTipsAscending", (JsonValue)this.getSortToolTipJavascript(component, false)).add("sortOrderToolTipsDescending", (JsonValue)this.getSortToolTipJavascript(component, true)).add("duplicateSelectionMsg", theme.getMessage("table.panel.duplicateSelectionError")).add("missingSelectionMsg", theme.getMessage("table.panel.missingSelectionError"));
        if (value != null) {
            jsonBuilder.add("selectSortMenuOptionValue", value);
        } else {
            jsonBuilder.add("selectSortMenuOptionValue", JsonObject.NULL);
        }
        jsonBuilder.add("hiddenSelectedRows", component.isHiddenSelectedRows());
        if (group != null) {
            jsonBuilder.add("paginated", group.isPaginated());
        } else {
            jsonBuilder.add("paginated", false);
        }
    }
}

