/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.rmic.tools.tree;

import org.glassfish.rmic.tools.java.ClassNotFound;
import org.glassfish.rmic.tools.java.Environment;
import org.glassfish.rmic.tools.java.Type;
import org.glassfish.rmic.tools.tree.BinaryExpression;
import org.glassfish.rmic.tools.tree.Context;
import org.glassfish.rmic.tools.tree.Expression;

public class BinaryEqualityExpression
extends BinaryExpression {
    public BinaryEqualityExpression(int op, long where, Expression left, Expression right) {
        super(op, where, Type.tBoolean, left, right);
    }

    @Override
    void selectType(Environment env, Context ctx, int tm) {
        if ((tm & 0x2000) != 0) {
            return;
        }
        if ((tm & 0x700) != 0) {
            try {
                if (env.explicitCast(this.left.type, this.right.type) || env.explicitCast(this.right.type, this.left.type)) {
                    return;
                }
                env.error(this.where, "incompatible.type", this.left.type, this.left.type, this.right.type);
            }
            catch (ClassNotFound e) {
                env.error(this.where, "class.not.found", e.name, opNames[this.op]);
            }
            return;
        }
        Type t = (tm & 0x80) != 0 ? Type.tDouble : ((tm & 0x40) != 0 ? Type.tFloat : ((tm & 0x20) != 0 ? Type.tLong : ((tm & 1) != 0 ? Type.tBoolean : Type.tInt)));
        this.left = this.convert(env, ctx, t, this.left);
        this.right = this.convert(env, ctx, t, this.right);
    }
}

