/*
 * Copyright (c) 2017, 2020 Oracle and/or its affiliates. All rights reserved.
 */

package javasoft.sqe.tests._int.mininclusive.mininclusive_1;

import jakarta.xml.bind.*;
import jakarta.xml.bind.TypeConstraintException;
import javasoft.sqe.javatest.Status;
import java.io.PrintWriter;
import javasoft.sqe.tests.api.jakarta.xml.bind.CTTest;

public class minInclusive1_ValidateCTTests extends CTTest {

    /**
     * Command line starter.
     */
    public static void main(String[] args) {
        minInclusive1_ValidateCTTests test = new minInclusive1_ValidateCTTests();
        PrintWriter err = new PrintWriter(System.err, true);
        PrintWriter out = new PrintWriter(System.out, true);
        Status status = test.run(args, err, out);
        err.flush();
        out.flush();
        status.exit();
    }

    final int[] validValues = {-2147483648, -21474, 0, 21474, 2147483647};
    
    JAXBElement<Integer> elemObj;

    Status testValid() {
        for (int i = 0; i < validValues.length; ++i){
            elemObj.setValue(validValues[i]);
            Status status = validate(elemObj);
            if (!status.isPassed()){
                return Status.failed("" + validValues[i] + " is unexpectedly invalid");
            }
        }
        return Status.passed("OKAY");
    }

    public Status Validate001( ) {
        String xmlDocName = "minInclusive-1-1.xml";
        elemObj = (JAXBElement<Integer>)unmarshal(xmlDocName);
        return testValid();
    }

    public Status Validate003( ) {
        elemObj = (JAXBElement<Integer>)(new ObjectFactory()).createNISTSchemaIntMinInclusive1(0);
        
        return testValid();
    }


}

