/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.cdi.tck.tests.context.request.async;

import com.gargoylesoftware.htmlunit.TextPage;
import com.gargoylesoftware.htmlunit.WebClient;
import java.net.URL;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.cdi.tck.AbstractTest;
import org.jboss.cdi.tck.shrinkwrap.ee.WebArchiveBuilder;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.testng.Assert;
import org.testng.annotations.Test;

@SpecVersion(spec="cdi", version="2.0")
public class RequestContextAsyncListenerTest
extends AbstractTest {
    @ArquillianResource
    private URL contextPath;

    @Deployment(testable=false)
    public static WebArchive createTestArchive() {
        return (WebArchive)((WebArchiveBuilder)new WebArchiveBuilder().withTestClassPackage(RequestContextAsyncListenerTest.class)).build();
    }

    @Test(groups={"integration", "asyncServlet"})
    @SpecAssertions(value={@SpecAssertion(section="request_context_ee", id="ad"), @SpecAssertion(section="request_context_ee", id="bd")})
    public void testRequestContextActiveOnComplete() throws Exception {
        WebClient webClient = new WebClient();
        webClient.getPage(this.getPath("complete"));
        TextPage results = (TextPage)webClient.getPage(String.valueOf(this.contextPath) + "Status");
        Assert.assertTrue((boolean)results.getContent().contains("onComplete: true"));
        webClient.getPage(this.getPath("complete"));
        TextPage results2 = (TextPage)webClient.getPage(String.valueOf(this.contextPath) + "Status");
        Assert.assertNotEquals((Object)this.extractSimpleRequestBeanIdString(results.getContent()), (Object)this.extractSimpleRequestBeanIdString(results2.getContent()));
    }

    @Test(groups={"integration", "asyncServlet"})
    @SpecAssertion(section="request_context_ee", id="ad")
    public void testRequestContextActiveOnTimeout() throws Exception {
        WebClient webClient = new WebClient();
        webClient.getPage(this.getPath("timeout"));
        TextPage results = (TextPage)webClient.getPage(String.valueOf(this.contextPath) + "Status");
        Assert.assertTrue((boolean)results.getContent().contains("onTimeout: true"));
    }

    @Test(groups={"integration", "asyncServlet"})
    @SpecAssertion(section="request_context_ee", id="ad")
    public void testRequestContextActiveOnError() throws Exception {
        WebClient webClient = new WebClient();
        webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
        webClient.getPage(this.getPath("error"));
        TextPage results = (TextPage)webClient.getPage(String.valueOf(this.contextPath) + "Status");
        Assert.assertTrue((boolean)results.getContent().contains("onError: true"));
    }

    @Test(groups={"integration", "asyncServlet"})
    @SpecAssertion(section="request_context_ee", id="ad")
    public void testRequestContextActiveOnStartAsync() throws Exception {
        WebClient webClient = new WebClient();
        webClient.getPage(this.getPath("loop"));
        TextPage results = (TextPage)webClient.getPage(String.valueOf(this.contextPath) + "Status");
        Assert.assertTrue((boolean)results.getContent().contains("onStartAsync: true"));
    }

    private String getPath(String test) {
        return String.valueOf(this.contextPath) + "AsyncServlet?test=" + test;
    }

    private String extractSimpleRequestBeanIdString(String content) {
        String[] tokens = content.split(",");
        return tokens[4];
    }
}

