/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core.sessiontests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.Connection;
import jakarta.jms.Destination;
import jakarta.jms.IllegalStateException;
import jakarta.jms.InvalidDestinationException;
import jakarta.jms.InvalidSelectorException;
import jakarta.jms.Message;
import jakarta.jms.MessageConsumer;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.QueueBrowser;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import jakarta.jms.Topic;
import jakarta.jms.TopicSubscriber;
import java.util.Enumeration;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SessionTestsIT {
    private static final String testName = "com.sun.ts.tests.jms.core.sessiontests.SessionTestsIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(SessionTestsIT.class.getName());
    private transient JmsTool tool = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null");
            }
            if (this.password == null) {
                throw new Exception("'password' is null");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("Setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
    }

    @Test
    public void SimpleSendAndReceiveQ() throws Exception {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            boolean pass = true;
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultConnection().start();
            messageSent = this.tool.getDefaultSession().createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "SimpleSendAndReceiveQ");
            logger.log(System.Logger.Level.TRACE, "Sending message to a Queue");
            this.tool.getDefaultProducer().send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultConsumer().receive(this.timeout);
            if (messageReceived.getText().equals(messageSent.getText())) {
                logger.log(System.Logger.Level.INFO, "Message text: \"" + messageReceived.getText() + "\"");
                logger.log(System.Logger.Level.INFO, "Received correct message");
            } else {
                logger.log(System.Logger.Level.ERROR, "didn't get the right message using Queue");
                pass = false;
            }
            if (!pass) {
                throw new Exception("SimpleSendAndReceiveQ Failed!");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("SimpleSendAndReceiveQ");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
                this.tool.flushDestination();
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Error closing Connection", (Throwable)ex);
            }
        }
    }

    @Test
    public void SimpleSendAndReceiveT() throws Exception {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            boolean pass = true;
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.tool.getDefaultConnection().start();
            messageSent = this.tool.getDefaultSession().createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "SimpleSendAndReceiveT");
            logger.log(System.Logger.Level.TRACE, "Sending message to a Topic");
            this.tool.getDefaultProducer().send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "Receiving message");
            messageReceived = (TextMessage)this.tool.getDefaultConsumer().receive(this.timeout);
            if (messageReceived.getText().equals(messageSent.getText())) {
                logger.log(System.Logger.Level.INFO, "Message text: \"" + messageReceived.getText() + "\"");
                logger.log(System.Logger.Level.INFO, "Received correct message");
            } else {
                logger.log(System.Logger.Level.ERROR, "didn't get the right message");
                pass = false;
            }
            if (!pass) {
                throw new Exception("SimpleSendAndReceiveT Failed!");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("SimpleSendAndReceiveT");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Error closing Connection", (Throwable)ex);
            }
        }
    }

    @Test
    public void selectorAndBrowserTests() throws Exception {
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            TextMessage tempMsg = null;
            boolean pass = true;
            int numMessages = 2;
            QueueBrowser browseAll = null;
            QueueBrowser selectiveBrowser = null;
            String message = "Just a Test Message from JMS TCK";
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultConsumer().close();
            this.tool.getDefaultConnection().start();
            messageSent = this.tool.getDefaultSession().createTextMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "selectorAndBrowserTests");
            messageSent.setText(message);
            messageSent.setBooleanProperty("lastMessage", false);
            this.tool.getDefaultProducer().send((Message)messageSent);
            messageSent.setStringProperty("TEST", "test");
            messageSent.setBooleanProperty("lastMessage", true);
            this.tool.getDefaultProducer().send((Message)messageSent);
            browseAll = this.tool.getDefaultSession().createBrowser((Queue)this.tool.getDefaultDestination());
            int msgCount = 0;
            Enumeration msgs = null;
            int i = 0;
            do {
                msgCount = 0;
                msgs = browseAll.getEnumeration();
                logger.log(System.Logger.Level.TRACE, "getting Enumeration " + ++i);
                while (msgs.hasMoreElements()) {
                    tempMsg = (TextMessage)msgs.nextElement();
                    if (!tempMsg.getText().equals(messageSent.getText())) continue;
                    ++msgCount;
                }
                logger.log(System.Logger.Level.TRACE, "found " + msgCount + " messages total in browser");
            } while (msgCount < 2 && i < 10);
            if (!browseAll.getQueue().toString().equals(this.tool.getDefaultDestination().toString())) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: QueueBrowser.getQueue test failed");
                logger.log(System.Logger.Level.ERROR, "QueueBrowser.getQueue=" + browseAll.getQueue().toString() + ".");
                logger.log(System.Logger.Level.ERROR, "tool.getDefaultDestination()=" + this.tool.getDefaultDestination().toString() + ".");
            }
            browseAll.close();
            selectiveBrowser = this.tool.getDefaultSession().createBrowser((Queue)this.tool.getDefaultDestination(), "TEST = 'test'");
            i = 0;
            do {
                msgCount = 0;
                msgs = selectiveBrowser.getEnumeration();
                logger.log(System.Logger.Level.TRACE, "getting Enumeration " + ++i);
                while (msgs.hasMoreElements()) {
                    tempMsg = (TextMessage)msgs.nextElement();
                    if (!tempMsg.getText().equals(messageSent.getText())) continue;
                    ++msgCount;
                }
                logger.log(System.Logger.Level.TRACE, "found " + msgCount + " messages total in browser");
            } while (msgCount < 1 && i < 10);
            String tmp = selectiveBrowser.getMessageSelector();
            if (tmp.indexOf("TEST") < 0 || tmp.indexOf("test") < 0) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: QueueBrowser.getMessageSelector test failed");
                logger.log(System.Logger.Level.ERROR, "selectiveBrowser.getMessageSelector()=" + selectiveBrowser.getMessageSelector());
            }
            selectiveBrowser.close();
            MessageConsumer SelectorConsumer = this.tool.getDefaultSession().createConsumer(this.tool.getDefaultDestination(), "TEST = 'test'");
            logger.log(System.Logger.Level.TRACE, "Receiving message with selective consumer");
            messageReceived = (TextMessage)SelectorConsumer.receive(this.timeout);
            if (messageReceived == null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Did not receive expected message");
            } else if (!messageReceived.getBooleanProperty("lastMessage")) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Received incorrect message");
            }
            SelectorConsumer.close();
            MessageConsumer qRec = this.tool.getDefaultSession().createConsumer(this.tool.getDefaultDestination());
            logger.log(System.Logger.Level.TRACE, "Receiving the remaining message");
            messageReceived = (TextMessage)qRec.receive(this.timeout);
            if (messageReceived == null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "message did not remain on queue");
            } else if (messageReceived.getBooleanProperty("lastMessage")) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "received incorrect message");
            }
            qRec.close();
            if (!pass) {
                throw new Exception("selectorAndBrowserTests Failed!");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("selectorAndBrowserTests");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
                this.tool.flushDestination();
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Error closing Connection", (Throwable)ex);
            }
        }
    }

    @Test
    public void SubscriberTests() throws Exception {
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        TextMessage messageSent = null;
        TextMessage messageReceived = null;
        Object tempMsg = null;
        int numMessages = 2;
        boolean pass = true;
        TopicSubscriber defaultSub = null;
        TopicSubscriber tSubSelect = null;
        TopicSubscriber tSubNoLocal = null;
        String subscriptionName1 = "DurableSubscriberNoLocal";
        String subscriptionName2 = "DurableSubscriberSelect";
        String subscriptionName3 = "DurableSubscriberDefault";
        Connection newConn = null;
        Session newSess = null;
        MessageProducer newPub = null;
        String clientID = "CTS";
        try {
            logger.log(System.Logger.Level.TRACE, "Setup tool for COMMON_T setup");
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            logger.log(System.Logger.Level.TRACE, "Create second connection and second session");
            newConn = this.tool.getNewConnection(14, this.user, this.password, lookup);
            newSess = newConn.createSession(false, 1);
            logger.log(System.Logger.Level.TRACE, "Create 3 durabale subscriptions (default, selector, nolocal) using second session");
            tSubNoLocal = newSess.createDurableSubscriber((Topic)this.tool.getDefaultDestination(), subscriptionName1, "", true);
            tSubSelect = newSess.createDurableSubscriber((Topic)this.tool.getDefaultDestination(), subscriptionName2, "TEST = 'test'", false);
            defaultSub = newSess.createDurableSubscriber((Topic)this.tool.getDefaultDestination(), subscriptionName3);
            logger.log(System.Logger.Level.TRACE, "Create producer using second session");
            newPub = newSess.createProducer(this.tool.getDefaultDestination());
            this.tool.getDefaultConnection().start();
            newConn.start();
            messageSent = this.tool.getDefaultSession().createTextMessage();
            messageSent.setText("Just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "SubscriberTests");
            logger.log(System.Logger.Level.TRACE, "Sending message to a Topic");
            messageSent.setBooleanProperty("lastMessage", false);
            newPub.send((Message)messageSent);
            messageSent.setStringProperty("TEST", "test");
            messageSent.setBooleanProperty("lastMessage", true);
            newPub.send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "tSubNoLocal Receiving message");
            messageReceived = (TextMessage)tSubNoLocal.receive(this.timeout);
            if (messageReceived != null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error:  No_local subscriber did receive local message");
            }
            logger.log(System.Logger.Level.TRACE, "defaultSub Receiving message");
            for (int i = 0; i < numMessages; ++i) {
                messageReceived = (TextMessage)defaultSub.receive(this.timeout);
                if (messageReceived == null) {
                    pass = false;
                    logger.log(System.Logger.Level.ERROR, "Error:  Did not receive message " + i);
                    continue;
                }
                if (messageReceived.getText().equals(messageSent.getText())) {
                    logger.log(System.Logger.Level.INFO, "Message text: \"" + messageReceived.getText() + "\"");
                    logger.log(System.Logger.Level.INFO, "Received correct message " + i);
                    continue;
                }
                logger.log(System.Logger.Level.ERROR, "Error: didn't get the right message " + i);
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "tSubSelect Receiving message");
            messageReceived = (TextMessage)tSubSelect.receive(this.timeout);
            if (messageReceived == null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error:  Did not receive correct message");
            } else if (messageReceived.getText().equals(messageSent.getText())) {
                logger.log(System.Logger.Level.INFO, "Message text: \"" + messageReceived.getText() + "\"");
                logger.log(System.Logger.Level.INFO, "Received correct message");
            } else {
                logger.log(System.Logger.Level.ERROR, "Error: didn't get the right message");
                pass = false;
            }
            logger.log(System.Logger.Level.TRACE, "sending message from default connection");
            messageSent.setBooleanProperty("newConnection", true);
            this.tool.getDefaultProducer().send((Message)messageSent);
            logger.log(System.Logger.Level.TRACE, "tSubNoLocal Receiving message");
            messageReceived = (TextMessage)tSubNoLocal.receive(this.timeout);
            if (messageReceived == null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error:  Did not receive correct message");
            } else if (messageReceived.getText().equals(messageSent.getText())) {
                logger.log(System.Logger.Level.INFO, "Message text: \"" + messageReceived.getText() + "\"");
                logger.log(System.Logger.Level.INFO, "Received correct message");
            } else {
                logger.log(System.Logger.Level.ERROR, "Error: didn't get the right message");
                pass = false;
            }
            if (!pass) {
                throw new Exception("SubscriberTests Failed!");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("SubscriberTests");
        }
        finally {
            try {
                logger.log(System.Logger.Level.TRACE, "Close 3 durable subscriptions");
                tSubNoLocal.close();
                defaultSub.close();
                tSubSelect.close();
                logger.log(System.Logger.Level.TRACE, "Unsubscribe from 3 durable subscriptions");
                newSess.unsubscribe(subscriptionName1);
                newSess.unsubscribe(subscriptionName2);
                newSess.unsubscribe(subscriptionName3);
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Error closing subscribers and unsubscribing from subscriptions", (Throwable)ex);
            }
            try {
                logger.log(System.Logger.Level.TRACE, "Closing new connection");
                newConn.close();
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Error closing the second Connection", (Throwable)ex);
            }
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Error closing Default Connection", (Throwable)ex);
            }
        }
    }

    @Test
    public void IllegalStateTestQ() throws Exception {
        try {
            TextMessage messageSent = null;
            Object messageReceived = null;
            boolean pass = true;
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultConnection().start();
            messageSent = this.tool.getDefaultSession().createTextMessage();
            messageSent.setText("just a test");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "IllegalStateTestQ");
            logger.log(System.Logger.Level.TRACE, "Sending message to a Queue");
            this.tool.getDefaultProducer().send((Message)messageSent);
            try {
                logger.log(System.Logger.Level.TRACE, "Rolling back a non-transacted session must throw IllegalStateException");
                this.tool.getDefaultSession().rollback();
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: QueueSession.rollback() didn't throw expected IllegalStateException");
            }
            catch (IllegalStateException en) {
                logger.log(System.Logger.Level.INFO, "Got expected IllegalStateException from QueueSession.rollback()");
            }
            if (!pass) {
                throw new Exception("IllegalStateTestQ");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("IllegalStateTestQ");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
                this.tool.flushDestination();
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Error closing Connection", (Throwable)ex);
            }
        }
    }

    @Test
    public void ackTests() throws Exception {
        try {
            boolean pass = true;
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            if (this.tool.getDefaultSession().getAcknowledgeMode() != 1) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: getAcknowledgeMode failed");
            }
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Error closing Connection", (Throwable)ex);
            }
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            if (this.tool.getDefaultSession().getAcknowledgeMode() != 1) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "Error: getAcknowledgeMode failed");
            }
            if (!pass) {
                throw new Exception("ackTests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("ackTests");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Error closing Connection", (Throwable)ex);
            }
        }
    }

    @Test
    public void InvalidDestinationTests() throws Exception {
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            TopicSubscriber tsub;
            boolean pass = true;
            Destination dummy = null;
            Topic dummyT = null;
            Queue dummyQ = null;
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.tool.getDefaultConsumer().close();
            try {
                this.tool.getDefaultSession().createConsumer(dummy);
                logger.log(System.Logger.Level.ERROR, "Error: createConsumer(null) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected InvalidDestinationException from createConsumer(null)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: createConsumer(null) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.getDefaultSession().createConsumer(dummy, "TEST = 'test'");
                logger.log(System.Logger.Level.ERROR, "Error: createConsumer(null, String) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected InvalidDestinationException from createConsumer(null, String)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: createConsumer(null, String) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.getDefaultSession().createConsumer(dummy, "TEST = 'test'", true);
                logger.log(System.Logger.Level.ERROR, "Error: createConsumer(null, String, boolean) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected InvalidDestinationException from createConsumer(null, String, true)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: createConsumer(null, String, true) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.getDefaultSession().createBrowser(dummyQ);
                logger.log(System.Logger.Level.ERROR, "Error: createBrowser(null) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected InvalidDestinationException from createBrowser(null)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: createBrowser(null) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.getDefaultSession().createBrowser(dummyQ, "TEST = 'test'");
                logger.log(System.Logger.Level.ERROR, "Error: createBrowser(null, String) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected InvalidDestinationException from createBrowser(null, String)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: createBrowser(null, String) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Error closing the default Connection", (Throwable)ex);
            }
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.tool.getDefaultConsumer().close();
            try {
                this.tool.getDefaultSession().createConsumer(dummy);
                logger.log(System.Logger.Level.ERROR, "Error: createConsumer(null) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected InvalidDestinationException from createConsumer(null)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: createConsumer(null) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.getDefaultSession().createConsumer(dummy, "TEST = 'test'");
                logger.log(System.Logger.Level.ERROR, "Error: createConsumer(null, String) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected InvalidDestinationException from createConsumer(null, String)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: createConsumer(null, String) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.getDefaultSession().createConsumer(dummy, "TEST = 'test'", true);
                logger.log(System.Logger.Level.ERROR, "Error: createConsumer(null, String, boolean) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected InvalidDestinationException from createConsumer(null, String, true)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: createConsumer(null, String, true) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Error closing default Connection", (Throwable)ex);
            }
            Connection newConn = this.tool.getNewConnection(14, this.user, this.password, lookup);
            Session newSession = newConn.createSession(false, 1);
            try {
                newSession.unsubscribe("foo");
                logger.log(System.Logger.Level.ERROR, "Error: unsubscribe(foo) didn't throw expected InvalidDestinationException");
                pass = false;
            }
            catch (InvalidDestinationException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected InvalidDestinationException from unsubscribe(foo)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: unsubscribe(foo) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                tsub = newSession.createDurableSubscriber(dummyT, "cts");
                logger.log(System.Logger.Level.ERROR, "Error: createDurableSubscriber(null, String) didn't throw expected InvalidDestinationException");
                pass = false;
                tsub.close();
                newSession.unsubscribe("cts");
            }
            catch (InvalidDestinationException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected InvalidDestinationException from createDurableSubscriber(null, String)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: createDurableSubscriber(null, String) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                tsub = newSession.createDurableSubscriber(dummyT, "cts", "TEST = 'test'", true);
                logger.log(System.Logger.Level.ERROR, "Error: createDurableSubscriber(null, String, String, boolean) didn't throw expected InvalidDestinationException");
                pass = false;
                tsub.close();
                newSession.unsubscribe("cts");
            }
            catch (InvalidDestinationException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected InvalidDestinationException from createDurableSubscriber(null, String, String, boolean)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: createDurableSubscriber(null, String, String, boolean) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                newConn.close();
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Error closing new Connection", (Throwable)ex);
            }
            if (!pass) {
                throw new Exception("InvalidDestinationTests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("InvalidDestinationTests");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Error closing Connection", (Throwable)ex);
            }
        }
    }

    @Test
    public void InvalidSelectorTests() throws Exception {
        String lookup = "DURABLE_SUB_CONNECTION_FACTORY";
        try {
            boolean pass = true;
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.tool.getDefaultConsumer().close();
            try {
                this.tool.getDefaultSession().createConsumer(this.tool.getDefaultDestination(), "=TEST 'test'");
                logger.log(System.Logger.Level.ERROR, "Error: createConsumer(Destination, String) didn't throw expected InvalidSelectorException");
                pass = false;
            }
            catch (InvalidSelectorException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected InvalidSelectorException from createConsumer(Destination, String)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: createConsumer(Destination, String) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.getDefaultSession().createBrowser((Queue)this.tool.getDefaultDestination(), "=TEST 'test'");
                logger.log(System.Logger.Level.ERROR, "Error: createBrowser(Queue, String) didn't throw expected InvalidSelectorException");
                pass = false;
            }
            catch (InvalidSelectorException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected InvalidSelectorException from createBrowser(Queue, String)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: createBrowser(Queue, String) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Error closing Connection", (Throwable)ex);
            }
            this.tool = new JmsTool(14, this.user, this.password, this.mode);
            this.tool.getDefaultProducer().close();
            this.tool.getDefaultConsumer().close();
            Connection newConn = this.tool.getNewConnection(14, this.user, this.password, lookup);
            Session newSess = newConn.createSession(false, 1);
            try {
                TopicSubscriber tsub = newSess.createDurableSubscriber((Topic)this.tool.getDefaultDestination(), "mysubscription", "=TEST 'test'", true);
                logger.log(System.Logger.Level.ERROR, "Error: createDurableSubscriber(Topic, String, String, boolean) didn't throw expected InvalidSelectorException");
                pass = false;
                tsub.close();
                newSess.unsubscribe("mysubscription");
            }
            catch (InvalidSelectorException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected InvalidSelectorException from createDurableSubscriber(Topic, String, String, boolean)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: createDurableSubscriber(Topic, String, String, boolean) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            try {
                newConn.close();
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Error closing new Connection", (Throwable)ex);
            }
            try {
                this.tool.getDefaultSession().createConsumer(this.tool.getDefaultDestination(), "=TEST 'test'", true);
                logger.log(System.Logger.Level.ERROR, "Error: createConsumer(Destination, String, boolean) didn't throw expected InvalidSelectorException");
                pass = false;
            }
            catch (InvalidSelectorException ex) {
                logger.log(System.Logger.Level.INFO, "Got expected InvalidSelectorException from createConsumer(Destination, String, boolean)");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error: createConsumer(Destination, String, boolean) throw incorrect Exception: ", (Throwable)e);
                pass = false;
            }
            if (!pass) {
                throw new Exception("InvalidSelectorTests");
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("InvalidSelectorTests");
        }
        finally {
            try {
                this.tool.closeDefaultConnections();
            }
            catch (Exception ex) {
                logger.log(System.Logger.Level.ERROR, "Error closing Connection", (Throwable)ex);
            }
        }
    }
}

