/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.core20.jmsproducerqueuetests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.common.JmsTool;
import jakarta.jms.BytesMessage;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.Destination;
import jakarta.jms.JMSConsumer;
import jakarta.jms.JMSContext;
import jakarta.jms.JMSProducer;
import jakarta.jms.MapMessage;
import jakarta.jms.Message;
import jakarta.jms.MessageFormatException;
import jakarta.jms.MessageFormatRuntimeException;
import jakarta.jms.MessageNotWriteableRuntimeException;
import jakarta.jms.ObjectMessage;
import jakarta.jms.Queue;
import jakarta.jms.StreamMessage;
import jakarta.jms.TextMessage;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ClientIT {
    private static final String testName = "com.sun.ts.tests.jms.core20.jmsproducerqueuetests.ClientIT";
    private static final String testDir = System.getProperty("user.dir");
    private static final long serialVersionUID = 1L;
    private static final System.Logger logger = System.getLogger(ClientIT.class.getName());
    private transient JmsTool tool = null;
    private transient ConnectionFactory cf = null;
    private transient Queue queue = null;
    private transient Destination destination = null;
    private transient JMSContext context = null;
    private transient JMSProducer producer = null;
    private transient JMSConsumer consumer = null;
    private Properties props = null;
    long timeout;
    String user;
    String password;
    String mode;
    private static final int numMessages = 3;
    private static final int iterations = 5;
    ArrayList queues = null;
    ArrayList connections = null;

    private boolean verifyMetaData(ConnectionMetaData data) {
        String tmp;
        boolean pass = true;
        try {
            String tmp2 = data.getJMSVersion();
            logger.log(System.Logger.Level.TRACE, "JMSVersion=" + tmp2);
            if (!tmp2.equals("2.0")) {
                logger.log(System.Logger.Level.ERROR, "Error: incorrect JMSVersion=" + tmp2);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for JMSVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp3 = data.getJMSMajorVersion();
            logger.log(System.Logger.Level.TRACE, "JMSMajorVersion=" + tmp3);
            if (tmp3 != 2) {
                logger.log(System.Logger.Level.ERROR, "Error: incorrect JMSMajorVersion=" + tmp3);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for JMSMajorVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp4 = data.getJMSMinorVersion();
            logger.log(System.Logger.Level.TRACE, "JMSMinorVersion=" + tmp4);
            if (tmp4 != 0) {
                logger.log(System.Logger.Level.ERROR, "Error: incorrect JMSMajorVersion=" + tmp4);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for JMSMinorVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            tmp = data.getJMSProviderName();
            logger.log(System.Logger.Level.TRACE, "JMSProviderName=" + tmp);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for JMSProviderName: ", (Throwable)e);
            pass = false;
        }
        try {
            tmp = data.getProviderVersion();
            logger.log(System.Logger.Level.TRACE, "JMSProviderVersion=" + tmp);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for ProviderVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp5 = data.getProviderMajorVersion();
            logger.log(System.Logger.Level.TRACE, "ProviderMajorVersion=" + tmp5);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for ProviderMajorVersion: ", (Throwable)e);
            pass = false;
        }
        try {
            int tmp6 = data.getProviderMinorVersion();
            logger.log(System.Logger.Level.TRACE, "ProviderMinorVersion=" + tmp6);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Error: incorrect type returned for ProviderMinorVersion: ", (Throwable)e);
            pass = false;
        }
        return pass;
    }

    private boolean chkMessageID(String id) {
        String[] status = new String[]{"Pass", "Fail"};
        boolean retcode = true;
        int index = 0;
        if (id != null && !id.startsWith("ID:")) {
            index = 1;
            retcode = false;
        }
        logger.log(System.Logger.Level.TRACE, "Results: " + status[index]);
        return retcode;
    }

    @BeforeEach
    public void setup() throws Exception {
        try {
            this.timeout = Long.parseLong(System.getProperty("jms_timeout"));
            this.user = System.getProperty("user");
            this.password = System.getProperty("password");
            this.mode = System.getProperty("platform.mode");
            if (this.timeout < 1L) {
                throw new Exception("'jms_timeout' (milliseconds) in must be > 0");
            }
            if (this.user == null) {
                throw new Exception("'user' is null ");
            }
            if (this.password == null) {
                throw new Exception("'password' is null ");
            }
            if (this.mode == null) {
                throw new Exception("'platform.mode' is null");
            }
            this.queues = new ArrayList(3);
            this.connections = new ArrayList(5);
            logger.log(System.Logger.Level.INFO, "Setup JmsTool for COMMON_Q");
            this.tool = new JmsTool(13, this.user, this.password, this.mode);
            this.cf = this.tool.getConnectionFactory();
            this.tool.getDefaultConnection().close();
            this.destination = this.tool.getDefaultDestination();
            this.queue = (Queue)this.destination;
            logger.log(System.Logger.Level.INFO, "Create JMSContext, JMSConsumer and JMSProducer");
            this.context = this.cf.createContext(this.user, this.password, 1);
            this.producer = this.context.createProducer();
            this.consumer = this.context.createConsumer(this.destination);
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("setup failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            logger.log(System.Logger.Level.INFO, "Close JMSContext Objects");
            if (this.context != null) {
                this.context.close();
                this.context = null;
            }
            this.producer = null;
            logger.log(System.Logger.Level.INFO, "Flush any messages left on Queue");
            this.tool.flushDestination();
            logger.log(System.Logger.Level.INFO, "Close JMSConsumer objects");
            if (this.consumer != null) {
                this.consumer.close();
                this.consumer = null;
            }
            this.tool.closeAllResources();
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("cleanup failed!", e);
        }
    }

    @Test
    public void sendAndRecvTest1() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        try {
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvTest1");
            logger.log(System.Logger.Level.INFO, "Sending TextMessage via JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Receive TextMessage via JMSconsumer.receive(long)");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
            if (actTextMessage.getText().equals(expTextMessage.getText())) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendAndRecvTest1", e);
        }
        if (!pass) {
            throw new Exception("sendAndRecvTest1 failed");
        }
    }

    @Test
    public void sendAndRecvTest2() throws Exception {
        boolean pass = true;
        String expTextMessage = "Where are you!";
        try {
            logger.log(System.Logger.Level.INFO, "Sending TextMessage via JMSProducer.send(Destination, String)");
            this.producer.send(this.destination, expTextMessage);
            logger.log(System.Logger.Level.INFO, "Receive TextMessage via JMSConsumer.receiveBody(String, long)");
            String actTextMessage = (String)this.consumer.receiveBody(String.class, this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
            if (actTextMessage.equals(expTextMessage)) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage + ", received " + actTextMessage);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendAndRecvTest2", e);
        }
        if (!pass) {
            throw new Exception("sendAndRecvTest2 failed");
        }
    }

    @Test
    public void sendAndRecvTest3() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "Send ObjectMessage");
            logger.log(System.Logger.Level.INFO, "Set some values in ObjectMessage");
            ObjectMessage expObjectMessage = this.context.createObjectMessage();
            StringBuffer expSb = new StringBuffer("Where are you!");
            logger.log(System.Logger.Level.INFO, "Set object in ObjectMessage to a StringBuffer");
            expObjectMessage.setObject((Serializable)expSb);
            expObjectMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvTest3");
            logger.log(System.Logger.Level.INFO, "Sending TextMessage via JMSProducer.send(Destination, Serializable)");
            this.producer.send(this.destination, (Message)expObjectMessage);
            logger.log(System.Logger.Level.INFO, "Receive ObjectMessage via JMSConsumer.receiveBody(Serializable.class, long)");
            StringBuffer actSb = (StringBuffer)this.consumer.receiveBody(Serializable.class, this.timeout);
            if (actSb == null) {
                throw new Exception("Did not receive ObjectMessage");
            }
            logger.log(System.Logger.Level.INFO, "Check the value in ObjectMessage");
            if (actSb.toString().equals(expSb.toString())) {
                logger.log(System.Logger.Level.INFO, "ObjectMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "ObjectMessage is incorrect expected " + expSb.toString() + ", received " + actSb.toString());
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendAndRecvTest3", e);
        }
        if (!pass) {
            throw new Exception("sendAndRecvTest3 failed");
        }
    }

    @Test
    public void sendAndRecvTest4() throws Exception {
        boolean pass = true;
        HashMap<String, Object> mapMsgSend = new HashMap<String, Object>();
        mapMsgSend.put("StringValue", "sendAndRecvTest4");
        mapMsgSend.put("BooleanValue", true);
        mapMsgSend.put("IntValue", 10);
        try {
            logger.log(System.Logger.Level.INFO, "Send MapMessage via JMSProducer.send(Destination, Map<String, Object>)");
            this.producer.send(this.destination, mapMsgSend);
            logger.log(System.Logger.Level.INFO, "Receive MapMessage via JMSConsumer.receiveBody(Map.class, long)");
            Map mapMsgRecv = (Map)this.consumer.receiveBody(Map.class, this.timeout);
            if (mapMsgRecv == null) {
                throw new Exception("Did not receive MapMessage");
            }
            logger.log(System.Logger.Level.INFO, "Compare MapMsgSend and MapMsgRecv for equality");
            for (Map.Entry entry : mapMsgSend.entrySet()) {
                String key = (String)entry.getKey();
                logger.log(System.Logger.Level.INFO, "key " + key + ": " + entry.getValue().equals(mapMsgRecv.get(key)));
                if (entry.getValue().equals(mapMsgRecv.get(key))) continue;
                pass = false;
            }
            if (pass) {
                logger.log(System.Logger.Level.INFO, "MapMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "MapMessage is incorrect expected " + mapMsgSend + ", received " + mapMsgRecv);
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendAndRecvTest4", e);
        }
        if (!pass) {
            throw new Exception("sendAndRecvTest4 failed");
        }
    }

    @Test
    public void sendAndRecvTest5() throws Exception {
        boolean pass = true;
        String messageSend = "Where are you!";
        byte[] bytesMsgSend = messageSend.getBytes();
        try {
            logger.log(System.Logger.Level.INFO, "Send BytesMessage via JMSProducer.send(Destination, byte[])");
            this.producer.send(this.destination, bytesMsgSend);
            logger.log(System.Logger.Level.INFO, "Receive BytesMessage via JMSConsumer.receiveBody(byte[].class, long)");
            byte[] bytesMsgRecv = (byte[])this.consumer.receiveBody(byte[].class, this.timeout);
            if (bytesMsgRecv == null) {
                throw new Exception("Did not receive BytesMessage");
            }
            logger.log(System.Logger.Level.INFO, "Compare BytesMsgSend and BytesMsgRecv for equality");
            String messageRecv = new String(bytesMsgRecv);
            if (messageRecv.equals(messageSend)) {
                logger.log(System.Logger.Level.INFO, "BytesMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "BytesMessage is incorrect expected " + messageRecv + ", received " + messageSend);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendAndRecvTest5", e);
        }
        if (!pass) {
            throw new Exception("sendAndRecvTest5 failed");
        }
    }

    @Test
    public void sendAndRecvMsgsOfEachMsgTypeTest() throws Exception {
        boolean pass = true;
        try {
            StringBuffer sb2;
            logger.log(System.Logger.Level.INFO, "Send Message");
            Message msg = this.context.createMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in Message");
            msg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeTest");
            msg.setBooleanProperty("booleanProperty", true);
            this.producer.send(this.destination, msg);
            long deliveryTime = msg.getJMSDeliveryTime();
            logger.log(System.Logger.Level.INFO, "Receive Message");
            Message msgRecv = this.consumer.receive(this.timeout);
            if (msgRecv == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive Message");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the values in Message");
                if (msgRecv.getBooleanProperty("booleanProperty")) {
                    logger.log(System.Logger.Level.INFO, "booleanproperty is correct");
                } else {
                    logger.log(System.Logger.Level.INFO, "booleanproperty is incorrect");
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "Send BytesMessage");
            BytesMessage bMsg = this.context.createBytesMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in BytesMessage");
            bMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeTest");
            bMsg.writeByte((byte)1);
            bMsg.writeInt(22);
            this.producer.send(this.destination, (Message)bMsg);
            deliveryTime = bMsg.getJMSDeliveryTime();
            logger.log(System.Logger.Level.INFO, "Receive BytesMessage");
            BytesMessage bMsgRecv = (BytesMessage)this.consumer.receive(this.timeout);
            if (bMsgRecv == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive BytesMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the values in BytesMessage");
                if (bMsgRecv.readByte() == 1) {
                    logger.log(System.Logger.Level.INFO, "bytevalue is correct");
                } else {
                    logger.log(System.Logger.Level.INFO, "bytevalue is incorrect");
                    pass = false;
                }
                if (bMsgRecv.readInt() == 22) {
                    logger.log(System.Logger.Level.INFO, "intvalue is correct");
                } else {
                    logger.log(System.Logger.Level.INFO, "intvalue is incorrect");
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "Send MapMessage");
            MapMessage mMsg = this.context.createMapMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in MapMessage");
            mMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeTest");
            mMsg.setBoolean("booleanvalue", true);
            mMsg.setInt("intvalue", 10);
            this.producer.send(this.destination, (Message)mMsg);
            deliveryTime = mMsg.getJMSDeliveryTime();
            logger.log(System.Logger.Level.INFO, "Receive MapMessage");
            MapMessage mMsgRecv = (MapMessage)this.consumer.receive(this.timeout);
            if (mMsgRecv == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive MapMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the values in MapMessage");
                Enumeration list = mMsgRecv.getMapNames();
                String name = null;
                while (list.hasMoreElements()) {
                    name = (String)list.nextElement();
                    if (name.equals("booleanvalue")) {
                        if (mMsgRecv.getBoolean(name)) {
                            logger.log(System.Logger.Level.INFO, "booleanvalue is correct");
                            continue;
                        }
                        logger.log(System.Logger.Level.ERROR, "booleanvalue is incorrect");
                        pass = false;
                        continue;
                    }
                    if (name.equals("intvalue")) {
                        if (mMsgRecv.getInt(name) == 10) {
                            logger.log(System.Logger.Level.INFO, "intvalue is correct");
                            continue;
                        }
                        logger.log(System.Logger.Level.ERROR, "intvalue is incorrect");
                        pass = false;
                        continue;
                    }
                    logger.log(System.Logger.Level.ERROR, "Unexpected name of [" + name + "] in MapMessage");
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "Send ObjectMessage");
            StringBuffer sb1 = new StringBuffer("This is a StringBuffer");
            logger.log(System.Logger.Level.INFO, "Set some values in ObjectMessage");
            ObjectMessage oMsg = this.context.createObjectMessage();
            oMsg.setObject((Serializable)sb1);
            oMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeTest");
            this.producer.send(this.destination, (Message)oMsg);
            deliveryTime = oMsg.getJMSDeliveryTime();
            logger.log(System.Logger.Level.INFO, "Receive ObjectMessage");
            ObjectMessage oMsgRecv = (ObjectMessage)this.consumer.receive(this.timeout);
            if (oMsgRecv == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive ObjectMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the value in ObjectMessage");
                sb2 = (StringBuffer)oMsgRecv.getObject();
                if (sb2.toString().equals(sb1.toString())) {
                    logger.log(System.Logger.Level.INFO, "objectvalue is correct");
                } else {
                    logger.log(System.Logger.Level.ERROR, "objectvalue is incorrect");
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "Send ObjectMessage passing object as param");
            sb1 = new StringBuffer("This is a StringBuffer");
            logger.log(System.Logger.Level.INFO, "Set some values in ObjectMessage passing object as param");
            oMsg = this.context.createObjectMessage((Serializable)sb1);
            oMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeTest");
            this.producer.send(this.destination, (Message)oMsg);
            deliveryTime = oMsg.getJMSDeliveryTime();
            logger.log(System.Logger.Level.INFO, "Receive ObjectMessage");
            oMsgRecv = (ObjectMessage)this.consumer.receive(this.timeout);
            if (oMsgRecv == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive ObjectMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the value in ObjectMessage");
                sb2 = (StringBuffer)oMsgRecv.getObject();
                if (sb2.toString().equals(sb1.toString())) {
                    logger.log(System.Logger.Level.INFO, "objectvalue is correct");
                } else {
                    logger.log(System.Logger.Level.ERROR, "objectvalue is incorrect");
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "Send StreamMessage");
            StreamMessage sMsg = this.context.createStreamMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in StreamMessage");
            sMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeTest");
            sMsg.writeBoolean(true);
            sMsg.writeInt(22);
            this.producer.send(this.destination, (Message)sMsg);
            deliveryTime = sMsg.getJMSDeliveryTime();
            logger.log(System.Logger.Level.INFO, "Receive StreamMessage");
            StreamMessage sMsgRecv = (StreamMessage)this.consumer.receive(this.timeout);
            if (sMsgRecv == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive StreamMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the values in StreamMessage");
                if (sMsgRecv.readBoolean()) {
                    logger.log(System.Logger.Level.INFO, "booleanvalue is correct");
                } else {
                    logger.log(System.Logger.Level.INFO, "booleanvalue is incorrect");
                    pass = false;
                }
                if (sMsgRecv.readInt() == 22) {
                    logger.log(System.Logger.Level.INFO, "intvalue is correct");
                } else {
                    logger.log(System.Logger.Level.INFO, "intvalue is incorrect");
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "Send TextMessage");
            TextMessage tMsg = this.context.createTextMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            tMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeTest");
            tMsg.setText("Hello There!");
            this.producer.send(this.destination, (Message)tMsg);
            deliveryTime = tMsg.getJMSDeliveryTime();
            logger.log(System.Logger.Level.INFO, "Receive TextMessage");
            TextMessage tMsgRecv = (TextMessage)this.consumer.receive(this.timeout);
            if (tMsgRecv == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive TextMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
                if (tMsgRecv.getText().equals("Hello There!")) {
                    logger.log(System.Logger.Level.INFO, "TextMessage is correct");
                } else {
                    logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect");
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "Send TextMessage");
            tMsg = this.context.createTextMessage("Where are you!");
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            tMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "sendAndRecvMsgsOfEachMsgTypeTest");
            this.producer.send(this.destination, (Message)tMsg);
            deliveryTime = tMsg.getJMSDeliveryTime();
            logger.log(System.Logger.Level.INFO, "Receive TextMessage");
            tMsgRecv = (TextMessage)this.consumer.receive(this.timeout);
            if (tMsgRecv == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive TextMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
                if (tMsgRecv.getText().equals("Where are you!")) {
                    logger.log(System.Logger.Level.INFO, "TextMessage is correct");
                } else {
                    logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("sendAndRecvMsgsOfEachMsgTypeTest", e);
        }
        if (!pass) {
            throw new Exception("sendAndRecvMsgsOfEachMsgTypeTest failed");
        }
    }

    @Test
    public void setGetDeliveryModeTest() throws Exception {
        int actDeliveryMode;
        int expDeliveryMode;
        boolean pass = true;
        try {
            expDeliveryMode = 2;
            logger.log(System.Logger.Level.INFO, "Calling getDeliveryMode and expect " + expDeliveryMode + " to be returned");
            actDeliveryMode = this.producer.getDeliveryMode();
            if (actDeliveryMode != expDeliveryMode) {
                logger.log(System.Logger.Level.ERROR, "getDeliveryMode() returned " + actDeliveryMode + ", expected " + expDeliveryMode);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("setGetDeliveryModeTest");
        }
        try {
            expDeliveryMode = 1;
            logger.log(System.Logger.Level.INFO, "Calling setDeliveryMode(" + expDeliveryMode + ")");
            this.producer.setDeliveryMode(expDeliveryMode);
            logger.log(System.Logger.Level.INFO, "Calling getDeliveryMode and expect " + expDeliveryMode + " to be returned");
            actDeliveryMode = this.producer.getDeliveryMode();
            if (actDeliveryMode != expDeliveryMode) {
                logger.log(System.Logger.Level.ERROR, "getDeliveryMode() returned " + actDeliveryMode + ", expected " + expDeliveryMode);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("setGetDeliveryModeTest");
        }
        if (!pass) {
            throw new Exception("setGetDeliveryModeTest failed");
        }
    }

    @Test
    public void setGetDeliveryDelayTest() throws Exception {
        long actDeliveryDelay;
        long expDeliveryDelay;
        boolean pass = true;
        try {
            expDeliveryDelay = 0L;
            logger.log(System.Logger.Level.INFO, "Calling getDeliveryDelay and expect " + expDeliveryDelay + " to be returned");
            actDeliveryDelay = this.producer.getDeliveryDelay();
            if (actDeliveryDelay != expDeliveryDelay) {
                logger.log(System.Logger.Level.ERROR, "getDeliveryDelay() returned " + actDeliveryDelay + ", expected " + expDeliveryDelay);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("setGetDeliveryDelayTest");
        }
        try {
            expDeliveryDelay = 1L;
            logger.log(System.Logger.Level.INFO, "Calling setDeliveryDelay(" + expDeliveryDelay + ")");
            this.producer.setDeliveryDelay(expDeliveryDelay);
            logger.log(System.Logger.Level.INFO, "Calling getDeliveryDelay and expect " + expDeliveryDelay + " to be returned");
            actDeliveryDelay = this.producer.getDeliveryDelay();
            if (actDeliveryDelay != expDeliveryDelay) {
                logger.log(System.Logger.Level.ERROR, "getDeliveryDelay() returned " + actDeliveryDelay + ", expected " + expDeliveryDelay);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("setGetDeliveryDelayTest");
        }
        if (!pass) {
            throw new Exception("setGetDeliveryDelayTest failed");
        }
    }

    @Test
    public void setGetDisableMessageIDTest() throws Exception {
        boolean actDisableMessageID;
        boolean expDisableMessageID;
        boolean pass = true;
        try {
            expDisableMessageID = true;
            logger.log(System.Logger.Level.INFO, "Calling setDisableMessageID(" + expDisableMessageID + ")");
            this.producer.setDisableMessageID(expDisableMessageID);
            logger.log(System.Logger.Level.INFO, "Calling getDisableMessageID and expect " + expDisableMessageID + " to be returned");
            actDisableMessageID = this.producer.getDisableMessageID();
            if (actDisableMessageID != expDisableMessageID) {
                logger.log(System.Logger.Level.ERROR, "getDisableMessageID() returned " + actDisableMessageID + ", expected " + expDisableMessageID);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("setGetDisableMessageIDTest");
        }
        try {
            expDisableMessageID = false;
            logger.log(System.Logger.Level.INFO, "Calling setDisableMessageID(" + expDisableMessageID + ")");
            this.producer.setDisableMessageID(expDisableMessageID);
            logger.log(System.Logger.Level.INFO, "Calling getDisableMessageID and expect " + expDisableMessageID + " to be returned");
            actDisableMessageID = this.producer.getDisableMessageID();
            if (actDisableMessageID != expDisableMessageID) {
                logger.log(System.Logger.Level.ERROR, "getDisableMessageID() returned " + actDisableMessageID + ", expected " + expDisableMessageID);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("setGetDisableMessageIDTest");
        }
        if (!pass) {
            throw new Exception("setGetDisableMessageIDTest failed");
        }
    }

    @Test
    public void setGetDisableMessageTimestampTest() throws Exception {
        boolean actDisableMessageTimestamp;
        boolean expDisableMessageTimestamp;
        boolean pass = true;
        try {
            expDisableMessageTimestamp = true;
            logger.log(System.Logger.Level.INFO, "Calling setDisableMessageTimestamp(" + expDisableMessageTimestamp + ")");
            this.producer.setDisableMessageTimestamp(expDisableMessageTimestamp);
            logger.log(System.Logger.Level.INFO, "Calling getDisableMessageTimestamp and expect " + expDisableMessageTimestamp + " to be returned");
            actDisableMessageTimestamp = this.producer.getDisableMessageTimestamp();
            if (actDisableMessageTimestamp != expDisableMessageTimestamp) {
                logger.log(System.Logger.Level.ERROR, "getDisableMessageTimestamp() returned " + actDisableMessageTimestamp + ", expected " + expDisableMessageTimestamp);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("setGetDisableMessageTimestampTest");
        }
        try {
            expDisableMessageTimestamp = false;
            logger.log(System.Logger.Level.INFO, "Calling setDisableMessageTimestamp(" + expDisableMessageTimestamp + ")");
            this.producer.setDisableMessageTimestamp(expDisableMessageTimestamp);
            logger.log(System.Logger.Level.INFO, "Calling getDisableMessageTimestamp and expect " + expDisableMessageTimestamp + " to be returned");
            actDisableMessageTimestamp = this.producer.getDisableMessageTimestamp();
            if (actDisableMessageTimestamp != expDisableMessageTimestamp) {
                logger.log(System.Logger.Level.ERROR, "getDisableMessageTimestamp() returned " + actDisableMessageTimestamp + ", expected " + expDisableMessageTimestamp);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("setGetDisableMessageTimestampTest");
        }
        if (!pass) {
            throw new Exception("setGetDisableMessageTimestampTest failed");
        }
    }

    @Test
    public void setGetPriorityTest() throws Exception {
        boolean pass = true;
        try {
            int expPriority = 4;
            logger.log(System.Logger.Level.INFO, "Calling getPriority and expect " + expPriority + " to be returned");
            int actPriority = this.producer.getPriority();
            if (actPriority != expPriority) {
                logger.log(System.Logger.Level.ERROR, "getPriority() returned " + actPriority + ", expected " + expPriority);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("setGetPriorityTest");
        }
        int[] expPriority = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9};
        for (int i = 0; i < expPriority.length; ++i) {
            try {
                logger.log(System.Logger.Level.INFO, "Calling setPriority(" + expPriority[i] + ")");
                this.producer.setPriority(expPriority[i]);
                logger.log(System.Logger.Level.INFO, "Calling getPriority and expect " + expPriority[i] + " to be returned");
                int actPriority = this.producer.getPriority();
                if (actPriority == expPriority[i]) continue;
                logger.log(System.Logger.Level.ERROR, "getPriority() returned " + actPriority + ", expected " + expPriority[i]);
                pass = false;
                continue;
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
                throw new Exception("setGetPriorityTest");
            }
        }
        if (!pass) {
            throw new Exception("setGetPriorityTest failed");
        }
    }

    @Test
    public void setGetTimeToLiveTest() throws Exception {
        boolean pass = true;
        try {
            long expTimeToLive = 0L;
            logger.log(System.Logger.Level.INFO, "Calling getTimeToLive and expect " + expTimeToLive + " to be returned");
            long actTimeToLive = this.producer.getTimeToLive();
            if (actTimeToLive != expTimeToLive) {
                logger.log(System.Logger.Level.ERROR, "getTimeToLive() returned " + actTimeToLive + ", expected " + expTimeToLive);
                pass = false;
            }
            expTimeToLive = 1000L;
            logger.log(System.Logger.Level.INFO, "Calling setTimeToLive(" + expTimeToLive + ")");
            this.producer.setTimeToLive(expTimeToLive);
            logger.log(System.Logger.Level.INFO, "Calling getTimeToLive and expect " + expTimeToLive + " to be returned");
            actTimeToLive = this.producer.getTimeToLive();
            if (actTimeToLive != expTimeToLive) {
                logger.log(System.Logger.Level.ERROR, "getTimeToLive() returned " + actTimeToLive + ", expected " + expTimeToLive);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("setGetTimeToLiveTest");
        }
        if (!pass) {
            throw new Exception("setGetTimeToLiveTest failed");
        }
    }

    @Test
    public void deliveryDelayTest() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "------------------------------------------------------");
            logger.log(System.Logger.Level.INFO, "BEGIN TEST deliveryDelayTest with DeliveryDelay=20Secs");
            logger.log(System.Logger.Level.INFO, "------------------------------------------------------");
            this.producer.setDeliveryDelay(20000L);
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage message = this.context.createTextMessage("This is a test!");
            logger.log(System.Logger.Level.INFO, "Set StringProperty COM_SUN_JMS_TESTNAME");
            message.setStringProperty("COM_SUN_JMS_TESTNAME", "deliveryDelayTest");
            logger.log(System.Logger.Level.INFO, "Sending message with DeliveryMode.PERSISTENT and DeliveryDelay=20Secs");
            this.producer.setDeliveryMode(2);
            this.producer.setPriority(4);
            this.producer.setTimeToLive(0L);
            this.producer.send(this.destination, (Message)message);
            logger.log(System.Logger.Level.INFO, "Waiting 10 seconds to receive message");
            message = (TextMessage)this.consumer.receive(10000L);
            if (message != null) {
                logger.log(System.Logger.Level.ERROR, "FAILED: Message received before delivery delay of 20 secs elapsed");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Didn't receive message after 10 seconds (CORRECT)");
                logger.log(System.Logger.Level.INFO, "Sleeping 5 more seconds before receiving message");
                Thread.sleep(5000L);
                logger.log(System.Logger.Level.INFO, "Waiting 10 more seconds to receive message");
                message = (TextMessage)this.consumer.receive(10000L);
                if (message == null) {
                    logger.log(System.Logger.Level.ERROR, "FAILED: Message was not received after delivery delay of 20 secs elapsed");
                    pass = false;
                } else {
                    logger.log(System.Logger.Level.INFO, "Received message after 20 secs elapsed (CORRECT)");
                }
            }
            logger.log(System.Logger.Level.INFO, "Sending message with DeliveryMode.NON_PERSISTENT and DeliveryDelay=20Secs");
            this.producer.setDeliveryMode(1);
            this.producer.setPriority(4);
            this.producer.setTimeToLive(0L);
            this.producer.send(this.destination, (Message)message);
            logger.log(System.Logger.Level.INFO, "Waiting 10 seconds to receive message");
            message = (TextMessage)this.consumer.receive(10000L);
            if (message != null) {
                logger.log(System.Logger.Level.ERROR, "FAILED: Message received before delivery delay of 20 secs elapsed");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Didn't receive message after 10 seconds (CORRECT)");
                logger.log(System.Logger.Level.INFO, "Sleeping 5 more seconds before receiving message");
                Thread.sleep(5000L);
                logger.log(System.Logger.Level.INFO, "Waiting 10 more seconds to receive message");
                message = (TextMessage)this.consumer.receive(10000L);
                if (message == null) {
                    logger.log(System.Logger.Level.ERROR, "FAILED: Message was not received after delivery delay of 20 secs elapsed");
                    pass = false;
                } else {
                    logger.log(System.Logger.Level.INFO, "Received message after 20 secs elapsed (CORRECT)");
                }
            }
            logger.log(System.Logger.Level.INFO, "----------------------------------------------------");
            logger.log(System.Logger.Level.INFO, "END TEST deliveryDelayTest with DeliveryDelay=20Secs");
            logger.log(System.Logger.Level.INFO, "----------------------------------------------------");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("deliveryDelayTest", e);
        }
        if (!pass) {
            throw new Exception("deliveryDelayTest failed");
        }
    }

    @Test
    public void msgHdrMessageIDTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        String id = null;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentS = null;
            StreamMessage messageReceivedS = null;
            BytesMessage messageSentB = null;
            BytesMessage messageReceivedB = null;
            MapMessage messageReceivedM = null;
            MapMessage messageSentM = null;
            ObjectMessage messageSentO = null;
            ObjectMessage messageReceivedO = null;
            this.producer.setDisableMessageID(false);
            logger.log(System.Logger.Level.INFO, "Send ObjectMessage to Queue.");
            messageSentO = this.context.createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"msgHdrMessageIDTest for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrMessageIDTest");
            this.producer.send(this.destination, (Message)messageSentO);
            logger.log(System.Logger.Level.INFO, "Receive ObjectMessage from Queue.");
            messageReceivedO = (ObjectMessage)this.consumer.receive(this.timeout);
            if (messageReceivedO == null) {
                logger.log(System.Logger.Level.ERROR, "Received no message NULL (unexpected)");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "getJMSMessageID=" + messageReceivedO.getJMSMessageID());
                id = messageReceivedO.getJMSMessageID();
                if (!this.chkMessageID(id)) {
                    logger.log(System.Logger.Level.ERROR, "ObjectMessage error: JMSMessageID does not start with ID:");
                    pass = false;
                } else {
                    logger.log(System.Logger.Level.INFO, "Objectessage JMSMessageID pass");
                }
            }
            logger.log(System.Logger.Level.INFO, "Send MapMessage to Queue.");
            messageSentM = this.context.createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrMessageIDTest");
            messageSentM.setString("aString", "value");
            this.producer.send(this.destination, (Message)messageSentM);
            logger.log(System.Logger.Level.INFO, "Receive MapMessage from Queue.");
            messageReceivedM = (MapMessage)this.consumer.receive(this.timeout);
            if (messageReceivedM == null) {
                logger.log(System.Logger.Level.ERROR, "Received no message NULL (unexpected)");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "getJMSMessageID=" + messageReceivedM.getJMSMessageID());
                id = messageReceivedM.getJMSMessageID();
                if (!this.chkMessageID(id)) {
                    logger.log(System.Logger.Level.ERROR, "MapMessage error: JMSMessageID does not start with ID:");
                    pass = false;
                } else {
                    logger.log(System.Logger.Level.INFO, "MapMessage JMSMessageID pass");
                }
            }
            logger.log(System.Logger.Level.INFO, "Send BytesMessage to Queue.");
            messageSentB = this.context.createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrMessageIDTest");
            messageSentB.writeByte(bValue);
            this.producer.send(this.destination, (Message)messageSentB);
            logger.log(System.Logger.Level.INFO, "Receive BytesMessage from Queue.");
            messageReceivedB = (BytesMessage)this.consumer.receive(this.timeout);
            if (messageReceivedB == null) {
                logger.log(System.Logger.Level.ERROR, "Received no message NULL (unexpected)");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "getJMSMessageID=" + messageReceivedB.getJMSMessageID());
                id = messageReceivedB.getJMSMessageID();
                if (!this.chkMessageID(id)) {
                    logger.log(System.Logger.Level.ERROR, "BytesMessage error: JMSMessageID does not start with ID:");
                    pass = false;
                } else {
                    logger.log(System.Logger.Level.INFO, "BytesMessage JMSMessageID pass");
                }
            }
            logger.log(System.Logger.Level.INFO, "Send StreamMessage to Queue");
            messageSentS = this.context.createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrMessageIDTest");
            messageSentS.writeString("Testing...");
            logger.log(System.Logger.Level.INFO, "Sending message");
            this.producer.send(this.destination, (Message)messageSentS);
            logger.log(System.Logger.Level.INFO, "Receive StreamMessage from Queue.");
            messageReceivedS = (StreamMessage)this.consumer.receive(this.timeout);
            if (messageReceivedM == null) {
                logger.log(System.Logger.Level.ERROR, "Received no message NULL (unexpected)");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "getJMSMessageID=" + messageReceivedS.getJMSMessageID());
                id = messageReceivedS.getJMSMessageID();
                if (!this.chkMessageID(id)) {
                    logger.log(System.Logger.Level.ERROR, "StreamMessage error: JMSMessageID does not start with ID:");
                    pass = false;
                } else {
                    logger.log(System.Logger.Level.INFO, "StreamMessage JMSMessageID pass");
                }
            }
            logger.log(System.Logger.Level.INFO, "Send TextMessage to Queue");
            messageSent = this.context.createTextMessage();
            messageSent.setText("sending a TextMessage");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrMessageIDTest");
            this.producer.send(this.destination, (Message)messageSent);
            logger.log(System.Logger.Level.INFO, "Receive TextMessage from Queue.");
            messageReceived = (TextMessage)this.consumer.receive(this.timeout);
            if (messageReceived == null) {
                logger.log(System.Logger.Level.ERROR, "Received no message NULL (unexpected)");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "getJMSMessageID=" + messageReceived.getJMSMessageID());
                id = messageReceived.getJMSMessageID();
                if (!this.chkMessageID(id)) {
                    logger.log(System.Logger.Level.ERROR, "TextMessage error: JMSMessageID does not start with ID:");
                    pass = false;
                } else {
                    logger.log(System.Logger.Level.INFO, "TextMessage JMSMessageID pass");
                }
            }
            if (!pass) {
                throw new Exception("Error: invalid JMSMessageID returned from JMSMessageID");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.INFO, "Caught unexpected exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrMessageIDTest");
        }
    }

    @Test
    public void msgHdrTimeStampTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        try {
            TextMessage messageSent = null;
            StreamMessage messageSentS = null;
            BytesMessage messageSentB = null;
            MapMessage messageSentM = null;
            ObjectMessage messageSentO = null;
            this.producer.setDisableMessageTimestamp(false);
            logger.log(System.Logger.Level.INFO, "Send ObjectMessage to Queue.");
            messageSentO = this.context.createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"msgHdrTimeStampTest for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrTimeStampTest");
            long timeBeforeSend = System.currentTimeMillis();
            this.producer.send(this.destination, (Message)messageSentO);
            long timeAfterSend = System.currentTimeMillis();
            logger.log(System.Logger.Level.INFO, "getJMSTimestamp=" + messageSentO.getJMSTimestamp());
            logger.log(System.Logger.Level.INFO, "Time at send is: " + timeBeforeSend);
            logger.log(System.Logger.Level.INFO, "Time after return fromsend is:" + timeAfterSend);
            if (timeBeforeSend <= messageSentO.getJMSTimestamp() && timeAfterSend >= messageSentO.getJMSTimestamp()) {
                logger.log(System.Logger.Level.INFO, "ObjectMessage JMSTimeStamp pass");
            } else {
                logger.log(System.Logger.Level.ERROR, "ObjectMessage invalid JMSTimeStamp failed");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send MapMessage to Queue.");
            messageSentM = this.context.createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrTimeStampTest");
            messageSentM.setString("aString", "value");
            timeBeforeSend = System.currentTimeMillis();
            this.producer.send(this.destination, (Message)messageSentM);
            timeAfterSend = System.currentTimeMillis();
            logger.log(System.Logger.Level.INFO, "getJMSTimestamp=" + messageSentM.getJMSTimestamp());
            logger.log(System.Logger.Level.INFO, "Time at send is: " + timeBeforeSend);
            logger.log(System.Logger.Level.INFO, "Time after return fromsend is:" + timeAfterSend);
            if (timeBeforeSend <= messageSentM.getJMSTimestamp() && timeAfterSend >= messageSentM.getJMSTimestamp()) {
                logger.log(System.Logger.Level.INFO, "MapMessage JMSTimeStamp pass");
            } else {
                logger.log(System.Logger.Level.ERROR, "MapMessage invalid JMSTimeStamp failed");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send BytesMessage to Queue.");
            messageSentB = this.context.createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrTimeStampTest");
            messageSentB.writeByte(bValue);
            timeBeforeSend = System.currentTimeMillis();
            this.producer.send(this.destination, (Message)messageSentB);
            timeAfterSend = System.currentTimeMillis();
            logger.log(System.Logger.Level.INFO, "getJMSTimestamp=" + messageSentB.getJMSTimestamp());
            logger.log(System.Logger.Level.INFO, "Time at send is: " + timeBeforeSend);
            logger.log(System.Logger.Level.INFO, "Time after return fromsend is:" + timeAfterSend);
            if (timeBeforeSend <= messageSentB.getJMSTimestamp() && timeAfterSend >= messageSentB.getJMSTimestamp()) {
                logger.log(System.Logger.Level.INFO, "BytesMessage JMSTimeStamp pass");
            } else {
                logger.log(System.Logger.Level.ERROR, "BytesMessage invalid JMSTimeStamp failed");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send StreamMessage to Queue");
            messageSentS = this.context.createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrTimeStampTest");
            messageSentS.writeString("Testing...");
            logger.log(System.Logger.Level.INFO, "Sending message");
            timeBeforeSend = System.currentTimeMillis();
            this.producer.send(this.destination, (Message)messageSentS);
            timeAfterSend = System.currentTimeMillis();
            logger.log(System.Logger.Level.INFO, "getJMSTimestamp=" + messageSentS.getJMSTimestamp());
            logger.log(System.Logger.Level.INFO, "Time at send is: " + timeBeforeSend);
            logger.log(System.Logger.Level.INFO, "Time after return fromsend is:" + timeAfterSend);
            if (timeBeforeSend <= messageSentS.getJMSTimestamp() && timeAfterSend >= messageSentS.getJMSTimestamp()) {
                logger.log(System.Logger.Level.INFO, "StreamMessage JMSTimeStamp pass");
            } else {
                logger.log(System.Logger.Level.ERROR, "StreamMessage invalid JMSTimeStamp failed");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send TextMessage to Queue");
            messageSent = this.context.createTextMessage();
            messageSent.setText("sending a TextMessage to Queue");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrTimeStampTest");
            timeBeforeSend = System.currentTimeMillis();
            this.producer.send(this.destination, (Message)messageSent);
            timeAfterSend = System.currentTimeMillis();
            logger.log(System.Logger.Level.INFO, "getJMSTimestamp=" + messageSent.getJMSTimestamp());
            logger.log(System.Logger.Level.INFO, "Time at send is: " + timeBeforeSend);
            logger.log(System.Logger.Level.INFO, "Time after return fromsend is:" + timeAfterSend);
            if (timeBeforeSend <= messageSent.getJMSTimestamp() && timeAfterSend >= messageSent.getJMSTimestamp()) {
                logger.log(System.Logger.Level.INFO, "TextMessage JMSTimeStamp pass");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage invalid JMSTimeStamp failed");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.INFO, "Caught unexpected exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrTimeStampTest");
        }
    }

    @Test
    public void msgHdrJMSPriorityTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        int priority2 = 2;
        int priority4 = 4;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentS = null;
            StreamMessage messageReceivedS = null;
            BytesMessage messageSentB = null;
            BytesMessage messageReceivedB = null;
            MapMessage messageReceivedM = null;
            MapMessage messageSentM = null;
            ObjectMessage messageSentO = null;
            ObjectMessage messageReceivedO = null;
            logger.log(System.Logger.Level.INFO, "Setting priority to 2");
            this.producer.setPriority(priority2);
            messageSent = this.context.createTextMessage();
            messageSent.setText("sending a message");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSPriorityTest");
            logger.log(System.Logger.Level.INFO, "JMSPriority test - Send a TextMessage to Queue");
            this.producer.send(this.destination, (Message)messageSent);
            logger.log(System.Logger.Level.INFO, "JMSPriority test - Recv a TextMessage from Queue");
            messageReceived = (TextMessage)this.consumer.receive(this.timeout);
            if (messageReceived == null) {
                logger.log(System.Logger.Level.ERROR, "Received no message NULL (unexpected)");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "JMSPriority is " + messageReceived.getJMSPriority());
                if (messageReceived.getJMSPriority() == priority2) {
                    logger.log(System.Logger.Level.INFO, "TextMessage JMSPriority passed");
                } else {
                    logger.log(System.Logger.Level.ERROR, "TextMessage JMSPriority failed");
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "JMSPriority test - Send ObjectMessage to Queue.");
            messageSentO = this.context.createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"msgHdrJMSPriorityTest for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSPriorityTest");
            this.producer.send(this.destination, (Message)messageSentO);
            logger.log(System.Logger.Level.INFO, "JMSPriority test - Recv a ObjectMessage from Queue");
            messageReceivedO = (ObjectMessage)this.consumer.receive(this.timeout);
            if (messageReceivedO == null) {
                logger.log(System.Logger.Level.ERROR, "Received no message NULL (unexpected)");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "JMSPriority is " + messageReceivedO.getJMSPriority());
                if (messageReceivedO.getJMSPriority() == priority2) {
                    logger.log(System.Logger.Level.INFO, "ObjectMessage JMSPriority passed");
                } else {
                    logger.log(System.Logger.Level.ERROR, "ObjectMessage JMSPriority failed");
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "JMSPriority test - Send MapMessage to Queue.");
            messageSentM = this.context.createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSPriorityTest");
            messageSentM.setString("aString", "value");
            this.producer.send(this.destination, (Message)messageSentM);
            logger.log(System.Logger.Level.INFO, "JMSPriority test - Recv a MapMessage from Queue");
            messageReceivedM = (MapMessage)this.consumer.receive(this.timeout);
            if (messageReceivedM == null) {
                logger.log(System.Logger.Level.ERROR, "Received no message NULL (unexpected)");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "JMSPriority is " + messageReceivedM.getJMSPriority());
                if (messageReceivedM.getJMSPriority() == priority2) {
                    logger.log(System.Logger.Level.INFO, "MapMessage JMSPriority passed");
                } else {
                    logger.log(System.Logger.Level.ERROR, "MapMessage JMSPriority failed");
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "Setting priority to 4");
            this.producer.setPriority(priority4);
            logger.log(System.Logger.Level.INFO, "JMSPriority test - Send BytesMessage to Queue.");
            messageSentB = this.context.createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSPriorityTest");
            messageSentB.writeByte(bValue);
            this.producer.send(this.destination, (Message)messageSentB);
            logger.log(System.Logger.Level.INFO, "JMSPriority test - Recv a BytesMessage from Queue");
            messageReceivedB = (BytesMessage)this.consumer.receive(this.timeout);
            if (messageReceivedB == null) {
                logger.log(System.Logger.Level.ERROR, "Received no message NULL (unexpected)");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "JMSPriority is " + messageReceivedB.getJMSPriority());
                if (messageReceivedB.getJMSPriority() == priority4) {
                    logger.log(System.Logger.Level.INFO, "BytesMessage JMSPriority passed");
                } else {
                    logger.log(System.Logger.Level.ERROR, "BytesMessage JMSPriority failed");
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "JMSPriority test - Send a StreamMessage to Queue");
            messageSentS = this.context.createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSPriorityTest");
            messageSentS.writeString("Testing...");
            this.producer.send(this.destination, (Message)messageSentS);
            logger.log(System.Logger.Level.INFO, "JMSPriority test - Recv a StreamMessage from Queue");
            messageReceivedS = (StreamMessage)this.consumer.receive(this.timeout);
            if (messageReceivedS == null) {
                logger.log(System.Logger.Level.ERROR, "Received no message NULL (unexpected)");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "JMSPriority is " + messageReceivedS.getJMSPriority());
                if (messageReceivedS.getJMSPriority() == priority4) {
                    logger.log(System.Logger.Level.INFO, "StreamMessage JMSPriority passed");
                } else {
                    logger.log(System.Logger.Level.ERROR, "StreamMessage JMSPriority failed");
                    pass = false;
                }
            }
            if (!pass) {
                throw new Exception("Error: invalid JMSPriority returned from JMS Header");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.INFO, "Caught unexpected exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrJMSPriorityTest");
        }
    }

    @Test
    public void msgHdrJMSExpirationTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        long forever = 0L;
        long timeToLive = 5000L;
        String testName = "msgHdrJMSExpirationTest";
        long timeBeforeSend = 0L;
        long timeAfterSend = 0L;
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentS = null;
            StreamMessage messageReceivedS = null;
            BytesMessage messageSentB = null;
            BytesMessage messageReceivedB = null;
            MapMessage messageReceivedM = null;
            MapMessage messageSentM = null;
            ObjectMessage messageSentO = null;
            ObjectMessage messageReceivedO = null;
            logger.log(System.Logger.Level.INFO, "JMSExpiration test - Send a TextMessage (timeToLive is forever)");
            messageSent = this.context.createTextMessage();
            messageSent.setText("sending a TextMessage");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.producer.setTimeToLive(forever);
            this.producer.send(this.destination, (Message)messageSent);
            logger.log(System.Logger.Level.INFO, "JMSExpiration test - Recv a TextMessage");
            messageReceived = (TextMessage)this.consumer.receive(this.timeout);
            if (messageReceived == null) {
                logger.log(System.Logger.Level.ERROR, "Received no message NULL (unexpected)");
                pass = false;
            } else if (messageReceived.getJMSExpiration() != forever) {
                logger.log(System.Logger.Level.ERROR, "TextMessage JMSExpiration failed");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "TextMessage JMSExpiration passed");
            }
            logger.log(System.Logger.Level.INFO, "JMSExpiration test - Send a TextMessage (timeToLive is 5000)");
            this.producer.setTimeToLive(timeToLive);
            timeBeforeSend = System.currentTimeMillis();
            this.producer.send(this.destination, (Message)messageSent);
            timeAfterSend = System.currentTimeMillis();
            long exp = messageSent.getJMSExpiration();
            logger.log(System.Logger.Level.INFO, "JMSExpiration is set to=" + exp);
            logger.log(System.Logger.Level.INFO, "Time before send=" + timeBeforeSend);
            logger.log(System.Logger.Level.INFO, "Time after send=" + timeAfterSend);
            logger.log(System.Logger.Level.INFO, "Time to Live =" + timeToLive);
            logger.log(System.Logger.Level.INFO, "JMSExpiration test - Recv a TextMessage");
            messageReceived = (TextMessage)this.consumer.receive(this.timeout);
            if (messageReceived == null) {
                logger.log(System.Logger.Level.ERROR, "Received no message NULL (unexpected)");
                pass = false;
            } else if (messageReceived.getJMSExpiration() != exp) {
                logger.log(System.Logger.Level.ERROR, "TextMessage failed: JMSExpiration didn't set correctly = " + messageReceived.getJMSExpiration());
                logger.log(System.Logger.Level.ERROR, "JMSExpiration was set to=" + exp);
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "TextMessage JMSExpiration passed");
            }
            logger.log(System.Logger.Level.INFO, "JMSExpiration test - Send a ObjectMessage (timeToLive is forever)");
            messageSentO = this.context.createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"msgHdrJMSExpirationTest for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.producer.setTimeToLive(forever);
            this.producer.send(this.destination, (Message)messageSentO);
            logger.log(System.Logger.Level.INFO, "JMSExpiration test - Recv a ObjectMessage");
            messageReceivedO = (ObjectMessage)this.consumer.receive(this.timeout);
            if (messageReceivedO == null) {
                logger.log(System.Logger.Level.ERROR, "Received no message NULL (unexpected)");
                pass = false;
            } else if (messageReceivedO.getJMSExpiration() != forever) {
                logger.log(System.Logger.Level.INFO, "ObjectMessage JMSExpiration failed");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "ObjectMessage JMSExpiration passed");
            }
            logger.log(System.Logger.Level.INFO, "JMSExpiration test - Send a ObjectMessage (timeToLive is 5000)");
            this.producer.setTimeToLive(timeToLive);
            timeBeforeSend = System.currentTimeMillis();
            this.producer.send(this.destination, (Message)messageSentO);
            timeAfterSend = System.currentTimeMillis();
            exp = messageSentO.getJMSExpiration();
            logger.log(System.Logger.Level.INFO, "JMSExpiration is set to=" + exp);
            logger.log(System.Logger.Level.INFO, "Time before send=" + timeBeforeSend);
            logger.log(System.Logger.Level.INFO, "Time after send=" + timeAfterSend);
            logger.log(System.Logger.Level.INFO, "Time to Live =" + timeToLive);
            logger.log(System.Logger.Level.INFO, "JMSExpiration test - Recv a ObjectMessage");
            messageReceivedO = (ObjectMessage)this.consumer.receive(this.timeout);
            if (messageReceivedO == null) {
                logger.log(System.Logger.Level.ERROR, "Received no message NULL (unexpected)");
                pass = false;
            } else if (messageReceivedO.getJMSExpiration() != exp) {
                logger.log(System.Logger.Level.ERROR, "ObjectMessage failed: JMSExpiration didn't set correctly = " + messageReceivedO.getJMSExpiration());
                logger.log(System.Logger.Level.ERROR, "JMSExpiration was set to=" + exp);
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "ObjectMessage JMSExpiration passed");
            }
            logger.log(System.Logger.Level.INFO, "JMSExpiration test - Send a MapMessage (timeToLive is forever)");
            messageSentM = this.context.createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentM.setString("aString", "value");
            this.producer.setTimeToLive(forever);
            this.producer.send(this.destination, (Message)messageSentM);
            logger.log(System.Logger.Level.INFO, "JMSExpiration test - Recv a MapMessage");
            messageReceivedM = (MapMessage)this.consumer.receive(this.timeout);
            if (messageReceivedM == null) {
                logger.log(System.Logger.Level.ERROR, "Received no message NULL (unexpected)");
                pass = false;
            } else if (messageReceivedM.getJMSExpiration() != forever) {
                logger.log(System.Logger.Level.INFO, "MapMessage JMSExpiration failed");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "MapMessage JMSExpiration passed");
            }
            logger.log(System.Logger.Level.INFO, "JMSExpiration test - Send a MapMessage (timeToLive is 5000)");
            this.producer.setTimeToLive(timeToLive);
            timeBeforeSend = System.currentTimeMillis();
            this.producer.send(this.destination, (Message)messageSentM);
            timeAfterSend = System.currentTimeMillis();
            exp = messageSentM.getJMSExpiration();
            logger.log(System.Logger.Level.INFO, "JMSExpiration is set to=" + exp);
            logger.log(System.Logger.Level.INFO, "Time before send=" + timeBeforeSend);
            logger.log(System.Logger.Level.INFO, "Time after send=" + timeAfterSend);
            logger.log(System.Logger.Level.INFO, "Time to Live =" + timeToLive);
            logger.log(System.Logger.Level.INFO, "JMSExpiration test - Recv a MapMessage");
            messageReceivedM = (MapMessage)this.consumer.receive(this.timeout);
            if (messageReceivedM == null) {
                logger.log(System.Logger.Level.ERROR, "Received no message NULL (unexpected)");
                pass = false;
            } else if (messageReceivedM.getJMSExpiration() != exp) {
                logger.log(System.Logger.Level.ERROR, "MapMessage failed: JMSExpiration didn't set correctly = " + messageReceivedM.getJMSExpiration());
                logger.log(System.Logger.Level.ERROR, "JMSExpiration was set to=" + exp);
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "MapMessage JMSExpiration passed");
            }
            logger.log(System.Logger.Level.INFO, "JMSExpiration test - Send a Bytesessage (timeToLive is forever)");
            messageSentB = this.context.createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentB.writeByte(bValue);
            this.producer.setTimeToLive(forever);
            this.producer.send(this.destination, (Message)messageSentB);
            logger.log(System.Logger.Level.INFO, "JMSExpiration test - Recv a BytesMessage");
            messageReceivedB = (BytesMessage)this.consumer.receive(this.timeout);
            if (messageReceivedB == null) {
                logger.log(System.Logger.Level.ERROR, "Received no message NULL (unexpected)");
                pass = false;
            } else if (messageReceivedB.getJMSExpiration() != forever) {
                logger.log(System.Logger.Level.INFO, "BytesMessage JMSExpiration failed");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "BytesMessage JMSExpiration passed");
            }
            logger.log(System.Logger.Level.INFO, "JMSExpiration test - Send a Bytesessage (timeToLive is 5000)");
            this.producer.setTimeToLive(timeToLive);
            timeBeforeSend = System.currentTimeMillis();
            this.producer.send(this.destination, (Message)messageSentB);
            timeAfterSend = System.currentTimeMillis();
            exp = messageSentB.getJMSExpiration();
            logger.log(System.Logger.Level.INFO, "JMSExpiration is set to=" + exp);
            logger.log(System.Logger.Level.INFO, "Time before send=" + timeBeforeSend);
            logger.log(System.Logger.Level.INFO, "Time after send=" + timeAfterSend);
            logger.log(System.Logger.Level.INFO, "Time to Live =" + timeToLive);
            logger.log(System.Logger.Level.INFO, "JMSExpiration test - Recv a BytesMessage");
            messageReceivedB = (BytesMessage)this.consumer.receive(this.timeout);
            if (messageReceivedB == null) {
                logger.log(System.Logger.Level.ERROR, "Received no message NULL (unexpected)");
                pass = false;
            } else if (messageReceivedB.getJMSExpiration() != exp) {
                logger.log(System.Logger.Level.ERROR, "BytesMessage failed: JMSExpiration didn't set correctly = " + messageReceivedB.getJMSExpiration());
                logger.log(System.Logger.Level.ERROR, "JMSExpiration was set to=" + exp);
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "BytesMessage JMSExpiration passed");
            }
            logger.log(System.Logger.Level.INFO, "JMSExpiration test - Send a Streamessage (timeToLive is forever)");
            messageSentS = this.context.createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentS.writeString("Testing...");
            this.producer.setTimeToLive(forever);
            this.producer.send(this.destination, (Message)messageSentS);
            logger.log(System.Logger.Level.INFO, "JMSExpiration test - Recv a StreamMessage");
            messageReceivedS = (StreamMessage)this.consumer.receive(this.timeout);
            if (messageReceivedS == null) {
                logger.log(System.Logger.Level.ERROR, "Received no message NULL (unexpected)");
                pass = false;
            } else if (messageReceivedS.getJMSExpiration() != forever) {
                logger.log(System.Logger.Level.INFO, "StreamMessage JMSExpiration failed");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "StreamMessage JMSExpiration passed");
            }
            logger.log(System.Logger.Level.INFO, "JMSExpiration test - Send a StreamMessage (timeToLive is 5000)");
            this.producer.setTimeToLive(timeToLive);
            timeBeforeSend = System.currentTimeMillis();
            this.producer.send(this.destination, (Message)messageSentS);
            timeAfterSend = System.currentTimeMillis();
            exp = messageSentS.getJMSExpiration();
            logger.log(System.Logger.Level.INFO, "JMSExpiration is set to=" + exp);
            logger.log(System.Logger.Level.INFO, "Time before send=" + timeBeforeSend);
            logger.log(System.Logger.Level.INFO, "Time after send=" + timeAfterSend);
            logger.log(System.Logger.Level.INFO, "Time to Live =" + timeToLive);
            logger.log(System.Logger.Level.INFO, "JMSExpiration test - Recv a StreamMessage");
            messageReceivedS = (StreamMessage)this.consumer.receive(this.timeout);
            if (messageReceivedS == null) {
                logger.log(System.Logger.Level.ERROR, "Received no message NULL (unexpected)");
                pass = false;
            } else if (messageReceivedS.getJMSExpiration() != exp) {
                logger.log(System.Logger.Level.ERROR, "StreamMessage failed: JMSExpiration didn't set correctly = " + messageReceivedS.getJMSExpiration());
                logger.log(System.Logger.Level.ERROR, "JMSExpiration was set to=" + exp);
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "StreamMessage JMSExpiration passed");
            }
            if (!pass) {
                throw new Exception("Error: invalid JMSExpiration returned from JMS Header");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.INFO, "Caught unexpected exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testName);
        }
    }

    @Test
    public void msgHdrJMSDeliveryModeTest() throws Exception {
        boolean pass = true;
        byte bValue = 127;
        String testName = "msgHdrJMSDeliveryModeTest";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            StreamMessage messageSentS = null;
            StreamMessage messageReceivedS = null;
            BytesMessage messageSentB = null;
            BytesMessage messageReceivedB = null;
            MapMessage messageReceivedM = null;
            MapMessage messageSentM = null;
            ObjectMessage messageSentO = null;
            ObjectMessage messageReceivedO = null;
            logger.log(System.Logger.Level.INFO, "send TextMessage to Queue with DeliveryMode.PERSISTENT.");
            this.producer.setDeliveryMode(2);
            messageSent = this.context.createTextMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.producer.send(this.destination, (Message)messageSent);
            logger.log(System.Logger.Level.INFO, "receive TextMessage");
            messageReceived = (TextMessage)this.consumer.receive(this.timeout);
            if (messageReceived == null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "TextMessage is null (unexpected)");
            } else if (messageReceived.getJMSDeliveryMode() != 2) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "TextMessage failed: JMSDeliveryMode should be set to persistent");
            } else {
                logger.log(System.Logger.Level.INFO, "TextMessage JMSDeliveryMode passed");
            }
            logger.log(System.Logger.Level.INFO, "send TextMessage to Queue with DeliveryMode.NON_PERSISTENT.");
            this.producer.setDeliveryMode(1);
            messageSent = this.context.createTextMessage();
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.producer.send(this.destination, (Message)messageSent);
            logger.log(System.Logger.Level.INFO, "receive TextMessage");
            messageReceived = (TextMessage)this.consumer.receive(this.timeout);
            if (messageReceived == null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "TextMessage is null (unexpected)");
            } else if (messageReceived.getJMSDeliveryMode() != 1) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "TextMessage failed: JMSDeliveryMode should be set to non persistent");
            } else {
                logger.log(System.Logger.Level.INFO, "TextMessage JMSDeliveryMode passed");
            }
            logger.log(System.Logger.Level.INFO, "send ObjectMessage to Queue with DeliveryMode.PERSISTENT.");
            this.producer.setDeliveryMode(2);
            messageSentO = this.context.createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"Test for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.producer.send(this.destination, (Message)messageSentO);
            logger.log(System.Logger.Level.INFO, "receive ObjectMessage");
            messageReceivedO = (ObjectMessage)this.consumer.receive(this.timeout);
            if (messageReceivedO == null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "ObjectMessage is null (unexpected)");
            } else if (messageReceivedO.getJMSDeliveryMode() != 2) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "ObjectMessage failed: JMSDeliveryMode should be set to persistent");
            } else {
                logger.log(System.Logger.Level.INFO, "ObjectMessage JMSDeliveryMode passed");
            }
            logger.log(System.Logger.Level.INFO, "send ObjectMessage to Queue with DeliveryMode.NON_PERSISTENT.");
            this.producer.setDeliveryMode(1);
            messageSentO = this.context.createObjectMessage();
            messageSentO.setObject((Serializable)((Object)"Test for ObjectMessage"));
            messageSentO.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            this.producer.send(this.destination, (Message)messageSentO);
            logger.log(System.Logger.Level.INFO, "receive ObjectMessage");
            messageReceivedO = (ObjectMessage)this.consumer.receive(this.timeout);
            if (messageReceivedO == null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "ObjectMessage is null (unexpected)");
            } else if (messageReceivedO.getJMSDeliveryMode() != 1) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "ObjectMessage failed: JMSDeliveryMode should be set to non persistent");
            } else {
                logger.log(System.Logger.Level.INFO, "ObjectMessage JMSDeliveryMode passed");
            }
            logger.log(System.Logger.Level.INFO, "send MapMessage to Queue with DeliveryMode.PERSISTENT.");
            this.producer.setDeliveryMode(2);
            messageSentM = this.context.createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentM.setString("aString", "value");
            this.producer.send(this.destination, (Message)messageSentM);
            logger.log(System.Logger.Level.INFO, "receive MapMessage");
            messageReceivedM = (MapMessage)this.consumer.receive(this.timeout);
            if (messageReceivedM == null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "MapMessage is null (unexpected)");
            } else if (messageReceivedM.getJMSDeliveryMode() != 2) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "MapMessage failed: JMSDeliveryMode should be set to persistent");
            } else {
                logger.log(System.Logger.Level.INFO, "MapMessage JMSDeliveryMode passed");
            }
            logger.log(System.Logger.Level.INFO, "send MapMessage to Queue with DeliveryMode.NON_PERSISTENT.");
            this.producer.setDeliveryMode(1);
            messageSentM = this.context.createMapMessage();
            messageSentM.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentM.setString("aString", "value");
            this.producer.send(this.destination, (Message)messageSentM);
            logger.log(System.Logger.Level.INFO, "receive MapMessage");
            messageReceivedM = (MapMessage)this.consumer.receive(this.timeout);
            if (messageReceivedM == null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "MapMessage is null (unexpected)");
            } else if (messageReceivedM.getJMSDeliveryMode() != 1) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "MapMessage failed: JMSDeliveryMode should be set to non persistent");
            } else {
                logger.log(System.Logger.Level.INFO, "MapMessage JMSDeliveryMode passed");
            }
            logger.log(System.Logger.Level.INFO, "send BytesMessage to Queue with DeliveryMode.PERSISTENT.");
            this.producer.setDeliveryMode(2);
            messageSentB = this.context.createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentB.writeByte(bValue);
            this.producer.send(this.destination, (Message)messageSentB);
            logger.log(System.Logger.Level.INFO, "receive BytesMessage");
            messageReceivedB = (BytesMessage)this.consumer.receive(this.timeout);
            if (messageReceivedB == null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "BytesMessage is null (unexpected)");
            } else if (messageReceivedB.getJMSDeliveryMode() != 2) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "BytesMessage failed: JMSDeliveryMode should be set to persistent");
            } else {
                logger.log(System.Logger.Level.INFO, "BytesMessage JMSDeliveryMode passed");
            }
            logger.log(System.Logger.Level.INFO, "send BytesMessage to Queue with DeliveryMode.NON_PERSISTENT.");
            this.producer.setDeliveryMode(1);
            messageSentB = this.context.createBytesMessage();
            messageSentB.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentB.writeByte(bValue);
            this.producer.send(this.destination, (Message)messageSentB);
            logger.log(System.Logger.Level.INFO, "receive BytesMessage");
            messageReceivedB = (BytesMessage)this.consumer.receive(this.timeout);
            if (messageReceivedB == null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "BytesMessage is null (unexpected)");
            } else if (messageReceivedB.getJMSDeliveryMode() != 1) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "BytesMessage failed: JMSDeliveryMode should be set to non persistent");
            } else {
                logger.log(System.Logger.Level.INFO, "BytesMessage JMSDeliveryMode passed");
            }
            logger.log(System.Logger.Level.INFO, "send StreamMessage to Queue with DeliveryMode.PERSISTENT.");
            this.producer.setDeliveryMode(2);
            messageSentS = this.context.createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentS.writeString("Testing...");
            this.producer.send(this.destination, (Message)messageSentS);
            logger.log(System.Logger.Level.INFO, "receive StreamMessage");
            messageReceivedS = (StreamMessage)this.consumer.receive(this.timeout);
            if (messageReceivedS == null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "StreamMessage is null (unexpected)");
            } else if (messageReceivedS.getJMSDeliveryMode() != 2) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "StreamMessage failed: JMSDeliveryMode should be set to persistent");
            } else {
                logger.log(System.Logger.Level.INFO, "StreamMessage JMSDeliveryMode passed");
            }
            logger.log(System.Logger.Level.INFO, "send StreamMessage to Queue with DeliveryMode.NON_PERSISTENT.");
            this.producer.setDeliveryMode(1);
            messageSentS = this.context.createStreamMessage();
            messageSentS.setStringProperty("COM_SUN_JMS_TESTNAME", testName);
            messageSentS.writeString("Testing...");
            this.producer.send(this.destination, (Message)messageSentS);
            logger.log(System.Logger.Level.INFO, "receive StreamMessage");
            messageReceivedS = (StreamMessage)this.consumer.receive(this.timeout);
            if (messageReceivedS == null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "StreamMessage is null (unexpected)");
            } else if (messageReceivedS.getJMSDeliveryMode() != 1) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "StreamMessage failed: JMSDeliveryMode should be set to non persistent");
            } else {
                logger.log(System.Logger.Level.INFO, "StreamMessage JMSDeliveryMode passed");
            }
            if (!pass) {
                throw new Exception("Error: invalid JMSDeliveryMode returned from JMS Header");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.INFO, "Caught unexpected exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception(testName);
        }
    }

    @Test
    public void msgHdrJMSDeliveryTimeTest() throws Exception {
        boolean pass = true;
        try {
            long JMSDeliveryTimeAfterRecv;
            long gmtTimeAfterRecv;
            long gmtTimebeforeSend = System.currentTimeMillis();
            logger.log(System.Logger.Level.INFO, "---------------------------------------------------------------");
            logger.log(System.Logger.Level.INFO, "BEGIN TEST msgHdrJMSDeliveryTimeTest with DeliveryDelay=20Secs");
            logger.log(System.Logger.Level.INFO, "---------------------------------------------------------------");
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            TextMessage messageSnd = this.context.createTextMessage("This is a test!");
            logger.log(System.Logger.Level.INFO, "Set StringProperty COM_SUN_JMS_TESTNAME");
            messageSnd.setStringProperty("COM_SUN_JMS_TESTNAME", "msgHdrJMSDeliveryTimeTest");
            logger.log(System.Logger.Level.INFO, "Sending message with DeliveryMode.PERSISTENT and DeliveryDelay=20Secs");
            this.producer.setDeliveryDelay(20000L);
            this.producer.setDeliveryMode(2);
            this.producer.setPriority(4);
            this.producer.setTimeToLive(0L);
            this.producer.send(this.destination, (Message)messageSnd);
            logger.log(System.Logger.Level.INFO, "Get JMSDeliveryTime after sending message");
            long deliverydelay = this.producer.getDeliveryDelay();
            long gmtTimeAfterSend = System.currentTimeMillis();
            long JMSDeliveryTimeAfterSend = messageSnd.getJMSDeliveryTime();
            logger.log(System.Logger.Level.INFO, "Receive message with timeout value of 21Secs");
            TextMessage messageRcv = (TextMessage)this.consumer.receive(21000L);
            if (messageRcv == null) {
                logger.log(System.Logger.Level.ERROR, "FAILED: Message was not received after delivery delay of 20 secs elapsed");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Get JMSDeliveryTime after receiving message");
                gmtTimeAfterRecv = System.currentTimeMillis();
                JMSDeliveryTimeAfterRecv = messageRcv.getJMSDeliveryTime();
                logger.log(System.Logger.Level.INFO, "Check JMSDeliverytime");
                logger.log(System.Logger.Level.INFO, "JMSDeliveryTime after send = " + JMSDeliveryTimeAfterSend);
                logger.log(System.Logger.Level.INFO, "JMSDeliveryTime after receive = " + JMSDeliveryTimeAfterRecv);
                if (JMSDeliveryTimeAfterSend == JMSDeliveryTimeAfterRecv) {
                    logger.log(System.Logger.Level.INFO, "JMSDeliveryTimeAfterSend = JMSDeliveryTimeAfterRecv (PASS)");
                } else {
                    logger.log(System.Logger.Level.ERROR, "JMSDeliveryTimeAfterSend != JMSDeliveryTimeAfterRecv (FAIL)");
                    pass = false;
                }
                logger.log(System.Logger.Level.INFO, "gmtTimeAfterSend after send = " + gmtTimeAfterSend);
                logger.log(System.Logger.Level.INFO, "gmtTimeAfterRecv after receive = " + gmtTimeAfterRecv);
                if (gmtTimeAfterRecv >= gmtTimebeforeSend + deliverydelay) {
                    logger.log(System.Logger.Level.INFO, "gmtTimeAfterRecv >= (gmtTimeAfterSend + deliverydelay) (PASS)");
                } else {
                    logger.log(System.Logger.Level.ERROR, "gmtTimeAfterRecv < (gmtTimeAfterSend + deliverydelay) (FAIL)");
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "Sending message with DeliveryMode.NON_PERSISTENT and DeliveryDelay=20Secs");
            this.producer.setDeliveryDelay(20000L);
            this.producer.setDeliveryMode(1);
            this.producer.setPriority(4);
            this.producer.setTimeToLive(0L);
            this.producer.send(this.destination, (Message)messageSnd);
            logger.log(System.Logger.Level.INFO, "Get JMSDeliveryTime after sending message");
            gmtTimeAfterSend = System.currentTimeMillis();
            JMSDeliveryTimeAfterSend = messageSnd.getJMSDeliveryTime();
            logger.log(System.Logger.Level.INFO, "Receive message with timeout value of 21Secs");
            messageRcv = (TextMessage)this.consumer.receive(21000L);
            if (messageRcv == null) {
                logger.log(System.Logger.Level.ERROR, "FAILED: Message was not received after delivery delay of 20 secs elapsed");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Get JMSDeliveryTime after receiving message");
                gmtTimeAfterRecv = System.currentTimeMillis();
                JMSDeliveryTimeAfterRecv = messageRcv.getJMSDeliveryTime();
                logger.log(System.Logger.Level.INFO, "Check JMSDeliverytime");
                logger.log(System.Logger.Level.INFO, "JMSDeliveryTime after send = " + JMSDeliveryTimeAfterSend);
                logger.log(System.Logger.Level.INFO, "JMSDeliveryTime after receive = " + JMSDeliveryTimeAfterRecv);
                if (JMSDeliveryTimeAfterSend == JMSDeliveryTimeAfterRecv) {
                    logger.log(System.Logger.Level.INFO, "JMSDeliveryTimeAfterSend = JMSDeliveryTimeAfterRecv (PASS)");
                } else {
                    logger.log(System.Logger.Level.ERROR, "JMSDeliveryTimeAfterSend != JMSDeliveryTimeAfterRecv (FAIL)");
                    pass = false;
                }
                logger.log(System.Logger.Level.INFO, "gmtTimeAfterSend after send = " + gmtTimeAfterSend);
                logger.log(System.Logger.Level.INFO, "gmtTimeAfterRecv after receive = " + gmtTimeAfterRecv);
                if (gmtTimeAfterRecv >= gmtTimebeforeSend + deliverydelay) {
                    logger.log(System.Logger.Level.INFO, "gmtTimeAfterRecv >= (gmtTimeAfterSend + deliverydelay) (PASS)");
                } else {
                    logger.log(System.Logger.Level.ERROR, "gmtTimeAfterRecv < (gmtTimeAfterSend + deliverydelay) (FAIL)");
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "-------------------------------------------------------------");
            logger.log(System.Logger.Level.INFO, "END TEST msgHdrJMSDeliveryTimeTest with DeliveryDelay=20Secs");
            logger.log(System.Logger.Level.INFO, "-------------------------------------------------------------");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("msgHdrJMSDeliveryTimeTest", e);
        }
        if (!pass) {
            throw new Exception("msgHdrJMSDeliveryTimeTest failed");
        }
    }

    @Test
    public void setGetAllPropertyTypesTest() throws Exception {
        boolean pass = true;
        boolean bool = true;
        byte bValue = 127;
        short nShort = 10;
        int nInt = 5;
        long nLong = 333L;
        float nFloat = 1.0f;
        double nDouble = 100.0;
        String testString = "test";
        int numPropertyNames = 16;
        try {
            logger.log(System.Logger.Level.INFO, "Create a JMSProducer from JMSContext");
            this.producer = this.context.createProducer();
            logger.log(System.Logger.Level.INFO, "Set all JMSProducer properties");
            this.producer.setProperty("TESTBOOLEAN", bool);
            this.producer.setProperty("TESTBYTE", bValue);
            this.producer.setProperty("TESTDOUBLE", nDouble);
            this.producer.setProperty("TESTFLOAT", nFloat);
            this.producer.setProperty("TESTINT", nInt);
            this.producer.setProperty("TESTLONG", nLong);
            this.producer.setProperty("TESTSHORT", nShort);
            this.producer.setProperty("TESTSTRING", "test");
            this.producer.setProperty("OBJTESTBOOLEAN", (Object)bool);
            this.producer.setProperty("OBJTESTBYTE", (Object)bValue);
            this.producer.setProperty("OBJTESTDOUBLE", (Object)nDouble);
            this.producer.setProperty("OBJTESTFLOAT", (Object)Float.valueOf(nFloat));
            this.producer.setProperty("OBJTESTINT", (Object)nInt);
            this.producer.setProperty("OBJTESTLONG", (Object)nLong);
            this.producer.setProperty("OBJTESTSHORT", (Object)nShort);
            this.producer.setProperty("OBJTESTSTRING", "test");
            logger.log(System.Logger.Level.INFO, "Get all JMSProducer properties");
            if (this.producer.getBooleanProperty("TESTBOOLEAN") == bool) {
                logger.log(System.Logger.Level.INFO, "Pass: getBooleanProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getBooleanProperty");
                pass = false;
            }
            if (this.producer.getByteProperty("TESTBYTE") == bValue) {
                logger.log(System.Logger.Level.INFO, "Pass: getByteProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getByteProperty");
                pass = false;
            }
            if (this.producer.getLongProperty("TESTLONG") == nLong) {
                logger.log(System.Logger.Level.INFO, "Pass: getLongProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getLongProperty");
                pass = false;
            }
            if (this.producer.getStringProperty("TESTSTRING").equals(testString)) {
                logger.log(System.Logger.Level.INFO, "Pass: getStringProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getStringProperty");
                pass = false;
            }
            if (this.producer.getDoubleProperty("TESTDOUBLE") == nDouble) {
                logger.log(System.Logger.Level.INFO, "Pass: getDoubleProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getDoubleProperty");
                pass = false;
            }
            if (this.producer.getFloatProperty("TESTFLOAT") == nFloat) {
                logger.log(System.Logger.Level.INFO, "Pass: getFloatProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getFloatProperty");
                pass = false;
            }
            if (this.producer.getIntProperty("TESTINT") == nInt) {
                logger.log(System.Logger.Level.INFO, "Pass: getIntProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getIntProperty");
                pass = false;
            }
            if (this.producer.getShortProperty("TESTSHORT") == nShort) {
                logger.log(System.Logger.Level.INFO, "Pass: getShortProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getShortProperty");
                pass = false;
            }
            if ((Boolean)this.producer.getObjectProperty("OBJTESTBOOLEAN") == bool) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct Boolean value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect Boolean value returned from getObjectProperty");
                pass = false;
            }
            if ((Byte)this.producer.getObjectProperty("OBJTESTBYTE") == bValue) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct Byte value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect Byte value returned from getObjectProperty");
                pass = false;
            }
            if ((Long)this.producer.getObjectProperty("OBJTESTLONG") == nLong) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct Long value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect Long value returned from getObjectProperty");
                pass = false;
            }
            if (((String)this.producer.getObjectProperty("OBJTESTSTRING")).equals(testString)) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct String value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect String value returned from getObjectProperty");
                pass = false;
            }
            if ((Double)this.producer.getObjectProperty("OBJTESTDOUBLE") == nDouble) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct Double value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect Double value returned from getObjectProperty");
                pass = false;
            }
            if (((Float)this.producer.getObjectProperty("OBJTESTFLOAT")).floatValue() == nFloat) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct Float value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect Float value returned from getObjectProperty");
                pass = false;
            }
            if ((Integer)this.producer.getObjectProperty("OBJTESTINT") == nInt) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct Integer value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect Integer value returned from getObjectProperty");
                pass = false;
            }
            if ((Short)this.producer.getObjectProperty("OBJTESTSHORT") == nShort) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct Short value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect Short value returned from getObjectProperty");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Now check all property names returned by JMSProducer.getPropertyNames()");
            int i = 0;
            Set propNames = this.producer.getPropertyNames();
            Iterator iterator = propNames.iterator();
            do {
                String tmp;
                if (!(tmp = (String)iterator.next()).startsWith("JMS")) {
                    ++i;
                    if (tmp.equals("TESTBOOLEAN") || tmp.equals("TESTBYTE") || tmp.equals("TESTINT") || tmp.equals("TESTSHORT") || tmp.equals("TESTFLOAT") || tmp.equals("TESTDOUBLE") || tmp.equals("TESTSTRING") || tmp.equals("TESTLONG") || tmp.equals("OBJTESTBOOLEAN") || tmp.equals("OBJTESTBYTE") || tmp.equals("OBJTESTINT") || tmp.equals("OBJTESTSHORT") || tmp.equals("OBJTESTFLOAT") || tmp.equals("OBJTESTDOUBLE") || tmp.equals("OBJTESTSTRING") || tmp.equals("OBJTESTLONG")) {
                        logger.log(System.Logger.Level.INFO, "Producer Property set by client: " + tmp);
                        continue;
                    }
                    logger.log(System.Logger.Level.ERROR, "Producer Property not set by client: " + tmp);
                    pass = false;
                    continue;
                }
                logger.log(System.Logger.Level.INFO, "JMSProperty Name is: " + tmp);
            } while (iterator.hasNext());
            if (i == numPropertyNames) {
                logger.log(System.Logger.Level.INFO, "Pass: # of properties is " + numPropertyNames + " as expected");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: expected " + numPropertyNames + " property names, but got " + i);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("setGetAllPropertyTypesTest");
        }
        if (!pass) {
            throw new Exception("setGetAllPropertyTypesTest failed");
        }
    }

    @Test
    public void setGetAllHeaderTypesTest() throws Exception {
        boolean pass = true;
        try {
            logger.log(System.Logger.Level.INFO, "Create a JMSProducer from JMSContext");
            this.producer = this.context.createProducer();
            try {
                logger.log(System.Logger.Level.INFO, "Set JMSProducer message header JMSCorrelationID as bytes");
                byte[] cid = "TestCorrelationID".getBytes();
                this.producer.setJMSCorrelationIDAsBytes(cid);
                logger.log(System.Logger.Level.INFO, "Get JMSProducer message header JMSCorrelationID as bytes");
                cid = this.producer.getJMSCorrelationIDAsBytes();
                String cidString = new String(cid);
                if (cid == null) {
                    logger.log(System.Logger.Level.INFO, "Fail: getJMSCorrelationID returned null");
                    pass = false;
                } else if (cidString.equals("TestCorrelationID")) {
                    logger.log(System.Logger.Level.INFO, "Pass: getJMSCorrelationID returned correct value");
                } else {
                    logger.log(System.Logger.Level.INFO, "Fail: getJMSCorrelationID returned incorrect value, got: " + cidString + " expected: TestCorrelationID");
                    pass = false;
                }
            }
            catch (UnsupportedOperationException e) {
                logger.log(System.Logger.Level.INFO, "UnsupportedOperationException - no further testing.");
            }
            logger.log(System.Logger.Level.INFO, "Set all JMSProducer message headers JMSCorrelationID, JMSType, JMSReplyTo");
            this.producer.setJMSCorrelationID("TestCorrelationID");
            this.producer.setJMSType("TestMessage");
            this.producer.setJMSReplyTo(this.destination);
            logger.log(System.Logger.Level.INFO, "Get all JMSProducer message headers JMSCorrelationID, JMSType, JMSReplyTo");
            String temp = null;
            Destination tempdest = null;
            temp = this.producer.getJMSCorrelationID();
            if (temp == null) {
                logger.log(System.Logger.Level.INFO, "Fail: getJMSCorrelationID returned null");
                pass = false;
            } else if (temp.equals("TestCorrelationID")) {
                logger.log(System.Logger.Level.INFO, "Pass: getJMSCorrelationID returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: getJMSCorrelationID returned incorrect value, got: " + temp + " expected: TestCorrelationID");
                pass = false;
            }
            temp = this.producer.getJMSType();
            if (temp == null) {
                logger.log(System.Logger.Level.INFO, "Fail: getJMSType returned null");
                pass = false;
            } else if (temp.equals("TestMessage")) {
                logger.log(System.Logger.Level.INFO, "Pass: getJMSType returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: getJMSType returned incorrect value, got: " + temp + " expected: TestMessage");
                pass = false;
            }
            tempdest = this.producer.getJMSReplyTo();
            if (tempdest == null) {
                logger.log(System.Logger.Level.INFO, "Fail: getJMSReplyTo returned null");
                pass = false;
            } else if (tempdest.equals(this.destination)) {
                logger.log(System.Logger.Level.INFO, "Pass: getJMSReplyTo returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: getJMSReplyTo returned incorrect value, got: " + tempdest + " expected: " + this.destination);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("setGetAllHeaderTypesTest");
        }
        if (!pass) {
            throw new Exception("setGetAllHeaderTypesTest failed");
        }
    }

    @Test
    public void msgPropertiesTest() throws Exception {
        boolean pass = true;
        boolean bool = true;
        byte bValue = 127;
        short nShort = 10;
        int nInt = 5;
        long nLong = 333L;
        float nFloat = 1.0f;
        double nDouble = 100.0;
        String testString = "test";
        Enumeration propertyNames = null;
        Object jmsxDefined = null;
        int numPropertyNames = 18;
        String testMessageBody = "Testing...";
        String message = "Where are you!";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            logger.log(System.Logger.Level.INFO, "Set primitive property types on JMSProducer");
            this.producer.setProperty("TESTBOOLEAN", bool);
            this.producer.setProperty("TESTBYTE", bValue);
            this.producer.setProperty("TESTDOUBLE", nDouble);
            this.producer.setProperty("TESTFLOAT", nFloat);
            this.producer.setProperty("TESTINT", nInt);
            this.producer.setProperty("TESTLONG", nLong);
            this.producer.setProperty("TESTSHORT", nShort);
            this.producer.setProperty("TESTSTRING", "test");
            logger.log(System.Logger.Level.INFO, "Set Object property types on JMSProducer");
            this.producer.setProperty("OBJTESTBOOLEAN", (Object)bool);
            this.producer.setProperty("OBJTESTBYTE", (Object)bValue);
            this.producer.setProperty("OBJTESTDOUBLE", (Object)nDouble);
            this.producer.setProperty("OBJTESTFLOAT", (Object)Float.valueOf(nFloat));
            this.producer.setProperty("OBJTESTINT", (Object)nInt);
            this.producer.setProperty("OBJTESTLONG", (Object)nLong);
            this.producer.setProperty("OBJTESTSHORT", (Object)nShort);
            this.producer.setProperty("OBJTESTSTRING", "test");
            logger.log(System.Logger.Level.INFO, "Creating TextMessage");
            messageSent = this.context.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "messageSent=" + messageSent.getText());
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgPropertiesTest");
            this.producer.send(this.destination, (Message)messageSent);
            messageReceived = (TextMessage)this.consumer.receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "messageReceived=" + messageReceived.getText());
            int i = 0;
            logger.log(System.Logger.Level.INFO, "Retrieve and verify correct # of properties set");
            propertyNames = messageReceived.getPropertyNames();
            do {
                String tmp = (String)propertyNames.nextElement();
                logger.log(System.Logger.Level.INFO, "Property Name is: " + tmp);
                if (tmp.indexOf("JMS") != 0) {
                    ++i;
                    continue;
                }
                if (!tmp.equals("JMSXDeliveryCount")) continue;
                ++i;
            } while (propertyNames.hasMoreElements());
            if (i == numPropertyNames) {
                logger.log(System.Logger.Level.INFO, "Pass: # of properties is " + numPropertyNames + " as expected");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: expected " + numPropertyNames + " property names, but got " + i);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Retrieve and verify that JMSProducer properties were set correctly");
            logger.log(System.Logger.Level.INFO, "Get properties for boolean, byte, short, int, long, float, double, and String.");
            if (this.producer.getBooleanProperty("TESTBOOLEAN") == bool) {
                logger.log(System.Logger.Level.INFO, "Pass: getBooleanProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getBooleanProperty");
                pass = false;
            }
            if (this.producer.getByteProperty("TESTBYTE") == bValue) {
                logger.log(System.Logger.Level.INFO, "Pass: getByteProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getByteProperty");
                pass = false;
            }
            if (this.producer.getLongProperty("TESTLONG") == nLong) {
                logger.log(System.Logger.Level.INFO, "Pass: getLongProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getLongProperty");
                pass = false;
            }
            if (this.producer.getStringProperty("TESTSTRING").equals(testString)) {
                logger.log(System.Logger.Level.INFO, "Pass: getStringProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getStringProperty");
                pass = false;
            }
            if (this.producer.getDoubleProperty("TESTDOUBLE") == nDouble) {
                logger.log(System.Logger.Level.INFO, "Pass: getDoubleProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getDoubleProperty");
                pass = false;
            }
            if (this.producer.getFloatProperty("TESTFLOAT") == nFloat) {
                logger.log(System.Logger.Level.INFO, "Pass: getFloatProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getFloatProperty");
                pass = false;
            }
            if (this.producer.getIntProperty("TESTINT") == nInt) {
                logger.log(System.Logger.Level.INFO, "Pass: getIntProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getIntProperty");
                pass = false;
            }
            if (this.producer.getShortProperty("TESTSHORT") == nShort) {
                logger.log(System.Logger.Level.INFO, "Pass: getShortProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getShortProperty");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Get properties for Boolean, Byte, Short, Integer, Long, Float, Double, String.");
            if ((Boolean)this.producer.getObjectProperty("OBJTESTBOOLEAN") == bool) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct Boolean value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect Boolean value returned from getObjectProperty");
                pass = false;
            }
            if ((Byte)this.producer.getObjectProperty("OBJTESTBYTE") == bValue) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct Byte value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect Byte value returned from getObjectProperty");
                pass = false;
            }
            if ((Long)this.producer.getObjectProperty("OBJTESTLONG") == nLong) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct Long value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect Long value returned from getObjectProperty");
                pass = false;
            }
            if (((String)this.producer.getObjectProperty("OBJTESTSTRING")).equals(testString)) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct String value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect String value returned from getObjectProperty");
                pass = false;
            }
            if ((Double)this.producer.getObjectProperty("OBJTESTDOUBLE") == nDouble) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct Double value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect Double value returned from getObjectProperty");
                pass = false;
            }
            if (((Float)this.producer.getObjectProperty("OBJTESTFLOAT")).floatValue() == nFloat) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct Float value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect Float value returned from getObjectProperty");
                pass = false;
            }
            if ((Integer)this.producer.getObjectProperty("OBJTESTINT") == nInt) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct Integer value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect Integer value returned from getObjectProperty");
                pass = false;
            }
            if ((Short)this.producer.getObjectProperty("OBJTESTSHORT") == nShort) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct Short value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect Short value returned from getObjectProperty");
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Set message headers JMSCorrelationID, JMSType, JMSReplyTo on JMSProducer");
            this.producer.setJMSCorrelationID("TestCorrelationID");
            this.producer.setJMSType("TestMessage");
            this.producer.setJMSReplyTo(this.destination);
            String temp = null;
            Destination tempdest = null;
            temp = this.producer.getJMSCorrelationID();
            if (temp == null) {
                logger.log(System.Logger.Level.INFO, "Fail: getJMSCorrelationID returned null");
                pass = false;
            } else if (temp.equals("TestCorrelationID")) {
                logger.log(System.Logger.Level.INFO, "Pass: getJMSCorrelationID returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: getJMSCorrelationID returned incorrect value, got: " + temp + " expected: TestCorrelationID");
                pass = false;
            }
            temp = this.producer.getJMSType();
            if (temp == null) {
                logger.log(System.Logger.Level.INFO, "Fail: getJMSType returned null");
                pass = false;
            } else if (temp.equals("TestMessage")) {
                logger.log(System.Logger.Level.INFO, "Pass: getJMSType returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: getJMSType returned incorrect value, got: " + temp + " expected: TestMessage");
                pass = false;
            }
            tempdest = this.producer.getJMSReplyTo();
            if (tempdest == null) {
                logger.log(System.Logger.Level.INFO, "Fail: getJMSReplyTo returned null");
                pass = false;
            } else if (tempdest.equals(this.destination)) {
                logger.log(System.Logger.Level.INFO, "Pass: getJMSReplyTo returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: getJMSReplyTo returned incorrect value, got: " + tempdest + " expected: " + this.destination);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Create a TextMessage");
            messageSent = this.context.createTextMessage();
            messageSent.setText(testMessageBody);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgPropertiesTest");
            logger.log(System.Logger.Level.INFO, "Send the TextMessage");
            this.producer.send(this.destination, (Message)messageSent);
            logger.log(System.Logger.Level.INFO, "messageSent=" + messageSent.getText());
            logger.log(System.Logger.Level.INFO, "Receive the TextMessage");
            messageReceived = (TextMessage)this.consumer.receive(this.timeout);
            logger.log(System.Logger.Level.INFO, "messageReceived=" + messageReceived.getText());
            logger.log(System.Logger.Level.INFO, "Retrieve and verify that TextMessage message properties were set correctly");
            if (messageReceived.getBooleanProperty("TESTBOOLEAN") == bool) {
                logger.log(System.Logger.Level.INFO, "Pass: getBooleanProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getBooleanProperty");
                pass = false;
            }
            if (messageReceived.getByteProperty("TESTBYTE") == bValue) {
                logger.log(System.Logger.Level.INFO, "Pass: getByteProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getByteProperty");
                pass = false;
            }
            if (messageReceived.getLongProperty("TESTLONG") == nLong) {
                logger.log(System.Logger.Level.INFO, "Pass: getLongProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getLongProperty");
                pass = false;
            }
            if (messageReceived.getStringProperty("TESTSTRING").equals(testString)) {
                logger.log(System.Logger.Level.INFO, "Pass: getStringProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getStringProperty");
                pass = false;
            }
            if (messageReceived.getDoubleProperty("TESTDOUBLE") == nDouble) {
                logger.log(System.Logger.Level.INFO, "Pass: getDoubleProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getDoubleProperty");
                pass = false;
            }
            if (messageReceived.getFloatProperty("TESTFLOAT") == nFloat) {
                logger.log(System.Logger.Level.INFO, "Pass: getFloatProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getFloatProperty");
                pass = false;
            }
            if (messageReceived.getIntProperty("TESTINT") == nInt) {
                logger.log(System.Logger.Level.INFO, "Pass: getIntProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getIntProperty");
                pass = false;
            }
            if (messageReceived.getShortProperty("TESTSHORT") == nShort) {
                logger.log(System.Logger.Level.INFO, "Pass: getShortProperty returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getShortProperty");
                pass = false;
            }
            if (messageReceived.getIntProperty("JMSXDeliveryCount") >= 1) {
                logger.log(System.Logger.Level.INFO, "Pass: getIntProperty(JMSXDeliveryCount) returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect value returned from getIntProperty(JMSXDeliveryCount)");
                pass = false;
            }
            if ((Boolean)messageReceived.getObjectProperty("OBJTESTBOOLEAN") == bool) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct Boolean value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect Boolean value returned from getObjectProperty");
                pass = false;
            }
            if ((Byte)messageReceived.getObjectProperty("OBJTESTBYTE") == bValue) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct Byte value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect Byte value returned from getObjectProperty");
                pass = false;
            }
            if ((Long)messageReceived.getObjectProperty("OBJTESTLONG") == nLong) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct Long value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect Long value returned from getObjectProperty");
                pass = false;
            }
            if (((String)messageReceived.getObjectProperty("OBJTESTSTRING")).equals(testString)) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct String value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect String value returned from getObjectProperty");
                pass = false;
            }
            if ((Double)messageReceived.getObjectProperty("OBJTESTDOUBLE") == nDouble) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct Double value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect Double value returned from getObjectProperty");
                pass = false;
            }
            if (((Float)messageReceived.getObjectProperty("OBJTESTFLOAT")).floatValue() == nFloat) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct Float value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect Float value returned from getObjectProperty");
                pass = false;
            }
            if ((Integer)messageReceived.getObjectProperty("OBJTESTINT") == nInt) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct Integer value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect Integer value returned from getObjectProperty");
                pass = false;
            }
            if ((Short)messageReceived.getObjectProperty("OBJTESTSHORT") == nShort) {
                logger.log(System.Logger.Level.INFO, "Pass: getObjectProperty returned correct Short value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: incorrect Short value returned from getObjectProperty");
                pass = false;
            }
            temp = messageReceived.getJMSCorrelationID();
            if (temp == null) {
                logger.log(System.Logger.Level.INFO, "Fail: getJMSCorrelationID returned null");
                pass = false;
            } else if (temp.equals("TestCorrelationID")) {
                logger.log(System.Logger.Level.INFO, "Pass: getJMSCorrelationID returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: getJMSCorrelationID returned incorrect value, got: " + temp + " expected: TestCorrelationID");
                pass = false;
            }
            temp = messageReceived.getJMSType();
            if (temp == null) {
                logger.log(System.Logger.Level.INFO, "Fail: getJMSType returned null");
                pass = false;
            } else if (temp.equals("TestMessage")) {
                logger.log(System.Logger.Level.INFO, "Pass: getJMSType returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: getJMSType returned incorrect value, got: " + temp + " expected: TestMessage");
                pass = false;
            }
            tempdest = messageReceived.getJMSReplyTo();
            if (tempdest == null) {
                logger.log(System.Logger.Level.INFO, "Fail: getJMSReplyTo returned null");
                pass = false;
            } else if (tempdest.equals(this.destination)) {
                logger.log(System.Logger.Level.INFO, "Pass: getJMSReplyTo returned correct value");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: getJMSReplyTo returned incorrect value, got: " + tempdest + " expected: " + this.destination);
                pass = false;
            }
            try {
                boolean b = this.producer.getBooleanProperty("TESTDUMMY");
                if (b) {
                    logger.log(System.Logger.Level.INFO, "Fail: should have received false for getBooleanProperty");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.INFO, "Caught unexpected exception: " + e);
                pass = false;
            }
            try {
                byte value = this.producer.getByteProperty("TESTDUMMY");
                logger.log(System.Logger.Level.INFO, "Fail: NumberFormatException should have occurred for getByteProperty");
                pass = false;
            }
            catch (NumberFormatException np) {
                logger.log(System.Logger.Level.INFO, "Pass: NumberFormatException as expected ");
            }
            try {
                short value = this.producer.getShortProperty("TESTDUMMY");
                logger.log(System.Logger.Level.INFO, "Fail: NumberFormatException should have occurred for getShortProperty");
                pass = false;
            }
            catch (NumberFormatException np) {
                logger.log(System.Logger.Level.INFO, "Pass: NumberFormatException as expected ");
            }
            try {
                int value = this.producer.getIntProperty("TESTDUMMY");
                logger.log(System.Logger.Level.INFO, "Fail: NumberFormatException should have occurred for getIntProperty");
                pass = false;
            }
            catch (NumberFormatException np) {
                logger.log(System.Logger.Level.INFO, "Pass: NumberFormatException as expected ");
            }
            try {
                long value = this.producer.getLongProperty("TESTDUMMY");
                logger.log(System.Logger.Level.INFO, "Fail: NumberFormatException should have occurred for getLongProperty");
                pass = false;
            }
            catch (NumberFormatException np) {
                logger.log(System.Logger.Level.INFO, "Pass: NumberFormatException as expected ");
            }
            try {
                float value = this.producer.getFloatProperty("TESTDUMMY");
                logger.log(System.Logger.Level.INFO, "Fail: NullPointerException should have occurred for getFloatProperty");
                pass = false;
            }
            catch (NullPointerException np) {
                logger.log(System.Logger.Level.INFO, "Pass: NullPointerException as expected ");
            }
            try {
                double value = this.producer.getDoubleProperty("TESTDUMMY");
                logger.log(System.Logger.Level.INFO, "Fail: NullPointerException should have occurred for getDoubleProperty");
                pass = false;
            }
            catch (NullPointerException np) {
                logger.log(System.Logger.Level.INFO, "Pass: NullPointerException as expected ");
            }
            this.producer.clearProperties();
            Long aLong = (Long)this.producer.getObjectProperty("OBJTESTLONG");
            if (aLong == null) {
                logger.log(System.Logger.Level.INFO, "Pass: property was cleared");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: getObjectProperty should have returned null for cleared property");
                pass = false;
            }
            try {
                short aShort = this.producer.getShortProperty("TESTSHORT");
                logger.log(System.Logger.Level.INFO, "Fail: NumberFormatException should have occurred for getShortProperty");
                pass = false;
            }
            catch (NumberFormatException np) {
                logger.log(System.Logger.Level.INFO, "Pass: NumberFormatException as expected ");
            }
            Set propNames = this.producer.getPropertyNames();
            Iterator iterator = propNames.iterator();
            boolean hasElements = iterator.hasNext();
            if (hasElements) {
                logger.log(System.Logger.Level.INFO, "Fail: JMSProducer.getPropertyName() has properties (unexpected)");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Pass: JMSProducer.getPropertyName() has no properties (expected)");
            }
            try {
                ConnectionMetaData data = this.context.getMetaData();
                Enumeration cmd = data.getJMSXPropertyNames();
                if (cmd == null) {
                    logger.log(System.Logger.Level.INFO, "Fail: no JMSX property names were returned!");
                    logger.log(System.Logger.Level.INFO, "expected JMSXGroupID, JMSXGroupSeq, JMSXDeliveryCount at a miniumum");
                    pass = false;
                } else {
                    int iCount = 0;
                    do {
                        String propName = (String)cmd.nextElement();
                        logger.log(System.Logger.Level.INFO, propName);
                        if (!propName.equals("JMSXGroupID") && !propName.equals("JMSXGroupSeq") && !propName.equals("JMSXDeliveryCount")) continue;
                        ++iCount;
                    } while (cmd.hasMoreElements());
                    if (iCount > 1) {
                        logger.log(System.Logger.Level.INFO, "Pass:");
                    } else {
                        logger.log(System.Logger.Level.INFO, "Fail: Expected property names not returned");
                        pass = false;
                    }
                }
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: unexpected exception: " + ee);
                pass = false;
            }
            if (!pass) {
                throw new Exception("msgPropertiesTest failed");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            e.printStackTrace();
            throw new Exception("msgPropertiesTest failed");
        }
    }

    @Test
    public void msgPropertiesConversionTests() throws Exception {
        boolean pass = true;
        boolean bool = true;
        byte bValue = 127;
        short nShort = 10;
        int nInt = 5;
        long nLong = 333L;
        float nFloat = 1.0f;
        double nDouble = 100.0;
        String testString = "test";
        String testMessageBody = "Testing...";
        boolean ntest = false;
        try {
            Object messageSent = null;
            Object messageReceived = null;
            this.producer.setProperty("TESTBOOLEAN", bool);
            this.producer.setProperty("TESTBYTE", bValue);
            this.producer.setProperty("TESTSHORT", nShort);
            this.producer.setProperty("TESTINT", nInt);
            this.producer.setProperty("TESTFLOAT", nFloat);
            this.producer.setProperty("TESTDOUBLE", nDouble);
            this.producer.setProperty("TESTSTRING", "test");
            this.producer.setProperty("TESTLONG", nLong);
            this.producer.setProperty("TESTSTRINGTRUE", "true");
            this.producer.setProperty("TESTSTRINGFALSE", "false");
            this.producer.setProperty("TESTSTRING1", "1");
            String myBool = this.producer.getStringProperty("TESTBOOLEAN");
            if (Boolean.valueOf(myBool) == bool) {
                logger.log(System.Logger.Level.INFO, "Pass: conversion from boolean to string - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: conversion from boolean to string failed");
                pass = false;
            }
            try {
                this.producer.getByteProperty("TESTBOOLEAN");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: boolean to byte ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception -- boolean to byte");
                pass = false;
            }
            try {
                this.producer.getShortProperty("TESTBOOLEAN");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: boolean to short ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception -- boolean to short");
                pass = false;
            }
            try {
                this.producer.getIntProperty("TESTBOOLEAN");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: boolean to int ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception --boolean to int ");
                pass = false;
            }
            try {
                this.producer.getLongProperty("TESTBOOLEAN");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: boolean to long ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception -- boolean to long");
                pass = false;
            }
            try {
                this.producer.getFloatProperty("TESTBOOLEAN");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: boolean to float ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception -- boolean to float");
                pass = false;
            }
            try {
                this.producer.getDoubleProperty("TESTBOOLEAN");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: boolean to double ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception -- boolean to double");
                pass = false;
            }
            String myByte = this.producer.getStringProperty("TESTBYTE");
            if (Byte.valueOf(myByte) == bValue) {
                logger.log(System.Logger.Level.INFO, "Pass: conversion from byte to string - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: conversion from byte to string failed");
                pass = false;
            }
            if (this.producer.getShortProperty("TESTBYTE") == bValue) {
                logger.log(System.Logger.Level.INFO, "Pass: conversion from byte to short - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: conversion from byte to short failed");
                pass = false;
            }
            if (this.producer.getIntProperty("TESTBYTE") == bValue) {
                logger.log(System.Logger.Level.INFO, "Pass: conversion from byte to int - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: conversion from byte to int failed");
                pass = false;
            }
            if (this.producer.getLongProperty("TESTBYTE") == (long)bValue) {
                logger.log(System.Logger.Level.INFO, "Pass: conversion from byte to long - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: conversion from byte to long failed");
                pass = false;
            }
            try {
                this.producer.getBooleanProperty("TESTBYTE");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: byte to boolean ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception -- byte to boolean");
                pass = false;
            }
            try {
                this.producer.getFloatProperty("TESTBYTE");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: byte to float ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception --byte to float ");
                pass = false;
            }
            try {
                this.producer.getDoubleProperty("TESTBYTE");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: byte to double ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception -- byte to double");
                pass = false;
            }
            String myshort = this.producer.getStringProperty("TESTSHORT");
            if (Short.valueOf(myshort) == nShort) {
                logger.log(System.Logger.Level.INFO, "Pass: conversion from short to string - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: conversion from short to string failed");
                pass = false;
            }
            if (this.producer.getIntProperty("TESTSHORT") == nShort) {
                logger.log(System.Logger.Level.INFO, "Pass: conversion from short to int - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: conversion from short to int failed");
                pass = false;
            }
            if (this.producer.getLongProperty("TESTSHORT") == (long)nShort) {
                logger.log(System.Logger.Level.INFO, "Pass: conversion from short to long - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: conversion from short to long failed");
                pass = false;
            }
            try {
                this.producer.getBooleanProperty("TESTSHORT");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: short to boolean ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception -- short to boolean");
                pass = false;
            }
            try {
                this.producer.getByteProperty("TESTSHORT");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: short to byte ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception -- short to byte");
                pass = false;
            }
            try {
                this.producer.getFloatProperty("TESTSHORT");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: short to float ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception -- short to float");
                pass = false;
            }
            try {
                this.producer.getDoubleProperty("TESTSHORT");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: short to double ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception -- short to double");
                pass = false;
            }
            if (Integer.valueOf(this.producer.getStringProperty("TESTINT")) == nInt) {
                logger.log(System.Logger.Level.INFO, "Pass: conversion from int to string - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: conversion from int to string failed");
                pass = false;
            }
            if (this.producer.getLongProperty("TESTINT") == (long)nInt) {
                logger.log(System.Logger.Level.INFO, "Pass: conversion from int to long - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: conversion from int to long failed");
                pass = false;
            }
            try {
                this.producer.getBooleanProperty("TESTINT");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: int to boolean ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception -- int to boolean");
                pass = false;
            }
            try {
                this.producer.getByteProperty("TESTINT");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: int to byte ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception --  int to byte");
                pass = false;
            }
            try {
                this.producer.getShortProperty("TESTINT");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: int to short ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected -- int to short ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception ");
                pass = false;
            }
            try {
                this.producer.getFloatProperty("TESTINT");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: int to float ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception -- int to float");
                pass = false;
            }
            try {
                this.producer.getDoubleProperty("TESTINT");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: int to double ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception -- int to double");
                pass = false;
            }
            if (Long.valueOf(this.producer.getStringProperty("TESTLONG")) == nLong) {
                logger.log(System.Logger.Level.INFO, "Pass: conversion from long to string - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: conversion from long to string failed");
                pass = false;
            }
            try {
                this.producer.getBooleanProperty("TESTLONG");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: long to boolean ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception -- long to boolean");
                pass = false;
            }
            try {
                this.producer.getByteProperty("TESTLONG");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: long to byte ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception -- long to byte");
                pass = false;
            }
            try {
                this.producer.getShortProperty("TESTLONG");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: long to short ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception -- long to short ");
                pass = false;
            }
            try {
                this.producer.getIntProperty("TESTLONG");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: long to int ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception -- long to int");
                pass = false;
            }
            try {
                this.producer.getFloatProperty("TESTLONG");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: long to float ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception -- long to float");
                pass = false;
            }
            try {
                this.producer.getDoubleProperty("TESTLONG");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: long to double ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception -- long to double");
                pass = false;
            }
            if (Float.valueOf(this.producer.getStringProperty("TESTFLOAT")).floatValue() == nFloat) {
                logger.log(System.Logger.Level.INFO, "Pass: conversion from float to string - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: conversion from float to string failed");
                pass = false;
            }
            if (this.producer.getDoubleProperty("TESTFLOAT") == (double)nFloat) {
                logger.log(System.Logger.Level.INFO, "Pass: conversion from long to double - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: conversion from long to double failed");
                pass = false;
            }
            try {
                this.producer.getBooleanProperty("TESTFLOAT");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: float to boolean ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception -- float to boolean ");
                pass = false;
            }
            try {
                this.producer.getByteProperty("TESTFLOAT");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: float to byte ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception -- float to byte");
                pass = false;
            }
            try {
                this.producer.getShortProperty("TESTFLOAT");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: float to short ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception - float to short ");
                pass = false;
            }
            try {
                this.producer.getIntProperty("TESTFLOAT");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: float to int ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception --- float to int");
                pass = false;
            }
            try {
                this.producer.getLongProperty("TESTFLOAT");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: float to long ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception --  float to long");
                pass = false;
            }
            if (Double.valueOf(this.producer.getStringProperty("TESTDOUBLE")) == nDouble) {
                logger.log(System.Logger.Level.INFO, "Pass: conversion from double to string - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: conversion from double to string failed");
                pass = false;
            }
            try {
                this.producer.getBooleanProperty("TESTDOUBLE");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: double to boolean ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception -- double to boolean ");
                pass = false;
            }
            try {
                this.producer.getByteProperty("TESTDOUBLE");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: double to byte ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception -- double to byte ");
                pass = false;
            }
            try {
                this.producer.getShortProperty("TESTDOUBLE");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: double to short ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception -- double to short");
                pass = false;
            }
            try {
                this.producer.getIntProperty("TESTDOUBLE");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: double to int ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception --- double to int ");
                pass = false;
            }
            try {
                this.producer.getLongProperty("TESTDOUBLE");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: double to long ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception -- double to long");
                pass = false;
            }
            try {
                this.producer.getFloatProperty("TESTDOUBLE");
                logger.log(System.Logger.Level.INFO, "Fail: MessageFormatRuntimeException should have occurred for type conversion error");
                logger.log(System.Logger.Level.INFO, "Fail: unsupported conversion: double to float ");
                pass = false;
            }
            catch (MessageFormatRuntimeException me) {
                logger.log(System.Logger.Level.INFO, "Pass: MessageFormatRuntimeException as expected ");
            }
            catch (Exception ee) {
                logger.log(System.Logger.Level.INFO, "Fail: Caught unexpected exception: " + ee);
                logger.log(System.Logger.Level.INFO, "Fail: did not catch expected Exception -- double to float");
                pass = false;
            }
            if (this.producer.getBooleanProperty("TESTSTRINGTRUE")) {
                logger.log(System.Logger.Level.INFO, "Pass: conversion from string to boolean - expect true - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: conversion from string to boolean - expect true  - failed");
                pass = false;
            }
            if (!this.producer.getBooleanProperty("TESTSTRINGFALSE")) {
                logger.log(System.Logger.Level.INFO, "Pass: conversion from string to boolean expect false - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: conversion from string to boolean expect false - failed");
                pass = false;
            }
            if (this.producer.getByteProperty("TESTSTRING1") == 1) {
                logger.log(System.Logger.Level.INFO, "Pass: conversion from string to byte - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: conversion from string to byte failed");
                pass = false;
            }
            if (this.producer.getShortProperty("TESTSTRING1") == 1) {
                logger.log(System.Logger.Level.INFO, "Pass: conversion from string to short - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: conversion from string to short failed");
                pass = false;
            }
            if (this.producer.getIntProperty("TESTSTRING1") == 1) {
                logger.log(System.Logger.Level.INFO, "Pass: conversion from string to int - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: conversion from string to int failed");
                pass = false;
            }
            if (this.producer.getLongProperty("TESTSTRING1") == 1L) {
                logger.log(System.Logger.Level.INFO, "Pass: conversion from string to long - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: conversion from string to long failed");
                pass = false;
            }
            if (this.producer.getFloatProperty("TESTSTRING1") == 1.0f) {
                logger.log(System.Logger.Level.INFO, "Pass: conversion from string to float - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: conversion from string to float failed");
                pass = false;
            }
            if (this.producer.getDoubleProperty("TESTSTRING1") == 1.0) {
                logger.log(System.Logger.Level.INFO, "Pass: conversion from string to double - ok");
            } else {
                logger.log(System.Logger.Level.INFO, "Fail: conversion from string to double failed");
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.INFO, "Caught unexpected exception: " + e);
            throw new Exception("msgPropertiesConversionTests failed");
        }
        if (!pass) {
            throw new Exception("msgPropertiesConversionTests failed");
        }
    }

    @Test
    public void msgPropertyExistTest() throws Exception {
        boolean pass = true;
        boolean bool = true;
        byte bValue = 127;
        short nShort = 10;
        int nInt = 5;
        long nLong = 333L;
        float nFloat = 1.0f;
        double nDouble = 100.0;
        String testString = "test";
        Enumeration propertyNames = null;
        String testMessageBody = "Testing msgPropertyExistTest";
        try {
            TextMessage messageSent = null;
            TextMessage messageReceived = null;
            this.producer.setProperty("TESTBOOLEAN", bool);
            this.producer.setProperty("TESTBYTE", bValue);
            this.producer.setProperty("TESTSHORT", nShort);
            this.producer.setProperty("TESTINT", nInt);
            this.producer.setProperty("TESTFLOAT", nFloat);
            this.producer.setProperty("TESTDOUBLE", nDouble);
            this.producer.setProperty("TESTSTRING", "test");
            this.producer.setProperty("TESTLONG", nLong);
            this.producer.setProperty("OBJTESTBOOLEAN", (Object)bool);
            logger.log(System.Logger.Level.INFO, "Create a TextMessage");
            messageSent = this.context.createTextMessage();
            messageSent.setText(testMessageBody);
            messageSent.setStringProperty("COM_SUN_JMS_TESTNAME", "msgPropertiesTest");
            logger.log(System.Logger.Level.INFO, "Send the TextMessage");
            this.producer.send(this.destination, (Message)messageSent);
            logger.log(System.Logger.Level.INFO, "Receive the TextMessage");
            messageReceived = (TextMessage)this.consumer.receive(this.timeout);
            if (messageReceived == null) {
                pass = false;
                logger.log(System.Logger.Level.ERROR, "messageReceived is null (unexpected)");
            } else {
                int i = 0;
                propertyNames = messageReceived.getPropertyNames();
                do {
                    String tmp;
                    if (!(tmp = (String)propertyNames.nextElement()).startsWith("JMS")) {
                        ++i;
                        if (tmp.equals("TESTBOOLEAN") || tmp.equals("TESTBYTE") || tmp.equals("TESTINT") || tmp.equals("TESTSHORT") || tmp.equals("TESTFLOAT") || tmp.equals("TESTDOUBLE") || tmp.equals("TESTSTRING") || tmp.equals("TESTLONG") || tmp.equals("OBJTESTBOOLEAN") || tmp.equals("COM_SUN_JMS_TESTNAME")) {
                            logger.log(System.Logger.Level.INFO, "Application Property set by client is: " + tmp);
                            if (!messageReceived.propertyExists(tmp)) {
                                pass = messageReceived.propertyExists(tmp);
                                logger.log(System.Logger.Level.ERROR, "Positive propertyExists test failed for " + tmp);
                                continue;
                            }
                            if (!messageReceived.propertyExists(tmp + "1")) continue;
                            pass = false;
                            logger.log(System.Logger.Level.ERROR, "Negative propertyExists test failed for " + tmp + "1");
                            continue;
                        }
                        logger.log(System.Logger.Level.ERROR, "Appclication Property not set by client: " + tmp);
                        pass = false;
                        continue;
                    }
                    logger.log(System.Logger.Level.INFO, "JMSProperty Name is: " + tmp);
                } while (propertyNames.hasMoreElements());
            }
            if (!pass) {
                throw new Exception("msgPropertyExistTest failed");
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.INFO, "Caught unexpected exception: " + e);
            throw new Exception("msgPropertyExistTest failed");
        }
    }

    @Test
    public void msgJMSXPropertiesTest() throws Exception {
        boolean pass;
        block25: {
            pass = true;
            String message = "Testing msgJMSXPropertiesTest";
            int seq = 123450;
            String id = "msgJMSXPropertiesTest";
            try {
                logger.log(System.Logger.Level.INFO, "Creating TextMessage");
                TextMessage expTextMessage = this.context.createTextMessage(message);
                logger.log(System.Logger.Level.INFO, "Set StringProperty COM_SUN_JMS_TESTNAME");
                expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "msgJMSXPropertiesTest");
                logger.log(System.Logger.Level.INFO, "Set JMSXGroupSeq and JMSXGroupSeq");
                expTextMessage.setStringProperty("JMSXGroupID", id);
                expTextMessage.setIntProperty("JMSXGroupSeq", seq);
                logger.log(System.Logger.Level.INFO, "Send the TextMessage");
                this.producer.send(this.destination, (Message)expTextMessage);
                logger.log(System.Logger.Level.INFO, "Receive the TextMessage");
                TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
                logger.log(System.Logger.Level.INFO, "Verify the value in TextMessage");
                if (actTextMessage == null) {
                    throw new Exception("Did not receive TextMessage");
                }
                if (actTextMessage.getText().equals(expTextMessage.getText())) {
                    logger.log(System.Logger.Level.INFO, "TextMessage is correct");
                } else {
                    logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + expTextMessage.getText() + ", received " + actTextMessage.getText());
                    pass = false;
                }
                logger.log(System.Logger.Level.INFO, "Verify properties JMSXGroupID, JMSXGroupSeq, JMSXDeliveryCount in TextMessage");
                if (actTextMessage.propertyExists("JMSXGroupID")) {
                    if (actTextMessage.getStringProperty("JMSXGroupID").equals(id)) {
                        logger.log(System.Logger.Level.INFO, "Pass: getStringProperty(JMSXGroupID) returned correct value");
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Fail: incorrect value returned from getStringProperty(JMSXGroupID)");
                        pass = false;
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Fail: TextMessage does not contain expected JMSXGroupID property");
                    pass = false;
                }
                if (actTextMessage.propertyExists("JMSXGroupSeq")) {
                    if (actTextMessage.getIntProperty("JMSXGroupSeq") == seq) {
                        logger.log(System.Logger.Level.INFO, "Pass: getIntProperty(JMSXGroupSeq) returned correct value");
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Fail: incorrect value returned from getIntProperty(JMSXGroupSeq)");
                        pass = false;
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Fail: TextMessage does not contain expected JMSXGroupSeq property");
                    pass = false;
                }
                if (actTextMessage.propertyExists("JMSXDeliveryCount")) {
                    if (actTextMessage.getIntProperty("JMSXDeliveryCount") == 1) {
                        logger.log(System.Logger.Level.INFO, "Pass: getIntProperty(JMSXDeliveryCount) returned correct value");
                    } else {
                        logger.log(System.Logger.Level.ERROR, "Fail: incorrect value returned from getIntProperty(JMSXDeliveryCount)");
                        pass = false;
                    }
                } else {
                    logger.log(System.Logger.Level.ERROR, "Fail: TextMessage does not contain expected JMSXDeliveryCount property");
                    pass = false;
                }
                logger.log(System.Logger.Level.INFO, "Verify the JMSXProperties in ConnectionMetaData");
                try {
                    logger.log(System.Logger.Level.INFO, "Get ConnectionMetaData");
                    ConnectionMetaData data = this.context.getMetaData();
                    logger.log(System.Logger.Level.INFO, "Get JMSXPropertyNames");
                    Enumeration cmd = data.getJMSXPropertyNames();
                    logger.log(System.Logger.Level.INFO, "Verify that we have JMSXGroupID, JMSXGroupSeq, JMSXDeliveryCount");
                    if (cmd == null) {
                        logger.log(System.Logger.Level.ERROR, "No JMSX property names were returned (Failed)");
                        pass = false;
                        break block25;
                    }
                    int iCount = 0;
                    do {
                        String propName = (String)cmd.nextElement();
                        logger.log(System.Logger.Level.TRACE, "Found JMSX property [" + propName + "]");
                        if (propName.equals("JMSXGroupID")) {
                            ++iCount;
                            continue;
                        }
                        if (propName.equals("JMSXGroupSeq")) {
                            ++iCount;
                            continue;
                        }
                        if (!propName.equals("JMSXDeliveryCount")) continue;
                        ++iCount;
                    } while (cmd.hasMoreElements());
                    if (iCount > 2) {
                        logger.log(System.Logger.Level.INFO, "Expected JMSX property names were returned (Passed)");
                        break block25;
                    }
                    logger.log(System.Logger.Level.ERROR, "Expected JMSX property names not returned (Failed)");
                    pass = false;
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
                throw new Exception("msgJMSXPropertiesTest", e);
            }
        }
        if (!pass) {
            throw new Exception("msgJMSXPropertiesTest failed");
        }
    }

    @Test
    public void setPropertyExceptionTests() throws Exception {
        boolean pass = true;
        boolean bool = true;
        byte bValue = 127;
        short nShort = 10;
        int nInt = 5;
        long nLong = 333L;
        float nFloat = 1.0f;
        double nDouble = 100.0;
        String testString = "test";
        try {
            logger.log(System.Logger.Level.INFO, "Create a JMSProducer from JMSContext");
            this.producer = this.context.createProducer();
            logger.log(System.Logger.Level.INFO, "Test IllegalArgumentException from all JMSProducer setProperty() API's");
            try {
                logger.log(System.Logger.Level.INFO, "Test IllegalArgumentException for setProperty(\"\", boolean)");
                this.producer.setProperty("", bool);
                logger.log(System.Logger.Level.ERROR, "Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                logger.log(System.Logger.Level.INFO, "Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: Caught unexpected exception: " + e);
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Test IllegalArgumentException for setProperty(\"\", byte)");
                this.producer.setProperty("", bValue);
                logger.log(System.Logger.Level.ERROR, "Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                logger.log(System.Logger.Level.INFO, "Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: Caught unexpected exception: " + e);
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Test IllegalArgumentException for setProperty(\"\", double)");
                this.producer.setProperty("", nDouble);
                logger.log(System.Logger.Level.ERROR, "Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                logger.log(System.Logger.Level.INFO, "Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: Caught unexpected exception: " + e);
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Test IllegalArgumentException for setProperty(\"\", float)");
                this.producer.setProperty("", nFloat);
                logger.log(System.Logger.Level.ERROR, "Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                logger.log(System.Logger.Level.INFO, "Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: Caught unexpected exception: " + e);
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Test IllegalArgumentException for setProperty(\"\", int)");
                this.producer.setProperty("", nInt);
                logger.log(System.Logger.Level.ERROR, "Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                logger.log(System.Logger.Level.INFO, "Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: Caught unexpected exception: " + e);
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Test IllegalArgumentException for setProperty(\"\", long)");
                this.producer.setProperty("", nLong);
                logger.log(System.Logger.Level.ERROR, "Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                logger.log(System.Logger.Level.INFO, "Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: Caught unexpected exception: " + e);
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Test IllegalArgumentException for setProperty(\"\", short)");
                this.producer.setProperty("", nShort);
                logger.log(System.Logger.Level.ERROR, "Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                logger.log(System.Logger.Level.INFO, "Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: Caught unexpected exception: " + e);
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Test IllegalArgumentException for setProperty(\"\", String)");
                this.producer.setProperty("", "test");
                logger.log(System.Logger.Level.ERROR, "Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                logger.log(System.Logger.Level.INFO, "Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: Caught unexpected exception: " + e);
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Test IllegalArgumentException for setProperty(\"\", Object)");
                this.producer.setProperty("", (Object)nLong);
                logger.log(System.Logger.Level.ERROR, "Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                logger.log(System.Logger.Level.INFO, "Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: Caught unexpected exception: " + e);
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Test IllegalArgumentException for setProperty(null, boolean)");
                this.producer.setProperty(null, bool);
                logger.log(System.Logger.Level.ERROR, "Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                logger.log(System.Logger.Level.INFO, "Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: Caught unexpected exception: " + e);
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Test IllegalArgumentException for setProperty(null, byte)");
                this.producer.setProperty(null, bValue);
                logger.log(System.Logger.Level.ERROR, "Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                logger.log(System.Logger.Level.INFO, "Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: Caught unexpected exception: " + e);
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Test IllegalArgumentException for setProperty(null, double)");
                this.producer.setProperty(null, nDouble);
                logger.log(System.Logger.Level.ERROR, "Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                logger.log(System.Logger.Level.INFO, "Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: Caught unexpected exception: " + e);
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Test IllegalArgumentException for setProperty(null, float)");
                this.producer.setProperty(null, nFloat);
                logger.log(System.Logger.Level.ERROR, "Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                logger.log(System.Logger.Level.INFO, "Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: Caught unexpected exception: " + e);
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Test IllegalArgumentException for setProperty(null, int)");
                this.producer.setProperty(null, nInt);
                logger.log(System.Logger.Level.ERROR, "Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                logger.log(System.Logger.Level.INFO, "Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: Caught unexpected exception: " + e);
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Test IllegalArgumentException for setProperty(null, long)");
                this.producer.setProperty(null, nLong);
                logger.log(System.Logger.Level.ERROR, "Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                logger.log(System.Logger.Level.INFO, "Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: Caught unexpected exception: " + e);
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Test IllegalArgumentException for setProperty(null, short)");
                this.producer.setProperty(null, nShort);
                logger.log(System.Logger.Level.ERROR, "Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                logger.log(System.Logger.Level.INFO, "Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: Caught unexpected exception: " + e);
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Test IllegalArgumentException for setProperty(null, String)");
                this.producer.setProperty(null, "test");
                logger.log(System.Logger.Level.ERROR, "Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                logger.log(System.Logger.Level.INFO, "Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: Caught unexpected exception: " + e);
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Test IllegalArgumentException for setProperty(null, Object)");
                this.producer.setProperty(null, (Object)nLong);
                logger.log(System.Logger.Level.ERROR, "Fail: Did not throw expected IllegalArgumentException");
                pass = false;
            }
            catch (IllegalArgumentException e) {
                logger.log(System.Logger.Level.INFO, "Pass: Caught expected IllegalArgumentException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: Caught unexpected exception: " + e);
                pass = false;
            }
            try {
                logger.log(System.Logger.Level.INFO, "Test MessageFormatRuntimeException for setProperty(String, Object)");
                this.producer.setProperty("name1", new ArrayList(2));
                logger.log(System.Logger.Level.ERROR, "Fail: Did not throw expected MessageFormatRuntimeException");
                pass = false;
            }
            catch (MessageFormatRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Pass: Caught expected MessageFormatRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Fail: Caught unexpected exception: " + e);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("setPropertyExceptionTests");
        }
        if (!pass) {
            throw new Exception("setPropertyExceptionTests failed");
        }
    }

    @Test
    public void sendExceptionTests() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        boolean bool = true;
        byte bValue = 127;
        short nShort = 10;
        int nInt = 5;
        long nLong = 333L;
        float nFloat = 1.0f;
        double nDouble = 100.0;
        String testString = "test";
        try {
            logger.log(System.Logger.Level.INFO, "Testing JMSProducer.send(Destination, Message) for MessageFormatRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Calling send(Destination, Message) -> expect MessageFormatRuntimeException");
                this.producer.send(this.destination, (Message)null);
                logger.log(System.Logger.Level.ERROR, "MessageFormatRuntimeException was not thrown");
                pass = false;
            }
            catch (MessageFormatRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected MessageFormatRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected MessageFormatRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSProducer.send(Destination, Map) for MessageFormatRuntimeException");
            try {
                HashMap<String, Cloneable> mp = new HashMap<String, Cloneable>();
                mp.put("1", new ArrayList(2));
                mp.put("2", new Properties());
                mp.put("2", new Properties());
                mp.put("1", new ArrayList(2));
                logger.log(System.Logger.Level.INFO, "Calling send(Destination, Map) -> expect MessageFormatRuntimeException");
                this.producer.send(this.destination, mp);
                logger.log(System.Logger.Level.ERROR, "MessageFormatRuntimeException was not thrown");
                pass = false;
            }
            catch (MessageFormatRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected MessageFormatRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected MessageFormatRuntimeException, received " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Testing JMSProducer.send(Destination, Message) for MessageNotWriteableRuntimeException");
            try {
                logger.log(System.Logger.Level.INFO, "Create TextMessage");
                TextMessage sendTextMessage = this.context.createTextMessage(message);
                sendTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "sendExceptionTests");
                logger.log(System.Logger.Level.INFO, "Send TextMessage");
                this.producer.send(this.destination, (Message)sendTextMessage);
                logger.log(System.Logger.Level.INFO, "Receive TextMessage");
                TextMessage recvTextMessage = (TextMessage)this.consumer.receive(this.timeout);
                if (recvTextMessage == null) {
                    logger.log(System.Logger.Level.ERROR, "Did not receive TextMessage");
                    pass = false;
                } else {
                    logger.log(System.Logger.Level.INFO, "Check the value in TextMessage");
                    if (recvTextMessage.getText().equals(sendTextMessage.getText())) {
                        logger.log(System.Logger.Level.INFO, "TextMessage is correct");
                    } else {
                        logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + sendTextMessage.getText() + ", received " + recvTextMessage.getText());
                        pass = false;
                    }
                }
                logger.log(System.Logger.Level.INFO, "Set a bunch of JMSProducer properties");
                this.producer.setProperty("TESTBOOLEAN", bool);
                this.producer.setProperty("TESTBYTE", bValue);
                this.producer.setProperty("TESTDOUBLE", nDouble);
                this.producer.setProperty("TESTFLOAT", nFloat);
                this.producer.setProperty("TESTINT", nInt);
                this.producer.setProperty("TESTLONG", nLong);
                this.producer.setProperty("TESTSHORT", nShort);
                this.producer.setProperty("TESTSTRING", testString);
                this.producer.setProperty("OBJTESTLONG", (Object)nLong);
                logger.log(System.Logger.Level.INFO, "Using received TextMessage try and send it (expect MessageNotWriteableRuntimeException)");
                this.producer.send(this.destination, (Message)recvTextMessage);
                logger.log(System.Logger.Level.ERROR, "MessageNotWriteableRuntimeException was not thrown");
                pass = false;
            }
            catch (MessageNotWriteableRuntimeException e) {
                logger.log(System.Logger.Level.INFO, "Caught expected MessageNotWriteableRuntimeException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Expected MessageNotWriteableRuntimeException, received " + e);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught exception: " + e);
            throw new Exception("sendExceptionTests", e);
        }
        if (!pass) {
            throw new Exception("sendExceptionTests failed");
        }
    }

    @Test
    public void getBodyTests() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        StringBuffer expSbuffer = new StringBuffer("This is it!");
        try {
            logger.log(System.Logger.Level.INFO, "Create TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "getBodyTests");
            logger.log(System.Logger.Level.INFO, "Send and receive the TextMessage");
            logger.log(System.Logger.Level.INFO, "Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receive(long) to receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Call TextMessage.getBody(String.class) to extract TextMessage as String");
            String actMessage = (String)actTextMessage.getBody(String.class);
            logger.log(System.Logger.Level.INFO, "Check the value in String");
            if (actMessage.equals(message)) {
                logger.log(System.Logger.Level.INFO, "TextMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "TextMessage is incorrect expected " + message + ", received " + actMessage);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Create ObjectMessage");
            ObjectMessage expObjectMessage = this.context.createObjectMessage((Serializable)expSbuffer);
            logger.log(System.Logger.Level.INFO, "Set some values in ObjectMessage");
            expObjectMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "getBodyTests");
            logger.log(System.Logger.Level.INFO, "Send and receive the ObjectMessage");
            logger.log(System.Logger.Level.INFO, "Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expObjectMessage);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receive(long) to receive ObjectMessage");
            ObjectMessage actObjectMessage = (ObjectMessage)this.consumer.receive(this.timeout);
            if (actObjectMessage == null) {
                throw new Exception("Did not receive ObjectMessage");
            }
            logger.log(System.Logger.Level.INFO, "Call ObjectMessage.getBody(StringBuffer.class) to extract ObjectMessage as StringBuffer");
            StringBuffer actSbuffer = (StringBuffer)actObjectMessage.getBody(StringBuffer.class);
            logger.log(System.Logger.Level.INFO, "Check the value in StringBuffer");
            if (actSbuffer.toString().equals(expSbuffer.toString())) {
                logger.log(System.Logger.Level.INFO, "ObjectMessage is correct");
            } else {
                logger.log(System.Logger.Level.ERROR, "ObjectMessage is incorrect expected " + expSbuffer + ", received " + actSbuffer);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Create BytesMessage");
            BytesMessage bMsg = this.context.createBytesMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in BytesMessage");
            bMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "getBodyTests");
            bMsg.writeByte((byte)1);
            bMsg.writeInt(22);
            logger.log(System.Logger.Level.INFO, "Send and receive the BytesMessage");
            this.producer.send(this.destination, (Message)bMsg);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receive(long) to receive BytesMessage");
            BytesMessage actBytesMessage = (BytesMessage)this.consumer.receive(this.timeout);
            if (actBytesMessage == null) {
                throw new Exception("Did not receive BytesMessage");
            }
            logger.log(System.Logger.Level.INFO, "Call BytesMessage.getBody(StringBuffer.class) to extract BytesMessage as byte[] array");
            byte[] bytes = (byte[])actBytesMessage.getBody(byte[].class);
            if (bytes == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive BytesMessage");
                pass = false;
            } else {
                try {
                    DataInputStream di = new DataInputStream(new ByteArrayInputStream(bytes));
                    logger.log(System.Logger.Level.INFO, "Check the values in BytesMessage");
                    if (di.readByte() == 1) {
                        logger.log(System.Logger.Level.INFO, "bytevalue is correct");
                    } else {
                        logger.log(System.Logger.Level.INFO, "bytevalue is incorrect");
                        pass = false;
                    }
                    if (di.readInt() == 22) {
                        logger.log(System.Logger.Level.INFO, "intvalue is correct");
                    } else {
                        logger.log(System.Logger.Level.INFO, "intvalue is incorrect");
                        pass = false;
                    }
                    try {
                        byte by = di.readByte();
                    }
                    catch (EOFException e) {
                        logger.log(System.Logger.Level.INFO, "Caught expected EOFException");
                    }
                    catch (Exception e) {
                        logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                        pass = false;
                    }
                }
                catch (Exception e) {
                    logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                    pass = false;
                }
            }
            logger.log(System.Logger.Level.INFO, "Send MapMessage");
            MapMessage mMsg = this.context.createMapMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in MapMessage");
            mMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "getBodyTests");
            mMsg.setBoolean("booleanvalue", true);
            mMsg.setInt("intvalue", 10);
            this.producer.send(this.destination, (Message)mMsg);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receive(long) to receive MapMessage");
            MapMessage actMapMessage = (MapMessage)this.consumer.receive(this.timeout);
            if (actMapMessage == null) {
                throw new Exception("Did not receive MapMessage");
            }
            logger.log(System.Logger.Level.INFO, "Call MapMessage.getBody(Map.class) to extract MapMessage as a Map object");
            Map map = (Map)actMapMessage.getBody(Map.class);
            if (map == null) {
                logger.log(System.Logger.Level.ERROR, "Did not receive MapMessage");
                pass = false;
            } else {
                logger.log(System.Logger.Level.INFO, "Check the values in MapMessage");
                logger.log(System.Logger.Level.INFO, "map.size()=" + map.size());
                if (map.size() != 2) {
                    logger.log(System.Logger.Level.ERROR, "Map size is " + map.size() + ", expected 2");
                    pass = false;
                }
                Iterator it = map.keySet().iterator();
                String name = null;
                while (it.hasNext()) {
                    name = (String)it.next();
                    if (name.equals("booleanvalue")) {
                        if (((Boolean)map.get(name)).booleanValue()) {
                            logger.log(System.Logger.Level.INFO, "booleanvalue is correct");
                            continue;
                        }
                        logger.log(System.Logger.Level.ERROR, "booleanvalue is incorrect");
                        pass = false;
                        continue;
                    }
                    if (name.equals("intvalue")) {
                        if ((Integer)map.get(name) == 10) {
                            logger.log(System.Logger.Level.INFO, "intvalue is correct");
                            continue;
                        }
                        logger.log(System.Logger.Level.ERROR, "intvalue is incorrect");
                        pass = false;
                        continue;
                    }
                    logger.log(System.Logger.Level.ERROR, "Unexpected name of [" + name + "] in MapMessage");
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            TestUtil.printStackTrace((Throwable)e);
            throw new Exception("getBodyTests", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("getBodyTests failed");
        }
    }

    @Test
    public void getBodyExceptionTests() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        StringBuffer expSbuffer = new StringBuffer("This is it!");
        try {
            logger.log(System.Logger.Level.INFO, "Create TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "getBodyExceptionTests");
            logger.log(System.Logger.Level.INFO, "Send and receive the TextMessage");
            logger.log(System.Logger.Level.INFO, "Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receive(long) to receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            logger.log(System.Logger.Level.INFO, "Call TextMessage.getBody(Boolean.class) to extract TextMessage as Boolean (expect MessageFormatException)");
            try {
                Boolean myBool = (Boolean)actTextMessage.getBody(Boolean.class);
                logger.log(System.Logger.Level.ERROR, "Expected MessageFormatException to be thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.INFO, "Caught correct MessageFormatException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Create ObjectMessage of type StringBuffer");
            ObjectMessage expObjectMessage = this.context.createObjectMessage((Serializable)expSbuffer);
            logger.log(System.Logger.Level.INFO, "Set some values in ObjectMessage");
            expObjectMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "getBodyExceptionTests");
            logger.log(System.Logger.Level.INFO, "Send and receive the ObjectMessage");
            logger.log(System.Logger.Level.INFO, "Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expObjectMessage);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receive(long) to receive ObjectMessage");
            ObjectMessage actObjectMessage = (ObjectMessage)this.consumer.receive(this.timeout);
            if (actObjectMessage == null) {
                throw new Exception("Did not receive ObjectMessage");
            }
            logger.log(System.Logger.Level.INFO, "Call ObjectMessage.getBody(HashMap.class) to extract ObjectMessage as HashMap (expect MessageFormatException");
            try {
                HashMap hmap = (HashMap)actObjectMessage.getBody(HashMap.class);
                logger.log(System.Logger.Level.ERROR, "Expected MessageFormatException to be thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.INFO, "Caught correct MessageFormatException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Create StreamMessage");
            StreamMessage expStreamMsg = this.context.createStreamMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in StreamMessage");
            expStreamMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "getBodyExceptionTests");
            expStreamMsg.writeBoolean(true);
            expStreamMsg.writeInt(22);
            logger.log(System.Logger.Level.INFO, "Send and receive the StreamMessage");
            this.producer.send(this.destination, (Message)expStreamMsg);
            StreamMessage actStreamMsg = (StreamMessage)this.consumer.receive(this.timeout);
            if (actStreamMsg == null) {
                throw new Exception("Did not receive StreamMessage");
            }
            logger.log(System.Logger.Level.INFO, "Call StreamMessage.getBody(HashMap.class) to extract StreamMessage as HashMap (expect MessageFormatException");
            try {
                HashMap hmap = (HashMap)actStreamMsg.getBody(HashMap.class);
                logger.log(System.Logger.Level.ERROR, "Expected MessageFormatException to be thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.INFO, "Caught correct MessageFormatException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Create BytesMessage");
            BytesMessage bMsg = this.context.createBytesMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in BytesMessage");
            bMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "getBodyExceptionTests");
            bMsg.writeByte((byte)1);
            bMsg.writeInt(22);
            logger.log(System.Logger.Level.INFO, "BytesMessage is in write-only mode");
            logger.log(System.Logger.Level.INFO, "Call BytesMessage.getBody(StringBuffer.class) to receive BytesMessage as StringBuffer(expect MessageFormatException)");
            try {
                bMsg.getBody(StringBuffer.class);
                logger.log(System.Logger.Level.ERROR, "Expected MessageFormatException to be thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.INFO, "Caught correct MessageFormatException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send and receive the BytesMessage");
            this.producer.send(this.destination, (Message)bMsg);
            BytesMessage actBytesMsg = (BytesMessage)this.consumer.receive(this.timeout);
            try {
                actBytesMsg.getBody(StringBuffer.class);
                logger.log(System.Logger.Level.ERROR, "Expected MessageFormatException to be thrown");
                pass = false;
            }
            catch (MessageFormatException e) {
                logger.log(System.Logger.Level.INFO, "Caught correct MessageFormatException");
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            throw new Exception("getBodyExceptionTests", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("getBodyExceptionTests failed");
        }
    }

    @Test
    public void isBodyAssignableToTest() throws Exception {
        boolean pass = true;
        String message = "Where are you!";
        StringBuffer expSbuffer = new StringBuffer("This is it!");
        try {
            logger.log(System.Logger.Level.INFO, "Create TextMessage");
            TextMessage expTextMessage = this.context.createTextMessage(message);
            logger.log(System.Logger.Level.INFO, "Set some values in TextMessage");
            expTextMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "isBodyAssignableToTest");
            logger.log(System.Logger.Level.INFO, "Send and receive the TextMessage");
            logger.log(System.Logger.Level.INFO, "Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expTextMessage);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receive(long) to receive TextMessage");
            TextMessage actTextMessage = (TextMessage)this.consumer.receive(this.timeout);
            if (actTextMessage == null) {
                throw new Exception("Did not receive TextMessage");
            }
            try {
                logger.log(System.Logger.Level.INFO, "Call TextMessage.isBodyAssignableTo(Boolean.class) (expect false)");
                boolean b = actTextMessage.isBodyAssignableTo(Boolean.class);
                if (b) {
                    logger.log(System.Logger.Level.ERROR, "Expected false got true");
                    pass = false;
                }
                logger.log(System.Logger.Level.INFO, "Call TextMessage.isBodyAssignableTo(String.class) (expect true)");
                b = actTextMessage.isBodyAssignableTo(String.class);
                if (!b) {
                    logger.log(System.Logger.Level.ERROR, "Expected true got false");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Create ObjectMessage");
            ObjectMessage expObjectMessage = this.context.createObjectMessage((Serializable)expSbuffer);
            logger.log(System.Logger.Level.INFO, "Set some values in ObjectMessage");
            expObjectMessage.setStringProperty("COM_SUN_JMS_TESTNAME", "isBodyAssignableToTest");
            logger.log(System.Logger.Level.INFO, "Send and receive the ObjectMessage");
            logger.log(System.Logger.Level.INFO, "Call JMSProducer.send(Destination, Message)");
            this.producer.send(this.destination, (Message)expObjectMessage);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receive(long) to receive ObjectMessage");
            ObjectMessage actObjectMessage = (ObjectMessage)this.consumer.receive(this.timeout);
            if (actObjectMessage == null) {
                throw new Exception("Did not receive ObjectMessage");
            }
            try {
                logger.log(System.Logger.Level.INFO, "Call ObjectMessage.isBodyAssignableTo(Boolean.class) (expect false)");
                boolean b = actObjectMessage.isBodyAssignableTo(Boolean.class);
                if (b) {
                    logger.log(System.Logger.Level.ERROR, "Expected false got true");
                    pass = false;
                }
                logger.log(System.Logger.Level.INFO, "Call ObjectMessage.isBodyAssignableTo(StringBuffer.class) (expect true)");
                b = actObjectMessage.isBodyAssignableTo(StringBuffer.class);
                if (!b) {
                    logger.log(System.Logger.Level.ERROR, "Expected true got false");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Create BytesMessage");
            BytesMessage bMsg = this.context.createBytesMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in BytesMessage");
            bMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "getBodyTest");
            bMsg.writeByte((byte)1);
            bMsg.writeInt(22);
            logger.log(System.Logger.Level.INFO, "Send and receive the BytesMessage");
            this.producer.send(this.destination, (Message)bMsg);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receive(long) to receive BytesMessage");
            BytesMessage actBytesMessage = (BytesMessage)this.consumer.receive(this.timeout);
            if (actBytesMessage == null) {
                throw new Exception("Did not receive BytesMessage");
            }
            try {
                logger.log(System.Logger.Level.INFO, "Call BytesMessage.isBodyAssignableTo(String.class) (expect false)");
                boolean b = actBytesMessage.isBodyAssignableTo(String.class);
                if (b) {
                    logger.log(System.Logger.Level.ERROR, "Expected false got true");
                    pass = false;
                }
                logger.log(System.Logger.Level.INFO, "Call BytesMessage.isBodyAssignableTo(byte[].class) (expect true)");
                b = actBytesMessage.isBodyAssignableTo(byte[].class);
                if (!b) {
                    logger.log(System.Logger.Level.ERROR, "Expected true got false");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
            logger.log(System.Logger.Level.INFO, "Send MapMessage");
            MapMessage mMsg = this.context.createMapMessage();
            logger.log(System.Logger.Level.INFO, "Set some values in MapMessage");
            mMsg.setStringProperty("COM_SUN_JMS_TESTNAME", "getBodyTest");
            mMsg.setBoolean("booleanvalue", true);
            mMsg.setInt("intvalue", 10);
            this.producer.send(this.destination, (Message)mMsg);
            logger.log(System.Logger.Level.INFO, "Call JMSConsumer.receive(long) to receive MapMessage");
            MapMessage actMapMessage = (MapMessage)this.consumer.receive(this.timeout);
            if (actMapMessage == null) {
                throw new Exception("Did not receive MapMessage");
            }
            try {
                logger.log(System.Logger.Level.INFO, "Call MapMessage.isBodyAssignableTo(String.class) (expect false)");
                boolean b = actMapMessage.isBodyAssignableTo(String.class);
                if (b) {
                    logger.log(System.Logger.Level.ERROR, "Expected false got true");
                    pass = false;
                }
                logger.log(System.Logger.Level.INFO, "Call MapMessage.isBodyAssignableTo(Map.class) (expect true)");
                b = actMapMessage.isBodyAssignableTo(Map.class);
                if (!b) {
                    logger.log(System.Logger.Level.ERROR, "Expected true got false");
                    pass = false;
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
                pass = false;
            }
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Caught unexpected exception: " + e);
            throw new Exception("isBodyAssignableToTest", e);
        }
        finally {
            try {
                if (this.consumer != null) {
                    this.consumer.close();
                }
            }
            catch (Exception exception) {}
        }
        if (!pass) {
            throw new Exception("isBodyAssignableToTest failed");
        }
    }
}

