/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_rec;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jms.ee.mdb.mdb_rec.MDB_AR_Test;
import jakarta.ejb.EJB;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MDBClientIT {
    @EJB(name="ejb/MDB_AR_Test")
    private static MDB_AR_Test hr;
    private Properties props = new Properties();
    private static final System.Logger logger;

    @BeforeEach
    public void setup() throws Exception {
        try {
            if (hr == null) {
                throw new Exception("@EJB injection failed");
            }
            this.props.put("jms_timeout", System.getProperty("jms_property"));
            this.props.put("user", System.getProperty("user"));
            this.props.put("password", System.getProperty("password"));
            hr.setup(this.props);
            if (hr.isThereSomethingInTheQueue()) {
                logger.log(System.Logger.Level.TRACE, "Error: message(s) left in Q");
                hr.cleanTheQueue();
            } else {
                logger.log(System.Logger.Level.TRACE, "Nothing left in queue");
            }
            logger.log(System.Logger.Level.INFO, "Setup ok;");
        }
        catch (Exception e) {
            throw new Exception("Setup Failed!", e);
        }
    }

    @Test
    public void asynRecTextMsgQueueTest() throws Exception {
        try {
            logger.log(System.Logger.Level.INFO, "Call bean - have it send mdb a message;");
            String matchMe = "mdb_asynchRecFromQueue_Text_Msg_Test";
            hr.sendTextMessageToQ(matchMe);
            if (!hr.checkOnResponse(matchMe)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: test1 failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void asynRecMapMsgQueueTest() throws Exception {
        try {
            logger.log(System.Logger.Level.INFO, "Call bean  - have it send mdb a message;");
            String matchMe = "mdb_asynchRecFromQueue_MapMessage_Test";
            logger.log(System.Logger.Level.TRACE, "Have bean send mdb a map message;");
            hr.sendMapMessageToQ(matchMe);
            if (!hr.checkOnResponse(matchMe)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: test3 failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void asynRecObjectMsgQueueTest() throws Exception {
        try {
            logger.log(System.Logger.Level.INFO, "Call bean - have it send mdb a message;");
            String matchMe = "mdb_asynchRecFromQueue_ObjectMessage_Test";
            logger.log(System.Logger.Level.TRACE, "Have bean send mdb a object message;");
            hr.sendObjectMessageToQ(matchMe);
            if (!hr.checkOnResponse(matchMe)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: test5 failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void asynRecTextMsgTopicTest() throws Exception {
        String matchMe = "mdb_asynchRecFromTopic_Text_Msg_Test";
        try {
            logger.log(System.Logger.Level.INFO, "Call bean  - have it send mdb a message;");
            hr.sendTextMessageToTopic(matchMe);
            if (!hr.checkOnResponse(matchMe)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: test6 failed");
            }
            logger.log(System.Logger.Level.INFO, "Test passed;");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void asynRecBytesMsgQueueTest() throws Exception {
        try {
            logger.log(System.Logger.Level.INFO, "Call bean  - have it send mdb a message;");
            String matchMe = "mdb_asynchRecFromQueue_BytesMessage_Test";
            logger.log(System.Logger.Level.TRACE, "Have bean send mdb a bytes message;");
            hr.sendBytesMessageToQ(matchMe);
            if (!hr.checkOnResponse(matchMe)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: test2 failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void asynRecStreamMsgQueueTest() throws Exception {
        try {
            logger.log(System.Logger.Level.INFO, "Call bean - have it send mdb a message;");
            String matchMe = "mdb_asynchRecFromQueue_StreamMessage_Test";
            logger.log(System.Logger.Level.TRACE, "Have bean send mdb a stream message;");
            hr.sendStreamMessageToQ(matchMe);
            if (!hr.checkOnResponse(matchMe)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: test4 failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void asynRecMapMsgTopicTest() throws Exception {
        String matchMe = "mdb_asynchRecFromTopic_Map_Msg_Test";
        try {
            logger.log(System.Logger.Level.INFO, "Call bean - have it send mdb a message;");
            hr.sendMapMessageToTopic(matchMe);
            if (!hr.checkOnResponse(matchMe)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: asynRecMapMsgTopicTest failed");
            }
            logger.log(System.Logger.Level.INFO, "Test passed;");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void asynRecObjectMsgTopicTest() throws Exception {
        String matchMe = "mdb_asynchRecFromTopic_Object_Msg_Test";
        try {
            logger.log(System.Logger.Level.INFO, "Call bean - have it send mdb a message;");
            hr.sendObjectMessageToTopic(matchMe);
            if (!hr.checkOnResponse(matchMe)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: asynRecObjectMsgTopicTest failed");
            }
            logger.log(System.Logger.Level.INFO, "Test passed;");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void asynRecBytesMsgTopicTest() throws Exception {
        String matchMe = "mdb_asynchRecFromTopic_Bytes_Msg_Test";
        try {
            logger.log(System.Logger.Level.INFO, "Call bean - have it send mdb a message;");
            hr.sendBytesMessageToTopic(matchMe);
            if (!hr.checkOnResponse(matchMe)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: asynRecBytesMsgTopicTest failed");
            }
            logger.log(System.Logger.Level.INFO, "Test passed;");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void asynRecStreamMsgTopicTest() throws Exception {
        String matchMe = "mdb_asynchRecFromTopic_Stream_Msg_Test";
        try {
            logger.log(System.Logger.Level.INFO, "Call bean - have it send mdb a message;");
            hr.sendStreamMessageToTopic(matchMe);
            if (!hr.checkOnResponse(matchMe)) {
                logger.log(System.Logger.Level.TRACE, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: asynRecStreamMsgTopicTest failed");
            }
            logger.log(System.Logger.Level.INFO, "Test passed;");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        try {
            if (hr.isThereSomethingInTheQueue()) {
                logger.log(System.Logger.Level.TRACE, "Error: message(s) left in Q");
                hr.cleanTheQueue();
            } else {
                logger.log(System.Logger.Level.TRACE, "Nothing left in queue");
            }
            logger.log(System.Logger.Level.INFO, "End  of client cleanup;");
        }
        catch (Exception e) {
            logger.log(System.Logger.Level.ERROR, "Unexpected Exception cleaning up the Queue", (Throwable)e);
        }
        finally {
            logger.log(System.Logger.Level.TRACE, "Closing all connections");
            try {
                hr.cleanup();
            }
            catch (Exception oh) {
                logger.log(System.Logger.Level.ERROR, "Fail: unexpected exception closing Connections", (Throwable)oh);
                TestUtil.printStackTrace((Throwable)oh);
                throw new Exception("Fail");
            }
            logger.log(System.Logger.Level.TRACE, "Removing EJBs");
            try {
                hr.remove();
            }
            catch (Exception oh) {
                logger.log(System.Logger.Level.ERROR, "Fail: unexpected exception removing EJB", (Throwable)oh);
                TestUtil.printStackTrace((Throwable)oh);
                throw new Exception("Fail");
            }
        }
    }

    static {
        logger = System.getLogger(MDBClientIT.class.getName());
    }
}

