/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jms.ee.mdb.mdb_sndQ;

import com.sun.ts.tests.jms.ee.mdb.mdb_sndQ.MDB_SNDQ_Test;
import jakarta.ejb.EJB;
import java.util.Properties;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class MDBClientIT {
    @EJB(name="ejb/MDB_SNDQ_Test")
    private static MDB_SNDQ_Test hr = null;
    private Properties props = new Properties();
    private static final System.Logger logger = System.getLogger(MDBClientIT.class.getName());

    @BeforeEach
    public void setup() throws Exception {
        try {
            if (hr == null) {
                throw new Exception("@EJB injection failed");
            }
            if (hr.isThereSomethingInTheQueue()) {
                logger.log(System.Logger.Level.TRACE, "Error: message(s) left in Q");
                hr.cleanTheQueue();
            } else {
                logger.log(System.Logger.Level.TRACE, "Nothing left in queue");
            }
            logger.log(System.Logger.Level.INFO, "Setup ok;");
        }
        catch (Exception e) {
            throw new Exception("Setup Failed!", e);
        }
    }

    @Test
    public void mdbSendTextMsgTest() throws Exception {
        String messageType = "TextMessage";
        String matchMe = "TextMessageFromMsgBean";
        try {
            logger.log(System.Logger.Level.TRACE, "Call bean - have it tell mdb to send a text message;");
            hr.askMDBToSendAMessage(messageType);
            if (!hr.checkOnResponse(matchMe)) {
                logger.log(System.Logger.Level.ERROR, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mdbSendTextMsgTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbSendBytesMsgTest() throws Exception {
        String messageType = "BytesMessage";
        String matchMe = "BytesMessageFromMsgBean";
        try {
            logger.log(System.Logger.Level.TRACE, "Call bean - have it tell mdb to send a Bytes message;");
            hr.askMDBToSendAMessage(messageType);
            if (!hr.checkOnResponse(matchMe)) {
                logger.log(System.Logger.Level.ERROR, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mdbSendBytesMsgTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbSendMapMsgTest() throws Exception {
        String matchMe = "MapMessageFromMsgBean";
        String messageType = "MapMessage";
        try {
            logger.log(System.Logger.Level.TRACE, "Call bean - have it tell mdb to send a map message;");
            hr.askMDBToSendAMessage(messageType);
            if (!hr.checkOnResponse(matchMe)) {
                logger.log(System.Logger.Level.ERROR, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mdbSendMapMsgTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbSendStreamMsgTest() throws Exception {
        String matchMe = "StreamMessageFromMsgBean";
        String messageType = "StreamMessage";
        try {
            logger.log(System.Logger.Level.TRACE, "Call bean - have it tell mdb to send a stream message;");
            hr.askMDBToSendAMessage(messageType);
            if (!hr.checkOnResponse(matchMe)) {
                logger.log(System.Logger.Level.ERROR, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mdbSendStreamMsgTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @Test
    public void mdbSendObjectMsgTest() throws Exception {
        String matchMe = "ObjectMessageFromMsgBean";
        String messageType = "ObjectMessage";
        try {
            logger.log(System.Logger.Level.TRACE, "Call bean - have it tell mdb to send an object message;");
            hr.askMDBToSendAMessage(messageType);
            if (!hr.checkOnResponse(matchMe)) {
                logger.log(System.Logger.Level.ERROR, "Error: didn't get expected response from mdb");
                throw new Exception("ERROR: mdbSendObjectMsgTest failed");
            }
            logger.log(System.Logger.Level.TRACE, "Test passed!");
        }
        catch (Exception e) {
            throw new Exception("Test Failed!", e);
        }
    }

    @AfterEach
    public void cleanup() throws Exception {
        if (hr != null) {
            try {
                if (hr.isThereSomethingInTheQueue()) {
                    logger.log(System.Logger.Level.TRACE, "Error: message(s) left in Q");
                    hr.cleanTheQueue();
                } else {
                    logger.log(System.Logger.Level.TRACE, "Nothing left in queue");
                }
            }
            catch (Exception e) {
                logger.log(System.Logger.Level.ERROR, "Error cleaning up messages", (Throwable)e);
            }
            finally {
                try {
                    hr.remove();
                }
                catch (Exception er) {
                    logger.log(System.Logger.Level.ERROR, "Error removing bean", (Throwable)er);
                }
            }
        }
        logger.log(System.Logger.Level.INFO, "End  of client cleanup;");
    }
}

