/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.SSLParameters;
import jdk.incubator.http.Exchange;
import jdk.incubator.http.ExchangeImpl;
import jdk.incubator.http.Http1Exchange;
import jdk.incubator.http.HttpClient;
import jdk.incubator.http.HttpConnection;
import jdk.incubator.http.HttpHeaders;
import jdk.incubator.http.HttpRequest;
import jdk.incubator.http.HttpRequestImpl;
import jdk.incubator.http.HttpResponse;
import jdk.incubator.http.ImmutableHeaders;
import jdk.incubator.http.RawChannelImpl;
import jdk.incubator.http.Response;
import jdk.incubator.http.Stream;
import jdk.incubator.http.internal.common.Log;
import jdk.incubator.http.internal.websocket.RawChannel;

class HttpResponseImpl<T>
extends HttpResponse<T>
implements RawChannel.Provider {
    final int responseCode;
    final Exchange<T> exchange;
    final HttpRequest initialRequest;
    final HttpRequestImpl finalRequest;
    final HttpHeaders headers;
    final SSLParameters sslParameters;
    final URI uri;
    final HttpClient.Version version;
    RawChannel rawchan;
    final HttpConnection connection;
    final Stream<T> stream;
    final T body;

    public HttpResponseImpl(HttpRequest httpRequest, Response response, T t, Exchange<T> exchange) {
        this.responseCode = response.statusCode();
        this.exchange = exchange;
        this.initialRequest = httpRequest;
        this.finalRequest = this.exchange.request();
        this.headers = response.headers();
        this.sslParameters = exchange.client().sslParameters().orElse(null);
        this.uri = this.finalRequest.uri();
        this.version = response.version();
        this.connection = exchange.exchImpl.connection();
        this.stream = null;
        this.body = t;
    }

    public HttpResponseImpl(Response response, HttpRequestImpl httpRequestImpl, ImmutableHeaders immutableHeaders, Stream<T> stream, SSLParameters sSLParameters, T t) {
        this.responseCode = response.statusCode();
        this.exchange = null;
        this.initialRequest = null;
        this.finalRequest = httpRequestImpl;
        this.headers = immutableHeaders;
        this.sslParameters = sSLParameters;
        this.uri = this.finalRequest.uri();
        this.version = HttpClient.Version.HTTP_2;
        this.connection = stream.connection();
        this.stream = stream;
        this.body = t;
    }

    private ExchangeImpl<?> exchangeImpl() {
        return this.exchange != null ? this.exchange.exchImpl : this.stream;
    }

    @Override
    public int statusCode() {
        return this.responseCode;
    }

    @Override
    public HttpRequest request() {
        return this.initialRequest;
    }

    @Override
    public HttpRequest finalRequest() {
        return this.finalRequest;
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public T body() {
        return this.body;
    }

    @Override
    public SSLParameters sslParameters() {
        return this.sslParameters;
    }

    @Override
    public URI uri() {
        return this.uri;
    }

    @Override
    public HttpClient.Version version() {
        return this.version;
    }

    @Override
    public synchronized RawChannel rawChannel() throws IOException {
        if (this.rawchan == null) {
            ExchangeImpl<?> exchangeImpl = this.exchangeImpl();
            if (!(exchangeImpl instanceof Http1Exchange)) {
                throw new UnsupportedOperationException("RawChannel is not supported over HTTP/2");
            }
            ByteBuffer byteBuffer = ((Http1Exchange)exchangeImpl).getBuffer();
            this.rawchan = new RawChannelImpl(this.exchange.client(), this.connection, byteBuffer);
        }
        return this.rawchan;
    }

    @Override
    public CompletableFuture<HttpHeaders> trailers() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    static void logResponse(Response response) {
        if (!Log.requests()) {
            return;
        }
        StringBuilder stringBuilder = new StringBuilder();
        String string = response.request().method();
        URI uRI = response.request().uri();
        String string2 = uRI == null ? "" : uRI.toString();
        stringBuilder.append('(').append(string).append(" ").append(string2).append(") ").append(response.statusCode());
        Log.logResponse(stringBuilder.toString(), new Object[0]);
    }
}

