/*
 * Decompiled with CFR 0.152.
 */
package jdk.incubator.http;

import java.io.IOException;
import java.io.InputStream;
import java.net.ProtocolException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;
import jdk.incubator.http.HttpConnection;
import jdk.incubator.http.HttpHeaders;
import jdk.incubator.http.ImmutableHeaders;
import jdk.incubator.http.internal.common.Utils;
import sun.net.www.MessageHeader;

final class ResponseHeaders
implements HttpHeaders {
    private static final char CR = '\r';
    private static final char LF = '\n';
    private final ImmutableHeaders delegate;

    ResponseHeaders(HttpConnection httpConnection, ByteBuffer byteBuffer) throws IOException {
        Objects.requireNonNull(httpConnection);
        Objects.requireNonNull(byteBuffer);
        InputStreamWrapper inputStreamWrapper = new InputStreamWrapper(httpConnection, byteBuffer);
        this.delegate = ImmutableHeaders.of(this.parse(inputStreamWrapper));
    }

    private static void display(Map<String, List<String>> map) {
        map.forEach((string, list) -> {
            System.out.print(string + ": ");
            for (String string2 : list) {
                System.out.print(string2 + ", ");
            }
            System.out.println("");
        });
    }

    private Map<String, List<String>> parse(InputStreamWrapper inputStreamWrapper) throws IOException {
        MessageHeader messageHeader = new MessageHeader();
        messageHeader.parseHeader(inputStreamWrapper);
        if (inputStreamWrapper.consumed == 1 && '\r' == (char)inputStreamWrapper.lastRead && inputStreamWrapper.read() != 10) {
            throw new IOException("Unexpected byte sequence when no headers: 13 " + inputStreamWrapper.lastRead + "(" + 13 + " " + 10 + " expected)");
        }
        Map<String, List<String>> map = messageHeader.getHeaders();
        HashMap<String, List<String>> hashMap = new HashMap<String, List<String>>();
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            String string = entry.getKey();
            if (string == null) {
                throw new ProtocolException("Bad header-field");
            }
            if (!Utils.isValidName(string)) {
                throw new ProtocolException(String.format("Bad header-name: '%s'", string));
            }
            List<String> list3 = entry.getValue();
            for (String string2 : list3) {
                if (Utils.isValidValue(string2)) continue;
                throw new ProtocolException(String.format("Bad header-value for header-name: '%s'", string));
            }
            String string3 = string.toLowerCase(Locale.US);
            hashMap.merge(string3, list3, (list, list2) -> {
                ArrayList arrayList = new ArrayList();
                if (list != null) {
                    arrayList.addAll(list);
                }
                arrayList.addAll(list2);
                return arrayList;
            });
        }
        return hashMap;
    }

    int getContentLength() throws IOException {
        return (int)this.firstValueAsLong("Content-Length").orElse(-1L);
    }

    @Override
    public Optional<String> firstValue(String string) {
        return this.delegate.firstValue(string);
    }

    @Override
    public OptionalLong firstValueAsLong(String string) {
        return this.delegate.firstValueAsLong(string);
    }

    @Override
    public List<String> allValues(String string) {
        return this.delegate.allValues(string);
    }

    @Override
    public Map<String, List<String>> map() {
        return this.delegate.map();
    }

    static final class InputStreamWrapper
    extends InputStream {
        final HttpConnection connection;
        ByteBuffer buffer;
        int lastRead = -1;
        int consumed = 0;

        InputStreamWrapper(HttpConnection httpConnection, ByteBuffer byteBuffer) {
            this.connection = httpConnection;
            this.buffer = byteBuffer;
        }

        @Override
        public int read() throws IOException {
            if (!this.buffer.hasRemaining()) {
                this.buffer = this.connection.read();
                if (this.buffer == null) {
                    this.lastRead = -1;
                    return -1;
                }
            }
            if (this.consumed >= 0) {
                ++this.consumed;
            }
            byte by = this.buffer.get();
            this.lastRead = by;
            return by;
        }
    }
}

