/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;

public interface HttpContent {
    public Buffer getContentType();

    public Buffer getLastModified();

    public Buffer getIndirectBuffer();

    public Buffer getDirectBuffer();

    public Buffer getETag();

    public Resource getResource();

    public long getContentLength();

    public InputStream getInputStream() throws IOException;

    public void release();

    public static class ResourceAsHttpContent
    implements HttpContent {
        private static final Logger LOG = Log.getLogger(ResourceAsHttpContent.class);
        final Resource _resource;
        final Buffer _mimeType;
        final int _maxBuffer;
        final Buffer _etag;

        public ResourceAsHttpContent(Resource resource, Buffer mimeType) {
            this(resource, mimeType, -1, false);
        }

        public ResourceAsHttpContent(Resource resource, Buffer mimeType, int maxBuffer) {
            this(resource, mimeType, maxBuffer, false);
        }

        public ResourceAsHttpContent(Resource resource, Buffer mimeType, boolean etag) {
            this(resource, mimeType, -1, etag);
        }

        public ResourceAsHttpContent(Resource resource, Buffer mimeType, int maxBuffer, boolean etag) {
            this._resource = resource;
            this._mimeType = mimeType;
            this._maxBuffer = maxBuffer;
            this._etag = etag ? new ByteArrayBuffer(resource.getWeakETag()) : null;
        }

        @Override
        public Buffer getContentType() {
            return this._mimeType;
        }

        @Override
        public Buffer getLastModified() {
            return null;
        }

        @Override
        public Buffer getDirectBuffer() {
            return null;
        }

        @Override
        public Buffer getETag() {
            return this._etag;
        }

        @Override
        public Buffer getIndirectBuffer() {
            InputStream inputStream = null;
            try {
                if (this._resource.length() <= 0L || (long)this._maxBuffer < this._resource.length()) {
                    Buffer buffer = null;
                    return buffer;
                }
                ByteArrayBuffer buffer = new ByteArrayBuffer((int)this._resource.length());
                inputStream = this._resource.getInputStream();
                buffer.readFrom(inputStream, (int)this._resource.length());
                ByteArrayBuffer byteArrayBuffer = buffer;
                return byteArrayBuffer;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException e) {
                        LOG.warn("Couldn't close inputStream. Possible file handle leak", (Throwable)e);
                    }
                }
            }
        }

        @Override
        public long getContentLength() {
            return this._resource.length();
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return this._resource.getInputStream();
        }

        @Override
        public Resource getResource() {
            return this._resource;
        }

        @Override
        public void release() {
            this._resource.release();
        }
    }
}

