/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.text.ui.hover.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Control;
import javafx.scene.layout.VBox;
import javafx.stage.PopupWindow;
import org.eclipse.fx.text.hover.DefaultHoverInfoType;
import org.eclipse.fx.text.hover.HoverInfo;
import org.eclipse.fx.text.ui.hover.HoverPresenter;
import org.eclipse.fx.text.ui.hover.HoverWindowPresenter;

public class DefaultHoverWindowPresenter
implements HoverWindowPresenter {
    private List<HoverPresenter> presenters = new ArrayList<HoverPresenter>();
    private final Control parent;
    private final PopupWindow popup;
    private final VBox root;
    private List<HoverInfo> currentVisible;

    public DefaultHoverWindowPresenter(Control parent) {
        this.parent = parent;
        this.popup = new PopupWindow(){};
        this.popup.setAutoFix(false);
        this.popup.setAutoHide(false);
        parent.sceneProperty().addListener(e -> {
            if (parent.getScene() != null) {
                this.popup.getScene().getStylesheets().setAll((Collection)parent.getScene().getStylesheets());
            } else {
                this.popup.getScene().getStylesheets().clear();
            }
        });
        this.root = new VBox();
        this.root.setSpacing(3.0);
        this.root.getStyleClass().add((Object)"styled-text-hover");
        this.popup.getScene().setRoot((Parent)this.root);
    }

    private Optional<HoverPresenter> findPresenter(HoverInfo hover) {
        return this.presenters.stream().filter(p -> p.isApplicable(hover.getClass())).sorted((a, b) -> a.getOrder() - b.getOrder()).findFirst();
    }

    private int compare(HoverInfo a, HoverInfo b) {
        return a.getHoverText().compareTo(b.getHoverText());
    }

    private void populate(List<HoverInfo> hovers) {
        if (this.currentVisible != null && this.currentVisible.equals(hovers)) {
            return;
        }
        this.root.getChildren().clear();
        List errors = hovers.stream().filter(h -> h.getType() == DefaultHoverInfoType.ERROR).sorted(this::compare).collect(Collectors.toList());
        List warnings = hovers.stream().filter(h -> h.getType() == DefaultHoverInfoType.WARNING).sorted(this::compare).collect(Collectors.toList());
        List infos = hovers.stream().filter(h -> h.getType() == DefaultHoverInfoType.INFO).sorted(this::compare).collect(Collectors.toList());
        List docs = hovers.stream().filter(h -> h.getType() == DefaultHoverInfoType.DOCUMENTATION).sorted(this::compare).collect(Collectors.toList());
        List others = hovers.stream().filter(h -> !errors.contains(h) && !warnings.contains(h) && !infos.contains(h) && !docs.contains(h)).sorted(this::compare).collect(Collectors.toList());
        if (!errors.isEmpty()) {
            VBox errorNode = new VBox();
            errorNode.getStyleClass().add((Object)"errors");
            errorNode.getChildren().addAll((Collection)errors.stream().map(e -> this.findPresenter((HoverInfo)e).map(p -> p.createHoverContent((HoverInfo)e))).filter(x -> x.isPresent()).map(x -> (Node)x.get()).collect(Collectors.toList()));
            this.root.getChildren().add((Object)errorNode);
        }
        if (!warnings.isEmpty()) {
            VBox warnNode = new VBox();
            warnNode.getStyleClass().add((Object)"warnings");
            warnNode.getChildren().addAll((Collection)warnings.stream().map(e -> this.findPresenter((HoverInfo)e).map(p -> p.createHoverContent((HoverInfo)e))).filter(x -> x.isPresent()).map(x -> (Node)x.get()).collect(Collectors.toList()));
            this.root.getChildren().add((Object)warnNode);
        }
        if (!infos.isEmpty()) {
            VBox infoNode = new VBox();
            infoNode.getStyleClass().add((Object)"infos");
            infoNode.getChildren().addAll((Collection)infos.stream().map(e -> this.findPresenter((HoverInfo)e).map(p -> p.createHoverContent((HoverInfo)e))).filter(x -> x.isPresent()).map(x -> (Node)x.get()).collect(Collectors.toList()));
            this.root.getChildren().add((Object)infoNode);
        }
        if (!docs.isEmpty()) {
            VBox docsNode = new VBox();
            docsNode.getStyleClass().add((Object)"docs");
            docsNode.getChildren().addAll((Collection)docs.stream().map(e -> this.findPresenter((HoverInfo)e).map(p -> p.createHoverContent((HoverInfo)e))).filter(x -> x.isPresent()).map(x -> (Node)x.get()).collect(Collectors.toList()));
            this.root.getChildren().add((Object)docsNode);
        }
        if (!others.isEmpty()) {
            VBox othersNode = new VBox();
            othersNode.getStyleClass().add((Object)"others");
            othersNode.getChildren().addAll((Collection)others.stream().map(e -> this.findPresenter((HoverInfo)e).map(p -> p.createHoverContent((HoverInfo)e))).filter(x -> x.isPresent()).map(x -> (Node)x.get()).collect(Collectors.toList()));
            this.root.getChildren().add((Object)othersNode);
        }
        this.currentVisible = hovers;
    }

    @Override
    public void show(Point2D screenAnchor, Bounds screenBounds, List<HoverInfo> hover) {
        this.populate(hover);
        this.popup.show(this.parent.getScene().getWindow(), screenAnchor.getX(), screenAnchor.getY());
    }

    @Override
    public void hide() {
        this.popup.hide();
    }

    public void setHoverPresenter(List<HoverPresenter> hoverPresenters) {
        this.presenters = hoverPresenters;
    }
}

