/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.bindings.internal;

import java.lang.ref.WeakReference;
import java.util.Objects;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.Binding;
import org.eclipse.fx.core.ThreadSynchronize;

public class SyncedBindingHelperObserver
implements InvalidationListener {
    private final ThreadSynchronize thread;
    private final WeakReference<Binding<?>> ref;

    public SyncedBindingHelperObserver(ThreadSynchronize thread, Binding<?> binding) {
        Objects.requireNonNull(binding);
        this.ref = new WeakReference(binding);
        this.thread = thread;
    }

    public void invalidated(Observable observable) {
        this.thread.asyncExec(() -> this.syncedInvalidated(observable));
    }

    private void syncedInvalidated(Observable observable) {
        Binding binding = (Binding)this.ref.get();
        if (binding == null) {
            observable.removeListener((InvalidationListener)this);
        } else {
            binding.invalidate();
        }
    }
}

