/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.extensionlocation;

import java.io.File;
import java.io.OutputStream;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.extensionlocation.Activator;
import org.eclipse.equinox.internal.p2.extensionlocation.Constants;
import org.eclipse.equinox.internal.p2.extensionlocation.ExtensionLocationArtifactRepositoryFactory;
import org.eclipse.equinox.internal.p2.extensionlocation.Messages;
import org.eclipse.equinox.internal.p2.extensionlocation.SiteListener;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.metadata.Version;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.repository.IRunnableWithProgress;
import org.eclipse.equinox.p2.repository.artifact.IArtifactDescriptor;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRequest;
import org.eclipse.equinox.p2.repository.artifact.IFileArtifactRepository;
import org.eclipse.equinox.p2.repository.spi.AbstractRepository;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleContext;

public class ExtensionLocationArtifactRepository
extends AbstractRepository<IArtifactKey>
implements IFileArtifactRepository,
Constants {
    public static final String TYPE = "org.eclipse.equinox.p2.extensionlocation.artifactRepository";
    public static final Integer VERSION = 1;
    public static final List<String> STANDARD_P2_REPOSITORY_FILE_NAMES = Arrays.asList("artifacts.xml", "content.xml", "compositeArtifacts.xml", "compositeContent.xml");
    IFileArtifactRepository artifactRepository;
    private File base;
    private Object state = SiteListener.UNINITIALIZED;

    public static URI getLocalRepositoryLocation(URI location) {
        BundleContext context = Activator.getContext();
        String stateDirName = Integer.toString(location.toString().hashCode());
        File bundleData = context.getDataFile(null);
        File stateDir = new File(bundleData, stateDirName);
        return stateDir.toURI();
    }

    public ExtensionLocationArtifactRepository(IProvisioningAgent agent, URI location, IFileArtifactRepository repository, IProgressMonitor monitor) throws ProvisionException {
        super(agent, Activator.getRepositoryName(location), TYPE, VERSION.toString(), location, null, null, null);
        this.artifactRepository = repository;
        this.base = ExtensionLocationArtifactRepository.getBaseDirectory(location);
    }

    public synchronized void ensureInitialized() {
        if (this.state == SiteListener.INITIALIZED || this.state == SiteListener.INITIALIZING) {
            return;
        }
        SiteListener.synchronizeRepositories(null, this, this.base);
    }

    void reload() {
        try {
            ExtensionLocationArtifactRepositoryFactory factory = new ExtensionLocationArtifactRepositoryFactory();
            factory.setAgent(this.getProvisioningAgent());
            ExtensionLocationArtifactRepository repo = (ExtensionLocationArtifactRepository)factory.load(this.getLocation(), 0, null);
            this.artifactRepository = repo.artifactRepository;
            this.base = repo.base;
        }
        catch (ProvisionException e) {
            e.printStackTrace();
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    void state(Object value) {
        this.state = value;
    }

    public static void validate(URI location, IProgressMonitor monitor) throws ProvisionException {
        File base = ExtensionLocationArtifactRepository.getBaseDirectory(location);
        if (new File(base, ".eclipseextension").exists() || location.getPath().endsWith(".eclipseextension")) {
            return;
        }
        if (ExtensionLocationArtifactRepository.containsUpdateSiteFile(base)) {
            String message = NLS.bind((String)Messages.error_update_site, (Object)location.toString());
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1000, message, null));
        }
        if (ExtensionLocationArtifactRepository.containsStandardP2Repository(base)) {
            String message = NLS.bind((String)Messages.error_p2_repository, (Object)location.toString());
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1000, message, null));
        }
    }

    private static boolean containsStandardP2Repository(File base) {
        File[] foundRepos = base.listFiles((dir, name) -> STANDARD_P2_REPOSITORY_FILE_NAMES.contains(name));
        return foundRepos.length > 0;
    }

    private static boolean containsUpdateSiteFile(File base) {
        String[] fileNames = base.list();
        if (fileNames == null) {
            return false;
        }
        int i = 0;
        while (i < fileNames.length) {
            if (fileNames[i].endsWith(".xml") && fileNames[i].indexOf("site") != -1) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static File getBaseDirectory(URI uri) throws ProvisionException {
        File base;
        if (!"file".equals(uri.getScheme())) {
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1000, Messages.not_file_protocol, null));
        }
        String path = URIUtil.toFile((URI)uri).getAbsolutePath();
        if (path.endsWith(".eclipseextension")) {
            path = path.substring(0, path.length() - ".eclipseextension".length());
        }
        if (!(base = new File(path)).isDirectory()) {
            throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1000, NLS.bind((String)Messages.not_directory, (Object)uri.toString()), null));
        }
        if (ExtensionLocationArtifactRepository.isBaseDirectory(base)) {
            return base;
        }
        File eclipseBase = new File(base, "eclipse");
        if (ExtensionLocationArtifactRepository.isBaseDirectory(eclipseBase)) {
            return eclipseBase;
        }
        throw new ProvisionException((IStatus)new Status(4, "org.eclipse.equinox.p2.extensionlocation", 1000, NLS.bind((String)Messages.not_eclipse_extension, (Object)uri.toString()), null));
    }

    private static boolean isBaseDirectory(File base) {
        File plugins = new File(base, "plugins");
        File features = new File(base, "features");
        return plugins.isDirectory() || features.isDirectory();
    }

    public void addDescriptor(IArtifactDescriptor descriptor, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void addDescriptor(IArtifactDescriptor descriptor) {
        throw new UnsupportedOperationException();
    }

    public void addDescriptors(IArtifactDescriptor[] descriptors, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void addDescriptors(IArtifactDescriptor[] descriptors) {
        throw new UnsupportedOperationException();
    }

    public void removeAll(IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void removeAll() {
        throw new UnsupportedOperationException();
    }

    public void removeDescriptor(IArtifactDescriptor descriptor, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void removeDescriptor(IArtifactDescriptor descriptor) {
        throw new UnsupportedOperationException();
    }

    public void removeDescriptor(IArtifactKey key, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void removeDescriptor(IArtifactKey key) {
        throw new UnsupportedOperationException();
    }

    public void removeDescriptors(IArtifactDescriptor[] descriptors, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void removeDescriptors(IArtifactDescriptor[] descriptors) {
        throw new UnsupportedOperationException();
    }

    public void removeDescriptors(IArtifactKey[] keys, IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void removeDescriptors(IArtifactKey[] keys) {
        throw new UnsupportedOperationException();
    }

    public boolean contains(IArtifactDescriptor descriptor) {
        this.ensureInitialized();
        return this.artifactRepository.contains(descriptor);
    }

    public boolean contains(IArtifactKey key) {
        this.ensureInitialized();
        return this.artifactRepository.contains(key);
    }

    public IStatus getArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        this.ensureInitialized();
        return this.artifactRepository.getArtifact(descriptor, destination, monitor);
    }

    public IStatus getRawArtifact(IArtifactDescriptor descriptor, OutputStream destination, IProgressMonitor monitor) {
        this.ensureInitialized();
        return this.artifactRepository.getRawArtifact(descriptor, destination, monitor);
    }

    public IArtifactDescriptor[] getArtifactDescriptors(IArtifactKey key) {
        this.ensureInitialized();
        return this.artifactRepository.getArtifactDescriptors(key);
    }

    public IStatus getArtifacts(IArtifactRequest[] requests, IProgressMonitor monitor) {
        this.ensureInitialized();
        return this.artifactRepository.getArtifacts(requests, monitor);
    }

    public OutputStream getOutputStream(IArtifactDescriptor descriptor) throws ProvisionException {
        this.ensureInitialized();
        return this.artifactRepository.getOutputStream(descriptor);
    }

    public File getArtifactFile(IArtifactKey key) {
        this.ensureInitialized();
        return this.artifactRepository.getArtifactFile(key);
    }

    public File getArtifactFile(IArtifactDescriptor descriptor) {
        this.ensureInitialized();
        return this.artifactRepository.getArtifactFile(descriptor);
    }

    public Map<String, String> getProperties() {
        this.ensureInitialized();
        return this.artifactRepository.getProperties();
    }

    public String setProperty(String key, String value, IProgressMonitor monitor) {
        try {
            this.ensureInitialized();
            String oldValue = this.artifactRepository.setProperty(key, value);
            if (oldValue == value || oldValue != null && oldValue.equals(value)) {
                String string = oldValue;
                return string;
            }
            if (!"org.eclipse.update.site.list".equals(key) && !"org.eclipse.update.site.policy".equals(key)) {
                String string = oldValue;
                return string;
            }
            this.state = SiteListener.UNINITIALIZED;
            this.ensureInitialized();
            String string = oldValue;
            return string;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    public IArtifactDescriptor createArtifactDescriptor(IArtifactKey key) {
        return this.artifactRepository.createArtifactDescriptor(key);
    }

    public IArtifactKey createArtifactKey(String classifier, String id, Version version) {
        return this.artifactRepository.createArtifactKey(classifier, id, version);
    }

    public IQueryable<IArtifactDescriptor> descriptorQueryable() {
        this.ensureInitialized();
        return this.artifactRepository.descriptorQueryable();
    }

    public IQueryResult<IArtifactKey> query(IQuery<IArtifactKey> query, IProgressMonitor monitor) {
        this.ensureInitialized();
        return this.artifactRepository.query(query, monitor);
    }

    public IStatus executeBatch(IRunnableWithProgress runnable, IProgressMonitor monitor) {
        try {
            runnable.run(monitor);
        }
        catch (OperationCanceledException oce) {
            return new Status(8, "org.eclipse.equinox.p2.extensionlocation", oce.getMessage(), (Throwable)oce);
        }
        catch (Exception e) {
            return new Status(4, "org.eclipse.equinox.p2.extensionlocation", e.getMessage(), (Throwable)e);
        }
        return Status.OK_STATUS;
    }
}

