/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egf.emf.pattern.util;

import java.io.IOException;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egf.core.EGFCorePlugin;
import org.eclipse.egf.emf.pattern.util.PartType;
import org.eclipse.egf.model.domain.Domain;
import org.eclipse.egf.model.domain.DomainFactory;
import org.eclipse.egf.model.domain.DomainViewpoint;
import org.eclipse.egf.model.domain.EMFDomain;
import org.eclipse.egf.model.domain.TypeDomain;
import org.eclipse.egf.model.fcore.Activity;
import org.eclipse.egf.model.fcore.Contract;
import org.eclipse.egf.model.fcore.FactoryComponent;
import org.eclipse.egf.model.fcore.FcoreFactory;
import org.eclipse.egf.model.fcore.Invocation;
import org.eclipse.egf.model.fcore.InvocationContract;
import org.eclipse.egf.model.fcore.InvocationContractContainer;
import org.eclipse.egf.model.fcore.Orchestration;
import org.eclipse.egf.model.fcore.ViewpointContainer;
import org.eclipse.egf.model.fprod.FprodFactory;
import org.eclipse.egf.model.fprod.ProductionPlan;
import org.eclipse.egf.model.fprod.ProductionPlanInvocation;
import org.eclipse.egf.model.types.Type;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

public class FcoreUtil {
    protected IProject _project;
    protected Resource _fcoreResource;
    protected Resource _emfPatternResource;
    protected URI _genModelURI;
    protected EMFDomain _genModelEMFDomain;
    protected ProductionPlan _productionPlan;
    private IFile _genModelFile;

    public void createFcoreFile(IFile genModelFile, IFile fcoreFile, IProgressMonitor monitor) throws Exception {
        this._genModelFile = genModelFile;
        final IOException[] ioExceptions = new IOException[1];
        TransactionalEditingDomain editingDomain = TransactionalEditingDomain.Registry.INSTANCE.getEditingDomain(EGFCorePlugin.EDITING_DOMAIN_ID);
        URI platformPluginURI = URI.createPlatformPluginURI((String)fcoreFile.getFullPath().toString(), (boolean)false);
        URI platformResourceURI = URI.createPlatformResourceURI((String)fcoreFile.getFullPath().toString(), (boolean)true);
        editingDomain.getResourceSet().getURIConverter().getURIMap().put(platformPluginURI, platformResourceURI);
        this._genModelURI = URI.createPlatformResourceURI((String)genModelFile.getFullPath().toString(), (boolean)true);
        this._fcoreResource = editingDomain.getResourceSet().createResource(platformPluginURI);
        URI emfPatternResourceURI = URI.createPlatformPluginURI((String)"/org.eclipse.egf.emf.pattern/egf/EMF_Pattern.fcore", (boolean)true);
        this._emfPatternResource = editingDomain.getResourceSet().getResource(emfPatternResourceURI, true);
        CreateCommand createCommand = new CreateCommand(editingDomain, monitor);
        editingDomain.getCommandStack().execute((Command)createCommand);
        if (createCommand._exception != null) {
            throw createCommand._exception;
        }
        try {
            editingDomain.runExclusive(new Runnable(){

                public void run() {
                    try {
                        FcoreUtil.this._fcoreResource.save(Collections.EMPTY_MAP);
                    }
                    catch (IOException ioe) {
                        ioExceptions[0] = ioe;
                    }
                }
            });
        }
        catch (InterruptedException ie) {
            return;
        }
        if (ioExceptions[0] != null) {
            throw ioExceptions[0];
        }
    }

    protected class CreateCommand
    extends RecordingCommand {
        protected Exception _exception;
        protected IProgressMonitor _monitor;
        private TransactionalEditingDomain domain;

        public CreateCommand(TransactionalEditingDomain domain, IProgressMonitor monitor) {
            super(domain);
            this.domain = domain;
            this._monitor = monitor;
        }

        protected void doExecute() {
            FactoryComponent factoryComponent = FcoreFactory.eINSTANCE.createFactoryComponent();
            factoryComponent.setName(String.valueOf(FcoreUtil.this._genModelFile.getName()) + " EMF Pattern");
            FcoreUtil.this._fcoreResource.getContents().add((Object)factoryComponent);
            ViewpointContainer viewpointContainer = FcoreFactory.eINSTANCE.createViewpointContainer();
            factoryComponent.setViewpointContainer(viewpointContainer);
            DomainViewpoint domainViewpoint = DomainFactory.eINSTANCE.createDomainViewpoint();
            viewpointContainer.getViewpoints().add((Object)domainViewpoint);
            FcoreUtil.this._genModelEMFDomain = DomainFactory.eINSTANCE.createEMFDomain();
            FcoreUtil.this._genModelEMFDomain.setUri(FcoreUtil.this._genModelURI);
            domainViewpoint.getDomains().add((Object)FcoreUtil.this._genModelEMFDomain);
            FcoreUtil.this._productionPlan = FprodFactory.eINSTANCE.createProductionPlan();
            factoryComponent.setOrchestration((Orchestration)FcoreUtil.this._productionPlan);
            for (EObject eObject : FcoreUtil.this._emfPatternResource.getContents()) {
                if (!(eObject instanceof FactoryComponent)) continue;
                FactoryComponent targetFactoryComponent = (FactoryComponent)eObject;
                PartType[] partTypeArray = PartType.values();
                int n = partTypeArray.length;
                int n2 = 0;
                while (n2 < n) {
                    PartType partType = partTypeArray[n2];
                    String name = PartType.getFactoryComponentName(partType);
                    if (name.equals(targetFactoryComponent.getName())) {
                        ProductionPlanInvocation productionPlanInvocation = FprodFactory.eINSTANCE.createProductionPlanInvocation();
                        productionPlanInvocation.setProductionPlan(FcoreUtil.this._productionPlan);
                        productionPlanInvocation.setInvokedActivity((Activity)targetFactoryComponent);
                        productionPlanInvocation.setName(String.valueOf(name) + " invocation");
                        InvocationContractContainer invocationContractContainer = FcoreFactory.eINSTANCE.createInvocationContractContainer();
                        invocationContractContainer.setInvocation((Invocation)productionPlanInvocation);
                        InvocationContract invocationContract = FcoreFactory.eINSTANCE.createInvocationContract();
                        invocationContract.setInvocationContractContainer(invocationContractContainer);
                        invocationContract.setInvokedContract((Contract)targetFactoryComponent.getContracts().get(0));
                        TypeDomain typeEMFDomain = DomainFactory.eINSTANCE.createTypeDomain();
                        typeEMFDomain.setDomain((Domain)FcoreUtil.this._genModelEMFDomain);
                        invocationContract.setType((Type)typeEMFDomain);
                    }
                    ++n2;
                }
            }
            org.eclipse.egf.emf.docgen.html.util.FcoreUtil.createEmfDocGenHtmlInvocation((EditingDomain)this.domain, (ProductionPlan)FcoreUtil.this._productionPlan, (EMFDomain)FcoreUtil.this._genModelEMFDomain);
        }
    }
}

