/**
 * Copyright (c) 2017 TypeFox GmbH (http://www.typefox.io) and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 */
package org.eclipse.elk.graph.text.ui;

import com.google.common.base.Objects;
import com.google.inject.Guice;
import com.google.inject.Injector;
import org.apache.log4j.Logger;
import org.eclipse.elk.graph.text.ide.ElkGraphIdeModule;
import org.eclipse.elk.graph.text.ui.internal.TextActivator;
import org.eclipse.xtext.util.Modules2;
import org.eclipse.xtext.xbase.lib.Exceptions;

@SuppressWarnings("all")
public class ElkGraphTextUiActivator extends TextActivator {
  protected com.google.inject.Module getIdeModule(final String grammar) {
    boolean _equals = Objects.equal(grammar, TextActivator.ORG_ECLIPSE_ELK_GRAPH_TEXT_ELKGRAPH);
    if (_equals) {
      return new ElkGraphIdeModule();
    }
    throw new IllegalArgumentException(grammar);
  }
  
  @Override
  protected Injector createInjector(final String language) {
    try {
      final com.google.inject.Module runtimeModule = this.getRuntimeModule(language);
      final com.google.inject.Module ideModule = this.getIdeModule(language);
      final com.google.inject.Module sharedStateModule = this.getSharedStateModule();
      final com.google.inject.Module uiModule = this.getUiModule(language);
      final com.google.inject.Module mergedModule = Modules2.mixin(runtimeModule, ideModule, sharedStateModule, uiModule);
      return Guice.createInjector(mergedModule);
    } catch (final Throwable _t) {
      if (_t instanceof Exception) {
        final Exception e = (Exception)_t;
        final Logger logger = Logger.getLogger(ElkGraphTextUiActivator.class);
        logger.error(("Failed to create injector for " + language), e);
        throw new RuntimeException(("Failed to create injector for " + language), e);
      } else {
        throw Exceptions.sneakyThrow(_t);
      }
    }
  }
}
