/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.ontapi.common;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.graph.FrontsNode;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.ontapi.common.CommonEnhNodeFactoryImpl;
import org.apache.jena.ontapi.common.CompositeEnhNodeFactoryImpl;
import org.apache.jena.ontapi.common.EnhNodeFactory;
import org.apache.jena.ontapi.common.EnhNodeFilter;
import org.apache.jena.ontapi.common.EnhNodeFinder;
import org.apache.jena.ontapi.common.EnhNodeProducer;
import org.apache.jena.ontapi.common.WrappedEnhNodeFactory;
import org.apache.jena.ontapi.model.OntObject;
import org.apache.jena.ontapi.utils.Iterators;
import org.apache.jena.ontapi.utils.StdModels;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.reasoner.InfGraph;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;

public class OntEnhNodeFactories {
    @SafeVarargs
    public static EnhNodeFactory createFrom(EnhNodeFinder finder, Class<? extends OntObject> type, Class<? extends OntObject> ... types) {
        return OntEnhNodeFactories.createFrom(finder, Stream.concat(Stream.of(type), Arrays.stream(types)).toList().stream());
    }

    public static EnhNodeFactory createFrom(EnhNodeFinder finder, Stream<Class<? extends OntObject>> types) {
        return OntEnhNodeFactories.createMulti(Objects.requireNonNull(finder, "Null finder"), types.map(WrappedEnhNodeFactory::new));
    }

    public static EnhNodeFactory createFrom(EnhNodeFinder finder, EnhNodeFactory factory, EnhNodeFactory ... factories) {
        return OntEnhNodeFactories.createMulti(Objects.requireNonNull(finder, "Null finder"), Stream.concat(Stream.of(factory), Arrays.stream(factories)).toList().stream());
    }

    public static EnhNodeFactory createFrom(EnhNodeFactory factory, EnhNodeFactory ... factories) {
        return OntEnhNodeFactories.createMulti(null, Stream.concat(Stream.of(factory), Arrays.stream(factories)).toList().stream());
    }

    public static EnhNodeFactory createCommon(Class<? extends EnhNode> impl, EnhNodeFinder finder, EnhNodeFilter filter, EnhNodeFilter ... additional) {
        return OntEnhNodeFactories.createCommon(new EnhNodeProducer.Default(impl), finder, filter, additional);
    }

    public static EnhNodeFactory createCommon(Class<? extends EnhNode> impl, BiFunction<Node, EnhGraph, EnhNode> producer, EnhNodeFinder finder, EnhNodeFilter filter) {
        return OntEnhNodeFactories.createCommon(new EnhNodeProducer.Default(impl, producer), finder, filter, new EnhNodeFilter[0]);
    }

    public static EnhNodeFactory createCommon(EnhNodeProducer maker, EnhNodeFinder finder, EnhNodeFilter primary, EnhNodeFilter ... additional) {
        return new CommonEnhNodeFactoryImpl(Objects.requireNonNull(maker, "Null maker"), Objects.requireNonNull(finder, "Null finder"), Objects.requireNonNull(primary, "Null filter").accumulate(additional));
    }

    public static EnhNodeFactory createCommon(final Class<? extends OntObject> type, EnhNodeProducer maker, EnhNodeFinder finder, EnhNodeFilter filter) {
        Objects.requireNonNull(type, "Null type");
        return new CommonEnhNodeFactoryImpl(Objects.requireNonNull(maker, "Null maker"), Objects.requireNonNull(finder, "Null finder"), Objects.requireNonNull(filter, "Null filter")){

            public String toString() {
                return String.format("ObjectFactory[%s]", OntEnhNodeFactories.viewAsString(type));
            }
        };
    }

    public static EnhNodeFinder createFinder(Resource ... types) {
        return OntEnhNodeFactories.createFinder(FrontsNode::asNode, types);
    }

    @SafeVarargs
    public static <R> EnhNodeFinder createFinder(Function<R, Node> asNode, R ... types) {
        return eg -> Iterators.distinct(OntEnhNodeFactories.listTriplesForTypes(eg.asGraph(), asNode, types).mapWith(Triple::getSubject));
    }

    private static EnhNodeFactory createMulti(EnhNodeFinder finder, Stream<EnhNodeFactory> factories) {
        return new CompositeEnhNodeFactoryImpl(finder, null, (EnhNodeFactory[])factories.peek(x -> Objects.requireNonNull(x, "Null component-factory")).toArray(EnhNodeFactory[]::new));
    }

    @SafeVarargs
    private static <R> ExtendedIterator<Triple> listTriplesForTypes(Graph g, Function<R, Node> asNode, R ... types) {
        return Iterators.flatMap(Iterators.of(types).mapWith(asNode), t -> g.find(Node.ANY, RDF.Nodes.type, (Node)t));
    }

    public static String viewAsString(Class<?> type) {
        return type.getName().replace(OntObject.class.getPackage().getName() + ".", "");
    }

    public static String toPrintString(Node node, EnhGraph graph) {
        if (!(graph instanceof Model)) {
            return node.toString(PrefixMapping.Standard);
        }
        Model m = (Model)((Object)graph);
        PrefixMapping pm = PrefixMapping.Factory.create().setNsPrefixes((PrefixMapping)((Object)graph)).setNsPrefixes(PrefixMapping.Standard);
        if (m.getGraph() instanceof InfGraph) {
            return node.toString(pm);
        }
        RDFNode rdfNode = m.asRDFNode(node);
        if (!rdfNode.isResource()) {
            return node.toString(pm);
        }
        List<Statement> properties = rdfNode.asResource().listProperties().toList();
        if (properties.isEmpty()) {
            return node.toString(pm);
        }
        StringBuilder sb = new StringBuilder("\n");
        properties.forEach(s -> sb.append(StdModels.toString(s, pm)).append("\n"));
        return sb.toString();
    }
}

