/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import java.util.Objects;
import org.apache.jena.query.ReadWrite;
import org.apache.jena.sparql.JenaTransactionException;
import org.apache.jena.sparql.core.Transactional;

public enum TxnType {
    READ,
    WRITE,
    READ_PROMOTE,
    READ_COMMITTED_PROMOTE;


    public static TxnType convert(ReadWrite rw) {
        switch (rw) {
            case READ: {
                return READ;
            }
            case WRITE: {
                return WRITE;
            }
        }
        throw new NullPointerException();
    }

    public static ReadWrite convert(TxnType txnType) {
        Objects.requireNonNull(txnType);
        switch (txnType) {
            case READ: {
                return ReadWrite.READ;
            }
            case WRITE: {
                return ReadWrite.WRITE;
            }
        }
        throw new JenaTransactionException("Incompatible mode: " + txnType);
    }

    public static ReadWrite initial(TxnType txnType) {
        Objects.requireNonNull(txnType);
        return txnType == WRITE ? ReadWrite.WRITE : ReadWrite.READ;
    }

    public static TxnType promote(Transactional.Promote promoteMode) {
        Objects.requireNonNull(promoteMode);
        return promoteMode == Transactional.Promote.ISOLATED ? READ_PROMOTE : READ_COMMITTED_PROMOTE;
    }
}

