/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.core.common.ide.modelpath;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;

public class ModelPathDescriptionLexer {
    public static final String MODELPATH_FILE_NAME = "modelpath";
    public static final String MODELPATH_KEYWORD_SRCDIR = "srcDir";
    public static final String MODELPATH_KEYWORD_PROJECT = "project";
    private static final Pattern ENTRY_PATTERN = Pattern.compile("^\\s*(?<key>\\S+)\\s*(?<value>.*?)\\s*$");

    public static List<ModelPathDescriptionEntry> read(InputStream input) throws IOException {
        BufferedReader reader = new BufferedReader(new InputStreamReader(input));
        ArrayList<ModelPathDescriptionEntry> entries = new ArrayList<ModelPathDescriptionEntry>();
        int lineNumber = 0;
        String line = reader.readLine();
        while (line != null) {
            Matcher matcher;
            int index = line.indexOf("//");
            if (index != -1) {
                line = line.substring(0, index);
            }
            if ((matcher = ENTRY_PATTERN.matcher(line)).matches()) {
                ModelPathDescriptionEntry entry = new ModelPathDescriptionEntry(matcher.group("key"), matcher.group("value"), lineNumber, matcher.start("key"), matcher.start("value"));
                entries.add(entry);
            }
            ++lineNumber;
            line = reader.readLine();
        }
        return entries;
    }

    public static class ModelPathDescriptionEntry {
        public final String key;
        public final String value;
        public final int lineNumber;
        public final int keyStart;
        public final int valueStart;

        private ModelPathDescriptionEntry(String key, String value, int lineNumber, int keyStart, int valueStart) {
            this.key = key;
            this.value = value;
            this.lineNumber = lineNumber;
            this.keyStart = keyStart;
            this.valueStart = valueStart;
        }

        public Range getRange() {
            return new Range(new Position(this.lineNumber, this.keyStart), new Position(this.lineNumber, this.valueStart + this.value.length()));
        }

        public Range getKeyRange() {
            return new Range(new Position(this.lineNumber, this.keyStart), new Position(this.lineNumber, this.keyStart + this.key.length()));
        }

        public Range getValueRange() {
            return new Range(new Position(this.lineNumber, this.valueStart), new Position(this.lineNumber, this.valueStart + this.value.length()));
        }
    }
}

