/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.executionframework.debugger;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.eclipse.debug.internal.ui.viewers.model.provisional.TreeModelViewer;
import org.eclipse.debug.internal.ui.views.launch.LaunchView;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gemoc.commons.eclipse.emf.EMFResource;
import org.eclipse.gemoc.dsl.debug.StackFrame;
import org.eclipse.gemoc.dsl.debug.ide.AbstractDSLDebugger;
import org.eclipse.gemoc.dsl.debug.ide.adapter.DSLStackFrameAdapter;
import org.eclipse.gemoc.dsl.debug.ide.event.IDSLDebugEventProcessor;
import org.eclipse.gemoc.executionframework.debugger.Activator;
import org.eclipse.gemoc.executionframework.debugger.IGemocDebugger;
import org.eclipse.gemoc.executionframework.debugger.IMutableFieldExtractor;
import org.eclipse.gemoc.executionframework.debugger.MutableField;
import org.eclipse.gemoc.trace.commons.model.trace.Step;
import org.eclipse.gemoc.xdsmlframework.api.core.IExecutionEngine;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.IEngineAddon;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.FieldChange;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.IModelChangeListenerAddon;
import org.eclipse.gemoc.xdsmlframework.api.engine_addon.modelchangelistener.SimpleModelChangeListenerAddon;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;

public abstract class AbstractGemocDebugger
extends AbstractDSLDebugger
implements IGemocDebugger {
    private Map<MutableField, Object> lastSuspendMutableFields;
    private Map<MutableField, Object> nextSuspendMutableFields;
    private final List<MutableField> mutableFields = new ArrayList<MutableField>();
    private IModelChangeListenerAddon modelChangeListenerAddon;
    protected EObject executedModelRoot = null;
    protected final IExecutionEngine engine;
    private String bundleSymbolicName;
    private List<IMutableFieldExtractor> mutableFieldExtractors = new ArrayList<IMutableFieldExtractor>();
    private Set<BiPredicate<IExecutionEngine, Step<?>>> predicateBreakPoints = new HashSet();
    private Set<BiPredicate<IExecutionEngine, Step<?>>> predicateBreaks = new HashSet();
    private Deque<String> stackFrameNames = new ArrayDeque<String>();
    private ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();

    public AbstractGemocDebugger(IDSLDebugEventProcessor target, IExecutionEngine engine) {
        super(target);
        this.engine = engine;
        if (engine.getExecutionContext().getLanguageDefinitionExtension() != null) {
            this.bundleSymbolicName = engine.getExecutionContext().getLanguageDefinitionExtension().getName().toLowerCase();
        }
        this.registerModelChangeListener();
        Activator openSourceActivator = Activator.getDefault();
        openSourceActivator.setHandlerFieldSuppliers(() -> this.engine, () -> this.bundleSymbolicName);
    }

    protected void registerModelChangeListener() {
        Set listenerAddons = this.engine.getAddonsTypedBy(IModelChangeListenerAddon.class);
        this.modelChangeListenerAddon = listenerAddons.isEmpty() ? new SimpleModelChangeListenerAddon(this.engine) : (IModelChangeListenerAddon)listenerAddons.stream().findFirst().get();
        this.modelChangeListenerAddon.registerAddon((IEngineAddon)this);
    }

    public void setMutableFieldExtractors(List<IMutableFieldExtractor> mutableFieldExtractors) {
        this.mutableFieldExtractors = mutableFieldExtractors;
    }

    @Override
    public void addPredicateBreakpoint(BiPredicate<IExecutionEngine, Step<?>> predicate) {
        this.predicateBreakPoints.add(predicate);
    }

    @Override
    public void addPredicateBreak(BiPredicate<IExecutionEngine, Step<?>> predicate) {
        this.predicateBreaks.add(predicate);
    }

    protected boolean shouldBreakPredicates(IExecutionEngine engine, Step<?> step) {
        boolean shouldBreak = false;
        HashSet toRemove = new HashSet();
        for (BiPredicate<IExecutionEngine, Step<?>> pred : this.predicateBreaks) {
            if (!pred.test(engine, step)) continue;
            shouldBreak = true;
            toRemove.add(pred);
        }
        this.predicateBreaks.removeAll(toRemove);
        if (shouldBreak) {
            return true;
        }
        for (BiPredicate<IExecutionEngine, Step<?>> pred : this.predicateBreakPoints) {
            if (!pred.test(engine, step)) continue;
            return true;
        }
        return false;
    }

    protected EObject getModelRoot() {
        if (this.executedModelRoot == null && this.engine != null) {
            this.executedModelRoot = (EObject)this.engine.getExecutionContext().getResourceModel().getContents().get(0);
        }
        return this.executedModelRoot;
    }

    private boolean updateMutableFieldList(EObject eObject) {
        Iterator<IMutableFieldExtractor> extractors = this.mutableFieldExtractors.iterator();
        List<Object> newMutableFields = Collections.emptyList();
        while (newMutableFields.isEmpty() && extractors.hasNext()) {
            newMutableFields = extractors.next().extractMutableField(eObject);
        }
        return this.mutableFields.addAll(newMutableFields);
    }

    private void initializeMutableDatas() {
        this.mutableFields.clear();
        this.lastSuspendMutableFields = new HashMap<MutableField, Object>();
        this.nextSuspendMutableFields = new HashMap<MutableField, Object>();
        Resource executedResource = this.executedModelRoot.eResource();
        Set allResources = EMFResource.getRelatedResources((Resource)executedResource);
        allResources.add(executedResource);
        allResources.removeIf(r -> r == null);
        for (IMutableFieldExtractor extractor : this.mutableFieldExtractors) {
            for (Resource resource : allResources) {
                TreeIterator iterator = resource.getAllContents();
                while (iterator.hasNext()) {
                    EObject eObject = (EObject)iterator.next();
                    this.mutableFields.addAll(extractor.extractMutableField(eObject));
                    Arrays.asList(eObject.getClass().getDeclaredFields()).stream().forEach(f -> {
                        try {
                            f.setAccessible(true);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    });
                }
            }
            if (!this.mutableFields.isEmpty()) break;
        }
        this.mutableFields.sort(new Comparator<MutableField>(){

            @Override
            public int compare(MutableField o1, MutableField o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    private MutableField lookForMutableField(String variableName) {
        return this.mutableFields.stream().filter(m -> m.getName().equals(variableName)).findFirst().get();
    }

    private List<MutableField> lookForMutableFields(EObject eObject) {
        return this.mutableFields.stream().filter(m -> m.geteObject() == eObject).collect(Collectors.toList());
    }

    private boolean mutableDataChanged(MutableField mutableData, Object value) {
        Object lastValue = this.lastSuspendMutableFields.get(mutableData);
        return lastValue != null && value == null || lastValue == null && value != null || lastValue != null && value != null && !lastValue.equals(value);
    }

    protected abstract void updateStack(String var1, EObject var2);

    protected void updateVariables(String threadName) {
        List changes = this.modelChangeListenerAddon.getChanges((IEngineAddon)this);
        block4: for (FieldChange change : changes) {
            switch (change.getChangeType()) {
                case ADD: 
                case MODIFY: {
                    EObject eObject;
                    List<MutableField> currentMutableFields;
                    if (!(change.getValue() instanceof EObject) || !(currentMutableFields = this.lookForMutableFields(eObject = (EObject)change.getValue())).isEmpty()) continue block4;
                    this.updateMutableFieldList(eObject);
                    break;
                }
                case REMOVE: {
                    Object value = change.getValue();
                    if (value instanceof EObject && ((EObject)value).eContainer() == null) {
                        List<MutableField> toRemove = this.lookForMutableFields((EObject)value);
                        toRemove.stream().forEach(m -> this.deleteVariable(threadName, m.getName()));
                        this.mutableFields.removeAll(toRemove);
                        break;
                    }
                    if (!(value instanceof List)) break;
                    List<EObject> eObjects = ((List)value).stream().filter(e -> e instanceof EObject).map(e -> (EObject)e).collect(Collectors.toList());
                    eObjects.forEach(e -> {
                        if (e.eContainer() == null) {
                            List<MutableField> toRemove = this.lookForMutableFields((EObject)e);
                            toRemove.stream().forEach(m -> this.deleteVariable(threadName, m.getName()));
                            this.mutableFields.removeAll(toRemove);
                        }
                    });
                }
            }
        }
        ArrayList changed = new ArrayList();
        this.mutableFields.forEach(e -> {
            this.nextSuspendMutableFields.put((MutableField)e, e.getValue());
            if (this.mutableDataChanged((MutableField)e, e.getValue())) {
                changed.add(e);
            }
        });
        String frameName = "Global context : " + this.executedModelRoot.eClass().getName();
        for (MutableField m2 : changed) {
            this.variable(threadName, frameName, "mutable data", m2.getName(), m2.getValue(), true);
        }
        for (String name : this.stackFrameNames) {
            for (MutableField m3 : changed) {
                this.variable(threadName, name, "mutable data", m3.getName(), m3.getValue(), true);
            }
        }
        if (!this.nextSuspendMutableFields.isEmpty()) {
            this.lastSuspendMutableFields = this.nextSuspendMutableFields;
            this.nextSuspendMutableFields = new HashMap<MutableField, Object>();
        }
    }

    public boolean validateVariableValue(String threadName, String variableName, String value) {
        MutableField data = this.lookForMutableField(variableName);
        return this.getValue(data, value) != null;
    }

    private Object getValue(MutableField data, String value) {
        Object res;
        Object currentValue = data.getValue();
        if (currentValue instanceof String) {
            res = value;
        } else if (currentValue instanceof Integer) {
            Integer integerValue = null;
            try {
                integerValue = Integer.decode(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            res = integerValue;
        } else if (currentValue instanceof Double) {
            Double doubleValue = null;
            try {
                doubleValue = Double.parseDouble(value);
            }
            catch (Exception exception) {
                // empty catch block
            }
            res = doubleValue;
        } else {
            res = currentValue instanceof Boolean ? Boolean.valueOf(value) : null;
        }
        return res;
    }

    public void pushStackFrame(String threadName, String frameName, EObject context, EObject instruction) {
        super.pushStackFrame(threadName, frameName, context, instruction);
        this.stackFrameNames.push(frameName);
        for (MutableField m : this.mutableFields) {
            this.variable(threadName, frameName, "mutable data", m.getName(), m.getValue(), true);
        }
    }

    public void popStackFrame(String threadName) {
        super.popStackFrame(threadName);
        this.stackFrameNames.pop();
    }

    public Object getVariableValue(String threadName, String stackName, String variableName, String value) {
        MutableField data = this.lookForMutableField(variableName);
        return this.getValue(data, value);
    }

    public void setVariableValue(String threadName, String stackName, String variableName, Object value) {
        MutableField data = this.lookForMutableField(variableName);
        data.setValue(value);
    }

    public void updateData(String threadName, EObject instruction) {
        if (this.executedModelRoot == null) {
            this.executedModelRoot = this.getModelRoot();
            this.initializeMutableDatas();
            String frameName = "Global context : " + this.executedModelRoot.eClass().getName();
            this.pushStackFrame(threadName, frameName, this.executedModelRoot, instruction);
            for (MutableField m : this.mutableFields) {
                this.variable(threadName, frameName, "mutable data", m.getName(), m.getValue(), true);
            }
        } else {
            this.updateVariables(threadName);
        }
        this.updateStack(threadName, instruction);
        this.scheduleSelectLastStackframe(500L);
    }

    protected void scheduleSelectLastStackframe(long delay) {
        this.executorService.schedule(() -> this.selectLastStackframe(), delay, TimeUnit.MILLISECONDS);
    }

    private <T> List<T> flatten(List<T> ts, Function<T, List<T>> provider) {
        if (ts.isEmpty()) {
            return ts;
        }
        ArrayList<T> res = new ArrayList<T>();
        for (T t : ts) {
            res.addAll(this.flatten(provider.apply(t), provider));
            res.add(t);
        }
        return res;
    }

    private void selectLastStackframe() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        workbench.getDisplay().asyncExec(() -> {
            IWorkbenchPage workbenchPage = workbench.getActiveWorkbenchWindow().getActivePage();
            IViewPart view = workbenchPage.findView("org.eclipse.debug.ui.DebugView");
            if (view == null) {
                Activator.getDefault().debug("Cannot find view org.eclipse.debug.ui.DebugView (may be not opened yet), => not updating the debug stack. ");
                return;
            }
            view.setFocus();
            ISelectionProvider selectionProvider = view.getSite().getSelectionProvider();
            selectionProvider.setSelection((ISelection)StructuredSelection.EMPTY);
            if (view instanceof LaunchView) {
                LaunchView launchView = (LaunchView)view;
                Viewer viewer = launchView.getViewer();
                Tree tree = ((TreeModelViewer)viewer).getTree();
                TreeItem[] items = tree.getItems();
                List<TreeItem> allItems = this.flatten(Arrays.asList(items), t -> Arrays.asList(t.getItems()));
                List leafItems = allItems.stream().filter(i -> i.getData() instanceof DSLStackFrameAdapter).filter(i -> ((DSLStackFrameAdapter)i.getData()).getTarget() instanceof StackFrame).collect(Collectors.toList());
                for (TreeItem item : leafItems) {
                    DSLStackFrameAdapter stackFrameAdapter = (DSLStackFrameAdapter)item.getData();
                    StackFrame s = (StackFrame)stackFrameAdapter.getTarget();
                    if (!s.getName().startsWith("Global context :")) continue;
                    tree.showItem(item);
                    tree.select(item);
                    TreeSelection selection = (TreeSelection)viewer.getSelection();
                    TreePath[] paths = selection.getPathsFor((Object)stackFrameAdapter);
                    selectionProvider.setSelection((ISelection)new TreeSelection(paths));
                    break;
                }
            }
        });
    }
}

