/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.actions;

import java.util.ArrayList;
import org.eclipse.gemoc.execution.concurrent.ccsljavaengine.ui.actions.GenerateExtendedCCSLFileAction;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.extensions.languages.ConcurrentLanguageDefinitionExtension;
import org.eclipse.gemoc.execution.concurrent.ccsljavaxdsml.api.extensions.languages.ConcurrentLanguageDefinitionExtensionPoint;
import org.eclipse.gemoc.xdsmlframework.api.extensions.languages.LanguageDefinitionExtension;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ListDialog;

public class GenerateExtendedCCSLFile
extends GenerateExtendedCCSLFileAction {
    @Override
    protected String getTransformationURI() {
        ListDialog dialog;
        String fileExtension = this.modelUriString.substring(this.modelUriString.lastIndexOf(46) + 1, this.modelUriString.length());
        ArrayList<ConcurrentLanguageDefinitionExtension> applicableLanguageDefinitions = new ArrayList<ConcurrentLanguageDefinitionExtension>();
        for (ConcurrentLanguageDefinitionExtension lde : ConcurrentLanguageDefinitionExtensionPoint.getSpecifications()) {
            if (!lde.getFileExtensions().contains(fileExtension)) continue;
            applicableLanguageDefinitions.add(lde);
        }
        ConcurrentLanguageDefinitionExtension selectedLanguageDefinition = null;
        if (applicableLanguageDefinitions.size() == 0) {
            dialog = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "No applicable language found", null, "No applicable language found for file extension " + fileExtension + ".", 1, new String[0], -1);
            dialog.open();
            return null;
        }
        if (applicableLanguageDefinitions.size() == 1) {
            selectedLanguageDefinition = (ConcurrentLanguageDefinitionExtension)applicableLanguageDefinitions.get(0);
        } else {
            dialog = new ListDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
            dialog.setTitle("Language selection");
            dialog.setMessage("Which language do you want to use");
            dialog.setLabelProvider((ILabelProvider)new ArrayLabelProvider());
            ArrayList<Object[]> input = new ArrayList<Object[]>();
            for (LanguageDefinitionExtension languageDefinitionExtension : applicableLanguageDefinitions) {
                input.add(new Object[]{languageDefinitionExtension.getName(), languageDefinitionExtension});
            }
            dialog.setInput(input);
            if (dialog.open() != 0) {
                return null;
            }
            Object[] objectArray = dialog.getResult();
            if (objectArray.length == 0) {
                MessageDialog dialog2 = new MessageDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), "Please select a language", null, "Please select a language for file extension " + fileExtension + ".", 1, new String[0], -1);
                dialog2.open();
                return null;
            }
            Object[] selected = (Object[])objectArray[0];
            selectedLanguageDefinition = (ConcurrentLanguageDefinitionExtension)selected[1];
        }
        String uri = selectedLanguageDefinition.getQVTOPath();
        if (!uri.startsWith("platform:/plugin")) {
            uri = "platform:/plugin" + uri;
        }
        return uri;
    }

    @Override
    protected String getMoCFileExtension() {
        return "extendedCCSL";
    }

    static class ArrayLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ArrayLabelProvider() {
        }

        public String getText(Object element) {
            return ((Object[])element)[0].toString();
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Object[] ss = (Object[])element;
            return ss[columnIndex].toString();
        }
    }
}

