/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.example.workflow.utils;

import java.util.HashMap;
import org.eclipse.glsp.example.workflow.wfgraph.ActivityNode;
import org.eclipse.glsp.example.workflow.wfgraph.Category;
import org.eclipse.glsp.example.workflow.wfgraph.Icon;
import org.eclipse.glsp.example.workflow.wfgraph.TaskNode;
import org.eclipse.glsp.example.workflow.wfgraph.WeightedEdge;
import org.eclipse.glsp.example.workflow.wfgraph.WfgraphFactory;
import org.eclipse.glsp.graph.GCompartment;
import org.eclipse.glsp.graph.GEdge;
import org.eclipse.glsp.graph.GLabel;
import org.eclipse.glsp.graph.GModelElement;
import org.eclipse.glsp.graph.GNode;
import org.eclipse.glsp.graph.builder.AbstractGCompartmentBuilder;
import org.eclipse.glsp.graph.builder.AbstractGEdgeBuilder;
import org.eclipse.glsp.graph.builder.AbstractGNodeBuilder;
import org.eclipse.glsp.graph.builder.impl.GCompartmentBuilder;
import org.eclipse.glsp.graph.builder.impl.GLabelBuilder;

public final class WorkflowBuilder {
    private static final String V_GRAB = "vGrab";
    private static final String H_GRAB = "hGrab";
    private static final String H_ALIGN = "hAlign";

    private WorkflowBuilder() {
    }

    public static class ActivityNodeBuilder
    extends AbstractGNodeBuilder<ActivityNode, ActivityNodeBuilder> {
        protected String nodeType;

        public ActivityNodeBuilder(String type, String nodeType) {
            super(type);
            this.nodeType = nodeType;
        }

        protected void setProperties(ActivityNode node) {
            super.setProperties((GNode)node);
            node.setNodeType(this.nodeType);
        }

        protected ActivityNode instantiate() {
            return WfgraphFactory.eINSTANCE.createActivityNode();
        }

        protected ActivityNodeBuilder self() {
            return this;
        }
    }

    public static class CategoryNodeBuilder
    extends AbstractGNodeBuilder<Category, CategoryNodeBuilder> {
        private String name;

        public CategoryNodeBuilder(String name) {
            super("category");
            this.name = name;
        }

        protected Category instantiate() {
            return WfgraphFactory.eINSTANCE.createCategory();
        }

        protected CategoryNodeBuilder self() {
            return this;
        }

        public void setName(String name) {
            this.name = name;
        }

        protected void setProperties(Category node) {
            super.setProperties((GNode)node);
            node.setName(this.name);
            node.setLayout("vbox");
            node.getLayoutOptions().put((Object)WorkflowBuilder.H_ALIGN, (Object)"center");
            node.getLayoutOptions().put((Object)WorkflowBuilder.H_GRAB, (Object)false);
            node.getLayoutOptions().put((Object)WorkflowBuilder.V_GRAB, (Object)false);
            node.getCssClasses().add((Object)"category");
            node.getChildren().add((Object)this.createLabelCompartment(node));
            node.getChildren().add((Object)this.createStructCompartment(node));
        }

        private GCompartment createLabelCompartment(Category node) {
            HashMap layoutOptions = new HashMap();
            return (GCompartment)((GCompartmentBuilder)((GCompartmentBuilder)((GCompartmentBuilder)((GCompartmentBuilder)new GCompartmentBuilder("comp:header").id(String.valueOf(node.getId()) + "_header")).layout("hbox")).layoutOptions(layoutOptions)).add((GModelElement)this.createCompartmentHeader(node))).build();
        }

        private GLabel createCompartmentHeader(Category node) {
            return (GLabel)((GLabelBuilder)((GLabelBuilder)new GLabelBuilder("label:heading").id(String.valueOf(node.getId()) + "_classname")).text(node.getName())).build();
        }

        private GCompartment createStructCompartment(Category node) {
            HashMap<String, Object> layoutOptions = new HashMap<String, Object>();
            layoutOptions.put(WorkflowBuilder.H_ALIGN, "left");
            layoutOptions.put(WorkflowBuilder.H_GRAB, true);
            layoutOptions.put(WorkflowBuilder.V_GRAB, true);
            GCompartmentBuilder structCompartmentBuilder = (GCompartmentBuilder)((GCompartmentBuilder)((GCompartmentBuilder)new GCompartmentBuilder("struct").id(String.valueOf(node.getId()) + "_struct")).layout("freeform")).layoutOptions(layoutOptions);
            return (GCompartment)structCompartmentBuilder.build();
        }
    }

    public static class IconBuilder
    extends AbstractGCompartmentBuilder<Icon, IconBuilder> {
        public IconBuilder() {
            super("icon");
        }

        protected Icon instantiate() {
            return WfgraphFactory.eINSTANCE.createIcon();
        }

        protected IconBuilder self() {
            return this;
        }
    }

    public static class TaskNodeBuilder
    extends AbstractGNodeBuilder<TaskNode, TaskNodeBuilder> {
        private final String name;
        private final String taskType;
        private final int duration;

        public TaskNodeBuilder(String type, String name, String taskType, int duration) {
            super(type);
            this.name = name;
            this.taskType = taskType;
            this.duration = duration;
        }

        protected TaskNode instantiate() {
            return WfgraphFactory.eINSTANCE.createTaskNode();
        }

        protected TaskNodeBuilder self() {
            return this;
        }

        public void setProperties(TaskNode taskNode) {
            super.setProperties((GNode)taskNode);
            taskNode.setName(this.name);
            taskNode.setTaskType(this.taskType);
            taskNode.setDuration(this.duration);
            taskNode.setLayout("hbox");
            taskNode.getLayoutOptions().put((Object)"paddingRight", (Object)10);
            taskNode.getChildren().add((Object)this.createCompartmentIcon(taskNode));
            taskNode.getChildren().add((Object)this.createCompartmentHeader(taskNode));
        }

        private Icon createCompartmentIcon(TaskNode taskNode) {
            return (Icon)((IconBuilder)new IconBuilder().id(String.valueOf(taskNode.getId()) + "_icon")).build();
        }

        private GLabel createCompartmentHeader(TaskNode taskNode) {
            return (GLabel)((GLabelBuilder)((GLabelBuilder)new GLabelBuilder("label:heading").id(String.valueOf(taskNode.getId()) + "_classname")).text(taskNode.getName())).build();
        }
    }

    public static class WeightedEdgeBuilder
    extends AbstractGEdgeBuilder<WeightedEdge, WeightedEdgeBuilder> {
        private String probability;

        public WeightedEdgeBuilder() {
            super("edge:weighted");
        }

        public WeightedEdgeBuilder probability(String probability) {
            this.probability = probability;
            return this.self();
        }

        protected void setProperties(WeightedEdge edge) {
            super.setProperties((GEdge)edge);
            edge.setProbability(this.probability);
        }

        protected WeightedEdge instantiate() {
            return WfgraphFactory.eINSTANCE.createWeightedEdge();
        }

        protected WeightedEdgeBuilder self() {
            return this;
        }
    }
}

