/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.glsp.graph.builder;

import java.util.List;
import org.eclipse.glsp.graph.GDimension;
import org.eclipse.glsp.graph.GPoint;
import org.eclipse.glsp.graph.GShapeElement;
import org.eclipse.glsp.graph.builder.GModelElementBuilder;
import org.eclipse.glsp.graph.util.GraphUtil;

public abstract class GShapeElementBuilder<T extends GShapeElement, E extends GShapeElementBuilder<T, E>>
extends GModelElementBuilder<T, E> {
    protected GDimension size;
    protected GPoint position;
    protected List<String> resizeLocations;

    public GShapeElementBuilder(String type) {
        super(type);
    }

    public E size(GDimension size) {
        this.size = size;
        return (E)((GShapeElementBuilder)this.self());
    }

    public E size(double width, double height) {
        return this.size(GraphUtil.dimension(width, height));
    }

    public E position(GPoint position) {
        this.position = position;
        return (E)((GShapeElementBuilder)this.self());
    }

    public E position(double x, double y) {
        return this.position(GraphUtil.point(x, y));
    }

    public E resizeLocations(String ... locations) {
        this.resizeLocations = List.of(locations);
        return (E)((GShapeElementBuilder)this.self());
    }

    @Override
    protected void setProperties(T element) {
        super.setProperties(element);
        element.setSize(this.size);
        element.setPosition(this.position);
        if (this.resizeLocations != null) {
            element.getResizeLocations().addAll(this.resizeLocations);
        }
    }
}

