/*
 * Decompiled with CFR 0.152.
 */
package net.sf.antcontrib.antserver.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import net.sf.antcontrib.antserver.Command;
import net.sf.antcontrib.antserver.Util;
import net.sf.antcontrib.antserver.commands.AbstractCommand;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class SendFileCommand
extends AbstractCommand
implements Command {
    private long contentLength;
    private String todir;
    private String tofile;
    private String fileBaseName;
    private transient File file;

    public File getFile() {
        return this.file;
    }

    public long getContentLength() {
        return this.contentLength;
    }

    public InputStream getContentStream() throws IOException {
        return new FileInputStream(this.file);
    }

    public void setFile(File file) {
        this.file = file;
        this.fileBaseName = file.getName();
        this.contentLength = file.length();
    }

    public String getTofile() {
        return this.tofile;
    }

    public void setTofile(String tofile) {
        this.tofile = tofile;
    }

    public String getTodir() {
        return this.todir;
    }

    public void setTodir(String todir) {
        this.todir = todir;
    }

    public void validate(Project project) {
        if (this.file == null) {
            throw new BuildException("Missing required attribute 'file'");
        }
        if (this.tofile == null && this.todir == null) {
            throw new BuildException("Missing both attributes 'tofile' and 'todir' at least one must be supplied");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(Project project, long contentLength, InputStream content) throws Throwable {
        File dest = null;
        if (this.tofile != null) {
            dest = new File(project.getBaseDir(), this.tofile);
            if (!new File(this.tofile).getCanonicalPath().startsWith(project.getBaseDir().getCanonicalPath())) {
                System.out.println("throwing an exception");
                throw new SecurityException("The requested filename must be a relative path.");
            }
        } else {
            dest = new File(project.getBaseDir(), this.todir);
            dest = new File(dest, this.fileBaseName);
            if (!new File(this.todir, this.tofile).getCanonicalPath().startsWith(project.getBaseDir().getCanonicalPath())) {
                throw new SecurityException("The requested filename must be a relative path.");
            }
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(dest);
            Util.transferBytes(content, contentLength, fos, false);
            Object var8_6 = null;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            if (fos != null) {
                fos.close();
            }
        }
        catch (IOException iOException) {}
        return false;
    }
}

