/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.inheritance;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.inheritance.ChildResource;
import ee.jakarta.tck.ws.rs.spec.inheritance.ChildResource1;
import ee.jakarta.tck.ws.rs.spec.inheritance.ParentResource;
import ee.jakarta.tck.ws.rs.spec.inheritance.ParentResource1;
import ee.jakarta.tck.ws.rs.spec.inheritance.TSAppConfig;
import jakarta.ws.rs.core.MediaType;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JAXRSCommonClient {
    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_inheritance_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/inheritance/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_spec_inheritance_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, ChildResource.class, ChildResource1.class, ParentResource.class, ParentResource1.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void test1() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST_HEADERS", JAXRSClientIT.buildAccept(MediaType.TEXT_PLAIN_TYPE));
        this.setProperty("REQUEST", this.buildRequest(JAXRSCommonClient.Request.GET, "InheritanceTest"));
        this.setProperty("SEARCH_STRING", "First");
        this.invoke();
    }

    @Test
    public void test2() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST_HEADERS", JAXRSClientIT.buildAccept(MediaType.TEXT_HTML_TYPE));
        this.setProperty("REQUEST", this.buildRequest(JAXRSCommonClient.Request.GET, "InheritanceTest1"));
        this.setProperty("SEARCH_STRING", "Second");
        this.invoke();
    }
}

