/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.ws.rs.spec.template;

import ee.jakarta.tck.ws.rs.common.JAXRSCommonClient;
import ee.jakarta.tck.ws.rs.lib.util.TestUtil;
import ee.jakarta.tck.ws.rs.spec.template.TSAppConfig;
import ee.jakarta.tck.ws.rs.spec.template.TemplateTest;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit5.ArquillianExtension;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ArquillianExtension.class})
public class JAXRSClientIT
extends JAXRSCommonClient {
    public JAXRSClientIT() {
        this.setup();
        this.setContextRoot("/jaxrs_spec_templateTest_web");
    }

    @Deployment(testable=false)
    public static WebArchive createDeployment() throws IOException {
        InputStream inStream = JAXRSClientIT.class.getClassLoader().getResourceAsStream("ee/jakarta/tck/ws/rs/spec/template/web.xml.template");
        String webXml = JAXRSClientIT.editWebXmlString(inStream);
        WebArchive archive = (WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jaxrs_spec_templateTest_web.war");
        archive.addClasses(new Class[]{TSAppConfig.class, TemplateTest.class});
        archive.setWebXML((Asset)new StringAsset(webXml));
        return archive;
    }

    @BeforeEach
    void logStartTest(TestInfo testInfo) {
        TestUtil.logMsg("STARTING TEST : " + testInfo.getDisplayName());
    }

    @AfterEach
    void logFinishTest(TestInfo testInfo) {
        TestUtil.logMsg("FINISHED TEST : " + testInfo.getDisplayName());
    }

    @Test
    public void Test1() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", "GET /jaxrs_spec_templateTest_web/TemplateTest/xyz HTTP/1.1");
        this.setProperty("SEARCH_STRING", "id1=xyz");
        this.invoke();
    }

    @Test
    public void Test2() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", "GET /jaxrs_spec_templateTest_web/TemplateTest/xyz/abc HTTP/1.1");
        this.setProperty("SEARCH_STRING", "id3=abc");
        this.invoke();
    }

    @Test
    public void Test3() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", "GET /jaxrs_spec_templateTest_web/TemplateTest/xyz/abc/def HTTP/1.1");
        this.setProperty("SEARCH_STRING", "id3=abc/def");
        this.invoke();
    }

    @Test
    public void Test4() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", "GET /jaxrs_spec_templateTest_web/TemplateTest/xy/abc/def HTTP/1.1");
        this.setProperty("SEARCH_STRING", "id1=xy/abc/def");
        this.invoke();
    }

    @Test
    public void Test5() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", "GET /jaxrs_spec_templateTest_web/TemplateTest/abc/test.html HTTP/1.1");
        this.setProperty("SEARCH_STRING", "id4=abc|name=test");
        this.invoke();
    }

    @Test
    public void Test6() throws JAXRSCommonClient.Fault {
        this.setProperty("REQUEST", "GET /jaxrs_spec_templateTest_web/TemplateTest/abc/def/test.xml HTTP/1.1");
        this.setProperty("SEARCH_STRING", "id5=abc/def|name=test");
        this.invoke();
    }
}

