/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvts2qvts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.qvtd.compiler.CompilerChainException;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.AbstractTransformationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.ScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.RegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.TraceElementRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.TracePropertyRegionAnalysis;
import org.eclipse.qvtd.compiler.internal.qvts2qvts.partitioner.TransformationPartitioner;
import org.eclipse.qvtd.compiler.internal.utilities.CompilerUtil;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.Edge;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;
import org.eclipse.qvtd.runtime.evaluation.AbstractDispatch;

public class TraceClassRegionAnalysis
extends TraceElementRegionAnalysis
implements CompilerUtil.TraceClass<RegionAnalysis, TraceClassRegionAnalysis, TracePropertyRegionAnalysis> {
    protected final @NonNull ScheduleManager scheduleManager;
    protected final @NonNull AbstractTransformationAnalysis transformationAnalysis;
    protected final @NonNull ClassDatum traceClassDatum;
    private @Nullable List<@NonNull Property> discriminatingProperties = null;
    private @NonNull List<@NonNull TraceClassRegionAnalysis> subTraceClassAnalyses = new ArrayList<TraceClassRegionAnalysis>();
    private @NonNull List<@NonNull TraceClassRegionAnalysis> superTraceClassAnalyses = new ArrayList<TraceClassRegionAnalysis>();
    private @Nullable Boolean isDispatcher = null;
    private @Nullable Boolean isCyclic = null;

    public TraceClassRegionAnalysis(@NonNull AbstractTransformationAnalysis transformationAnalysis, @NonNull ClassDatum traceClassDatum) {
        this.scheduleManager = transformationAnalysis.getScheduleManager();
        this.transformationAnalysis = transformationAnalysis;
        this.traceClassDatum = traceClassDatum;
        this.subTraceClassAnalyses.add(this);
        this.superTraceClassAnalyses.add(this);
    }

    public void addSubTraceClassAnalysis(@NonNull TraceClassRegionAnalysis traceClassAnalysis) {
        if (!this.subTraceClassAnalyses.contains(traceClassAnalysis)) {
            this.subTraceClassAnalyses.add(traceClassAnalysis);
        }
    }

    public void addSuperTraceClassAnalysis(@NonNull TraceClassRegionAnalysis traceClassAnalysis) {
        if (!this.superTraceClassAnalyses.contains(traceClassAnalysis)) {
            this.superTraceClassAnalyses.add(traceClassAnalysis);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void discriminate() throws CompilerChainException {
        if (this.producers.size() <= 1 || this.consumers.size() <= 1) {
            TransformationPartitioner.DISCRIMINATION.println("Not required for " + this);
            return;
        }
        HashMap<@NonNull RegionAnalysis, @NonNull HashMap<@NonNull K, @NonNull V>> partitioner2property2edge = new HashMap();
        HashSet<@NonNull E> commonProperties = null;
        for (RegionAnalysis producer : this.producers) {
            HashMap<@NonNull Property, @NonNull Iterator<Object>> property2edge = new HashMap<Property, Iterator<Object>>();
            partitioner2property2edge.put(producer, property2edge);
            for (Node traceNode : producer.getTraceNodes()) {
                for (Iterator<Object> edge : traceNode.getRealizedNavigationEdges()) {
                    if (edge.getEdgeTarget().isRealized()) continue;
                    property2edge.put(QVTscheduleUtil.getProperty(edge), edge);
                }
            }
            Set partionerProperties = property2edge.keySet();
            if (commonProperties == null) {
                commonProperties = new HashSet(partionerProperties);
                continue;
            }
            commonProperties.retainAll(partionerProperties);
        }
        if (commonProperties == null || commonProperties.isEmpty()) {
            TransformationPartitioner.DISCRIMINATION.println("No common properties to disambiguate " + this);
            return;
        }
        ArrayList<@NonNull E> sortedProperties = new ArrayList(commonProperties);
        Collections.sort(sortedProperties, NameUtil.NAMEABLE_COMPARATOR);
        HashMap<@NonNull Property, @Nullable HashMap<@Nullable K, @NonNull @NonNull V>> property2completeClass2regionAnalyses = new HashMap();
        for (Property property : sortedProperties) {
            for (RegionAnalysis producer : this.producers) {
                Node targetNode;
                CompleteClass completeClass;
                ArrayList<RegionAnalysis> regionAnalyses;
                @NonNull @NonNull Map property2edge = (Map)partitioner2property2edge.get(producer);
                assert (property2edge != null);
                NavigableEdge edge = (NavigableEdge)property2edge.get(property);
                if (edge == null) {
                    property2completeClass2regionAnalyses.put(property, null);
                    continue;
                }
                HashMap<@Nullable CompleteClass, @NonNull ArrayList<@NonNull RegionAnalysis>> completeClass2regionAnalyses = (HashMap<CompleteClass, ArrayList<RegionAnalysis>>)property2completeClass2regionAnalyses.get(property);
                if (completeClass2regionAnalyses == null) {
                    completeClass2regionAnalyses = new HashMap<CompleteClass, ArrayList<RegionAnalysis>>();
                    property2completeClass2regionAnalyses.put(property, completeClass2regionAnalyses);
                }
                if ((regionAnalyses = (ArrayList<RegionAnalysis>)completeClass2regionAnalyses.get(completeClass = (targetNode = QVTscheduleUtil.getTargetNode((Edge)edge)).isNullLiteral() ? null : targetNode.getCompleteClass())) == null) {
                    regionAnalyses = new ArrayList<RegionAnalysis>();
                    completeClass2regionAnalyses.put(completeClass, regionAnalyses);
                }
                regionAnalyses.add(producer);
            }
        }
        int bestSize = 0;
        Property bestProperty = null;
        for (Property property : property2completeClass2regionAnalyses.keySet()) {
            int size;
            @Nullable @NonNull @NonNull Map completeClass2regionAnalyses = (Map)property2completeClass2regionAnalyses.get(property);
            if (completeClass2regionAnalyses == null || (size = completeClass2regionAnalyses.size()) <= bestSize) continue;
            bestSize = size;
            bestProperty = property;
        }
        if (TransformationPartitioner.DISCRIMINATION.isActive()) {
            StringBuilder s = new StringBuilder();
            s.append("property->completeClass->regionAnalyses");
            for (Property property : property2completeClass2regionAnalyses.keySet()) {
                s.append("\n\t" + property);
                @Nullable @NonNull @NonNull Map completeClass2regionAnalyses = (Map)property2completeClass2regionAnalyses.get(property);
                if (completeClass2regionAnalyses == null) continue;
                for (CompleteClass completeClass : completeClass2regionAnalyses.keySet()) {
                    s.append("\n\t\t" + completeClass);
                    @NonNull List regionAnalyses = (List)completeClass2regionAnalyses.get(completeClass);
                    assert (regionAnalyses != null);
                    for (RegionAnalysis regionAnalysis : regionAnalyses) {
                        s.append("\n\t\t\t" + regionAnalysis);
                    }
                }
            }
            TransformationPartitioner.DISCRIMINATION.println(s.toString());
        }
        if (bestProperty != null) {
            TransformationPartitioner.DISCRIMINATION.println("Best property : " + bestProperty);
            this.discriminatingProperties = Collections.singletonList(bestProperty);
            return;
        }
        throw new CompilerChainException("Unable to disambiguate " + this, new Object[0]);
    }

    public @NonNull ClassDatum getClassDatum() {
        return this.traceClassDatum;
    }

    public @Nullable Iterable<@NonNull Property> getDiscriminatingProperties() {
        return this.discriminatingProperties;
    }

    public String getName() {
        return this.traceClassDatum.getName();
    }

    public @NonNull ScheduleManager getScheduleManager() {
        return this.scheduleManager;
    }

    @Override
    public @NonNull Iterable<@NonNull TraceClassRegionAnalysis> getSubTraceClassAnalyses() {
        return this.subTraceClassAnalyses;
    }

    public @NonNull Iterable<@NonNull TraceClassRegionAnalysis> getSuperTraceClassAnalyses() {
        return this.superTraceClassAnalyses;
    }

    public @NonNull CompleteClass getTraceClass() {
        return QVTscheduleUtil.getCompleteClass((ClassDatum)this.traceClassDatum);
    }

    public boolean isCyclic() {
        Boolean isCyclic2 = this.isCyclic;
        if (isCyclic2 == null) {
            for (TraceClassRegionAnalysis subTraceClassAnalysis : this.getSubTraceClassAnalyses()) {
                if (!this.transformationAnalysis.isCyclic(subTraceClassAnalysis)) continue;
                isCyclic2 = this.isCyclic = Boolean.valueOf(true);
                return isCyclic2;
            }
            isCyclic2 = this.isCyclic = Boolean.valueOf(false);
        }
        return isCyclic2;
    }

    public boolean isDispatcher() {
        Boolean isDispatcher2 = this.isDispatcher;
        if (isDispatcher2 == null) {
            String abstractDispatchClassName = AbstractDispatch.class.getName();
            for (Class superClass : QVTbaseUtil.getSuperClasses((Class)QVTscheduleUtil.getCompleteClass((ClassDatum)this.traceClassDatum).getPrimaryClass())) {
                if (!abstractDispatchClassName.equals(superClass.getInstanceClassName())) continue;
                isDispatcher2 = this.isDispatcher = Boolean.valueOf(true);
                return isDispatcher2;
            }
            isDispatcher2 = this.isDispatcher = Boolean.valueOf(false);
        }
        return isDispatcher2;
    }

    public String toString() {
        return this.traceClassDatum.toString();
    }
}

