/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping.eav;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.usertype.UserType;

public class EAVGenericIDUserType
implements UserType {
    private static final int[] SQL_TYPES = new int[]{12};
    private static final String SEPARATOR = "__;__";
    private final HashMap<String, Constructor<?>> constructors = new HashMap();

    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    public Class<?> returnedClass() {
        return Object.class;
    }

    public boolean isMutable() {
        return false;
    }

    public Object deepCopy(Object value) {
        return value;
    }

    public boolean equals(Object x, Object y) {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        return x.equals(y);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, SessionImplementor sessionImplementor, Object owner) throws SQLException {
        String value = (String)StandardBasicTypes.STRING.nullSafeGet(rs, names[0], sessionImplementor);
        if (rs.wasNull()) {
            return null;
        }
        int end1 = value.indexOf(SEPARATOR);
        int start2 = end1 + SEPARATOR.length();
        String idStr = value.substring(0, end1);
        String idClassName = value.substring(start2);
        Serializable id = this.getId(idStr, idClassName);
        return id;
    }

    public void nullSafeSet(PreparedStatement statement, Object value, int index, SessionImplementor sessionImplementor) throws SQLException {
        if (value == null) {
            statement.setNull(index, 12);
        } else {
            statement.setString(index, String.valueOf(value.toString()) + SEPARATOR + value.getClass().getName());
        }
    }

    public Serializable disassemble(Object value) {
        return (Serializable)value;
    }

    public Object assemble(Serializable cachedValue, Object owner) {
        return cachedValue;
    }

    public Object replace(Object original, Object target, Object owner) {
        return original;
    }

    public int hashCode(Object x) {
        return x.hashCode();
    }

    private Serializable getId(String idStr, String idType) {
        try {
            Constructor<?> constructor = this.constructors.get(idType);
            if (constructor == null) {
                Class<?> idClass = this.getClass().getClassLoader().loadClass(idType);
                constructor = idClass.getConstructor(String.class);
                this.constructors.put(idType, constructor);
            }
            return (Serializable)constructor.newInstance(idStr);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

