/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.teneo.annotations.pannotation.InheritanceType;
import org.eclipse.emf.teneo.hibernate.HbDataStore;
import org.eclipse.emf.teneo.hibernate.HbStoreException;
import org.eclipse.emf.teneo.hibernate.SessionWrapper;
import org.hibernate.FlushMode;
import org.hibernate.LockOptions;
import org.hibernate.Query;
import org.hibernate.Session;
import org.hibernate.internal.SessionImpl;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.persister.entity.JoinedSubclassEntityPersister;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.persister.entity.UnionSubclassEntityPersister;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HbSessionWrapper
implements SessionWrapper {
    private Session session = null;
    private final HbDataStore hbDataStore;
    private FlushMode flushMode;

    public HbSessionWrapper(HbDataStore hbDataStore) {
        this.hbDataStore = hbDataStore;
    }

    public HbSessionWrapper(HbDataStore hbDataStore, Session session) {
        this.hbDataStore = hbDataStore;
        this.session = session;
    }

    @Override
    public Object getSession() {
        if (this.session == null) {
            this.session = this.hbDataStore.getSessionFactory().openSession();
        }
        return this.session;
    }

    private Session getSessionInternal() {
        return (Session)this.getSession();
    }

    @Override
    public void beginTransaction() {
        this.getSessionInternal().beginTransaction();
    }

    @Override
    public void commitTransaction() {
        this.getSessionInternal().getTransaction().commit();
    }

    @Override
    public void rollbackTransaction() {
        this.getSessionInternal().getTransaction().rollback();
    }

    @Override
    public Object get(String entityName, Serializable id) {
        return this.getSessionInternal().get(entityName, id);
    }

    @Override
    public List<?> executeQuery(String qry) {
        Query query = this.getSessionInternal().createQuery(qry);
        return query.list();
    }

    @Override
    public List<?> executeQuery(String qry, String entityParameter, Object entity) {
        Query query = this.getSessionInternal().createQuery(qry);
        query.setEntity(entityParameter, entity);
        return query.list();
    }

    @Override
    public List<?> executeQuery(String qry, List<Object> parameters) {
        Query query = this.getSessionInternal().createQuery(qry);
        int pos = 0;
        for (Object obj : parameters) {
            query.setParameter(pos++, obj);
        }
        return query.list();
    }

    @Override
    public List<?> executeQuery(String qry, boolean cacheable) {
        Query query = this.getSessionInternal().createQuery(qry);
        query.setCacheable(cacheable);
        return query.list();
    }

    @Override
    public List<?> executeQuery(String qry, Map<String, Object> namedParameters) {
        Query query = this.getSessionInternal().createQuery(qry);
        for (Map.Entry<String, Object> entry : namedParameters.entrySet()) {
            query.setParameter(entry.getKey(), entry.getValue());
        }
        return query.list();
    }

    @Override
    public boolean isEJB3EntityManager() {
        return false;
    }

    @Override
    public void restorePreviousFlushMode() {
        if (this.flushMode != null) {
            this.getSessionInternal().setFlushMode(this.flushMode);
            this.flushMode = null;
        }
    }

    @Override
    public void setFlushModeManual() {
        this.flushMode = this.getSessionInternal().getFlushMode();
        this.getSessionInternal().setFlushMode(FlushMode.MANUAL);
    }

    @Override
    public void close() {
        if (this.getSessionInternal().isOpen()) {
            this.getSessionInternal().clear();
            if (!this.getSessionInternal().getSessionFactory().isClosed()) {
                this.getSessionInternal().close();
            }
        }
    }

    @Override
    public void saveOrUpdate(Object obj) {
        this.getSessionInternal().saveOrUpdate(obj);
    }

    @Override
    public void delete(Object obj) {
        this.getSessionInternal().delete(obj);
    }

    @Override
    public void flush() {
        this.getSessionInternal().flush();
    }

    @Override
    public boolean isTransactionActive() {
        return ((SessionImpl)this.getSessionInternal()).isTransactionInProgress();
    }

    @Override
    public void refresh(Object obj) {
        this.getSessionInternal().refresh(obj, LockOptions.UPGRADE);
    }

    @Override
    public boolean isInheritanceStrategy(Class<?> cls, InheritanceType strategy) {
        String clsName = cls.getName();
        String realName = clsName.substring(clsName.lastIndexOf(46) + 1, clsName.length() - 4);
        ClassMetadata cmd = this.hbDataStore.getSessionFactory().getClassMetadata(realName);
        if (strategy.equals((Object)InheritanceType.SINGLE_TABLE)) {
            return cmd instanceof SingleTableEntityPersister;
        }
        if (strategy.equals((Object)InheritanceType.JOINED)) {
            return cmd instanceof JoinedSubclassEntityPersister;
        }
        if (strategy.equals((Object)InheritanceType.TABLE_PER_CLASS)) {
            return cmd instanceof UnionSubclassEntityPersister;
        }
        throw new HbStoreException("Strategy: " + strategy.toString() + " not supported ");
    }

    @Override
    public void clear() {
        this.getSessionInternal().clear();
    }

    @Override
    public Object merge(Object obj) {
        return this.getSessionInternal().merge(obj);
    }

    @Override
    public void persist(Object obj) {
        this.getSessionInternal().save(obj);
    }

    @Override
    public Session getHibernateSession() {
        return this.getSessionInternal();
    }
}

