/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.cdo;

import java.util.List;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.hibernate.mapper.EntityMapper;
import org.eclipse.emf.teneo.simpledom.Element;

public class CDOEntityMapper
extends EntityMapper {
    private PAnnotatedEClass currentEntity = null;
    private boolean addedExtraMappings = false;

    @Override
    public void processEntity(PAnnotatedEClass entity) {
        this.currentEntity = entity;
        try {
            this.addedExtraMappings = false;
            super.processEntity(entity);
        }
        finally {
            this.currentEntity = null;
        }
    }

    @Override
    protected void processFeatures(List<PAnnotatedEStructuralFeature> features) {
        super.processFeatures(features);
        if (!this.addedExtraMappings && this.currentEntity.getPaSuperEntity() == null) {
            Element entityElement = this.getHbmContext().getCurrent();
            Element resourceElement = entityElement.addElement("property");
            resourceElement.addAttribute("name", "resourceID");
            resourceElement.addElement("column").addAttribute("name", "resID_Entity");
            resourceElement.addElement("column").addAttribute("name", "resID_ID");
            resourceElement.addElement("column").addAttribute("name", "resID_class");
            resourceElement.addAttribute("type", "org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOIDUserType");
            Element containerElement = entityElement.addElement("property");
            containerElement.addAttribute("name", "containerID");
            containerElement.addElement("column").addAttribute("name", "contID_Entity");
            containerElement.addElement("column").addAttribute("name", "contID_ID");
            containerElement.addElement("column").addAttribute("name", "contID_class");
            containerElement.addAttribute("type", "org.eclipse.emf.cdo.server.internal.hibernate.tuplizer.CDOIDUserType");
            Element containingFeatureElement = entityElement.addElement("property");
            containingFeatureElement.addAttribute("name", "containingFeatureID");
            containingFeatureElement.addAttribute("column", "contFeatureID");
            containingFeatureElement.addAttribute("type", "int");
            this.addedExtraMappings = true;
        }
    }
}

