/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.hbannotation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum CacheConcurrencyStrategy implements Enumerator
{
    NONE(0, "NONE", "NONE"),
    READ_ONLY(1, "READ_ONLY", "READ_ONLY"),
    NONSTRICT_READ_WRITE(2, "NONSTRICT_READ_WRITE", "NONSTRICT_READ_WRITE"),
    READ_WRITE(3, "READ_WRITE", "READ_WRITE"),
    TRANSACTIONAL(4, "TRANSACTIONAL", "TRANSACTIONAL");

    public static final int NONE_VALUE = 0;
    public static final int READ_ONLY_VALUE = 1;
    public static final int NONSTRICT_READ_WRITE_VALUE = 2;
    public static final int READ_WRITE_VALUE = 3;
    public static final int TRANSACTIONAL_VALUE = 4;
    private static final CacheConcurrencyStrategy[] VALUES_ARRAY;
    public static final List<CacheConcurrencyStrategy> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new CacheConcurrencyStrategy[]{NONE, READ_ONLY, NONSTRICT_READ_WRITE, READ_WRITE, TRANSACTIONAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static CacheConcurrencyStrategy get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CacheConcurrencyStrategy result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CacheConcurrencyStrategy getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            CacheConcurrencyStrategy result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static CacheConcurrencyStrategy get(int value) {
        switch (value) {
            case 0: {
                return NONE;
            }
            case 1: {
                return READ_ONLY;
            }
            case 2: {
                return NONSTRICT_READ_WRITE;
            }
            case 3: {
                return READ_WRITE;
            }
            case 4: {
                return TRANSACTIONAL;
            }
        }
        return null;
    }

    private CacheConcurrencyStrategy(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

