/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.teneo.PersistenceOptions;
import org.eclipse.emf.teneo.annotations.mapper.PersistenceMappingBuilder;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedModel;
import org.eclipse.emf.teneo.extension.ExtensionManager;
import org.eclipse.emf.teneo.extension.ExtensionManagerFactory;
import org.eclipse.emf.teneo.hibernate.HbDataStore;
import org.eclipse.emf.teneo.hibernate.HbDataStoreFactory;
import org.eclipse.emf.teneo.hibernate.HbMapperException;
import org.eclipse.emf.teneo.hibernate.HbSessionDataStore;
import org.eclipse.emf.teneo.hibernate.mapper.HibernateMappingGenerator;
import org.eclipse.emf.teneo.hibernate.mapper.MappingUtil;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;

public class HbHelper {
    private static Log log = LogFactory.getLog(HbHelper.class);
    public static final HbHelper INSTANCE = new HbHelper();
    private final Hashtable<String, HbDataStore> emfDataStores = new Hashtable();
    private final Hashtable<Object, HbDataStore> dataStoreByPersistentClass = new Hashtable();
    private static HbDataStoreFactory emfDataStoreFactory = new HbDataStoreFactory(){

        public HbDataStore createHbDataStore() {
            return new HbSessionDataStore();
        }
    };

    public static void setHbDataStoreFactory(HbDataStoreFactory hbDataStoreFactory) {
        emfDataStoreFactory = hbDataStoreFactory;
    }

    void registerDataStoreByPC(HbDataStore ds) {
        Iterator<?> it = ds.getClassMappings();
        while (it.hasNext()) {
            PersistentClass pc = (PersistentClass)it.next();
            if (this.dataStoreByPersistentClass.get(pc) != null) {
                throw new HbMapperException("There is already a datastore registered for this pc: " + pc.getEntityName() + this.dataStoreByPersistentClass.get(pc).getName() + "/" + ds.getName());
            }
            log.debug((Object)("Datastore: " + ds.getName() + " registered for pc: " + pc.getEntityName()));
            this.dataStoreByPersistentClass.put(pc, ds);
        }
    }

    void registerDataStoreByComponent(HbDataStore ds, Component component) {
        log.debug((Object)("Datastore: " + ds.getName() + " registered for component: " + component.getComponentClassName()));
        this.dataStoreByPersistentClass.put(component, ds);
    }

    public HbDataStore getDataStore(PersistentClass pc) {
        HbDataStore ds = this.dataStoreByPersistentClass.get(pc);
        if (ds == null) {
            throw new HbMapperException("No datastore for pc " + pc.getEntityName());
        }
        return ds;
    }

    public HbDataStore getDataStore(Component component) {
        HbDataStore ds = this.dataStoreByPersistentClass.get(component);
        if (ds == null) {
            throw new HbMapperException("No datastore for pc " + component.getComponentClassName());
        }
        return ds;
    }

    public synchronized void closeAll() {
        for (HbDataStore emfds : this.emfDataStores.values()) {
            emfds.close();
        }
        this.emfDataStores.clear();
        this.dataStoreByPersistentClass.clear();
    }

    public synchronized void deRegisterDataStore(String name) {
        if (name == null) {
            throw new HbMapperException("An unique name should be specified when deregistering a session factory");
        }
        HbDataStore emfds = this.emfDataStores.get(name);
        if (emfds == null) {
            return;
        }
        ArrayList<Object> toRemove = new ArrayList<Object>();
        for (Object key : this.dataStoreByPersistentClass.keySet()) {
            if (emfds != this.dataStoreByPersistentClass.get(key)) continue;
            toRemove.add(key);
        }
        for (Object key : toRemove) {
            this.dataStoreByPersistentClass.remove(key);
        }
        log.debug((Object)("Removing and closing emf data store: " + name));
        this.emfDataStores.remove(name);
        if (emfds.isInitialized()) {
            emfds.close();
        }
    }

    public synchronized HbDataStore createRegisterDataStore(String name) {
        HbDataStore emfds = this.emfDataStores.get(name);
        if (emfds != null) {
            log.warn((Object)("EMF Data Store already registered under name: " + name + ", returning it"));
            return emfds;
        }
        log.info((Object)("Creating emf data store and registering it under name: " + name));
        emfds = emfDataStoreFactory.createHbDataStore();
        emfds.setName(name);
        log.info((Object)"Returning created emf data store, initialize this newly created data store!");
        return emfds;
    }

    public void register(HbDataStore hbDataStore) {
        this.emfDataStores.put(hbDataStore.getName(), hbDataStore);
    }

    public HbDataStore getDataStore(String name) {
        HbDataStore hds = this.emfDataStores.get(name);
        if (hds == null) {
            log.debug((Object)("No datastore found using " + name));
        }
        return hds;
    }

    public String generateMapping(EPackage[] epackages, Properties props) {
        return this.generateMapping(epackages, props, ExtensionManagerFactory.getInstance().create());
    }

    public String generateMapping(EPackage[] epackages, Properties props, ExtensionManager extensionManager) {
        MappingUtil.registerHbExtensions((ExtensionManager)extensionManager);
        log.debug((Object)"Generating mapping file passed epackages");
        PersistenceOptions po = (PersistenceOptions)extensionManager.getExtension(PersistenceOptions.class, new Object[]{props});
        PAnnotatedModel paModel = ((PersistenceMappingBuilder)extensionManager.getExtension(PersistenceMappingBuilder.class)).buildMapping(epackages, po, extensionManager);
        HibernateMappingGenerator hmg = (HibernateMappingGenerator)extensionManager.getExtension(HibernateMappingGenerator.class);
        hmg.setPersistenceOptions(po);
        return hmg.generateToString(paModel);
    }
}

