package org.eclipse.emf.henshin.examples.apibasics;

import java.io.IOException;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.henshin.examples.apibasics.boxing.Boxing;
import org.eclipse.emf.henshin.examples.apibasics.boxing.BoxingFactory;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;

public class CreateAndStoreModel {

	// The dir used by the HenshinResourceSet to resolve relative paths.
	private static final String BASEDIR = "src/org/eclipse/emf/henshin/examples/apibasics/models";

	public static void main(String[] args) {
		EObject model = createModel();
		saveModel(model);		
	}

	public static EObject createModel() {
		// Model elements can be created by the generated factory.
		BoxingFactory fac = BoxingFactory.eINSTANCE;
		Boxing boxing = fac.createBoxing();

		/*
		 * Getters for attributes and references are automatically generated by
		 * the code* generator. Use them to get and changes the contents of the
		 * model elements.
		 */
		boxing.getBoxes().add(fac.createBox());
		boxing.getItems().add(fac.createItem());
		return boxing;
	}
	
	public static void saveModel(EObject model) {
		/*
		 * Models can be saved by putting them into a Resource. Resources are 
		 * managed by ResourceSets. The Henshin versions of these types are a 
		 * bit easier to use.
		 */
		HenshinResourceSet rs = new HenshinResourceSet(BASEDIR);
		Resource res = rs.createResource("createdInstanceStatic.xmi");
		res.getContents().add(model);

		try {
			res.save(null);
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
	}
}
