/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.variability.mergein.clustering.extension;

import java.util.Map;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.variability.mergein.clone.CloneGroup;

public class ExtensionCloneRelation {
    public static boolean isExtensionClone(CloneGroup basis, CloneGroup extension) {
        return basis.getSize() < extension.getSize() && basis.getRules().containsAll(extension.getRules()) && ExtensionCloneRelation.containsMapping(basis, extension);
    }

    private static boolean containsMapping(CloneGroup subCloneCandidate, CloneGroup superClone) {
        Map<Rule, Node> innerMapSuper;
        Map<Rule, Node> innerMap;
        for (Node node : subCloneCandidate.getNodeMappings().keySet()) {
            if (!superClone.getRules().contains(node.getGraph().getRule())) continue;
            innerMap = subCloneCandidate.getNodeMappings().get(node);
            innerMapSuper = superClone.getNodeMappings().get(node);
            if (innerMapSuper == null) {
                return false;
            }
            for (Rule rule : subCloneCandidate.getNodeMappings().get(node).keySet()) {
                if (!superClone.getRules().contains(rule) || innerMap.get(rule) == innerMapSuper.get(rule)) continue;
                return false;
            }
        }
        for (Edge edge : subCloneCandidate.getEdgeMappings().keySet()) {
            if (!superClone.getRules().contains(edge.getGraph().getRule())) continue;
            innerMap = subCloneCandidate.getEdgeMappings().get(edge);
            innerMapSuper = superClone.getEdgeMappings().get(edge);
            if (innerMapSuper == null) {
                return false;
            }
            for (Rule rule : subCloneCandidate.getEdgeMappings().get(edge).keySet()) {
                if (!superClone.getRules().contains(rule) || innerMap.get(rule) == innerMapSuper.get(rule)) continue;
                return false;
            }
        }
        for (Attribute attribute : subCloneCandidate.getAttributeMappings().keySet()) {
            if (!superClone.getRules().contains(attribute.getGraph().getRule())) continue;
            innerMap = subCloneCandidate.getAttributeMappings().get(attribute);
            innerMapSuper = superClone.getAttributeMappings().get(attribute);
            if (innerMapSuper == null) {
                return false;
            }
            for (Rule rule : subCloneCandidate.getAttributeMappings().get(attribute).keySet()) {
                if (!superClone.getRules().contains(rule) || innerMap.get(rule) == innerMapSuper.get(rule)) continue;
                return false;
            }
        }
        return true;
    }
}

