/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.wizards.pages.simple;

import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.provider.EcoreItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gmf.internal.bridge.ui.Plugin;
import org.eclipse.gmf.internal.bridge.wizards.pages.simple.Resolution;
import org.eclipse.gmf.internal.bridge.wizards.pages.simple.ResolvedItem;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

class DomainModelViewerFactory {
    DomainModelViewerFactory() {
    }

    public static TreeViewer createViewer(Tree tree, boolean withLabes) {
        TreeViewer viewer = new TreeViewer(tree);
        viewer.setContentProvider((IContentProvider)new ResolverContentProvider());
        EcoreItemProviderAdapterFactory adapterFactory = new EcoreItemProviderAdapterFactory();
        viewer.setLabelProvider((IBaseLabelProvider)new ResolverLabelProvider((ILabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)adapterFactory)));
        if (withLabes) {
            viewer.setColumnProperties(new String[]{"no", Resolution.NODE.getName(), Resolution.LINK.getName(), Resolution.LABEL.getName()});
            CellEditor[] cellEditorArray = new CellEditor[4];
            cellEditorArray[1] = new CheckboxCellEditor();
            cellEditorArray[2] = new CheckboxCellEditor();
            cellEditorArray[3] = new CheckboxCellEditor();
            viewer.setCellEditors(cellEditorArray);
        } else {
            viewer.setColumnProperties(new String[]{"no", Resolution.NODE.getName(), Resolution.LINK.getName()});
            CellEditor[] cellEditorArray = new CellEditor[3];
            cellEditorArray[1] = new CheckboxCellEditor();
            cellEditorArray[2] = new CheckboxCellEditor();
            viewer.setCellEditors(cellEditorArray);
        }
        viewer.setCellModifier((ICellModifier)new ResolverCellModifier(viewer, withLabes));
        return viewer;
    }

    private static class ResolverCellModifier
    implements ICellModifier {
        private TreeViewer viewer;
        private boolean withLabels;

        public ResolverCellModifier(TreeViewer viewer, boolean withLabels) {
            this.viewer = viewer;
            this.withLabels = withLabels;
        }

        public Object getValue(Object element, String property) {
            ResolvedItem item = (ResolvedItem)element;
            return item.getResolution() == Resolution.getByName(property);
        }

        public boolean canModify(Object element, String property) {
            ResolvedItem item = (ResolvedItem)element;
            return !item.isDisabled();
        }

        public void modify(Object element, String property, Object value) {
            Resolution resolution;
            ResolvedItem item = (ResolvedItem)((TreeItem)element).getData();
            if (!item.isPossibleResolution(resolution = Resolution.getByName(property))) {
                return;
            }
            item.setResolution((Boolean)value != false ? resolution : null);
            if (this.withLabels) {
                this.viewer.update((Object)item, new String[]{Resolution.NODE.getName(), Resolution.LINK.getName(), Resolution.LABEL.getName()});
            } else {
                this.viewer.update((Object)item, new String[]{Resolution.NODE.getName(), Resolution.LINK.getName()});
            }
        }
    }

    private static class ResolverContentProvider
    implements ITreeContentProvider {
        private ResolverContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object getParent(Object element) {
            return ((ResolvedItem)element).getParent();
        }

        public Object[] getChildren(Object parentElement) {
            List<ResolvedItem> children = ((ResolvedItem)parentElement).getChildren();
            return children.toArray();
        }

        public boolean hasChildren(Object element) {
            List<ResolvedItem> children = ((ResolvedItem)element).getChildren();
            return !children.isEmpty();
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }
    }

    private static class ResolverLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private ILabelProvider domainLabelProvider;

        public ResolverLabelProvider(ILabelProvider domainLabelProvider) {
            this.domainLabelProvider = domainLabelProvider;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                Object domainRef = ((ResolvedItem)element).getDomainRef();
                return this.domainLabelProvider.getText(domainRef);
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                Object domainRef = ((ResolvedItem)element).getDomainRef();
                return this.domainLabelProvider.getImage(domainRef);
            }
            ResolvedItem item = (ResolvedItem)element;
            Image image = this.getResolutionImage(element, columnIndex);
            if (item.isDisabled() && image != null) {
                return Plugin.getDefault().getImageRegistry().get("/icons/cview16/grayed.gif");
            }
            return image;
        }

        protected Image getResolutionImage(Object element, int columnIndex) {
            ResolvedItem item = (ResolvedItem)element;
            Image checkedIcon = Plugin.getDefault().getImageRegistry().get("/icons/cview16/checked.gif");
            Image uncheckedIcon = Plugin.getDefault().getImageRegistry().get("/icons/cview16/unchecked.gif");
            if (columnIndex == 1) {
                if (!item.isPossibleResolution(Resolution.NODE)) {
                    return null;
                }
                return Resolution.NODE == item.getResolution() ? checkedIcon : uncheckedIcon;
            }
            if (columnIndex == 2) {
                if (!item.isPossibleResolution(Resolution.LINK)) {
                    return null;
                }
                return Resolution.LINK == item.getResolution() ? checkedIcon : uncheckedIcon;
            }
            if (columnIndex == 3) {
                if (!item.isPossibleResolution(Resolution.LABEL)) {
                    return null;
                }
                return Resolution.LABEL == item.getResolution() ? checkedIcon : uncheckedIcon;
            }
            return null;
        }
    }
}

