/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmf.internal.xpand.ResourceManager;
import org.eclipse.gmf.internal.xpand.build.MetaModelSource;
import org.eclipse.gmf.internal.xpand.build.WorkspaceResourceManager;
import org.osgi.framework.BundleContext;

public class Activator
extends Plugin {
    private static Activator anInstance;
    private final Map<IProject, ResourceManager> resourceManagers = new HashMap<IProject, ResourceManager>();
    private final Set<MetaModelSource> modelSources = new LinkedHashSet<MetaModelSource>();

    public void start(BundleContext context) throws Exception {
        super.start(context);
        anInstance = this;
    }

    public void stop(BundleContext context) throws Exception {
        anInstance = null;
        super.stop(context);
    }

    public static String getId() {
        return anInstance.getBundle().getSymbolicName();
    }

    public static void logWarn(String message) {
        Activator.log((IStatus)new Status(2, Activator.getId(), 0, message, null));
    }

    public static void logError(Exception e) {
        if (e instanceof CoreException) {
            Activator.log(((CoreException)e).getStatus());
        } else {
            Activator.log((IStatus)new Status(4, Activator.getId(), 0, e.getMessage(), (Throwable)e));
        }
    }

    public static void log(IStatus status) {
        anInstance.getLog().log(status);
    }

    public static ResourceManager getResourceManager(IProject context) {
        if (Activator.anInstance.resourceManagers.containsKey(context)) {
            return Activator.anInstance.resourceManagers.get(context);
        }
        WorkspaceResourceManager resourceManager = new WorkspaceResourceManager(context);
        Activator.registerResourceManager(context, resourceManager);
        return resourceManager;
    }

    public static void registerResourceManager(IProject project, ResourceManager resourceManager) {
        assert (!Activator.anInstance.resourceManagers.containsKey(project));
        Activator.anInstance.resourceManagers.put(project, resourceManager);
    }

    public static void registerModelSource(MetaModelSource modelSource) {
        assert (modelSource != null);
        Activator.anInstance.modelSources.add(modelSource);
    }

    public static EPackage findMetaModel(String nsURI) {
        if (anInstance == null) {
            return null;
        }
        for (MetaModelSource s : Activator.anInstance.modelSources) {
            EPackage p = s.find(nsURI);
            if (p == null) continue;
            return p;
        }
        return EPackage.Registry.INSTANCE.getEPackage(nsURI);
    }
}

