/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.actions.internal;

import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.ui.actions.DiagramAction;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsMessages;
import org.eclipse.gmf.runtime.diagram.ui.actions.internal.l10n.DiagramUIActionsPluginImages;
import org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.ui.IWorkbenchPage;

public class AutoSizeAction
extends DiagramAction {
    protected String getCommandLabel() {
        return DiagramUIActionsMessages.AutoSizeAction_ActionLabelText;
    }

    public AutoSizeAction(IWorkbenchPage workbenchPage) {
        super(workbenchPage);
        this.setText(DiagramUIActionsMessages.AutoSizeAction_ActionLabelText);
        this.setId("autoSizeAction");
        this.setToolTipText(DiagramUIActionsMessages.AutoSizeAction_ActionToolTipText);
        this.setImageDescriptor(DiagramUIActionsPluginImages.DESC_AUTOSIZE);
        this.setDisabledImageDescriptor(DiagramUIActionsPluginImages.DESC_AUTOSIZE_DISABLED);
        this.setHoverImageDescriptor(DiagramUIActionsPluginImages.DESC_AUTOSIZE);
    }

    protected Request createTargetRequest() {
        return new Request((Object)"autosize");
    }

    protected boolean isSelectionListener() {
        return true;
    }

    protected boolean isOperationHistoryListener() {
        return true;
    }

    protected Command getCommand(Request request) {
        boolean foundNonAutosizedPart = false;
        List operationSet = this.getOperationSet();
        Iterator editParts = operationSet.iterator();
        CompoundCommand command = new CompoundCommand(this.getCommandLabel());
        while (editParts.hasNext()) {
            Command curCommand;
            EditPart editPart = (EditPart)editParts.next();
            if (editPart instanceof GraphicalEditPart) {
                GraphicalEditPart graphicalEditPart = (GraphicalEditPart)editPart;
                Integer containerWidth = (Integer)graphicalEditPart.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Width());
                Integer containerHeight = (Integer)graphicalEditPart.getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getSize_Height());
                if (containerWidth != -1 || containerHeight != -1) {
                    foundNonAutosizedPart = true;
                }
            }
            if ((curCommand = editPart.getCommand(request)) == null) continue;
            command.add(curCommand);
        }
        return command.isEmpty() || command.size() != operationSet.size() || !foundNonAutosizedPart ? UnexecutableCommand.INSTANCE : command;
    }
}

