/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.ast;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.gmf.internal.xpand.BuiltinMetaModel;
import org.eclipse.gmf.internal.xpand.ast.Statement;
import org.eclipse.gmf.internal.xpand.expression.ast.Identifier;
import org.eclipse.gmf.internal.xpand.model.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.model.EvaluationException;
import org.eclipse.gmf.internal.xpand.model.ExecutionContext;
import org.eclipse.gmf.internal.xpand.model.Variable;
import org.eclipse.gmf.internal.xpand.ocl.ExpressionHelper;
import org.eclipse.ocl.cst.OCLExpressionCS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LetStatement
extends Statement {
    private final Identifier varName;
    private final ExpressionHelper varValue;
    private final Statement[] body;

    public LetStatement(int start, int end, int line, Identifier varName, OCLExpressionCS value, Statement[] body) {
        super(start, end, line);
        this.varName = varName;
        this.varValue = new ExpressionHelper(value, this);
        this.body = body;
    }

    @Override
    public void analyze(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        ctx = ctx.cloneWithVariable(new Variable(this.varName.getValue(), this.getVarType(ctx, issues), null));
        Statement[] statementArray = this.body;
        int n = this.body.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement = statementArray[n2];
            statement.analyze(ctx, issues);
            ++n2;
        }
    }

    @Override
    public void evaluateInternal(ExecutionContext ctx) {
        HashSet<AnalysationIssue> issues = new HashSet<AnalysationIssue>();
        EClassifier varType = this.getVarType(ctx, issues);
        if (issues.size() > 0) {
            throw new EvaluationException("Can't evaluate LET expression: variable type cannot be defined", this.varValue);
        }
        Object evaluatedVarValue = this.varValue.evaluate(ctx);
        if (!BuiltinMetaModel.isAssignableFrom(ctx, varType, BuiltinMetaModel.getType(ctx, evaluatedVarValue))) {
            throw new EvaluationException("Can't evaluate LET expression: actual variable type is not assignable to declared one", this);
        }
        ctx = ctx.cloneWithVariable(new Variable(this.varName.getValue(), varType, evaluatedVarValue));
        Statement[] statementArray = this.body;
        int n = this.body.length;
        int n2 = 0;
        while (n2 < n) {
            Statement statement = statementArray[n2];
            statement.evaluate(ctx);
            ++n2;
        }
    }

    private EClassifier getVarType(ExecutionContext ctx, Set<AnalysationIssue> issues) {
        EClassifier t = this.varValue.analyze(ctx, issues);
        return t == null ? (t = EcorePackage.eINSTANCE.getEObject()) : t;
    }
}

