/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.bridge.ui;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Plugin
extends AbstractUIPlugin {
    public static final String CHECKED_ICON = "/icons/cview16/checked.gif";
    public static final String UNCHECKED_ICON = "/icons/cview16/unchecked.gif";
    public static final String NODE_ICON = "/icons/cview16/node.gif";
    public static final String LINK_ICON = "/icons/cview16/link.gif";
    public static final String LABEL_ICON = "/icons/cview16/label.gif";
    private static Plugin plugin;

    public Plugin() {
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        plugin = null;
    }

    public static Plugin getDefault() {
        return plugin;
    }

    public static String getBundleString(String key) {
        return Platform.getResourceBundle((Bundle)Plugin.getDefault().getBundle()).getString(key);
    }

    public static String getBundleString(String key, Object[] args) {
        String val = Plugin.getBundleString(key);
        if (val == null) {
            return key;
        }
        return MessageFormat.format(val, args);
    }

    protected void initializeImageRegistry(ImageRegistry reg) {
        this.loadImage(reg, CHECKED_ICON);
        this.loadImage(reg, UNCHECKED_ICON);
        this.loadImage(reg, NODE_ICON);
        this.loadImage(reg, LINK_ICON);
        this.loadImage(reg, LABEL_ICON);
    }

    protected void loadImage(ImageRegistry registry, String id) {
        this.loadImage(registry, id, this.getBundle().getSymbolicName());
    }

    protected void loadImage(ImageRegistry registry, String id, String bundleId) {
        ImageDescriptor descriptor = Plugin.imageDescriptorFromPlugin((String)bundleId, (String)id);
        if (descriptor != null) {
            registry.put(id, descriptor);
        }
    }

    public static void log(CoreException ex) {
        Plugin.log(ex.getStatus());
    }

    public static void log(Exception ex) {
        if (ex instanceof CoreException) {
            Plugin.log((CoreException)ex);
        } else {
            Plugin.log((IStatus)new Status(4, Plugin.getPluginID(), 0, ex.getMessage(), (Throwable)ex));
        }
    }

    public static String getPluginID() {
        return Plugin.getDefault().getBundle().getSymbolicName();
    }

    public static void log(IStatus s) {
        Plugin.getDefault().getLog().log(s);
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.gmf.bridge.ui", (String)path);
    }
}

