/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.graphdef.editor.part;

import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.graphdef.editor.edit.parts.CanvasEditPart;
import org.eclipse.gmf.graphdef.editor.part.GMFGraphDiagramEditorUtil;
import org.eclipse.gmf.graphdef.editor.part.GMFGraphDiagramFileCreator;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.ide.wizards.EditorWizardPage;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.util.DiagramFileCreator;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;

public class GMFGraphCreationWizardPage
extends EditorWizardPage {
    public GMFGraphCreationWizardPage(IWorkbench workbench, IStructuredSelection selection) {
        super("CreationWizardPage", workbench, selection);
        this.setTitle("Create GMFGraph Diagram");
        this.setDescription("Create a new GMFGraph diagram.");
    }

    public IFile createAndOpenDiagram(IPath containerPath, String fileName, InputStream initialContents, String kind, IWorkbenchWindow dWindow, IProgressMonitor progressMonitor, boolean saveDiagram) {
        return GMFGraphDiagramEditorUtil.createAndOpenDiagram(this.getDiagramFileCreator(), containerPath, fileName, initialContents, kind, dWindow, progressMonitor, this.isOpenNewlyCreatedDiagramEditor(), saveDiagram);
    }

    protected String getDefaultFileName() {
        return "default";
    }

    public DiagramFileCreator getDiagramFileCreator() {
        return GMFGraphDiagramFileCreator.getInstance();
    }

    protected String getDiagramKind() {
        return CanvasEditPart.MODEL_ID;
    }

    protected boolean validatePage() {
        if (super.validatePage()) {
            String fileName = this.getFileName();
            if (fileName == null) {
                return false;
            }
            IPath path = this.getContainerFullPath().append(this.getDiagramFileCreator().appendExtensionToFileName(fileName));
            path = path.removeFileExtension().addFileExtension("gmfgraph");
            if (ResourcesPlugin.getWorkspace().getRoot().exists(path)) {
                this.setErrorMessage("Model File already exists: " + path.lastSegment());
                return false;
            }
            return true;
        }
        return false;
    }
}

