/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.emf.clipboard.core.internal;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gmf.runtime.emf.clipboard.core.IClipboardSupportFactory;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.ClipboardPlugin;
import org.eclipse.gmf.runtime.emf.clipboard.core.internal.l10n.EMFClipboardCoreMessages;
import org.eclipse.osgi.util.NLS;

public class ClipboardSupportManager {
    public static final String EP_CLIPBOARD_SUPPORT = "org.eclipse.gmf.runtime.emf.clipboard.core.clipboardSupport";
    static final String E_NSURI = "nsURI";
    static final String E_CLASS = "class";
    static final String E_PRIORITY = "priority";
    private static final List PRIORITIES = Arrays.asList("lowest", "low", "medium", "high", "highest");
    private static final Map clipboardSupportMap = new HashMap();

    private ClipboardSupportManager() {
    }

    public static void configureExtensions(IConfigurationElement[] configs) {
        int i = 0;
        while (i < configs.length) {
            try {
                Descriptor desc = new Descriptor(configs[i]);
                Descriptor previous = (Descriptor)clipboardSupportMap.get(desc.getEPackage());
                if (previous == null || previous.getPriority() < desc.getPriority()) {
                    clipboardSupportMap.put(desc.getEPackage(), desc);
                }
            }
            catch (CoreException e) {
                ClipboardPlugin.getPlugin().log(e.getStatus());
            }
            ++i;
        }
    }

    public static IClipboardSupportFactory lookup(EPackage ePackage) {
        IClipboardSupportFactory result = null;
        Descriptor desc = (Descriptor)clipboardSupportMap.get(ePackage);
        if (desc != null) {
            result = desc.getFactory();
        }
        return result;
    }

    public static IClipboardSupportFactory lookup(EClass eClass) {
        return ClipboardSupportManager.lookup(eClass.getEPackage());
    }

    public static IClipboardSupportFactory lookup(EObject eObject) {
        return ClipboardSupportManager.lookup(eObject.eClass().getEPackage());
    }

    static IStatus createErrorStatus(int code, String message) {
        return ClipboardSupportManager.createErrorStatus(code, message, null);
    }

    static IStatus createErrorStatus(int code, String message, Throwable exception) {
        return new Status(4, ClipboardPlugin.getPlugin().getSymbolicName(), code, message, exception);
    }

    private static final class Descriptor {
        private final EPackage ePackage;
        private IClipboardSupportFactory factory;
        private IConfigurationElement config;
        private int priority = 2;
        static /* synthetic */ Class class$0;

        Descriptor(IConfigurationElement config) throws CoreException {
            this.config = config;
            String nsUri = config.getAttribute(ClipboardSupportManager.E_NSURI);
            if (nsUri == null || nsUri.length() == 0) {
                throw new CoreException(ClipboardSupportManager.createErrorStatus(30, NLS.bind((String)EMFClipboardCoreMessages.missing_nsUri_ERROR_, (Object[])new Object[]{"clipboardSupport", config.getDeclaringExtension().getNamespaceIdentifier()})));
            }
            this.ePackage = EPackage.Registry.INSTANCE.getEPackage(nsUri);
            if (this.ePackage == null) {
                throw new CoreException(ClipboardSupportManager.createErrorStatus(32, NLS.bind((String)EMFClipboardCoreMessages.unresolved_nsUri_ERROR_, (Object[])new Object[]{"clipboardSupport", nsUri, config.getDeclaringExtension().getNamespaceIdentifier()})));
            }
            String className = config.getAttribute(ClipboardSupportManager.E_CLASS);
            if (className == null || className.length() == 0) {
                throw new CoreException(ClipboardSupportManager.createErrorStatus(31, NLS.bind((String)EMFClipboardCoreMessages.missing_class_ERROR_, (Object[])new Object[]{"clipboardSupport", config.getDeclaringExtension().getNamespaceIdentifier()})));
            }
            String priorityStr = config.getAttribute(ClipboardSupportManager.E_PRIORITY);
            if (priorityStr != null) {
                priorityStr = priorityStr.toLowerCase();
                if (PRIORITIES.contains(priorityStr)) {
                    this.priority = PRIORITIES.indexOf(priorityStr);
                }
            }
        }

        EPackage getEPackage() {
            return this.ePackage;
        }

        int getPriority() {
            return this.priority;
        }

        IClipboardSupportFactory getFactory() {
            if (this.factory == null && this.config != null) {
                this.factory = this.createFactory();
            }
            return this.factory;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private IClipboardSupportFactory createFactory() {
            IClipboardSupportFactory result = null;
            try {
                try {
                    result = (IClipboardSupportFactory)this.config.createExecutableExtension(ClipboardSupportManager.E_CLASS);
                }
                catch (CoreException e) {
                    ClipboardPlugin.getPlugin().log(e.getStatus());
                }
                catch (Exception e) {
                    ClipboardPlugin.Implementation implementation = ClipboardPlugin.getPlugin();
                    Object[] objectArray = new Object[2];
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        Class<?> clazz2;
                        try {
                            clazz2 = Class.forName("org.eclipse.gmf.runtime.emf.clipboard.core.IClipboardSupportFactory");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                        clazz = class$0 = clazz2;
                    }
                    objectArray[0] = clazz.getName();
                    objectArray[1] = this.config.getAttribute(ClipboardSupportManager.E_CLASS);
                    implementation.log(ClipboardSupportManager.createErrorStatus(33, NLS.bind((String)EMFClipboardCoreMessages.factory_failed_ERROR_, (Object[])objectArray), e));
                }
            }
            catch (Throwable throwable) {
                Object var3_5 = null;
                this.config = null;
                throw throwable;
            }
            {
                Object var3_6 = null;
                this.config = null;
                return result;
            }
        }
    }
}

