/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.setup;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import junit.framework.TestCase;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.gmf.codegen.gmfgen.GMFGenPackage;
import org.eclipse.gmf.codegen.gmfgen.GenEditorGenerator;
import org.eclipse.gmf.gmfgraph.Canvas;
import org.eclipse.gmf.gmfgraph.Connection;
import org.eclipse.gmf.gmfgraph.Node;
import org.eclipse.gmf.gmfgraph.util.Assistant;
import org.eclipse.gmf.mappings.GMFMapPackage;
import org.eclipse.gmf.tests.Plugin;
import org.eclipse.gmf.tests.setup.DiaDefFileSetup;
import org.eclipse.gmf.tests.setup.DiaDefSetup;
import org.eclipse.gmf.tests.setup.DiaDefSource;
import org.eclipse.gmf.tests.setup.DiaGenFileSetup;
import org.eclipse.gmf.tests.setup.DiaGenSetup;
import org.eclipse.gmf.tests.setup.DiaGenSource;
import org.eclipse.gmf.tests.setup.DomainModelSetup;
import org.eclipse.gmf.tests.setup.DomainModelSource;
import org.eclipse.gmf.tests.setup.MapDefFileSetup;
import org.eclipse.gmf.tests.setup.MapSetup;
import org.eclipse.gmf.tests.setup.MultiPackageGenSetup;
import org.eclipse.gmf.tests.setup.MultiplePackagesDomainModelSetup;
import org.eclipse.gmf.tests.setup.ToolDefSetup;

public class TestSetupTest
extends TestCase {
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.gmf.tests.setup.TestSetupTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public TestSetupTest(String name) {
        super(name);
    }

    public void testLibraryMap() {
        try {
            MapDefFileSetup s = new MapDefFileSetup().init(Plugin.createURI("/models/library/library.gmfmap"));
            TestSetupTest.doAssert(Diagnostician.INSTANCE.validate((EObject)s.getMapping().getDiagram()));
        }
        catch (IOException ex) {
            TestSetupTest.fail((String)ex.getMessage());
        }
    }

    public void testLibraryGen() {
        try {
            DiaGenFileSetup s = new DiaGenFileSetup().init(Plugin.createURI("/models/library/library.gmfgen"));
            TestSetupTest.doAssert(Diagnostician.INSTANCE.validate((EObject)s.getGenDiagram()));
        }
        catch (IOException ex) {
            TestSetupTest.fail((String)ex.getMessage());
        }
    }

    public void testBasicGraphDefModel() {
        try {
            DiaDefFileSetup s = new DiaDefFileSetup().init(Assistant.getBasicGraphDef());
            this.doDiaDefTests(s);
        }
        catch (IOException ex) {
            TestSetupTest.fail((String)ex.getMessage());
        }
    }

    public void testDiaDefSetupNoConfig() {
        DiaDefSetup s = new DiaDefSetup().init();
        this.doDiaDefTests(s);
    }

    public void testDiaDefGenerateSetupWithConfig() {
        final boolean[] setupCanvasDef = new boolean[1];
        final boolean[] setupLinkDef = new boolean[1];
        final boolean[] setupNodeDef = new boolean[1];
        DiaDefSetup s = new DiaDefSetup(){

            public void setupCanvasDef(Canvas canvasDef) {
                setupCanvasDef[0] = true;
            }

            public void setupLinkDef(Connection linkDef) {
                setupLinkDef[0] = true;
            }

            public void setupNodeDef(Node nodeDef) {
                setupNodeDef[0] = true;
            }
        }.init();
        TestSetupTest.assertTrue((String)"DiaDefGenerateSetup.Config.setupNodeDef()", (boolean)setupNodeDef[0]);
        TestSetupTest.assertTrue((String)"DiaDefGenerateSetup.Config.setupLinkDef()", (boolean)setupLinkDef[0]);
        TestSetupTest.assertTrue((String)"DiaDefGenerateSetup.Config.setupCanvasDef()", (boolean)setupCanvasDef[0]);
        this.doDiaDefTests(s);
    }

    public void testDomainModelSetup() {
        DomainModelSetup s = new DomainModelSetup().init();
        TestSetupTest.doDomainSourceTests(s);
    }

    public void testExtendedValidationIsOn() {
        EValidator vMap = EValidator.Registry.INSTANCE.getEValidator((EPackage)GMFMapPackage.eINSTANCE);
        TestSetupTest.assertNotNull((String)"No validator set for gmfmap", (Object)vMap);
        TestSetupTest.assertNotSame((String)"Default validator is in use for gmfmap", (Object)EValidator.Registry.INSTANCE.getEValidator(null), (Object)vMap);
        EValidator vGen = EValidator.Registry.INSTANCE.getEValidator((EPackage)GMFGenPackage.eINSTANCE);
        TestSetupTest.assertNotNull((String)"No validator set for gmfgen", (Object)vGen);
        TestSetupTest.assertNotSame((String)"Default validator is in use for gmfgen", (Object)EValidator.Registry.INSTANCE.getEValidator(null), (Object)vGen);
    }

    public void testMultiPackageSetup() throws Exception {
        MultiplePackagesDomainModelSetup s = new MultiplePackagesDomainModelSetup().init();
        TestSetupTest.doDomainSourceTests(s);
        HashSet<EPackage> additionalPacks = new HashSet<EPackage>(8);
        additionalPacks.add(s.getNodeA().getEClass().getEPackage());
        additionalPacks.add(s.getNodeB().getEClass().getEPackage());
        additionalPacks.add(s.getLinkAsClass().getEClass().getEPackage());
        DiaDefFileSetup gmfGraph = new DiaDefFileSetup().init(Assistant.getBasicGraphDef());
        ToolDefSetup toolDef = new ToolDefSetup();
        MapSetup mapSource = new MapSetup().init(gmfGraph, s, toolDef);
        Resource resource = s.getModel().eResource();
        resource.getContents().add((Object)mapSource.getMapping());
        resource.getContents().add((Object)toolDef.getRegistry());
        TestSetupTest.confineInResource((EObject)mapSource.getMapping());
        TestSetupTest.doAssert("Map", Diagnostician.INSTANCE.validate((EObject)mapSource.getMapping().getDiagram()));
        this.doDiaGenTests(new MultiPackageGenSetup(additionalPacks).init(mapSource));
    }

    public void testDiaGenSetupDM() {
        this.doDiaGenTests(new DiaGenSetup().init(new DomainModelSetup().init()));
    }

    public void testDiaGenSetupMap() {
        DomainModelSetup ds = new DomainModelSetup().init();
        MapSetup ms = new MapSetup().init(new DiaDefSetup().init(), ds, new ToolDefSetup());
        this.doDiaGenTests(new DiaGenSetup().init(ms));
    }

    private void doDiaDefTests(DiaDefSource s) {
        TestSetupTest.doAssert(Diagnostician.INSTANCE.validate((EObject)s.getCanvasDef()));
    }

    private void doDiaGenTests(DiaGenSource s) {
        GenEditorGenerator editorGen = s.getGenDiagram().getEditorGen();
        TestSetupTest.confineInResource((EObject)editorGen);
        Diagnostic d = Diagnostician.INSTANCE.validate((EObject)s.getNodeA());
        TestSetupTest.doAssert("GenNode", d);
        d = Diagnostician.INSTANCE.validate((EObject)s.getLinkC());
        TestSetupTest.doAssert("GenLink", d);
        d = Diagnostician.INSTANCE.validate((EObject)s.getGenDiagram());
        TestSetupTest.doAssert("GenDiagram", d);
        d = Diagnostician.INSTANCE.validate((EObject)editorGen);
        TestSetupTest.doAssert("EditorGenerator", d);
    }

    private static void confineInResource(EObject eObject) {
        new ResourceSetImpl().createResource(URI.createURI((String)"uri://fake")).getContents().add((Object)eObject);
    }

    private static void doDomainSourceTests(DomainModelSource s) {
        TestSetupTest.doAssert(Diagnostician.INSTANCE.validate((EObject)s.getDiagramElement()));
        TestSetupTest.doAssert(Diagnostician.INSTANCE.validate((EObject)s.getNodeA().getEClass()));
        TestSetupTest.doAssert(Diagnostician.INSTANCE.validate((EObject)s.getLinkAsRef()));
        TestSetupTest.doAssert(Diagnostician.INSTANCE.validate((EObject)s.getLinkAsClass().getEClass()));
        TestSetupTest.doAssert(Diagnostician.INSTANCE.validate((EObject)s.getModel()));
    }

    private static void doAssert(Diagnostic d) {
        TestSetupTest.doAssert("", d);
    }

    private static void doAssert(String prefix, Diagnostic d) {
        TestSetupTest.assertTrue((String)TestSetupTest.formatMessage(prefix, d), (d.getSeverity() == 0 ? 1 : 0) != 0);
    }

    private static String formatMessage(String prefix, Diagnostic d) {
        return String.valueOf(prefix) + "(severity=" + TestSetupTest.getSeverityTitle(d) + "):" + TestSetupTest.getSeverityMessage(d);
    }

    private static String getSeverityTitle(Diagnostic d) {
        if ((d.getSeverity() & 8) != 0) {
            return "CANCEL";
        }
        if ((d.getSeverity() & 4) != 0) {
            return "ERROR";
        }
        if ((d.getSeverity() & 2) != 0) {
            return "WARN";
        }
        if ((d.getSeverity() & 1) != 0) {
            return "INFO";
        }
        if (!$assertionsDisabled && d.getSeverity() != 0) {
            throw new AssertionError();
        }
        return "OK";
    }

    private static String getSeverityMessage(Diagnostic d) {
        Iterator it = d.getChildren().iterator();
        while (it.hasNext()) {
            Diagnostic child = (Diagnostic)it.next();
            if (child.getSeverity() != d.getSeverity()) continue;
            if (child.getChildren().isEmpty()) {
                return child.getMessage();
            }
            it = child.getChildren().iterator();
        }
        return d.getMessage();
    }
}

