/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.common.reconcile;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.gmf.internal.common.Activator;
import org.eclipse.gmf.internal.common.reconcile.Cleaner;
import org.eclipse.gmf.internal.common.reconcile.Copier;
import org.eclipse.gmf.internal.common.reconcile.Decision;
import org.eclipse.gmf.internal.common.reconcile.Matcher;
import org.eclipse.gmf.internal.common.reconcile.ReconcilerConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Reconciler {
    private final ReconcilerConfig myConfig;
    private final Map<EObject, List<EStructuralFeature.Setting>> myCrossRefsToFix;
    private final Map<EObject, EObject> myMatches;
    private boolean myIsMatching;
    private final boolean traceMatches;
    private final boolean traceDecision;
    private final boolean traceFeatureInDecision;
    private final boolean traceCrossRefUpdate;

    public Reconciler(ReconcilerConfig config) {
        this.myConfig = config;
        this.myCrossRefsToFix = new LinkedHashMap<EObject, List<EStructuralFeature.Setting>>();
        this.myMatches = new LinkedHashMap<EObject, EObject>();
        this.traceMatches = Boolean.parseBoolean(Platform.getDebugOption((String)(String.valueOf(Activator.getID()) + "/reconciler/" + "traceMatches")));
        this.traceDecision = Boolean.parseBoolean(Platform.getDebugOption((String)(String.valueOf(Activator.getID()) + "/reconciler/" + "traceDecision")));
        this.traceFeatureInDecision = Boolean.parseBoolean(Platform.getDebugOption((String)(String.valueOf(Activator.getID()) + "/reconciler/" + "traceDecision" + "/features")));
        this.traceCrossRefUpdate = Boolean.parseBoolean(Platform.getDebugOption((String)(String.valueOf(Activator.getID()) + "/reconciler/" + "traceCrossRefUpdate")));
    }

    protected void handleNotMatchedCurrent(EObject current) {
        Cleaner cleaner = this.myConfig.getCleaner(current.eClass());
        cleaner.clear(current);
    }

    protected EObject handleNotMatchedOld(EObject currentParent, EObject notMatchedOld) {
        Copier copier = this.myConfig.getCopier(notMatchedOld.eClass());
        return copier.copyToCurrent(currentParent, notMatchedOld, this);
    }

    public void reconcileResource(Resource current, Resource old) {
        this.reconcileContents(null, (Collection<EObject>)current.getContents(), (Collection<EObject>)old.getContents());
        this.updateCrossReferences();
    }

    public void reconcileTree(EObject currentRoot, EObject oldRoot) {
        this.internalReconcileTree(currentRoot, oldRoot);
        this.updateCrossReferences();
    }

    protected void reconcileVertex(EObject current, EObject old) {
        assert (current.eClass().equals(old.eClass()));
        this.registerMatch(current, old);
        Decision[] decisionArray = this.myConfig.getDecisions(current.eClass());
        int n = decisionArray.length;
        int n2 = 0;
        while (n2 < n) {
            Decision decision = decisionArray[n2];
            decision.apply(current, old);
            if (this.traceDecision) {
                Reconciler.trace(this.traceFeatureInDecision ? "[decision] %s (%s)" : "[decision] %s", decision.getClass().getName(), decision.getFeature().getName());
            }
            ++n2;
        }
    }

    protected void internalReconcileTree(EObject currentRoot, EObject oldRoot) {
        this.reconcileVertex(currentRoot, oldRoot);
        this.reconcileContents(currentRoot, (Collection<EObject>)currentRoot.eContents(), (Collection<EObject>)oldRoot.eContents());
    }

    protected void registerMatch(EObject current, EObject old) {
        this.myMatches.put(old, current);
        if (this.traceMatches) {
            Reconciler.trace("[matched]%s -> %s", old.eClass().getName(), current.eClass().getName());
        }
    }

    protected void updateCrossReferences() {
        for (Map.Entry<EObject, List<EStructuralFeature.Setting>> e : this.myCrossRefsToFix.entrySet()) {
            EObject oldReferenceTarget = e.getKey();
            if (this.myMatches.containsKey(oldReferenceTarget)) {
                EObject copied = this.myMatches.get(oldReferenceTarget);
                if (this.traceCrossRefUpdate) {
                    Reconciler.trace("[crossRefUpd] matched %s -> %s", oldReferenceTarget, copied);
                }
                for (EStructuralFeature.Setting s : e.getValue()) {
                    if (this.myMatches.containsKey(s.getEObject())) {
                        EObject newOwner = this.myMatches.get(s.getEObject());
                        if (this.traceCrossRefUpdate) {
                            Reconciler.trace("[crossRefUpd] updating '%s' value of %s", s.getEStructuralFeature().getName(), newOwner);
                        }
                        if (s.getEStructuralFeature().isMany() || FeatureMapUtil.isMany((EObject)s.getEObject(), (EStructuralFeature)s.getEStructuralFeature())) {
                            List values = (List)newOwner.eGet(s.getEStructuralFeature());
                            assert (!values.contains(copied));
                            if (values.contains(oldReferenceTarget)) {
                                values.set(values.indexOf(oldReferenceTarget), copied);
                                continue;
                            }
                            values.add(copied);
                            continue;
                        }
                        newOwner.eSet(s.getEStructuralFeature(), (Object)copied);
                        continue;
                    }
                    if (!this.traceCrossRefUpdate) continue;
                    Reconciler.trace("[crossRefUpd] no matching owner for %s (old owner: %s)", s.getEStructuralFeature().getName(), s.getEObject());
                }
                continue;
            }
            if (!this.traceCrossRefUpdate) continue;
            Reconciler.trace("[crossRefUpd] no match for old %s", oldReferenceTarget);
        }
    }

    void registerCrossReferencesToUpdate(Map<EObject, Collection<EStructuralFeature.Setting>> crossReferences) {
        for (Map.Entry<EObject, Collection<EStructuralFeature.Setting>> e : crossReferences.entrySet()) {
            List<EStructuralFeature.Setting> entries = this.myCrossRefsToFix.get(e.getKey());
            if (entries == null) {
                entries = new LinkedList<EStructuralFeature.Setting>();
                this.myCrossRefsToFix.put(e.getKey(), entries);
            }
            for (EStructuralFeature.Setting s : e.getValue()) {
                if (!s.getEStructuralFeature().isChangeable()) continue;
                entries.add(s);
            }
            if (!entries.isEmpty()) continue;
            this.myCrossRefsToFix.remove(e.getKey());
        }
    }

    private void reconcileContents(EObject currentParent, Collection<EObject> allCurrents, Collection<EObject> allOlds) {
        if (allCurrents.isEmpty() && allOlds.isEmpty()) {
            return;
        }
        LinkedList<Pair> storage = new LinkedList<Pair>();
        this.match(allCurrents, allOlds, storage);
        for (Pair next : storage) {
            EObject nextCurrent = next.current;
            EObject nextOld = next.old;
            assert (nextCurrent != null || nextOld != null);
            if (nextCurrent == null && currentParent != null) {
                nextCurrent = this.handleNotMatchedOld(currentParent, nextOld);
            }
            if (nextCurrent != null && nextOld != null) {
                this.internalReconcileTree(nextCurrent, nextOld);
                continue;
            }
            if (nextOld != null) continue;
            this.handleNotMatchedCurrent(nextCurrent);
        }
    }

    private void match(Collection<EObject> currents, Collection<EObject> olds, Collection<Pair> output) {
        assert (!this.myIsMatching);
        try {
            this.myIsMatching = true;
            LinkedHashSet<EObject> myOlds = new LinkedHashSet<EObject>(olds);
            LinkedList<EObject> myCurrents = new LinkedList<EObject>(currents);
            Iterator currentContents = myCurrents.iterator();
            while (!myOlds.isEmpty() && currentContents.hasNext()) {
                EObject nextCurrent = (EObject)currentContents.next();
                EObject matchedOld = this.removeMatched(nextCurrent, myOlds);
                output.add(new Pair(nextCurrent, matchedOld));
                currentContents.remove();
            }
            Iterator notMatchedOlds = myOlds.iterator();
            while (notMatchedOlds.hasNext()) {
                output.add(new Pair(null, (EObject)notMatchedOlds.next()));
            }
        }
        finally {
            this.myIsMatching = false;
        }
    }

    private EObject removeMatched(EObject current, Collection<EObject> allOld) {
        EClass eClass = current.eClass();
        Matcher matcher = this.myConfig.getMatcher(eClass);
        EObject result = null;
        if (matcher != Matcher.FALSE) {
            Iterator<EObject> all = allOld.iterator();
            while (all.hasNext()) {
                EObject next = all.next();
                if (!eClass.equals(next.eClass()) || !matcher.match(current, next)) continue;
                result = next;
                all.remove();
                break;
            }
        }
        return result;
    }

    private static void trace(String format, Object ... args) {
        Activator.log((IStatus)new Status(1, Activator.getID(), String.format(format, args)));
    }

    private static class Pair {
        public final EObject current;
        public final EObject old;

        public Pair(EObject cur, EObject old) {
            this.current = cur;
            this.old = old;
        }
    }
}

