/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.runtime.emf.commands.core.command;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.commands.operations.OperationHistoryFactory;
import org.eclipse.core.commands.operations.UndoContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.AbstractCommand;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;

public class CompositeTransactionalCommandTest
extends TestCase {
    private IOperationHistory history;
    private IProject project;

    public static void main(String[] args) {
        TestRunner.run((Test)CompositeTransactionalCommandTest.suite());
    }

    public static Test suite() {
        return new TestSuite(CompositeTransactionalCommandTest.class);
    }

    public CompositeTransactionalCommandTest(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.history = OperationHistoryFactory.getOperationHistory();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        this.project = root.getProject("AbstractCommandTest");
        this.project.create(null);
        this.project.open(null);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.project.close((IProgressMonitor)new NullProgressMonitor());
        this.project.delete(true, true, (IProgressMonitor)new NullProgressMonitor());
        this.project = null;
        this.history = null;
    }

    private List getFiles(String str) {
        IFile file = this.project.getFile(str);
        return Collections.singletonList(file);
    }

    public void test_execute_undo_redo() {
        TransactionalEditingDomain domain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
        ResourceImpl res = new ResourceImpl(URI.createURI((String)"file:/foo"));
        domain.getResourceSet().getResources().add((Object)res);
        TransactionalTestCommand child1 = new TransactionalTestCommand(domain, (Resource)res);
        TestCommand child2 = new TestCommand();
        TransactionalTestCommand child3 = new TransactionalTestCommand(domain, (Resource)res);
        UndoContext ctx = new UndoContext();
        CompositeTransactionalCommand c = new CompositeTransactionalCommand(domain, "test_execute_undo_redo");
        c.add((IUndoableOperation)child1);
        c.add((IUndoableOperation)child2);
        c.add((IUndoableOperation)child3);
        try {
            c.addContext((IUndoContext)ctx);
            this.history.execute((IUndoableOperation)c, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            CompositeTransactionalCommandTest.fail((String)("Should not have thrown: " + e.getLocalizedMessage()));
        }
        child1.assertExecuted();
        child2.assertExecuted();
        child3.assertExecuted();
        try {
            CompositeTransactionalCommandTest.assertTrue((boolean)this.history.canUndo((IUndoContext)ctx));
            this.history.undo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            CompositeTransactionalCommandTest.fail((String)("Should not have thrown: " + e.getLocalizedMessage()));
        }
        child1.assertUndone();
        child2.assertUndone();
        child3.assertUndone();
        try {
            CompositeTransactionalCommandTest.assertTrue((boolean)this.history.canRedo((IUndoContext)ctx));
            this.history.redo((IUndoContext)ctx, (IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            CompositeTransactionalCommandTest.fail((String)("Should not have thrown: " + e.getLocalizedMessage()));
        }
        child1.assertRedone();
        child2.assertRedone();
        child3.assertRedone();
    }

    public void test_compose() {
        TransactionalEditingDomain domain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
        CompositeTransactionalCommand c = new CompositeTransactionalCommand(domain, "test_compose");
        UndoContext ctx1 = new UndoContext();
        UndoContext ctx2 = new UndoContext();
        TestCommand child1 = new TestCommand("child1", this.getFiles("compose1"));
        child1.addContext((IUndoContext)ctx1);
        TestCommand child2 = new TestCommand("child2", this.getFiles("compose1"));
        child1.addContext((IUndoContext)ctx2);
        ICommand composition = c.compose((IUndoableOperation)child1);
        composition = composition.compose((IUndoableOperation)child2);
        CompositeTransactionalCommandTest.assertSame((Object)c, (Object)composition);
        List affectedFiles = composition.getAffectedFiles();
        CompositeTransactionalCommandTest.assertTrue((boolean)affectedFiles.containsAll(child1.getAffectedFiles()));
        CompositeTransactionalCommandTest.assertTrue((boolean)affectedFiles.containsAll(child2.getAffectedFiles()));
        CompositeTransactionalCommandTest.assertEquals((int)1, (int)affectedFiles.size());
        List<IUndoContext> contexts = Arrays.asList(composition.getContexts());
        CompositeTransactionalCommandTest.assertTrue((boolean)contexts.contains(ctx1));
        CompositeTransactionalCommandTest.assertTrue((boolean)contexts.contains(ctx2));
    }

    public void test_reduce() {
        TransactionalEditingDomain domain = TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain();
        CompositeTransactionalCommand composite = new CompositeTransactionalCommand(domain, "test_reduce");
        Object child = new TestCommand();
        composite.compose((IUndoableOperation)child);
        ICommand reduction = composite.reduce();
        CompositeTransactionalCommandTest.assertSame((Object)composite, (Object)reduction);
        composite.remove((IUndoableOperation)child);
        child = new TransactionalTestCommand(domain, null);
        composite.compose((IUndoableOperation)child);
        reduction = composite.reduce();
        CompositeTransactionalCommandTest.assertSame((Object)child, (Object)reduction);
    }

    protected static class TestCommand
    extends AbstractCommand {
        private static final String EXECUTED = "executed";
        private static final String UNDONE = "undone";
        private static final String REDONE = "redone";
        private boolean executed;
        private boolean undone;
        private boolean redone;

        public TestCommand() {
            super("Test Command", null);
        }

        public TestCommand(String label, List affectedFiles) {
            super(label, affectedFiles);
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            this.executed = true;
            this.undone = false;
            this.redone = false;
            return CommandResult.newOKCommandResult((Object)EXECUTED);
        }

        protected CommandResult doRedoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            this.executed = false;
            this.undone = false;
            this.redone = true;
            return CommandResult.newOKCommandResult((Object)REDONE);
        }

        protected CommandResult doUndoWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            this.executed = false;
            this.undone = true;
            this.redone = false;
            return CommandResult.newOKCommandResult((Object)UNDONE);
        }

        public void assertExecuted() {
            CompositeTransactionalCommandTest.assertTrue((boolean)this.executed);
            CompositeTransactionalCommandTest.assertFalse((boolean)this.undone);
            CompositeTransactionalCommandTest.assertFalse((boolean)this.redone);
            CompositeTransactionalCommandTest.assertEquals((int)0, (int)this.getCommandResult().getStatus().getSeverity());
            CompositeTransactionalCommandTest.assertSame((Object)EXECUTED, (Object)this.getCommandResult().getReturnValue());
        }

        public void assertUndone() {
            CompositeTransactionalCommandTest.assertTrue((boolean)this.undone);
            CompositeTransactionalCommandTest.assertFalse((boolean)this.executed);
            CompositeTransactionalCommandTest.assertFalse((boolean)this.redone);
            CompositeTransactionalCommandTest.assertEquals((int)0, (int)this.getCommandResult().getStatus().getSeverity());
            CompositeTransactionalCommandTest.assertSame((Object)UNDONE, (Object)this.getCommandResult().getReturnValue());
        }

        public void assertRedone() {
            CompositeTransactionalCommandTest.assertTrue((boolean)this.redone);
            CompositeTransactionalCommandTest.assertFalse((boolean)this.undone);
            CompositeTransactionalCommandTest.assertFalse((boolean)this.executed);
            CompositeTransactionalCommandTest.assertEquals((int)0, (int)this.getCommandResult().getStatus().getSeverity());
            CompositeTransactionalCommandTest.assertSame((Object)REDONE, (Object)this.getCommandResult().getReturnValue());
        }
    }

    protected static class TransactionalTestCommand
    extends AbstractTransactionalCommand {
        private static final String EXECUTED = "executed";
        private final Resource resource;
        private EObject testObject;
        private boolean executed;
        private boolean undone;
        private boolean redone;

        public TransactionalTestCommand(TransactionalEditingDomain domain, Resource resource) {
            super(domain, "CompositeTransactionalCommandTest", null);
            this.resource = resource;
        }

        public TransactionalTestCommand(List affectedFiles) {
            super(TransactionalEditingDomain.Factory.INSTANCE.createEditingDomain(), "CompositeTransactionalCommandTest", affectedFiles);
            this.resource = null;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
            if (this.resource != null) {
                this.testObject = EcoreFactory.eINSTANCE.createEPackage();
                this.resource.getContents().add((Object)this.testObject);
            }
            this.executed = true;
            this.undone = false;
            this.redone = false;
            return CommandResult.newOKCommandResult((Object)EXECUTED);
        }

        public void assertExecuted() {
            CompositeTransactionalCommandTest.assertTrue((boolean)this.executed);
            CompositeTransactionalCommandTest.assertFalse((boolean)this.undone);
            CompositeTransactionalCommandTest.assertFalse((boolean)this.redone);
            CompositeTransactionalCommandTest.assertEquals((int)0, (int)this.getCommandResult().getStatus().getSeverity());
            CompositeTransactionalCommandTest.assertSame((Object)EXECUTED, (Object)this.getCommandResult().getReturnValue());
            if (this.resource != null) {
                CompositeTransactionalCommandTest.assertTrue((boolean)this.resource.getContents().contains((Object)this.testObject));
            }
        }

        public void assertUndone() {
            CompositeTransactionalCommandTest.assertEquals((int)0, (int)this.getCommandResult().getStatus().getSeverity());
            if (this.resource != null) {
                CompositeTransactionalCommandTest.assertFalse((boolean)this.resource.getContents().contains((Object)this.testObject));
            } else {
                CompositeTransactionalCommandTest.assertNull((Object)this.getCommandResult().getReturnValue());
            }
        }

        public void assertRedone() {
            CompositeTransactionalCommandTest.assertEquals((int)0, (int)this.getCommandResult().getStatus().getSeverity());
            if (this.resource != null) {
                CompositeTransactionalCommandTest.assertTrue((boolean)this.resource.getContents().contains((Object)this.testObject));
            } else {
                CompositeTransactionalCommandTest.assertNull((Object)this.getCommandResult().getReturnValue());
            }
        }
    }
}

