/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.tests.gen;

import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.gmf.gmfgraph.Alignment;
import org.eclipse.gmf.gmfgraph.BorderLayout;
import org.eclipse.gmf.gmfgraph.BorderLayoutData;
import org.eclipse.gmf.gmfgraph.Color;
import org.eclipse.gmf.gmfgraph.CustomAttribute;
import org.eclipse.gmf.gmfgraph.CustomFigure;
import org.eclipse.gmf.gmfgraph.CustomLayout;
import org.eclipse.gmf.gmfgraph.Dimension;
import org.eclipse.gmf.gmfgraph.Ellipse;
import org.eclipse.gmf.gmfgraph.Figure;
import org.eclipse.gmf.gmfgraph.FigureMarker;
import org.eclipse.gmf.gmfgraph.FigureRef;
import org.eclipse.gmf.gmfgraph.FlowLayout;
import org.eclipse.gmf.gmfgraph.GMFGraphFactory;
import org.eclipse.gmf.gmfgraph.GridLayout;
import org.eclipse.gmf.gmfgraph.GridLayoutData;
import org.eclipse.gmf.gmfgraph.Label;
import org.eclipse.gmf.gmfgraph.Layout;
import org.eclipse.gmf.gmfgraph.LayoutData;
import org.eclipse.gmf.gmfgraph.Layoutable;
import org.eclipse.gmf.gmfgraph.RGBColor;
import org.eclipse.gmf.gmfgraph.Rectangle;
import org.eclipse.gmf.gmfgraph.RoundedRectangle;
import org.eclipse.gmf.gmfgraph.XYLayoutData;
import org.eclipse.gmf.tests.gen.FigureCodegenTestBase;
import org.eclipse.gmf.tests.gen.LayoutAwareCheck;

public class FigureLayoutTest
extends FigureCodegenTestBase {
    public FigureLayoutTest(String name) {
        super(name);
    }

    public void disabled_XXX_testGridLayout() {
        Figure parent = this.figure2();
        parent.setLayout((Layout)this.createGridLayoutAllProperties());
        this.performTests(parent);
    }

    public void testConcreteShapeLayoutAllProperties() {
        Figure parent = this.figure2();
        EList children = parent.getChildren();
        FigureLayoutTest.assertFalse((String)"Precondition -- children required to test layout", (boolean)children.isEmpty());
        parent.setLayout((Layout)this.createGridLayoutAllProperties());
        boolean oddChild = false;
        Iterator it = children.iterator();
        while (it.hasNext()) {
            FigureMarker next = (FigureMarker)it.next();
            oddChild = !oddChild;
            GridLayoutData data = this.createGridLayoutDataAllProperties(oddChild);
            next.setLayoutData((LayoutData)data);
            FigureLayoutTest.assertEquals((String)"data-owner relation should be bidirectional", (Object)next, (Object)data.getOwner());
        }
        this.performGridLayoutTests(parent);
    }

    public void testCustomFigureLayoutAllProperties() {
        Figure parent = this.figure1();
        parent.setName("Parent");
        GridLayout layout = this.createGridLayoutAllProperties();
        layout.setNumColumns(1);
        layout.setEqualWidth(false);
        parent.setLayout((Layout)layout);
        Iterator children = parent.getChildren().iterator();
        while (children.hasNext()) {
            FigureMarker next = (FigureMarker)children.next();
            GridLayoutData data = this.createGridLayoutDataAllProperties(false);
            data.setHorizontalAlignment(Alignment.FILL_LITERAL);
            data.setOwner((Layoutable)next);
            FigureLayoutTest.assertEquals((String)"data-owner relation should be bidirectional", (Object)data, (Object)next.getLayoutData());
        }
        this.performGridLayoutTests(parent);
    }

    public void testDeepChildrenLayout() {
        Rectangle parent = GMFGraphFactory.eINSTANCE.createRectangle();
        parent.setName("Root");
        Rectangle next = parent;
        int i = 0;
        while (i < 4) {
            next = this.addPairOfChildRectanglesAndReturnLeft((Figure)next);
            ++i;
        }
        this.performTests((Figure)parent);
    }

    public void testLayoutDefaults() {
        Ellipse parent = GMFGraphFactory.eINSTANCE.createEllipse();
        parent.setName("GenEllipse");
        parent.setLayout((Layout)GMFGraphFactory.eINSTANCE.createGridLayout());
        Label top = GMFGraphFactory.eINSTANCE.createLabel();
        top.setName("Top");
        top.setLayoutData((LayoutData)GMFGraphFactory.eINSTANCE.createGridLayoutData());
        parent.getChildren().add((Object)top);
        RoundedRectangle bottom = GMFGraphFactory.eINSTANCE.createRoundedRectangle();
        bottom.setName("Bottom");
        bottom.setLayoutData((LayoutData)GMFGraphFactory.eINSTANCE.createGridLayoutData());
        parent.getChildren().add((Object)bottom);
        this.performGridLayoutTests((Figure)parent);
    }

    public void off_UnlessSupportFigureRef_testLayoutForReferencedChild() {
        Figure actualContainer = this.figure2();
        Figure referencedFigure = (Figure)actualContainer.getChildren().get(0);
        Rectangle parent = GMFGraphFactory.eINSTANCE.createRectangle();
        parent.setName("ReferencedFigureParent");
        parent.setLayout((Layout)this.createGridLayoutAllProperties());
        FigureRef refChildA = GMFGraphFactory.eINSTANCE.createFigureRef();
        refChildA.setFigure(referencedFigure);
        refChildA.setLayoutData((LayoutData)this.createGridLayoutDataAllProperties(false));
        FigureRef refChildB = GMFGraphFactory.eINSTANCE.createFigureRef();
        refChildB.setFigure(referencedFigure);
        refChildB.setLayoutData((LayoutData)this.createGridLayoutDataAllProperties(true));
        parent.getChildren().add((Object)refChildA);
        parent.getChildren().add((Object)refChildB);
        this.performGridLayoutTests((Figure)parent);
    }

    public void testMissedLayoutPresentLayoutData() {
        Rectangle parent = GMFGraphFactory.eINSTANCE.createRectangle();
        parent.setName("ParentWithoutLayout");
        FigureLayoutTest.assertNull((Object)parent.getLayout());
        Rectangle child = GMFGraphFactory.eINSTANCE.createRectangle();
        child.setName("childWithLayoutData");
        child.setLayoutData((LayoutData)this.createGridLayoutDataAllProperties(false));
        parent.getChildren().add((Object)child);
        this.performTests((Figure)parent);
    }

    public void testBorderLayout() {
        Rectangle parent = GMFGraphFactory.eINSTANCE.createRectangle();
        parent.setName("BorderedContents");
        BorderLayout layout = GMFGraphFactory.eINSTANCE.createBorderLayout();
        layout.setSpacing(this.createDimension(2, 4));
        parent.setLayout((Layout)layout);
        RoundedRectangle centerA = GMFGraphFactory.eINSTANCE.createRoundedRectangle();
        centerA.setName("Center_1");
        centerA.setLayoutData((LayoutData)this.createLayoutData(Alignment.CENTER_LITERAL, false));
        RoundedRectangle left = GMFGraphFactory.eINSTANCE.createRoundedRectangle();
        left.setName("Left");
        left.setLayoutData((LayoutData)this.createLayoutData(Alignment.BEGINNING_LITERAL, false));
        RoundedRectangle right = GMFGraphFactory.eINSTANCE.createRoundedRectangle();
        right.setName("Right");
        right.setLayoutData((LayoutData)this.createLayoutData(Alignment.END_LITERAL, false));
        RoundedRectangle top = GMFGraphFactory.eINSTANCE.createRoundedRectangle();
        top.setName("Top");
        top.setLayoutData((LayoutData)this.createLayoutData(Alignment.BEGINNING_LITERAL, true));
        RoundedRectangle bottom = GMFGraphFactory.eINSTANCE.createRoundedRectangle();
        bottom.setName("Bottom");
        bottom.setLayoutData((LayoutData)this.createLayoutData(Alignment.END_LITERAL, true));
        parent.getChildren().addAll(Arrays.asList(top, bottom, left, right, centerA));
        this.performTests((Figure)parent);
    }

    public void testBorderLayoutDataCenter() {
        Rectangle parent = GMFGraphFactory.eINSTANCE.createRectangle();
        parent.setName("Matreshka");
        LayoutData[] allAreCenters = new LayoutData[]{this.createLayoutData(Alignment.CENTER_LITERAL, true), this.createLayoutData(Alignment.CENTER_LITERAL, false), this.createLayoutData(Alignment.FILL_LITERAL, true), this.createLayoutData(Alignment.FILL_LITERAL, false)};
        Rectangle nextParent = parent;
        int i = 0;
        while (i < allAreCenters.length) {
            BorderLayout layout = GMFGraphFactory.eINSTANCE.createBorderLayout();
            layout.setSpacing(this.createDimension(4, 2));
            nextParent.setLayout((Layout)layout);
            Rectangle child = GMFGraphFactory.eINSTANCE.createRectangle();
            child.setName("Doll" + (i + 1));
            child.setLayoutData(allAreCenters[i]);
            nextParent.getChildren().add((Object)child);
            nextParent = child;
            ++i;
        }
        this.performTests((Figure)parent);
    }

    public void testCustomLayout() {
        CustomLayout layout = GMFGraphFactory.eINSTANCE.createCustomLayout();
        layout.setQualifiedClassName("com.borland.layouts.TheBestLayoutManagerForever");
        CustomAttribute normalAttr = GMFGraphFactory.eINSTANCE.createCustomAttribute();
        normalAttr.setDirectAccess(false);
        normalAttr.setMultiStatementValue(false);
        normalAttr.setName("UnlimateAnswer");
        normalAttr.setValue("42");
        layout.getAttributes().add((Object)normalAttr);
        CustomAttribute directAttr = GMFGraphFactory.eINSTANCE.createCustomAttribute();
        directAttr.setDirectAccess(true);
        directAttr.setMultiStatementValue(false);
        directAttr.setName("DirectUltimateAnswer");
        directAttr.setValue("this.getUltimateAnswer() - 6 * 7");
        layout.getAttributes().add((Object)directAttr);
        CustomAttribute multiAttr = GMFGraphFactory.eINSTANCE.createCustomAttribute();
        multiAttr.setDirectAccess(false);
        multiAttr.setMultiStatementValue(true);
        multiAttr.setName("MultiStatementParameter");
        multiAttr.setValue("int {0}; if (Boolean.TRUE.booleanValue()) '{' {0} = 42; } else '{' {0} = -42; } ");
        layout.getAttributes().add((Object)multiAttr);
        Rectangle parent = GMFGraphFactory.eINSTANCE.createRectangle();
        parent.setName("CarefullyLayouted");
        parent.setLayout((Layout)layout);
        this.generateAndParse((Figure)parent);
    }

    public void testStackLayout() {
        Figure group = this.createRGBGroup("Stack");
        group.setLayout((Layout)GMFGraphFactory.eINSTANCE.createStackLayout());
        this.performTests(group);
    }

    public void testFlowLayout() {
        Figure group = this.createRGBGroup("Flow");
        FlowLayout flowLayout = GMFGraphFactory.eINSTANCE.createFlowLayout();
        flowLayout.setVertical(false);
        flowLayout.setForceSingleLine(false);
        flowLayout.setMinorAlignment(Alignment.END_LITERAL);
        flowLayout.setMajorAlignment(Alignment.FILL_LITERAL);
        flowLayout.setMinorSpacing(23);
        flowLayout.setMinorSpacing(32);
        group.setLayout((Layout)flowLayout);
        this.performTests(group);
    }

    public void testToolbarLayoutUnusedAndIncorrectValues() {
        Figure group = this.createRGBGroup("ToolbarBadConfig");
        FlowLayout flowLayout = GMFGraphFactory.eINSTANCE.createFlowLayout();
        flowLayout.setForceSingleLine(true);
        flowLayout.setMinorSpacing(23456);
        flowLayout.setMajorAlignment(Alignment.FILL_LITERAL);
        group.setLayout((Layout)flowLayout);
        this.performTests(group);
    }

    public void testToolbarLayout() {
        Figure group = this.createRGBGroup("Toolbar");
        FlowLayout flowLayout = GMFGraphFactory.eINSTANCE.createFlowLayout();
        flowLayout.setForceSingleLine(true);
        flowLayout.setMajorSpacing(11);
        flowLayout.setMinorAlignment(Alignment.END_LITERAL);
        group.setLayout((Layout)flowLayout);
        this.performTests(group);
    }

    public void testXYLayout() {
        Figure group = this.createRGBGroup("XY");
        Figure left = (Figure)group.getChildren().get(0);
        Figure right = (Figure)group.getChildren().get(1);
        this.setupXYLayout(group, left, right);
        this.performTests(group);
        this.performTests(right);
        this.performTests(left);
    }

    public void testXYLayoutForCustomFigure() {
        CustomFigure group = GMFGraphFactory.eINSTANCE.createCustomFigure();
        group.setBundleName("org.eclipse.draw2d");
        group.setQualifiedClassName("org.eclipse.draw2d.Layer");
        group.setName("CustomLayer");
        Rectangle left = GMFGraphFactory.eINSTANCE.createRectangle();
        left.setName("Left");
        group.getChildren().add((Object)left);
        RoundedRectangle right = GMFGraphFactory.eINSTANCE.createRoundedRectangle();
        right.setName("Right");
        group.getChildren().add((Object)right);
        this.setupXYLayout((Figure)group, (Figure)left, (Figure)right);
        this.performTests((Figure)group);
    }

    private void setupXYLayout(Figure group, Figure left, Figure right) {
        FigureLayoutTest.assertTrue((boolean)group.getChildren().contains((Object)left));
        FigureLayoutTest.assertTrue((boolean)group.getChildren().contains((Object)right));
        FigureLayoutTest.assertNotSame((Object)left, (Object)right);
        group.setLayout((Layout)GMFGraphFactory.eINSTANCE.createXYLayout());
        XYLayoutData leftDataCorrect = GMFGraphFactory.eINSTANCE.createXYLayoutData();
        leftDataCorrect.setTopLeft(GMFGraphFactory.eINSTANCE.createPoint());
        leftDataCorrect.getTopLeft().setX(12);
        leftDataCorrect.getTopLeft().setY(13);
        leftDataCorrect.setSize(GMFGraphFactory.eINSTANCE.createDimension());
        leftDataCorrect.getSize().setDx(20);
        leftDataCorrect.getSize().setDy(30);
        leftDataCorrect.setOwner((Layoutable)left);
        XYLayoutData rightDataIncomplete = GMFGraphFactory.eINSTANCE.createXYLayoutData();
        rightDataIncomplete.setSize(GMFGraphFactory.eINSTANCE.createDimension());
        rightDataIncomplete.getSize().setDx(30);
        rightDataIncomplete.getSize().setDy(20);
        right.setLayoutData((LayoutData)rightDataIncomplete);
    }

    private Figure createRGBGroup(String rootName) {
        Rectangle parent = GMFGraphFactory.eINSTANCE.createRectangle();
        this.setColor((Figure)parent, 0, 0, 255);
        parent.setName(rootName);
        Ellipse greenEllipse = GMFGraphFactory.eINSTANCE.createEllipse();
        greenEllipse.setName("GreenEllipse");
        this.setColor((Figure)greenEllipse, 0, 255, 0);
        RoundedRectangle redRRectangle = GMFGraphFactory.eINSTANCE.createRoundedRectangle();
        redRRectangle.setName("RedRoundedRectangle");
        this.setColor((Figure)redRRectangle, 255, 0, 0);
        parent.getChildren().add((Object)greenEllipse);
        parent.getChildren().add((Object)redRRectangle);
        return parent;
    }

    private Figure addPairOfChildRectanglesAndReturnLeft(Figure parent) {
        parent.setLayout((Layout)this.createBorderLayoutAllProperties());
        Rectangle left = GMFGraphFactory.eINSTANCE.createRectangle();
        left.setName(String.valueOf(parent.getName()) + "_1");
        left.setLayoutData((LayoutData)this.createBorderLayoutDataAllProperties(Alignment.BEGINNING_LITERAL, false));
        parent.getChildren().add((Object)left);
        Rectangle right = GMFGraphFactory.eINSTANCE.createRectangle();
        right.setName(String.valueOf(parent.getName()) + "_2");
        right.setLayoutData((LayoutData)this.createBorderLayoutDataAllProperties(Alignment.END_LITERAL, false));
        parent.getChildren().add((Object)right);
        return left;
    }

    private GridLayoutData createGridLayoutDataAllProperties(boolean horizontalBeginningNotEnd) {
        GridLayoutData data = GMFGraphFactory.eINSTANCE.createGridLayoutData();
        data.setGrabExcessHorizontalSpace(true);
        data.setGrabExcessVerticalSpace(false);
        data.setHorizontalAlignment(horizontalBeginningNotEnd ? Alignment.BEGINNING_LITERAL : Alignment.END_LITERAL);
        data.setVerticalAlignment(Alignment.CENTER_LITERAL);
        data.setHorizontalIndent(5);
        data.setHorizontalSpan(1);
        data.setVerticalSpan(1);
        return data;
    }

    private GridLayout createGridLayoutAllProperties() {
        GridLayout layout = GMFGraphFactory.eINSTANCE.createGridLayout();
        layout.setEqualWidth(true);
        layout.setNumColumns(2);
        Dimension margins = GMFGraphFactory.eINSTANCE.createDimension();
        margins.setDx(5);
        margins.setDy(10);
        layout.setMargins(margins);
        Dimension spacing = GMFGraphFactory.eINSTANCE.createDimension();
        spacing.setDx(7);
        spacing.setDy(8);
        layout.setSpacing(spacing);
        return layout;
    }

    private BorderLayout createBorderLayoutAllProperties() {
        BorderLayout result = GMFGraphFactory.eINSTANCE.createBorderLayout();
        Dimension spacing = GMFGraphFactory.eINSTANCE.createDimension();
        spacing.setDx(11);
        spacing.setDy(12);
        result.setSpacing(spacing);
        return result;
    }

    private BorderLayoutData createBorderLayoutDataAllProperties(Alignment alignment, boolean isVertical) {
        BorderLayoutData result = GMFGraphFactory.eINSTANCE.createBorderLayoutData();
        result.setAlignment(alignment);
        result.setVertical(isVertical);
        return result;
    }

    private Dimension createDimension(int dx, int dy) {
        Dimension result = GMFGraphFactory.eINSTANCE.createDimension();
        result.setDx(dx);
        result.setDy(dy);
        return result;
    }

    private BorderLayoutData createLayoutData(Alignment alignment, boolean isVertical) {
        BorderLayoutData result = GMFGraphFactory.eINSTANCE.createBorderLayoutData();
        result.setAlignment(alignment);
        result.setVertical(isVertical);
        return result;
    }

    private void setColor(Figure figure, int red, int green, int blue) {
        RGBColor color = GMFGraphFactory.eINSTANCE.createRGBColor();
        color.setRed(red);
        color.setGreen(green);
        color.setBlue(blue);
        figure.setForegroundColor((Color)color);
    }

    private void performGridLayoutTests(Figure figure) {
        this.generateAndParse(figure);
    }

    protected void performTests(Figure f) {
        super.performTests(f, new LayoutAwareCheck(f));
    }
}

