/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.internal.xpand.build;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.gmf.internal.xpand.Activator;
import org.eclipse.gmf.internal.xpand.RootManager;
import org.eclipse.gmf.internal.xpand.build.WorkspaceModelRegistry;
import org.eclipse.gmf.internal.xpand.build.WorkspaceResourceManager;
import org.eclipse.gmf.internal.xpand.expression.AnalysationIssue;
import org.eclipse.gmf.internal.xpand.expression.ExecutionContext;
import org.eclipse.gmf.internal.xpand.model.XpandExecutionContext;
import org.eclipse.gmf.internal.xpand.model.XpandResource;
import org.eclipse.gmf.internal.xpand.util.ContextFactory;
import org.eclipse.gmf.internal.xpand.util.OawMarkerManager;
import org.eclipse.gmf.internal.xpand.util.ParserException;
import org.eclipse.gmf.internal.xpand.xtend.ast.XtendResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OawBuilder
extends IncrementalProjectBuilder
implements RootManager.IRootChangeListener {
    private RootManager myRootManager;
    private WorkspaceModelRegistry modelRegistry;
    private boolean myRootsChanged = true;
    private final Map<XtendResource, IFile> xtendResourcesToAnalyze = new HashMap<XtendResource, IFile>();
    private final Map<XpandResource, IFile> xpandResourcesToAnalyze = new HashMap<XpandResource, IFile>();

    public static final String getBUILDER_ID() {
        return String.valueOf(Activator.getId()) + ".oawBuilder";
    }

    protected void startupOnInitialize() {
        super.startupOnInitialize();
        this.myRootManager = Activator.getRootManager(this.getProject());
        this.myRootManager.addRootChangeListener(this);
        this.modelRegistry = new WorkspaceModelRegistry();
        Activator.registerModelSource(this.modelRegistry);
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        HashSet<AnalysationIssue> issues;
        ExecutionContext ctx;
        try {
            this.doBuild(kind, args, monitor);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        for (XtendResource xtendResource : this.xtendResourcesToAnalyze.keySet()) {
            ctx = ContextFactory.createXtendContext(this.getResourceManager(this.xtendResourcesToAnalyze.get(xtendResource)));
            issues = new HashSet<AnalysationIssue>();
            xtendResource.analyze(ctx, issues);
            OawBuilder.updateMarkers(this.xtendResourcesToAnalyze.get(xtendResource), issues);
        }
        for (XpandResource xpandResource : this.xpandResourcesToAnalyze.keySet()) {
            ctx = ContextFactory.createXpandContext(this.getResourceManager(this.xpandResourcesToAnalyze.get(xpandResource)));
            issues = new HashSet();
            xpandResource.analyze((XpandExecutionContext)ctx, issues);
            OawBuilder.updateMarkers(this.xpandResourcesToAnalyze.get(xpandResource), issues);
        }
        this.xtendResourcesToAnalyze.clear();
        this.xpandResourcesToAnalyze.clear();
        this.myRootsChanged = false;
        Set<IProject> set = this.myRootManager.getReferencedProjects();
        set.remove(this.getProject());
        return set.toArray(new IProject[set.size()]);
    }

    private void doBuild(int kind, Map<?, ?> args, IProgressMonitor monitor) throws CoreException {
        if (kind == 6 || this.haveRootsChangedSinceLastBuild()) {
            this.fullBuild(monitor);
        } else {
            Set<IProject> referencedProjects = this.myRootManager.getReferencedProjects();
            referencedProjects.remove(this.getProject());
            ArrayList<IResourceDelta> deltas = new ArrayList<IResourceDelta>(referencedProjects.size());
            IResourceDelta projectDelta = this.getDelta(this.getProject());
            if (projectDelta == null) {
                this.fullBuild(monitor);
                return;
            }
            for (IProject next : referencedProjects) {
                IResourceDelta delta = this.getDelta(next);
                if (delta == null) {
                    this.fullBuild(monitor);
                    return;
                }
                deltas.add(delta);
            }
            this.incrementalBuild(projectDelta, deltas, monitor);
        }
    }

    @Override
    public void rootsChanged(RootManager rootManager) {
        this.myRootsChanged = true;
    }

    private boolean haveRootsChangedSinceLastBuild() {
        return this.myRootsChanged;
    }

    void reloadResource(IFile resource) {
        this.getResourceManager(resource).forget(resource);
        if (!resource.exists()) {
            return;
        }
        try {
            XtendResource r;
            if (OawBuilder.isXpand(resource)) {
                XpandResource r2 = this.getResourceManager(resource).loadXpandResource(resource);
                if (r2 != null) {
                    this.xpandResourcesToAnalyze.put(r2, resource);
                }
            } else if (OawBuilder.isXtend(resource) && (r = this.getResourceManager(resource).loadXtendResource(resource)) != null) {
                this.xtendResourcesToAnalyze.put(r, resource);
            }
        }
        catch (ParserException ex) {
            OawBuilder.updateMarkers(resource, ex.getParsingErrors());
        }
        catch (Exception ex) {
            Activator.logError(ex);
            OawMarkerManager.deleteMarkers((IResource)resource);
            OawMarkerManager.addErrorMarker(resource, ex.getMessage(), -1, -1);
        }
    }

    public void handleRemovement(IFile resource) {
        OawMarkerManager.deleteMarkers((IResource)resource);
        this.getResourceManager(resource).forget(resource);
    }

    private WorkspaceResourceManager getResourceManager(IFile file) {
        WorkspaceResourceManager result = this.myRootManager.getResourceManager(file);
        assert (result != null);
        return result;
    }

    protected void fullBuild(IProgressMonitor monitor) throws CoreException {
        Set<IProject> referencedProjects = this.myRootManager.getReferencedProjects();
        referencedProjects.add(this.getProject());
        OawMarkerManager.deleteMarkers((IResource)this.getProject());
        monitor.beginTask(null, 1 + referencedProjects.size());
        try {
            for (IProject next : referencedProjects) {
                this.checkCanceled(monitor);
                next.accept((IResourceVisitor)new XpandResourceVisitor((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
            }
            this.checkCanceled(monitor);
            this.modelRegistry.build(this.getProject(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
    }

    protected void incrementalBuild(IResourceDelta projectDelta, Collection<IResourceDelta> referencedProjectDeltas, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(null, 2 + referencedProjectDeltas.size());
        try {
            for (IResourceDelta delta : referencedProjectDeltas) {
                this.checkCanceled(monitor);
                delta.accept((IResourceDeltaVisitor)new XpandResourceVisitor((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
            }
            this.checkCanceled(monitor);
            projectDelta.accept((IResourceDeltaVisitor)new XpandResourceVisitor((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
            this.checkCanceled(monitor);
            this.modelRegistry.build(this.getProject(), projectDelta, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
    }

    private void checkCanceled(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    private static void updateMarkers(IFile resource, Set<AnalysationIssue> issues) {
        OawMarkerManager.deleteMarkers((IResource)resource);
        OawMarkerManager.addMarkers(resource, issues.toArray(new AnalysationIssue[issues.size()]));
    }

    private static void updateMarkers(IFile resource, ParserException.ErrorLocationInfo[] parsingErrors) {
        OawMarkerManager.deleteMarkers((IResource)resource);
        OawMarkerManager.addMarkers(resource, parsingErrors);
    }

    private static boolean isXtend(IFile resource) {
        return "ext".equals(resource.getFileExtension());
    }

    private static boolean isXpand(IFile resource) {
        return "xpt".equals(resource.getFileExtension());
    }

    private boolean isFileOfInterest(IFile file) {
        if (!OawBuilder.isXpand(file) && !OawBuilder.isXtend(file)) {
            return false;
        }
        return this.getResourceManager(file) != null;
    }

    private class XpandResourceVisitor
    implements IResourceVisitor,
    IResourceDeltaVisitor {
        private final IProgressMonitor monitor;

        public XpandResourceVisitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }

        public boolean visit(IResource resource) {
            if (!resource.isDerived() && resource instanceof IFile && OawBuilder.this.isFileOfInterest((IFile)resource)) {
                OawBuilder.this.reloadResource((IFile)resource);
            }
            this.monitor.worked(1);
            return true;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource resource = delta.getResource();
            if (resource.isDerived()) {
                return false;
            }
            if (resource instanceof IFile) {
                IFile file = (IFile)resource;
                if (!OawBuilder.this.isFileOfInterest(file)) {
                    return false;
                }
                switch (delta.getKind()) {
                    case 1: {
                        OawBuilder.this.reloadResource(file);
                        break;
                    }
                    case 2: {
                        OawBuilder.this.handleRemovement(file);
                        break;
                    }
                    case 4: {
                        OawBuilder.this.reloadResource(file);
                    }
                }
            } else if (resource instanceof IProject) {
                if (delta.getKind() == 2) {
                    System.err.println("Project removed:" + resource.getName());
                }
                if (delta.getKind() == 16384) {
                    System.err.println("Project open:" + ((IProject)resource).isOpen());
                }
            }
            this.monitor.worked(1);
            return true;
        }
    }
}

