/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.usecase.modelfilter.methodcalls.discoverer.ui.internal.editor;

import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.edit.ui.util.EditUIUtil;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.java.AbstractMethodDeclaration;
import org.eclipse.modisco.usecase.modelfilter.methodcalls.discoverer.ui.internal.Activator;
import org.eclipse.modisco.usecase.modelfilter.methodcalls.discoverer.ui.internal.Messages;
import org.eclipse.modisco.usecase.modelfilter.methodcalls.discoverer.ui.internal.PrefuseGraphContainerForJava;
import org.eclipse.modisco.usecase.modelfilter.methodcalls.discoverer.ui.internal.editor.PrefuseGraphInput;
import org.eclipse.modisco.usecase.modelfilter.methodcalls.methodcalls.CallNode;
import org.eclipse.modisco.usecase.modelfilter.methodcalls.methodcalls.CallsModel;
import org.eclipse.modisco.usecase.modelfilter.methodcalls.methodcalls.MethodCall;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.FileEditorInput;
import prefuse.data.Graph;
import prefuse.data.Node;
import prefuse.data.Table;
import prefuse.data.Tree;

public class MethodCallsModelEditor
extends EditorPart {
    public static final String EDITOR_ID = "org.eclipse.modisco.usecase.modelfilter.methodcalls.discoverer.ui.prefuse.EditorID";
    private PrefuseGraphInput editorInput;
    private final String nameAttribute = "name";
    private final List<CallNode> parents = new ArrayList<CallNode>();

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setPartName(Messages.MethodCallsModelEditor_partName);
        if (input instanceof PrefuseGraphInput) {
            this.editorInput = (PrefuseGraphInput)input;
            this.setInput(this.editorInput);
        } else if (input instanceof FileEditorInput) {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            URI resourceURI = EditUIUtil.getURI((IEditorInput)input);
            Resource result = resourceSet.getResource(resourceURI, true);
            IJavaProject tempProject = null;
            IProject project = ((FileEditorInput)input).getFile().getProject();
            try {
                if (project.hasNature("org.eclipse.jdt.core.javanature")) {
                    tempProject = JavaCore.create((IProject)project);
                }
            }
            catch (CoreException e) {
                MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
            }
            this.editorInput = new PrefuseGraphInput(result, tempProject);
            this.setInput(this.editorInput);
        } else {
            throw new PartInitException("invalid input type : input should be of type PrefuseGraphInput");
        }
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void createPartControl(Composite parent) {
        if (this.editorInput != null) {
            Tree graph = null;
            if (this.editorInput.getInputResource() != null) {
                Resource resource = this.editorInput.getInputResource();
                CallsModel root = (CallsModel)resource.getContents().get(0);
                this.setPartName(root.getName());
                graph = this.initializeMethodCallsGraph(root);
            } else if (this.editorInput.getInputCallNode() != null) {
                CallNode callNode = this.editorInput.getInputCallNode();
                this.setPartName(callNode.getName());
                graph = this.initializeMethodCallsGraph(callNode);
            }
            JPanel treeview = PrefuseGraphContainerForJava.getInstance().initializeTreeViewContainer((Graph)graph, "name", null);
            Composite composite = new Composite(parent, 0x1040000);
            Frame frame = SWT_AWT.new_Frame((Composite)composite);
            frame.add(treeview);
        }
    }

    public void setFocus() {
    }

    private final Tree initializeMethodCallsGraph(CallsModel root) {
        Tree result = new Tree();
        Node parentNode = this.intializeMethodCallsGraph(result, root.getName());
        for (CallNode rootElement : root.getRootNodes()) {
            this.generateMethodCallsNode(result, parentNode, rootElement);
        }
        return result;
    }

    private final Tree initializeMethodCallsGraph(CallNode callNode) {
        Tree result = new Tree();
        Node parentNode = this.intializeMethodCallsGraph(result, callNode.getName());
        this.generateMethodCallsNode(result, parentNode, callNode);
        return result;
    }

    private final Node intializeMethodCallsGraph(Tree result, String rootName) {
        Table nodes = result.getNodeTable();
        Node activeNode = null;
        nodes.addColumn("name", String.class);
        nodes.addColumn("javaOperation", AbstractMethodDeclaration.class);
        nodes.addColumn("jdtProject", IJavaProject.class);
        activeNode = result.addRoot();
        activeNode.set("name", (Object)(String.valueOf(Messages.MethodCallsModelEditor_rootNodeName) + rootName));
        return activeNode;
    }

    private final void generateMethodCallsNode(Tree result, Node parentNode, CallNode element) {
        Node activeNode = result.addChild(parentNode);
        activeNode.set("javaOperation", (Object)element.getJavaMethod());
        activeNode.set("jdtProject", (Object)this.editorInput.getJavaProject());
        if (this.parents.contains(element)) {
            activeNode.set("name", (Object)(String.valueOf(Messages.MethodCallsModelEditor_recursion) + element.getName()));
        } else {
            this.parents.add(element);
            activeNode.set("name", (Object)element.getName());
            EList calledMethods = element.getMethodCalls();
            if (calledMethods.isEmpty() && element.getJavaMethod().getBody() == null) {
                activeNode.set("name", (Object)(String.valueOf(element.getName()) + "[" + element.getSubMethods().size() + "]"));
                for (CallNode subMethod : element.getSubMethods()) {
                    this.generateMethodCallsNode(result, activeNode, subMethod);
                }
            }
            for (MethodCall child : calledMethods) {
                this.generateMethodCallsNode(result, activeNode, child.getCallee());
            }
            this.parents.remove(element);
        }
    }
}

