/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.moka.datavisualization.service;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.infra.core.services.IService;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.core.services.ServicesRegistry;
import org.eclipse.papyrus.moka.datavisualization.profile.BooleanSeries;
import org.eclipse.papyrus.moka.datavisualization.profile.DataSource;
import org.eclipse.papyrus.moka.datavisualization.profile.DoubleSeries;
import org.eclipse.papyrus.moka.datavisualization.profile.IntegerSeries;
import org.eclipse.papyrus.moka.datavisualization.profile.ValueSeries;
import org.eclipse.papyrus.moka.datavisualization.service.DataPort;
import org.eclipse.papyrus.moka.datavisualization.service.DataSourceVariableID;
import org.eclipse.papyrus.moka.datavisualization.service.VariableDataEntry;
import org.eclipse.papyrus.moka.datavisualization.service.VariableEntry;
import org.eclipse.papyrus.moka.datavisualization.service.VariableEntryTable;
import org.eclipse.papyrus.moka.datavisualization.service.VariableImpl;
import org.eclipse.papyrus.moka.datavisualization.ui.GraphBuilderHelper;
import org.eclipse.papyrus.moka.xygraph.mapping.common.Variable;
import org.eclipse.papyrus.moka.xygraph.mapping.util.DataBatch;

public class DataVisualizationService
implements IService {
    private List<DataPort> dataPorts = new ArrayList<DataPort>();
    private VariableEntryTable<VariableEntry> varTable = new VariableEntryTable();
    private static DataVisualizationService instance = new DataVisualizationService();

    private DataVisualizationService() {
    }

    public static DataVisualizationService getInstance() {
        return instance;
    }

    public void registerUnlinkedVariable(Variable v) {
        if (this.hasVariable(v)) {
            return;
        }
        this.varTable.addEntryFor(v.getID(), new VariableDataEntry(v));
    }

    public boolean hasVariable(Variable var) {
        return this.hasVariable(var.getID());
    }

    private boolean hasVariable(Variable.VariableID id) {
        return this.varTable.hasVariable(id);
    }

    public void addDataPort(DataPort port) {
        if (this.dataPorts.contains(port)) {
            return;
        }
        this.dataPorts.add(port);
    }

    private VariableDataEntry getEntry(Variable.VariableID vID) {
        return (VariableDataEntry)this.varTable.getEntry(vID);
    }

    public Variable makeIndependentVariable(ValueSeries independentSeries) {
        return new VariableImpl(independentSeries.getBase_Property().getLabel(), new DataSourceVariableID(independentSeries));
    }

    public Variable makeDependentVariable(ValueSeries depSeries, Variable independent) {
        return new VariableImpl(depSeries.getBase_Property().getLabel(), new DataSourceVariableID(depSeries), independent);
    }

    public void setVariableBatch(Variable var, DataBatch batch) {
        this.getEntry(var.getID()).setData(batch);
    }

    public List<Variable> importNewDataValueSet(DataSource set) {
        ArrayList<Variable> contained = new ArrayList<Variable>();
        ArrayList<ValueSeries> independent = new ArrayList<ValueSeries>();
        ArrayList<ValueSeries> dependent = new ArrayList<ValueSeries>();
        GraphBuilderHelper.separateValueSeries((List<ValueSeries>)set.getSeries(), independent, dependent);
        if (independent.size() == 0) {
            return contained;
        }
        ValueSeries independentSeries = independent.get(0);
        if (this.getVariable(independentSeries) == null) {
            Variable iVar = this.makeIndependentVariable(independentSeries);
            this.registerUnlinkedVariable(iVar);
            this.setVariableBatch(iVar, DataVisualizationService.getDataFromValueSeries(independentSeries));
        }
        for (ValueSeries dep : dependent) {
            if (this.getEntryFromSerie(dep) != null) continue;
            Variable in = this.getEntryFromSerie(dep.getDependent()).getVariable();
            Variable dVar = this.makeDependentVariable(dep, in);
            this.registerUnlinkedVariable(dVar);
            this.setVariableBatch(dVar, DataVisualizationService.getDataFromValueSeries(dep));
        }
        return contained;
    }

    private VariableEntry getEntryFromSerie(ValueSeries dependent) {
        DataSourceVariableID dsID = new DataSourceVariableID(dependent);
        return this.getEntry(dsID);
    }

    public void updateVariableData(Variable v, DataBatch values) {
        VariableDataEntry entry = this.getEntry(v.getID());
        entry.setData(values);
    }

    public void flushData() {
        for (DataPort port : this.dataPorts) {
            this.pullAllData(port);
        }
    }

    public void flushVariable(Variable v) {
        for (DataPort port : this.dataPorts) {
            if (v.isIndependent() || !port.getSupportedVariableIDs().contains(v.getID())) continue;
            this.flushVariableToPort(this.getEntry(v.getID()), port);
        }
    }

    private void flushVariableToPort(VariableDataEntry entry, DataPort port) {
        if (entry.getVariable().isIndependent()) {
            return;
        }
        Variable v = entry.getVariable();
        VariableDataEntry indepEntry = this.getEntry(v.getDependsOn().getID());
        long portLastUpdate = port.getLastUpdate(v.getID());
        if (portLastUpdate < indepEntry.getLastUpdate()) {
            port.resetValues(v.getID(), indepEntry.getValuesBatch(), entry.getValuesBatch());
        }
    }

    public void pullAllData(DataPort port) {
        for (Variable.VariableID vId : port.getSupportedVariableIDs()) {
            VariableDataEntry entry = this.getEntry(vId);
            this.flushVariableToPort(entry, port);
        }
    }

    public static DataBatch getDataFromValueSeries(ValueSeries serie) {
        switch (serie.eClass().getClassifierID()) {
            case 5: {
                return DataBatch.fromBoolean((List)((BooleanSeries)serie).getValues());
            }
            case 4: {
                return DataBatch.fromInteger((List)((IntegerSeries)serie).getValues());
            }
            case 3: {
                return DataBatch.fromDouble((List)((DoubleSeries)serie).getValues());
            }
        }
        return DataBatch.dummy();
    }

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
    }

    public void startService() throws ServiceException {
    }

    public void disposeService() throws ServiceException {
    }

    public void fixDependencies(DataSource dataSource) {
        ValueSeries dep = null;
        for (ValueSeries serie : dataSource.getSeries()) {
            if (!"time".equalsIgnoreCase(serie.getBase_Property().getLabel())) continue;
            dep = serie;
            break;
        }
        for (ValueSeries serie : dataSource.getSeries()) {
            if ("time".equalsIgnoreCase(serie.getBase_Property().getLabel())) continue;
            serie.setDependent(dep);
        }
    }

    public Variable getVariable(ValueSeries series) {
        VariableEntry entry = this.varTable.getEntry(new DataSourceVariableID(series));
        if (entry == null) {
            return null;
        }
        return entry.getVariable();
    }

    public void removeDataPort(DataPort port) {
        this.dataPorts.remove(port);
    }
}

