/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.evaluation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.ids.IdResolver;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;

public class ShadowCache {
    public static final @NonNull TracingOption SHADOWS = new TracingOption("org.eclipse.ocl.pivot", "shadows");
    protected final @NonNull Executor executor;
    private final @NonNull Map<@NonNull Integer, @NonNull Object> hashCode2shadows = new HashMap<Integer, Object>();
    protected final boolean debugShadows = SHADOWS.isActive();

    public ShadowCache(@NonNull Executor executor) {
        this.executor = executor;
    }

    public void dispose() {
        this.hashCode2shadows.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Issues handling annotations - annotations may be inaccurate
     */
    public @Nullable Object getCachedShadowObject(@NonNull Class thisClass, @NonNull Property @NonNull [] theseProperties, @Nullable Object @NonNull [] theseValues) {
        @NonNull IdResolver.IdResolverExtension idResolver = (IdResolver.IdResolverExtension)this.executor.getIdResolver();
        int hashCode = thisClass.hashCode();
        assert (theseValues.length == theseProperties.length);
        int iMax = theseValues.length;
        int i22 = 0;
        while (i22 < iMax) {
            hashCode = 3 * hashCode + idResolver.oclHashCode(theseValues[i22]);
            ++i22;
        }
        Map<Integer, Object> i22 = this.hashCode2shadows;
        synchronized (i22) {
            Object zeroOrMoreShadows = this.hashCode2shadows.get(hashCode);
            ShadowResult oneShadow = null;
            if (zeroOrMoreShadows instanceof ShadowResult) {
                oneShadow = (ShadowResult)zeroOrMoreShadows;
                if (oneShadow.isEqual(idResolver, thisClass, theseProperties, theseValues)) {
                    if (this.debugShadows) {
                        SHADOWS.println("old:" + oneShadow);
                    }
                    return oneShadow.getInstance();
                }
            } else if (zeroOrMoreShadows instanceof List) {
                @NonNull @NonNull List zeroOrMoreShadows2 = (List)zeroOrMoreShadows;
                for (ShadowResult aShadow : zeroOrMoreShadows2) {
                    if (!aShadow.isEqual(idResolver, thisClass, theseProperties, theseValues)) continue;
                    if (this.debugShadows) {
                        SHADOWS.println("old:" + aShadow);
                    }
                    return aShadow.getInstance();
                }
            }
        }
        EObject eObject = thisClass.createInstance();
        int i = 0;
        while (i < iMax) {
            Property referredProperty = theseProperties[i];
            java.lang.Class<?> instanceClass = PivotUtil.getEcoreInstanceClass(referredProperty);
            Object ecoreValue = idResolver.ecoreValueOf(instanceClass, theseValues[i]);
            referredProperty.initValue(eObject, ecoreValue);
            ++i;
        }
        ShadowResult theShadow = new ShadowResult(thisClass, theseProperties, theseValues, eObject);
        Map<Integer, Object> map = this.hashCode2shadows;
        synchronized (map) {
            Object zeroOrMoreShadows = this.hashCode2shadows.get(hashCode);
            if (zeroOrMoreShadows == null) {
                this.hashCode2shadows.put(hashCode, theShadow);
            } else if (zeroOrMoreShadows instanceof ShadowResult) {
                ShadowResult oneShadow = (ShadowResult)zeroOrMoreShadows;
                if (oneShadow.isEqual(idResolver, thisClass, theseProperties, theseValues)) {
                    if (this.debugShadows) {
                        SHADOWS.println("old:" + oneShadow);
                    }
                    return oneShadow.getInstance();
                }
                ArrayList<@NonNull ShadowResult> twoOrMoreShadows = new ArrayList<ShadowResult>(4);
                twoOrMoreShadows.add(oneShadow);
                twoOrMoreShadows.add(theShadow);
                this.hashCode2shadows.put(hashCode, twoOrMoreShadows);
            } else if (zeroOrMoreShadows instanceof List) {
                @NonNull @NonNull List twoOrMoreShadows = (List)zeroOrMoreShadows;
                for (ShadowResult aShadow : twoOrMoreShadows) {
                    if (!aShadow.isEqual(idResolver, thisClass, theseProperties, theseValues)) continue;
                    if (this.debugShadows) {
                        SHADOWS.println("old:" + aShadow);
                    }
                    return aShadow.getInstance();
                }
                twoOrMoreShadows.add(theShadow);
            }
            if (this.debugShadows) {
                SHADOWS.println("new:" + theShadow);
            }
            return theShadow.getInstance();
        }
    }

    private static final class ShadowResult {
        private final @NonNull Class thisClass;
        private final @NonNull Property @NonNull [] theseProperties;
        private final @Nullable Object @NonNull [] theseValues;
        private final @NonNull Object instance;

        public ShadowResult(@NonNull Class thisClass, @NonNull Property @NonNull [] theseProperties, @Nullable Object @NonNull [] theseValues, @NonNull Object instance) {
            this.thisClass = thisClass;
            this.theseProperties = theseProperties;
            this.theseValues = theseValues;
            this.instance = instance;
            assert (theseValues.length == theseProperties.length);
        }

        public @NonNull Object getInstance() {
            return this.instance;
        }

        public boolean isEqual(@NonNull IdResolver idResolver, @NonNull Class thatClass, @NonNull Property @NonNull [] thoseProperties, @Nullable Object @NonNull [] thoseValues) {
            if (this.thisClass != thatClass) {
                return false;
            }
            Object[] thoseValues2 = thoseValues;
            int iMax = thoseValues2.length;
            Object[] theseValues2 = this.theseValues;
            if (iMax != theseValues2.length) {
                return false;
            }
            assert (thoseValues2.length == thoseProperties.length);
            int i = 0;
            while (i < iMax) {
                if (this.theseProperties[i] != thoseProperties[i]) {
                    return false;
                }
                if (!idResolver.oclEquals(theseValues2[i], thoseValues2[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }
}

