/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelrepair.handler;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.infra.core.resource.ModelSet;
import org.eclipse.papyrus.infra.core.services.ServiceException;
import org.eclipse.papyrus.infra.emf.utils.EMFHelper;
import org.eclipse.papyrus.infra.emf.utils.ServiceUtilsForEObject;
import org.eclipse.papyrus.infra.ui.lifecycleevents.ISaveAndDirtyService;
import org.eclipse.papyrus.uml.modelrepair.Activator;
import org.eclipse.papyrus.uml.modelrepair.ui.SwitchLibraryDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.uml2.uml.Package;

public class SwitchLibraryHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection.isEmpty() || !(currentSelection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection selection = (IStructuredSelection)currentSelection;
        EObject selectedAdapter = EMFHelper.getEObject((Object)selection.getFirstElement());
        final Shell activeShell = HandlerUtil.getActiveShell((ExecutionEvent)event);
        if (activeShell == null) {
            return new Status(4, "org.eclipse.papyrus.uml.modelrepair", "Impossible to find the active shell for switch package import");
        }
        if (selectedAdapter instanceof Package) {
            final Package selectedPackage = (Package)selectedAdapter;
            Job openDialogJob = new Job("Switch package imports"){
                protected IStatus status;
                protected boolean needSave;
                {
                    super($anonymous0);
                    this.status = Status.OK_STATUS;
                    this.needSave = false;
                }

                protected IStatus run(IProgressMonitor monitor) {
                    monitor.beginTask("Analyzing model", -1);
                    try {
                        ModelSet modelSet = ServiceUtilsForEObject.getInstance().getModelSet((Object)selectedPackage);
                        TransactionalEditingDomain editingDomain = modelSet.getTransactionalEditingDomain();
                        ISaveAndDirtyService saveAndDirtyService = (ISaveAndDirtyService)ServiceUtilsForEObject.getInstance().getService(ISaveAndDirtyService.class, (Object)selectedPackage);
                        if (saveAndDirtyService.isDirty()) {
                            this.needSave = true;
                            activeShell.getDisplay().syncExec(new Runnable(){

                                public void run() {
                                    boolean openQuestion = MessageDialog.openQuestion((Shell)activeShell, (String)"Switch package import", (String)"Model should be saved before switching package imports. Would you like to save it now? \nOperation will be cancelled if you press no.");
                                    if (!openQuestion) {
                                        status = Status.CANCEL_STATUS;
                                    }
                                }
                            });
                        }
                        if (!this.status.isOK()) {
                            return this.status;
                        }
                        if (this.needSave) {
                            saveAndDirtyService.doSave(monitor);
                        }
                        SwitchLibraryHandler.this.switchLibrariesForModelSet(selectedPackage, modelSet, editingDomain, activeShell, monitor);
                    }
                    catch (ServiceException e) {
                        Activator.log.error((Throwable)e);
                        return new Status(4, "org.eclipse.papyrus.uml.modelrepair", e.getMessage(), (Throwable)e);
                    }
                    return Status.OK_STATUS;
                }
            };
            openDialogJob.setUser(true);
            openDialogJob.schedule();
        }
        return null;
    }

    public void switchLibrariesForModelSet(Package profiledPackage, final ModelSet modelSet, final TransactionalEditingDomain editingDomain, final Shell activeShell, IProgressMonitor monitor) {
        monitor.subTask("Resolve all proxies...");
        EcoreUtil.resolveAll((ResourceSet)modelSet);
        monitor.subTask("Open package import management dialog...");
        activeShell.getDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    SwitchLibraryDialog dialog = new SwitchLibraryDialog(activeShell, modelSet, editingDomain);
                    dialog.open();
                }
                catch (ServiceException e) {
                    StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.papyrus.uml.modelrepair", "Failed to open package import switching dialog.", (Throwable)e), 2);
                }
            }
        });
    }
}

